/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.editors.sciencegoals.TargetParametersEditor;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.FieldSetupModel;
import alma.obsprep.ot.models.sciencegoals.TargetParametersModel;
import alma.obsprep.services.sfi.SingleFieldScienceGoalEditor;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.GUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.help.CSH;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

public class FieldSetupEditor
extends Editor
implements ModelChangeSubscriber {
    private static DialogId DIALOG_OVERWRITE_FILE = new DialogId("ExportTargets.OverwriteFile", "Export to file. Overwrite existing file?");
    public static final FieldID FID_TABBEDPANE = new FieldID("FieldSetup.tabs");
    public static final FieldID FID_ADD_BUTTON = new FieldID("FieldSetup.addBtn");
    public static final FieldID FID_LOAD_BUTTON = new FieldID("FieldSetup.loadBtn");
    public static final FieldID FID_EXPORT_BUTTON = new FieldID("FieldSetup.exportBtn");
    public static final FieldID FID_DELETE_BUTTON = new FieldID("FieldSetup.delBtn");
    public static final FieldID FID_CLONE_BUTTON = new FieldID("FieldSetup.cloneBtn");
    public static final FieldID FID_DELETE_ALL_BUTTON = new FieldID("FieldSetup.delAllBtn");
    public static final FieldID FID_DEBUGPRINT_BUTTON = new FieldID("FieldSetup.debugBtn");
    private Box buttonBox;
    private JTabbedPane tabbedPane;
    private TargetParametersEditor targetEditor;
    private TargetParametersModel targetModel;
    private int selectedTabIndex = 0;
    private boolean tabSelectionListenerActivated = true;
    private ChangeListener tabSelectionListener = changeEvent -> {
        if (this.tabSelectionListenerActivated) {
            this.setEditorAtSelectedTab();
        }
    };
    private DialogId SOURCEFILEFORMATCHANGEDIALOGID = new DialogId("ExportTargets.FormatChanged", "Exporting to file. Problem while writing file");
    private SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews currentView = SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews.DEFAULTVIEW;

    public FieldSetupEditor(Model model) {
        this(model, false, false);
    }

    public FieldSetupEditor(Model model, boolean bl, boolean bl2) {
        this.targetModel = ((FieldSetupModel)model).getTargetParametersModel();
        this.targetModel.subscribe(this);
        this.targetEditor = new TargetParametersEditor(this.targetModel);
        this.registerSubView(this.targetEditor);
        CSH.setHelpIDString((Component)this.targetEditor, (String)"TOC-Phase 1 and Phase 2 Science Goals-Field Setup-Source");
        this.setModel(model);
        this.build();
        model.publish();
    }

    public TargetParametersEditor getTargetParametersEditor() {
        return this.targetEditor;
    }

    @Override
    public FieldSetupModel getModel() {
        return (FieldSetupModel)super.getModel();
    }

    @Override
    protected void build() {
        Dimension dimension = new Dimension(10, 3);
        this.setLayout(new BoxLayout(this, 3));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(0);
        this.tabbedPane.addChangeListener(this.tabSelectionListener);
        this.tabbedPane.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        this.initEvents(this.tabbedPane, FID_TABBEDPANE);
        this.add(this.tabbedPane);
        this.add(Box.createRigidArea(dimension));
        this.buttonBox = this.createButtonBox();
        this.add(this.buttonBox);
        this.add(Box.createRigidArea(dimension));
        UserEditRestrictionController.getInstance().registerUserChangeRestrictionAffectedComponents(this.targetEditor.getUserRestrictedEditableComponents());
    }

    private Box createButtonBox() {
        Box box = Box.createHorizontalBox();
        Dimension dimension = new Dimension(3, 3);
        JButton jButton = new JButton("Add Source");
        jButton.setToolTipText("Add another science source");
        this.initEvents(jButton, FID_ADD_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Load from File...");
        jButton.setToolTipText("Load list of science sources from a file");
        jButton.addActionListener(actionEvent -> this.loadFromFile());
        this.initEvents(jButton, FID_LOAD_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Export to File...");
        jButton.setToolTipText("Export list of science sources to a file");
        jButton.addActionListener(actionEvent -> this.exportTargetsToFile());
        jButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        this.initEvents(jButton, FID_EXPORT_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Clone Source");
        jButton.setToolTipText("Clone the source");
        jButton.setEnabled(true);
        this.initEvents(jButton, FID_CLONE_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Delete Source");
        jButton.setToolTipText("Delete selected source");
        jButton.setEnabled(false);
        this.initEvents(jButton, FID_DELETE_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Delete All Sources");
        jButton.setToolTipText("Delete all sources");
        jButton.setEnabled(false);
        this.initEvents(jButton, FID_DELETE_ALL_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Debug Print");
        jButton.setToolTipText("Debug Print");
        jButton.setEnabled(true);
        this.initEvents(jButton, FID_DEBUGPRINT_BUTTON);
        return box;
    }

    private void enableButtons(boolean bl) {
        ((JButton)this.getComponent(FID_ADD_BUTTON)).setEnabled(bl);
        ((JButton)this.getComponent(FID_LOAD_BUTTON)).setEnabled(bl);
        ((JButton)this.getComponent(FID_EXPORT_BUTTON)).setEnabled(bl);
        ((JButton)this.getComponent(FID_DELETE_BUTTON)).setEnabled(bl);
        ((JButton)this.getComponent(FID_DELETE_ALL_BUTTON)).setEnabled(bl);
        ((JButton)this.getComponent(FID_CLONE_BUTTON)).setEnabled(bl);
    }

    private void updateButtons() {
        if (!this.isEnabled()) {
            return;
        }
        this.buttonBox.setVisible(true);
        this.enableButtons(true);
        ScienceGoal scienceGoal = this.getModel().getScienceGoal();
        if (scienceGoal == null || scienceGoal.getTargetParametersCount() <= 1) {
            ((JButton)this.retrieve(FID_DELETE_BUTTON)).setEnabled(false);
            ((JButton)this.retrieve(FID_DELETE_ALL_BUTTON)).setEnabled(false);
        }
        if (scienceGoal != null) {
            JButton jButton = (JButton)this.retrieve(FID_ADD_BUTTON);
            jButton.setEnabled(!this.currentView.equals((Object)SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews.VLBI));
            JButton jButton2 = (JButton)this.retrieve(FID_LOAD_BUTTON);
            jButton2.setEnabled(true);
            JButton jButton3 = (JButton)this.retrieve(FID_EXPORT_BUTTON);
            jButton3.setEnabled(true);
        }
    }

    protected JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        ScienceGoal scienceGoal = this.getModel().getScienceGoal();
        if (scienceGoal == null) {
            return;
        }
        if (fieldID == FID_TABBEDPANE) {
            if (object instanceof ScienceGoal) {
                this.resetTabEditor((ScienceGoal)object);
                this.updateTargetTypeButtons();
                this.updateButtons();
                this.setEditorAtSelectedTab();
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                try {
                    if (n >= 0) {
                        this.tabbedPane.setSelectedIndex(n);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return;
        }
        if (fieldID == FID_ADD_BUTTON) {
            int n = scienceGoal.getTargetParametersCount();
            this.tabbedPane.setSelectedIndex(n - 1);
            return;
        }
        if (fieldID == FID_LOAD_BUTTON) {
            int n = scienceGoal.getTargetParametersCount();
            this.tabbedPane.setSelectedIndex(n - 1);
            return;
        }
        if (fieldID == FID_EXPORT_BUTTON) {
            int n = scienceGoal.getTargetParametersCount();
            this.tabbedPane.setSelectedIndex(n - 1);
            return;
        }
        if (fieldID == FID_DELETE_BUTTON) {
            return;
        }
        if (fieldID == FID_DELETE_ALL_BUTTON) {
            return;
        }
        if (fieldID == FID_DEBUGPRINT_BUTTON) {
            return;
        }
        super.update(fieldID, object);
    }

    public void updateTargetTypeButtons() {
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = true;
        if (this.getTargetCountByType(TargetParameters.TYPE_F_MULTIPLEPOINTS) > 1 || this.getTargetCountByType(TargetParameters.TYPE_F_SINGLERECTANGLE) > 1) {
            bl = false;
        }
        this.targetEditor.retrieve(TargetParametersEditor.FID_TARGETTYPE).setEnabled(bl);
    }

    private void loadFromFile() {
        File file;
        GUIUtilities.warningWithDoNotShowAgain(this.SOURCEFILEFORMATCHANGEDIALOGID, "<html>Changes to the file format for Cycle 3 & 6 :<BR><UL><li>Doppler Type is now a required parameter (column 8)</li><li>Line widths must now be entered in km/s</li><li>The continuum circular polarization percentage should be entered as a real (column 14)</li> <li>The spectral line circular polarization percentage should be entered as a real (column 15)</li> </ul></html>");
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser(this);
        AppendOrReplaceAccessory appendOrReplaceAccessory = new AppendOrReplaceAccessory();
        jFileChooser.setAccessory(appendOrReplaceAccessory);
        jFileChooser.setDialogTitle("Read");
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()).exists()) {
            if (appendOrReplaceAccessory.isReplaceOperation()) {
                this.getModel().loadFromFile(file, false);
            } else {
                this.getModel().loadFromFile(file, true);
            }
        }
    }

    private void exportTargetsToFile() {
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser(this);
        ExportOptions exportOptions = new ExportOptions();
        jFileChooser.setAccessory(exportOptions);
        jFileChooser.setDialogTitle("Write");
        jFileChooser.setDialogType(1);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file.exists()) {
                String string = "";
                try {
                    string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String string2 = "File " + string + " already exists." + "\nDo you want to replace it?";
                boolean bl = GUIUtilities.confirm(DIALOG_OVERWRITE_FILE, string2);
                if (!bl) {
                    return;
                }
            }
            if (exportOptions.isExportTargets()) {
                this.getModel().exportTargetsToFile(file);
            } else if (exportOptions.isExportParameters()) {
                this.getModel().exportParametersToFile(file, exportOptions.isParametersIncludeTargetNames(), exportOptions.getParametersCoordsType());
            }
        }
    }

    private int getTargetCountByType(String string) {
        ScienceGoal scienceGoal = this.getModel().getScienceGoal();
        int n = 0;
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            String string2 = targetParameters.getType();
            if (string2 == null) {
                throw new RuntimeException("Unexpected Target Parameters Type : " + string2);
            }
            if (!string2.equals(string)) continue;
            ++n;
        }
        return n;
    }

    private String tabTitle(TargetParameters targetParameters) {
        String string;
        if (targetParameters == null) {
            return null;
        }
        String string2 = targetParameters.getSourceName();
        if (string2 != null && string2.length() > 0) {
            string = string2;
        } else {
            try {
                string = targetParameters.getField(0).getClass().getSimpleName();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                string = "Field";
            }
        }
        return string;
    }

    private void updateTabTitle() {
        String string;
        int n = this.tabbedPane.getSelectedIndex();
        if (n == -1) {
            return;
        }
        ScienceGoal scienceGoal = (ScienceGoal)this.getModel().getDocument();
        if (scienceGoal == null) {
            string = "Field";
        } else {
            if (scienceGoal.getTargetParametersCount() <= n) {
                return;
            }
            TargetParameters targetParameters = scienceGoal.getTargetParameters(n);
            string = this.tabTitle(targetParameters);
        }
        this.tabbedPane.setTitleAt(n, string);
    }

    private void resetTabTitle(String string) {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.tabbedPane.setTitleAt(n, string);
    }

    public void resetTabEditor(ScienceGoal scienceGoal) {
        this.tabbedPane.removeChangeListener(this.tabSelectionListener);
        this.tabbedPane.removeAll();
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            this.tabbedPane.add(this.tabTitle(targetParameters), new JLabel("dummy"));
        }
        if (scienceGoal.getTargetParametersCount() <= this.selectedTabIndex) {
            this.selectedTabIndex = 0;
        }
        this.tabbedPane.setSelectedIndex(this.selectedTabIndex);
        this.tabbedPane.addChangeListener(this.tabSelectionListener);
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID.equals(TargetParametersEditor.FID_TARGETTYPE)) {
            this.updateTabTitle();
            this.updateTargetTypeButtons();
            this.updateButtons();
        } else if (fieldID.equals(TargetParametersEditor.FID_SOURCENAME)) {
            if (object == "") {
                this.resetTabTitle("Unspecified");
            } else {
                this.updateTabTitle();
            }
        } else if (fieldID.equals(SingleFieldScienceGoalModel.EDITOR_SUBVIEW_FID)) {
            this.configureEditorForView((SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews)((Object)object));
        }
        super.modelChanged(model, fieldID, object);
    }

    @Override
    public void configureEditorForView(SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews scienceGoalEditorSubviews) {
        if (scienceGoalEditorSubviews == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: view");
        }
        this.currentView = scienceGoalEditorSubviews;
        this.updateButtons();
        this.targetEditor.configureEditorForView(this.currentView);
    }

    private void setEditorAtSelectedTab() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.getModel().setSelectedTargetParametersIndex(n);
        int n2 = this.tabbedPane.indexOfComponent(this.targetEditor);
        this.tabSelectionListenerActivated = false;
        try {
            this.tabbedPane.setComponentAt(n2, new JLabel("dummy"));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(this.targetEditor);
        this.tabbedPane.setComponentAt(n, this.targetEditor);
        this.updateTabTitle();
        this.selectedTabIndex = n;
        this.tabSelectionListenerActivated = true;
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Science Goal Field Setup Editor");
        jFrame.setDefaultCloseOperation(3);
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        TargetParameters targetParameters = TargetParameters.createTargetParameters();
        SinglePoint singlePoint = SinglePoint.createSinglePoint();
        targetParameters.setSourceName("Target1");
        targetParameters.addField((Field)((Object)singlePoint));
        targetParameters.setType(TargetParameters.TYPE_F_MULTIPLEPOINTS);
        scienceGoal.addTargetParameters(targetParameters);
        FieldSetupModel fieldSetupModel = new FieldSetupModel(scienceGoal);
        FieldSetupEditor fieldSetupEditor = new FieldSetupEditor(fieldSetupModel);
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 3));
        jFrame.getContentPane().setPreferredSize(new Dimension(800, 950));
        jFrame.getContentPane().add(fieldSetupEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class ExportOptions
    extends JPanel {
        private static final long serialVersionUID = 5264761919008845165L;
        private static final String TARGETS_BTN_NAME = "ExportOptionsDialog.expTargetsBtn";
        private static final String PARAMETERS_BTN_NAME = "ExportOptionsDialog.expParametersBtn";
        private static final String POINTINGS_BTN_NAME = "ExportOptionsDialog.expPointingsBtn";
        private final ButtonGroup exportGroup = new ButtonGroup();
        private final JRadioButton targetsBtn;
        private final JRadioButton parametersBtn;
        private final JCheckBox paramIncTargetName;
        private final CoordsOptions parametersCoords;

        public ExportOptions() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.targetsBtn = new JRadioButton("Export full source information");
            this.targetsBtn.setName(TARGETS_BTN_NAME);
            this.targetsBtn.setToolTipText("Export in a format compatible with the science goal load from text file function");
            this.exportGroup.add(this.targetsBtn);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.targetsBtn, gridBagConstraints);
            this.parametersBtn = new JRadioButton("Export source positions only");
            this.parametersBtn.setName(PARAMETERS_BTN_NAME);
            this.parametersBtn.setToolTipText("Export of target parameter positions only (RA, Dec)");
            this.exportGroup.add(this.parametersBtn);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.parametersBtn, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            this.add((Component)new JLabel("     "), gridBagConstraints);
            this.paramIncTargetName = new JCheckBox("Include target name");
            this.paramIncTargetName.setName("ExportOptionsDialog.expParamIncTargetName");
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            this.add((Component)this.paramIncTargetName, gridBagConstraints);
            this.parametersCoords = new CoordsOptions();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            this.add((Component)this.parametersCoords, gridBagConstraints);
            ActionListener actionListener = actionEvent -> {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                if (abstractButton.getName().equals(TARGETS_BTN_NAME)) {
                    this.setParametersIncludeTargetNamesEnabled(false);
                    this.setParametersCoordsEnabled(false);
                } else if (abstractButton.getName().equals(PARAMETERS_BTN_NAME)) {
                    this.setParametersIncludeTargetNamesEnabled(true);
                    this.setParametersCoordsEnabled(true);
                } else if (abstractButton.getName().equals(POINTINGS_BTN_NAME)) {
                    this.setParametersIncludeTargetNamesEnabled(false);
                    this.setParametersCoordsEnabled(false);
                }
            };
            this.targetsBtn.addActionListener(actionListener);
            this.parametersBtn.addActionListener(actionListener);
            this.setParametersIncludeTargetNamesEnabled(false);
            this.setParametersCoordsEnabled(false);
            this.targetsBtn.setSelected(true);
        }

        public boolean isExportTargets() {
            return this.targetsBtn.isSelected();
        }

        public boolean isExportParameters() {
            return this.parametersBtn.isSelected();
        }

        public exportFormat getExportFormat() {
            if (this.targetsBtn.isSelected()) {
                return exportFormat.TARGETS;
            }
            if (this.parametersBtn.isSelected()) {
                return exportFormat.PARAMETERS;
            }
            return null;
        }

        public boolean isParametersIncludeTargetNames() {
            return this.paramIncTargetName.isSelected();
        }

        public void setParametersIncludeTargetNamesEnabled(boolean bl) {
            this.paramIncTargetName.setEnabled(bl);
        }

        public coordsFormat getParametersCoordsType() {
            return this.parametersCoords.getCoordsType();
        }

        public void setParametersCoordsEnabled(boolean bl) {
            this.parametersCoords.setEnabled(bl);
        }

        class CoordsOptions
        extends JPanel {
            private final ButtonGroup coordsGroup = new ButtonGroup();
            private final JRadioButton sexagBtn;
            private final JRadioButton degreesBtn;
            private final JRadioButton radiansBtn;

            public CoordsOptions() {
                this.setLayout(new BoxLayout(this, 0));
                this.sexagBtn = new JRadioButton("Sexagesimal");
                this.sexagBtn.setName("ExportOptionsDialog.CoordsSexagesimal");
                this.coordsGroup.add(this.sexagBtn);
                this.degreesBtn = new JRadioButton("Degrees");
                this.degreesBtn.setName("ExportOptionsDialog.CoordsDegrees");
                this.coordsGroup.add(this.degreesBtn);
                this.radiansBtn = new JRadioButton("Radians");
                this.radiansBtn.setName("ExportOptionsDialog.CoordsRadians");
                this.coordsGroup.add(this.radiansBtn);
                this.add(this.sexagBtn);
                this.add(this.degreesBtn);
                this.add(this.radiansBtn);
                this.sexagBtn.setSelected(true);
            }

            public boolean isSexagesimal() {
                return this.sexagBtn.isSelected();
            }

            public boolean isDegrees() {
                return this.degreesBtn.isSelected();
            }

            public boolean isRadians() {
                return this.radiansBtn.isSelected();
            }

            public coordsFormat getCoordsType() {
                if (this.sexagBtn.isSelected()) {
                    return coordsFormat.SEXAGESIMAL;
                }
                if (this.degreesBtn.isSelected()) {
                    return coordsFormat.DEGREES;
                }
                if (this.radiansBtn.isSelected()) {
                    return coordsFormat.RADIANS;
                }
                return null;
            }

            @Override
            public void setEnabled(boolean bl) {
                this.sexagBtn.setEnabled(bl);
                this.degreesBtn.setEnabled(bl);
                this.radiansBtn.setEnabled(bl);
            }
        }
    }

    class AppendOrReplaceAccessory
    extends JPanel {
        private final ButtonGroup group = new ButtonGroup();
        private final JRadioButton appendButton;
        private final JRadioButton replaceButton;

        public AppendOrReplaceAccessory() {
            this.setLayout(new GridLayout(2, 1));
            this.replaceButton = new JRadioButton("Replace Source List");
            this.replaceButton.setToolTipText("Create a new source list containing targets specified in the selected file");
            this.group.add(this.replaceButton);
            this.appendButton = new JRadioButton("Append to Source List");
            this.appendButton.setToolTipText("Append sources in the selected file to your source list");
            this.group.add(this.appendButton);
            this.appendButton.setSelected(true);
            this.add(this.appendButton);
            this.add(this.replaceButton);
        }

        public boolean isAppendOperation() {
            return this.appendButton.isSelected();
        }

        public boolean isReplaceOperation() {
            return this.replaceButton.isSelected();
        }
    }

    public static enum coordsFormat {
        SEXAGESIMAL,
        DEGREES,
        RADIANS;

    }

    public static enum exportFormat {
        TARGETS,
        PARAMETERS,
        POINTINGS;

    }
}

