/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.obsproject.MonitoringConstraint;
import alma.obsprep.ot.editors.sciencegoals.MonitoringConstraintEditor;
import alma.obsprep.ot.editors.sciencegoals.MonitoringConstraintTableModel;
import alma.obsprep.ot.gui.factory.Table;
import alma.valuetypes.Time;
import java.awt.Component;
import java.text.SimpleDateFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class MonitoringConstraintsTable
extends Table {
    private static final long serialVersionUID = 3900865882362616898L;
    public static final int TABLE_WIDTH = 500;

    public MonitoringConstraintsTable(MonitoringConstraintTableModel monitoringConstraintTableModel) {
        super(monitoringConstraintTableModel);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setToolTipText("TODO add tooltip");
        this.setupTableCellEditors();
        this.setupTableCellRenderers();
    }

    private void setupTableCellEditors() {
        MonitoringConstraintTableModel monitoringConstraintTableModel = (MonitoringConstraintTableModel)this.getModel();
        TableColumn tableColumn = this.getColumn("<html><center>Monitoring Constraints</center></html>");
        MonitoringConstraintEditor monitoringConstraintEditor = new MonitoringConstraintEditor(monitoringConstraintTableModel.getModel());
        monitoringConstraintEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(monitoringConstraintEditor);
    }

    private void setupTableCellRenderers() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 3474423374972813684L;
            String sdfStr = "yyyy-MM-dd HH:mm";
            SimpleDateFormat sdf = new SimpleDateFormat(this.sdfStr);

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setToolTipText("Click on row to select, double click to change any of the values");
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                MonitoringConstraint monitoringConstraint = (MonitoringConstraint)((Object)object);
                String string = "<html>";
                Time time = monitoringConstraint.getMonitoringLength();
                Time time2 = monitoringConstraint.getCycleTime();
                Time time3 = monitoringConstraint.getAllowedMargin();
                if (monitoringConstraint.hasIsFixedStart() && monitoringConstraint.getIsFixedStart() && "" != monitoringConstraint.getStartTime()) {
                    string = string + "Start date of ";
                    string = string + this.sdf.format(monitoringConstraint.getStartTimeAsDate());
                } else {
                    string = string + "Arbitrary start ";
                }
                if (time.getContent() > 0.0) {
                    string = string + " with a monitoring length of ";
                    string = string + time.getContent();
                    string = string + " ";
                    string = string + time.getUnit();
                }
                if (time2.getContent() > 0.0) {
                    string = string + " and a cycle time of ";
                    string = string + time2.getContent();
                    string = string + " ";
                    string = string + time2.getUnit();
                }
                if (time3.getContent() > 0.0) {
                    string = string + " with a margin of &plusmn; ";
                    string = string + time3.getContent();
                    string = string + " ";
                    string = string + time3.getUnit();
                }
                string = string + "</html>";
                this.setText(string);
                return this;
            }
        };
        TableColumn tableColumn = this.getColumn("<html><center>Monitoring Constraints</center></html>");
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }

    public int getPreferredEditorWidth() {
        TableColumn tableColumn = this.getColumn("<html><center>Monitoring Constraints</center></html>");
        MonitoringConstraintEditor monitoringConstraintEditor = (MonitoringConstraintEditor)tableColumn.getCellEditor();
        return monitoringConstraintEditor.getPreferredSize().width;
    }
}

