/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.DataRate;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProjectTimeEstimateSummary {
    protected static Time ZEROTIME = Time.createTimeSec(0.0);
    protected final Map<ScienceGoal, Map<TimeTableColTypes, Time>> estimatedTotalTimeData = new HashMap<ScienceGoal, Map<TimeTableColTypes, Time>>();
    protected final Map<ScienceGoal, String> scienceGoalNameMap = new LinkedHashMap<ScienceGoal, String>();
    protected final Map<ScienceGoal, Map<TimeTableColTypes, Time>> estimatedCalibrationTimeData = new HashMap<ScienceGoal, Map<TimeTableColTypes, Time>>();
    protected final Map<ScienceGoal, Map<DataTableColTypes, DataRate>> estimatedDataRates = new HashMap<ScienceGoal, Map<DataTableColTypes, DataRate>>();
    protected final Map<ScienceGoal, Map<DataTableColTypes, StorageVolume>> estimatedDataVolume = new HashMap<ScienceGoal, Map<DataTableColTypes, StorageVolume>>();
    protected Map<ScienceGoal, Boolean> badlyConfiguredScienceGoals = new HashMap<ScienceGoal, Boolean>();

    protected static String formatStorageVolume(StorageVolume storageVolume) {
        double d = storageVolume.getContentInDefaultUnits();
        if (storageVolume.isZero() || Double.isNaN(d) || Double.isInfinite(d)) {
            return "-";
        }
        return TextUtils.format(storageVolume.convertToFriendlyUnit(), 2);
    }

    protected static String formatDataRate(DataRate dataRate) {
        double d = dataRate.getContentInDefaultUnits();
        if (dataRate.isZero() || Double.isNaN(d) || Double.isInfinite(d)) {
            return "-";
        }
        dataRate.convertToUnit(DataRate.UNIT_MB_S);
        return TextUtils.format(dataRate, 2);
    }

    protected static String formatTime(Time time) {
        if (time.isZero()) {
            return "-";
        }
        return TextUtils.format(time.convertToFriendlyUnit(), 2);
    }

    /*
     * WARNING - void declaration
     */
    protected String build() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<head>");
        stringBuilder.append("<style>");
        stringBuilder.append("table {");
        stringBuilder.append("text-shadow: 0 1px rgba(255,255,255,.8);");
        stringBuilder.append("-moz-border-radius: 5px;-webkit-border-radius: 5px;\tborder-radius: 5px;\t-moz-box-shadow: 10px 0 10px -10px rgba(0, 0, 0, .15), -10px 0 10px -10px rgba(0, 0, 0, .15);");
        stringBuilder.append("-webkit-box-shadow: 10px 0 10px -10px rgba(0, 0, 0, .15), -10px 0 10px -10px rgba(0, 0, 0, .15);");
        stringBuilder.append("box-shadow: 10px 0 10px -10px rgba(0, 0, 0, .15), -10px 0 10px -10px rgba(0, 0, 0, .15);}");
        stringBuilder.append("td {");
        stringBuilder.append("padding: 5px;");
        stringBuilder.append("text-align: left;");
        stringBuilder.append("border-bottom: 1px solid #ddd;");
        stringBuilder.append("}");
        stringBuilder.append("tr:hover {");
        stringBuilder.append("background-color: #EEEEEE;");
        stringBuilder.append("-webkit-box-shadow: 0 6px 6px -6px #EEEEEE;");
        stringBuilder.append("-moz-box-shadow: 0 6px 6px -6px #EEEEEE;");
        stringBuilder.append("box-shadow: 0 6px 6px -6px #EEEEEE;");
        stringBuilder.append("}");
        stringBuilder.append("td.overall {");
        stringBuilder.append("text-align: left;");
        stringBuilder.append("background-color: #DEEAF6;");
        stringBuilder.append("border-bottom: 1px solid #ddd;");
        stringBuilder.append("}");
        stringBuilder.append("td.header {");
        stringBuilder.append("text-align: left;");
        stringBuilder.append("background-color: #DEEAF6;");
        stringBuilder.append("border-bottom: 1px solid #ddd;");
        stringBuilder.append("}");
        stringBuilder.append("th {");
        stringBuilder.append("background-color: #BDD6EE;");
        stringBuilder.append("color: #202020;");
        stringBuilder.append("padding: 5px;");
        stringBuilder.append("text-align: left;");
        stringBuilder.append("border-bottom: 1px solid #ddd;");
        stringBuilder.append("}");
        stringBuilder.append("h1 {font-family: Georgia, \"Times New Roman\",Serif; font-size: 125%;}");
        stringBuilder.append("</style>");
        stringBuilder.append("</head>");
        stringBuilder.append("<body>");
        stringBuilder.append("<center>");
        stringBuilder.append("<h1> Total and Calibration Times</h1>");
        stringBuilder.append("<table>");
        stringBuilder.append("<tr><th>Science Goal</th><th colspan=2>" + TimeTableColTypes.TWELVEMEXT.getLabel() + "<th colspan=2>" + TimeTableColTypes.TWELVEMCOMPACT.getLabel() + "</th><th colspan=2>" + TimeTableColTypes.COMBINEDTWELVEM.getLabel() + "</th><th colspan=2>" + TimeTableColTypes.ACA7M.getLabel() + "</th><th colspan=2>" + TimeTableColTypes.ACATP.getLabel() + "</th><th colspan=2>Overall</th></th><th>Non-standard Mode</th></tr>");
        String string = " class=\"header\"";
        stringBuilder.append("<tr><td " + string + ">&nbsp;</td><td" + string + ">Tot.</td><td" + string + "> Cal.</td><td" + string + ">Tot.</td><td" + string + "> Cal.</td><td" + string + ">Tot.</td><td" + string + "> Cal.</td><td" + string + ">Tot.</td><td" + string + "> Cal.</td><td" + string + ">Tot.</td><td" + string + "> Cal.</td><td" + string + ">Tot.</td><td" + string + "> Cal.</td><td" + string + "> &nbsp;</td></tr>");
        HashMap<TimeTableColTypes, Time> hashMap = new HashMap<TimeTableColTypes, Time>();
        HashMap<TimeTableColTypes, Time> hashMap2 = new HashMap<TimeTableColTypes, Time>();
        for (TimeTableColTypes object3 : TimeTableColTypes.values()) {
            hashMap.put(object3, ZEROTIME);
            hashMap2.put(object3, ZEROTIME);
        }
        for (ScienceGoal scienceGoal : this.scienceGoalNameMap.keySet()) {
            String string2 = this.scienceGoalNameMap.get(scienceGoal);
            if (this.badlyConfiguredScienceGoals.containsKey(scienceGoal)) {
                stringBuilder.append("<tr color=red><td>" + string2 + "</td>");
            } else {
                stringBuilder.append("<tr><td>" + string2 + "</td>");
            }
            Object var8_15 = null;
            Time time = null;
            Map<TimeTableColTypes, Time> map = this.estimatedTotalTimeData.get(scienceGoal);
            Map<TimeTableColTypes, Time> map2 = this.estimatedCalibrationTimeData.get(scienceGoal);
            for (TimeTableColTypes timeTableColTypes : EnumSet.range(TimeTableColTypes.TWELVEMEXT, TimeTableColTypes.OVERALL)) {
                void var8_20;
                switch (timeTableColTypes) {
                    case TWELVEMCOMPACT: 
                    case TWELVEMEXT: 
                    case ACA7M: 
                    case ACATP: {
                        Time time2 = map.get((Object)timeTableColTypes);
                        time = map2.get((Object)timeTableColTypes);
                        break;
                    }
                    case COMBINEDTWELVEM: {
                        Time time3 = (Time)map.get((Object)TimeTableColTypes.TWELVEMEXT).plus((AbstractDoubleWithUnit)map.get((Object)TimeTableColTypes.TWELVEMCOMPACT));
                        time = (Time)map2.get((Object)TimeTableColTypes.TWELVEMEXT).plus((AbstractDoubleWithUnit)map2.get((Object)TimeTableColTypes.TWELVEMCOMPACT));
                        break;
                    }
                    case OVERALL: {
                        Time time4 = map.get((Object)TimeTableColTypes.ACA7M).isGreaterThan((AbstractDoubleWithUnit)map.get((Object)TimeTableColTypes.ACATP)) ? map.get((Object)TimeTableColTypes.ACA7M) : map.get((Object)TimeTableColTypes.ACATP);
                        Time time5 = map2.get((Object)TimeTableColTypes.ACA7M).isGreaterThan((AbstractDoubleWithUnit)map2.get((Object)TimeTableColTypes.ACATP)) ? map2.get((Object)TimeTableColTypes.ACA7M) : map2.get((Object)TimeTableColTypes.ACATP);
                        Time time6 = (Time)((Time)map.get((Object)TimeTableColTypes.TWELVEMEXT).plus((AbstractDoubleWithUnit)map.get((Object)TimeTableColTypes.TWELVEMCOMPACT))).plus((AbstractDoubleWithUnit)time4);
                        time = (Time)((Time)map2.get((Object)TimeTableColTypes.TWELVEMEXT).plus((AbstractDoubleWithUnit)map2.get((Object)TimeTableColTypes.TWELVEMCOMPACT))).plus((AbstractDoubleWithUnit)time5);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown column type specified");
                    }
                }
                hashMap.put(timeTableColTypes, (Time)((Time)hashMap.get((Object)timeTableColTypes)).plus((AbstractDoubleWithUnit)var8_20));
                hashMap2.put(timeTableColTypes, (Time)((Time)hashMap2.get((Object)timeTableColTypes)).plus((AbstractDoubleWithUnit)time));
                stringBuilder.append("<td>" + ProjectTimeEstimateSummary.formatTime((Time)var8_20) + "</td><td>" + ProjectTimeEstimateSummary.formatTime(time) + "</td>");
            }
            object = "-";
            if (!this.badlyConfiguredScienceGoals.containsKey(scienceGoal)) {
                object = scienceGoal.getMode().equals("Other") ? "Yes" : "No";
            }
            stringBuilder.append("<td>" + (String)object + "</td></tr>");
        }
        String string3 = " class=\"overall\"";
        stringBuilder.append("<tr><td " + (String)string3 + ">Overall</td>");
        for (TimeTableColTypes timeTableColTypes : EnumSet.range(TimeTableColTypes.TWELVEMEXT, TimeTableColTypes.OVERALL)) {
            stringBuilder.append("<td" + (String)string3 + ">" + ProjectTimeEstimateSummary.formatTime((Time)hashMap.get((Object)timeTableColTypes)) + "</td><td" + (String)string3 + ">" + ProjectTimeEstimateSummary.formatTime((Time)hashMap2.get((Object)timeTableColTypes)) + "</td>");
        }
        stringBuilder.append("<td" + (String)string3 + "></td>");
        stringBuilder.append("</table>");
        stringBuilder.append("<h1>Data Volumes and Data Rates</h1>");
        stringBuilder.append("<table>");
        stringBuilder.append("<tr><th>Science Goal</th><th colspan=3> Data Volume </th> <th colspan=3> Avg. Data Rate</th>");
        stringBuilder.append("<tr><td " + string + ">&nbsp;<td" + string + ">" + DataTableColTypes.TWELVEM.getLabel() + "</td><td" + string + ">" + DataTableColTypes.ACA7M.getLabel() + "</td><td" + string + ">" + DataTableColTypes.ACATP.getLabel() + "</td><td" + string + ">" + DataTableColTypes.TWELVEM.getLabel() + "</td><td" + string + ">" + DataTableColTypes.ACA7M.getLabel() + "</td><td" + string + ">" + DataTableColTypes.ACATP.getLabel() + "</td></tr>");
        HashMap hashMap3 = new HashMap();
        HashMap<DataTableColTypes, StorageVolume> hashMap4 = new HashMap<DataTableColTypes, StorageVolume>();
        for (DataTableColTypes dataTableColTypes : DataTableColTypes.values()) {
            hashMap3.put(dataTableColTypes, DataRate.createDataRate());
            hashMap4.put(dataTableColTypes, StorageVolume.createStorageVolume());
        }
        for (ScienceGoal scienceGoal : this.scienceGoalNameMap.keySet()) {
            String string2 = this.scienceGoalNameMap.get(scienceGoal);
            if (this.badlyConfiguredScienceGoals.containsKey(scienceGoal)) {
                stringBuilder.append("<tr color=red><td>" + string2 + "</td>");
            } else {
                stringBuilder.append("<tr><td>" + string2 + "</td>");
            }
            Map<DataTableColTypes, StorageVolume> map = this.estimatedDataVolume.get(scienceGoal);
            object = this.estimatedDataRates.get(scienceGoal);
            stringBuilder.append("<td>" + ProjectTimeEstimateSummary.formatStorageVolume(map.get((Object)DataTableColTypes.TWELVEM)) + "</td>" + "<td>" + ProjectTimeEstimateSummary.formatStorageVolume(map.get((Object)DataTableColTypes.ACA7M)) + "</td>" + "<td>" + ProjectTimeEstimateSummary.formatStorageVolume(map.get((Object)DataTableColTypes.ACATP)) + "</td>" + "<td>" + ProjectTimeEstimateSummary.formatDataRate(object.get((Object)DataTableColTypes.TWELVEM)) + "</td>" + "<td>" + ProjectTimeEstimateSummary.formatDataRate(object.get((Object)DataTableColTypes.ACA7M)) + "</td>" + "<td>" + ProjectTimeEstimateSummary.formatDataRate(object.get((Object)DataTableColTypes.ACATP)) + "</td></tr>");
            for (DataTableColTypes dataTableColTypes : DataTableColTypes.values()) {
                hashMap3.put(dataTableColTypes, ((DataRate)((Object)hashMap3.get((Object)dataTableColTypes))).plus((AbstractDoubleWithUnit)object.get((Object)dataTableColTypes)));
                hashMap4.put(dataTableColTypes, (StorageVolume)((StorageVolume)((Object)hashMap4.get((Object)dataTableColTypes))).plus((AbstractDoubleWithUnit)map.get((Object)dataTableColTypes)));
            }
        }
        stringBuilder.append("<tr><td" + string + ">Overall</td>" + "<td" + string + ">" + ProjectTimeEstimateSummary.formatStorageVolume((StorageVolume)((Object)hashMap4.get((Object)DataTableColTypes.TWELVEM))) + "</td>" + "<td" + string + ">" + ProjectTimeEstimateSummary.formatStorageVolume((StorageVolume)((Object)hashMap4.get((Object)DataTableColTypes.ACA7M))) + "</td>" + "<td" + string + ">" + ProjectTimeEstimateSummary.formatStorageVolume(((StorageVolume)((Object)hashMap4.get((Object)DataTableColTypes.ACATP))).convertToFriendlyUnit()) + "</td>" + "<td" + string + "> &nbsp;</td>" + "<td" + string + "> &nbsp; </td>" + "<td" + string + "> &nbsp; </td></tr>");
        stringBuilder.append("</table></center></body></html>");
        return stringBuilder.toString();
    }

    protected static enum DataTableColTypes {
        TWELVEM("12-m (1+2)"),
        ACA7M("ACA 7-m"),
        ACATP("ACA TP");

        private String label;

        private String getLabel() {
            return this.label;
        }

        private DataTableColTypes(String string2) {
            this.label = string2;
        }
    }

    protected static enum TimeTableColTypes {
        TWELVEMEXT("12-m (1)"),
        TWELVEMCOMPACT("12-m (2)"),
        COMBINEDTWELVEM("12-m (1+2)"),
        ACA7M("ACA 7-m"),
        ACATP("ACA TP"),
        OVERALL("Overall");

        private String label;

        private String getLabel() {
            return this.label;
        }

        private TimeTableColTypes(String string2) {
            this.label = string2;
        }
    }
}

