/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.InvalidGroupIndexException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralFeedback;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.SpectralSetupParametersData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.editors.sciencegoals.NotSupportedYetPanel;
import alma.obsprep.ot.editors.sciencegoals.SfiScanSetupEditor;
import alma.obsprep.ot.editors.sciencegoals.SpectralSetupParametersEditor;
import alma.obsprep.ot.editors.spectralvisual.ResourceColumnRenderer;
import alma.obsprep.ot.editors.valuetypes.ObservingFrequencyEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.MultiResolutionElementTableModel;
import alma.obsprep.ot.models.sciencegoals.SelectedSpectralLineValidatorInterface;
import alma.obsprep.ot.models.sciencegoals.SfiScanSetupModel;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.spectralvisual.TargetParametersTableModel;
import alma.obsprep.ot.models.valuetypes.ObservingFrequencyModel;
import alma.obsprep.services.experts.spectralline.DialogSpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLinePublisher;
import alma.obsprep.services.sfi.SingleFieldScienceGoalEditor;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import javax.help.CSH;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.lang3.StringUtils;

public class SfiSpectralSetupEditor
extends EditorWithGridBagLayout
implements ModelChangeSubscriber {
    private static final String REST_FREQ_MSG = "<html><P>Please set the rest frequencies of spectral lines that will be observed. These will be used during data reduction<br> to set the velocity scale and will enhance the ALMA Science Archive. We recommend that this be done<br>once the spectral setup is fully defined.";
    public static final FieldID FID_SPECTRALTYPE = new FieldID("SfiSpectralSetup.SpectralType");
    public static final FieldID FID_WALSH_SWITCHING = new FieldID("SfiSpectralSetup.WalshSwitchingEnabled");
    public static final FieldID FID_POLARIZATION = new FieldID("SfiSpectralSetup.Polarization");
    public static final FieldID FID_FEEDBACK = new FieldID("SfiSpectralSetup.Feedback");
    public static final FieldID FID_SPECTRALAVERAGING = new FieldID("SfiSpectralSetup.SpectralAveraging");
    public static final FieldID REST_FREQUENCIES_DEFINED_FID = new FieldID("SfiSpectralSetup.restFrequenciesDefined");
    public static FieldID FID_WALSH_SWITCHING_USER_CONTROLLABLE = new FieldID("SfiSpectralSetup.walshSwitchingUserControllable");
    private FieldID FID_DEFINE_REST_FREQUENCIES = new FieldID("SfiSpectralSetupEditor.defineRestFrequencies");
    private final SpectralLineChooser lineChooser;
    private JTable targetsTable;
    private final TargetParametersTableModel targetsTableModel;
    protected SpectralSetupParametersEditor spectralLineEditor;
    protected SpectralSetupParametersEditor spectralContinuumLineEditor;
    protected ObservingFrequencyEditor singleContinuumEditor;
    protected SfiScanSetupEditor scanEditor;
    protected AdvancedSpectralPanel advancedSpectralPanel;
    protected JLabel feedbackArea;
    JPanel spectralLineGroup;
    JPanel singleContinuumGroup;
    JPanel spectralScanGroup;
    JPanel advancedSpectralGroup;
    private boolean feedbackComplete = true;
    private OTButtonGroup polarisationButtonGroup;
    private List<ScienceSpectralWindowSelectionListener> listeners = new ArrayList<ScienceSpectralWindowSelectionListener>();
    private OTButtonGroup spectralTypeButtonGroup;

    public SfiSpectralSetupEditor(Model model, SpectralLineChooser spectralLineChooser) {
        this.setName("SfiSpectralSetup");
        this.lineChooser = spectralLineChooser;
        this.setModel(model);
        SingleFieldScienceGoalModel singleFieldScienceGoalModel = null;
        if (model != null) {
            Model model2 = this.getMyModel().getParentModel();
            if (model2 instanceof SingleFieldScienceGoalModel) {
                singleFieldScienceGoalModel = (SingleFieldScienceGoalModel)model2;
                this.targetsTableModel = singleFieldScienceGoalModel.getTargetParametersTableModel();
            } else {
                this.targetsTableModel = null;
            }
        } else {
            this.targetsTableModel = null;
        }
        this.build();
        if (model != null) {
            model.publish();
        }
    }

    public SfiSpectralSetupEditor(Model model) {
        this(model, DialogSpectralLineChooser.getInstance());
    }

    public SpectralSetupParametersModel getMyModel() {
        return (SpectralSetupParametersModel)this.getModel();
    }

    public SelectedSpectralLineValidatorInterface getSpectralLineValidator() {
        return (SelectedSpectralLineValidatorInterface)((Object)this.getModel());
    }

    @Override
    protected void build() {
        super.build("Spectral Setup");
    }

    public SpectralSetupParametersEditor getSpectralLineEditor() {
        return this.spectralLineEditor;
    }

    public SpectralSetupParametersEditor getSpectralContinuumLineEditor() {
        return this.spectralContinuumLineEditor;
    }

    @Override
    public void addComponents(String string) {
        Object object;
        this.constraints.anchor = 11;
        this.constraints.weightx = 1.0;
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.spectralTypeButtonGroup = new OTButtonGroup(SpectralSetupParameters.SpectralSetupTypeChoice.getKnownTypeChoiceLabels(), 1, SpectralSetupParameters.SpectralSetupTypeChoice.getKnownTypeChoiceTooltips());
        this.spectralTypeButtonGroup.setSelectedItem(SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE.label);
        this.initEvents(this.spectralTypeButtonGroup, FID_SPECTRALTYPE);
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Spectral Type", (JComponent)this.spectralTypeButtonGroup);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 10);
        this.addBooleanComponent(jPanel, gridBagLayout, gridBagConstraints, FID_WALSH_SWITCHING, "Produce image sidebands (Bands 9 and 10 only)", "Enable/Disable 90-degree Walsh switching");
        String[] stringArray = SpectralSetupParameters.getKnownPolarisationList();
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            object = CorrPolarization.getCorrPolarization(string2);
            stringArray2[n] = ((CorrPolarization)((Object)object)).label;
            stringArray3[n] = ((CorrPolarization)((Object)object)).tooltip;
            ++n;
        }
        this.polarisationButtonGroup = this.addOTButtonGroup((JComponent)jPanel, gridBagLayout, gridBagConstraints, FID_POLARIZATION, "Polarization products desired", stringArray3, stringArray2);
        JPanel jPanel2 = this.addGroup(jPanel, "Spectral Type");
        CSH.setHelpIDString((Component)jPanel2, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Spectral Type");
        this.spectralLineEditor = new SpectralSetupParametersEditor((Model)this.getMyModel(), this.lineChooser);
        this.registerSubView(this.spectralLineEditor);
        this.addSpectralSelectionListeners(this.spectralLineEditor);
        this.spectralLineEditor.addTableModelListener(tableModelEvent -> {
            if (this.spectralLineEditor.isVisible()) {
                try {
                    this.feedbackAdvancedSetup(tableModelEvent);
                }
                catch (InvalidGroupIndexException invalidGroupIndexException) {
                    invalidGroupIndexException.printStackTrace();
                    GUIUtilities.error(null, "Unexpected Error", invalidGroupIndexException);
                }
            }
        });
        this.feedbackArea = new JLabel();
        this.feedbackArea.setBorder(BorderFactory.createTitledBorder("Spectral Setup Errors"));
        this.feedbackArea.setForeground(Color.RED);
        this.feedbackArea.setBackground(this.getBackground());
        ObservingFrequencyModel observingFrequencyModel = this.getMyModel().getSingleContinuumModel();
        this.singleContinuumEditor = new ObservingFrequencyEditor(observingFrequencyModel);
        this.registerSubView(this.singleContinuumEditor);
        observingFrequencyModel.subscribe(new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (SfiSpectralSetupEditor.this.singleContinuumGroup.isVisible() && SfiSpectralSetupEditor.this.getMyModel().getSpectralSetupParameters().getType() == SpectralSetupParametersData.TYPE_CONTINUUM) {
                    if (fieldID.equals(ObservingFrequencyModel.FEEDBACK_AREA_FID)) {
                        return;
                    }
                    SfiSpectralSetupEditor.this.feedbackSingleContinuumSetup();
                    SfiSpectralSetupEditor.this.getMyModel().updateSpectralWindowsForContinuum();
                }
            }
        });
        SfiScanSetupModel sfiScanSetupModel = this.getMyModel().getSpectralScanModel();
        sfiScanSetupModel.subscribe(new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (SfiSpectralSetupEditor.this.spectralScanGroup != null && SfiSpectralSetupEditor.this.getMyModel().getSpectralSetupParameters().getType() == SpectralSetupParametersData.TYPE_SCAN) {
                    SfiSpectralSetupEditor.this.feedbackSpectralScanSetup();
                }
            }
        });
        SfiScanSetupModel sfiScanSetupModel2 = (SfiScanSetupModel)this.getMyModel().getScanSetupModel();
        this.scanEditor = new SfiScanSetupEditor(sfiScanSetupModel2);
        this.registerSubView(this.scanEditor);
        this.addComponent(this.feedbackArea);
        this.advancedSpectralPanel = new AdvancedSpectralPanel(SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE.label);
        this.spectralLineGroup = this.addGroup(this.spectralLineEditor, SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE.label);
        CSH.setHelpIDString((Component)this.spectralLineGroup, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Spectral Line");
        this.spectralContinuumLineEditor = new SpectralSetupParametersEditor((Model)this.getMyModel(), this.lineChooser);
        this.registerSubView(this.spectralContinuumLineEditor);
        this.addSpectralSelectionListeners(this.spectralContinuumLineEditor);
        this.spectralContinuumLineEditor.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (SfiSpectralSetupEditor.this.spectralContinuumLineEditor.isVisible()) {
                    try {
                        SfiSpectralSetupEditor.this.feedbackAdvancedSetup(tableModelEvent);
                    }
                    catch (InvalidGroupIndexException invalidGroupIndexException) {
                        invalidGroupIndexException.printStackTrace();
                        GUIUtilities.error(null, "Unexpected Error", invalidGroupIndexException);
                    }
                }
            }
        });
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 3));
        ((Container)object).add(this.singleContinuumEditor);
        ((Container)object).add(this.spectralContinuumLineEditor);
        this.singleContinuumGroup = this.addGroup((JComponent)object, SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM.label);
        CSH.setHelpIDString((Component)this.singleContinuumGroup, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Single Continuum");
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 3));
        ((Container)object).add(this.scanEditor);
        this.spectralScanGroup = this.addGroup((JComponent)object, SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALSCAN.label);
        CSH.setHelpIDString((Component)this.spectralScanGroup, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Spectral Scan");
        this.addComponent(this.advancedSpectralPanel);
        this.advancedSpectralGroup = this.advancedSpectralPanel;
        CSH.setHelpIDString((Component)this.advancedSpectralGroup, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Spectral Scan");
        this.singleContinuumGroup.setVisible(false);
        this.spectralScanGroup.setVisible(false);
        this.advancedSpectralGroup.setVisible(false);
        this.constraints.weighty = 1.0;
        this.addComponent(new JPanel());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.add((Component)new JLabel(REST_FREQ_MSG), gridBagConstraints2);
        JButton jButton = new JButton("Define Rest Frequencies");
        gridBagConstraints2.gridy = 1;
        this.initEvents(jButton, this.FID_DEFINE_REST_FREQUENCIES);
        jPanel3.add((Component)jButton, gridBagConstraints2);
        UserEditRestrictionController.getInstance().registerUserChangeRestrictionAffectedComponents((List<JComponent>)ImmutableList.of((Object)jButton));
        JPanel jPanel4 = this.addGroup(jPanel3, "Rest Frequencies");
        CSH.setHelpIDString((Component)jPanel4, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Rest Frequencies");
        if (this.getMyModel().getParentModel() instanceof SingleFieldScienceGoalModel) {
            this.addSourceVelocityGroup((SingleFieldScienceGoalModel)this.getMyModel().getParentModel());
        }
        this.spectralLineEditor.addTargetTableListener(this.getTargetsTable());
    }

    protected void feedbackSpectralScanSetup() {
        SpectralSetupParameters spectralSetupParameters = this.getMyModel().getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return;
        }
        final SpectralFeedback spectralFeedback = spectralSetupParameters.feedbackSpectralScanSetup();
        if (this.feedbackArea != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (spectralFeedback == null) {
                        SfiSpectralSetupEditor.this.setSpectralSetupAdvisorySeverity(SpectralFeedback.AdvisoryType.ERROR);
                        SfiSpectralSetupEditor.this.feedbackArea.setText("");
                    } else {
                        SfiSpectralSetupEditor.this.setSpectralSetupAdvisorySeverity(spectralFeedback.getAdvisoryType());
                        SfiSpectralSetupEditor.this.feedbackArea.setText(spectralFeedback.getMessage());
                    }
                }
            });
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FID_SPECTRALTYPE) {
            SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice;
            if (object instanceof String) {
                Log.logger((Object)this).warning("Unexpected value : " + object);
                spectralSetupTypeChoice = SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE;
            } else {
                spectralSetupTypeChoice = (SpectralSetupParameters.SpectralSetupTypeChoice)((Object)object);
            }
            super.update(fieldID, spectralSetupTypeChoice.label);
            this.updateView(spectralSetupTypeChoice);
            this.determineSpectralModeSpecificPolarisationOptions(spectralSetupTypeChoice);
            return;
        }
        if (fieldID == FID_POLARIZATION) {
            CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization((String)object);
            String string = corrPolarization == null ? null : corrPolarization.label;
            super.update(fieldID, string);
            return;
        }
        if (fieldID == SingleFieldScienceGoalModel.EDITOR_SUBVIEW_FID) {
            this.singleContinuumEditor.update(fieldID, object);
            SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews scienceGoalEditorSubviews = (SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews)((Object)object);
            Log.logger(SfiSpectralSetupEditor.class).fine("Instructed to display view : " + (Object)((Object)scienceGoalEditorSubviews));
            this.configureEditorForView(scienceGoalEditorSubviews);
            return;
        }
        if (fieldID.equals(FID_FEEDBACK)) {
            this.displaySpectralErrorWarning((String)object);
        } else if (fieldID.equals(FID_WALSH_SWITCHING)) {
            JCheckBox jCheckBox = (JCheckBox)this.retrieve(FID_WALSH_SWITCHING);
            this.set2(jCheckBox, (boolean)((Boolean)object));
        } else if (fieldID.equals(FID_WALSH_SWITCHING_USER_CONTROLLABLE)) {
            this.retrieve(FID_WALSH_SWITCHING).setEnabled((Boolean)object);
        } else if (fieldID.equals(this.FID_DEFINE_REST_FREQUENCIES)) {
            Velocity velocity;
            JButton jButton = (JButton)this.retrieve(this.FID_DEFINE_REST_FREQUENCIES);
            jButton.setEnabled(false);
            SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getMyModel().getDocument());
            if (spectralSetupParameters != null) {
                int n = this.targetsTable.getSelectionModel().getMaxSelectionIndex();
                if (n == -1) {
                    n = 0;
                }
                TargetParameters targetParameters = spectralSetupParameters.getScienceGoal().getTargetParameters(n);
                velocity = targetParameters.getSourceVelocity();
            } else {
                velocity = Velocity.createVelocity();
            }
            if (this.isUserWantingToAddOverlayLinesToExpectedLines()) {
                this.getMyModel().addExistingOverlayLinesToRestFrequencies();
            }
            SpectralLinePublisher spectralLinePublisher = DialogSpectralLineChooser.getInstance().createPublisher(this, REST_FREQUENCIES_DEFINED_FID, jButton);
            DialogSpectralLineChooser.getInstance().chooseMultipleLinesForRestFrequencies(spectralLinePublisher, velocity, spectralSetupParameters, this.getSpectralLineValidator());
        }
        super.update(fieldID, object);
    }

    private boolean isUserWantingToAddOverlayLinesToExpectedLines() {
        SpectralSetupParametersModel spectralSetupParametersModel = this.getMyModel();
        if (spectralSetupParametersModel.isSpectralScan()) {
            return false;
        }
        if (spectralSetupParametersModel.isExpectedLinesToBeDefinedByPI() && spectralSetupParametersModel.isOverlayLinesDefined()) {
            return GUIUtilities.confirm(null, "Do you want to add the overlay lines to the expected rest frequencies associated with the spectral windows?");
        }
        return false;
    }

    private void displaySpectralErrorWarning(String string) {
        String string2;
        if (StringUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (StringUtils.startsWith((CharSequence)string, (CharSequence)"Warning:")) {
            string2 = StringUtils.removeStart((String)string, (String)"Warning:");
            this.feedbackArea.setForeground(Color.BLUE);
        } else {
            this.feedbackArea.setForeground(Color.RED);
            string2 = string;
        }
        SwingUtilities.invokeLater(() -> this.feedbackArea.setText(string2));
    }

    @Override
    public void configureEditorForView(SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews scienceGoalEditorSubviews) {
        switch (scienceGoalEditorSubviews) {
            case DEFAULTVIEW: {
                this.configureSpectralSetupEditorForDefaultView();
                break;
            }
            case SOLAR: {
                this.configureSpectralEditorForSolar();
                break;
            }
            case VLBI: {
                this.configureSpectralSetupEditorForVLBI();
                break;
            }
            default: {
                throw new RuntimeException("Unknown view requested : " + (Object)((Object)scienceGoalEditorSubviews));
            }
        }
        this.singleContinuumEditor.configureEditorForView(scienceGoalEditorSubviews);
    }

    private void configureSpectralSetupEditorForDefaultView() {
        SpectralSetupParameters spectralSetupParameters;
        Object object;
        Enumeration<AbstractButton> enumeration = this.spectralTypeButtonGroup.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ((AbstractButton)object).setEnabled(true);
        }
        this.getComponent(FID_POLARIZATION).setEnabled(true);
        this.setFullPolarizationButtonVisibility(true);
        object = this.getMyModel();
        if (object != null && (spectralSetupParameters = ((SpectralSetupParametersModel)object).getSpectralSetupParameters()) != null) {
            this.determineSpectralModeSpecificPolarisationOptions(spectralSetupParameters.getSpectralType());
        }
    }

    private void configureSpectralEditorForSolar() {
        SpectralSetupParametersModel spectralSetupParametersModel = this.getMyModel();
        if (spectralSetupParametersModel == null) {
            return;
        }
        SpectralSetupParameters spectralSetupParameters = spectralSetupParametersModel.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return;
        }
        if (spectralSetupParameters.getPolarisation().equals(CorrPolarization.FULL.toString())) {
            spectralSetupParametersModel.update(this, FID_POLARIZATION, CorrPolarization.DOUBLE.polarization);
        }
        this.setFullPolarizationButtonVisibility(false);
        spectralSetupParametersModel.update(this, FID_SPECTRALTYPE, SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM.label);
        Enumeration<AbstractButton> enumeration = this.spectralTypeButtonGroup.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            abstractButton.setEnabled(false);
        }
        this.retrieve(FID_POLARIZATION).setEnabled(true);
    }

    private void configureSpectralSetupEditorForVLBI() {
        SpectralSetupParametersModel spectralSetupParametersModel = this.getMyModel();
        if (spectralSetupParametersModel == null) {
            return;
        }
        this.setFullPolarizationButtonVisibility(true);
        spectralSetupParametersModel.update(this, FID_POLARIZATION, CorrPolarization.FULL.polarization);
        spectralSetupParametersModel.update(this, FID_SPECTRALTYPE, SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM.label);
        Enumeration<AbstractButton> enumeration = this.spectralTypeButtonGroup.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            abstractButton.setEnabled(false);
        }
        this.retrieve(FID_POLARIZATION).setEnabled(false);
    }

    private void setFullPolarizationButtonVisibility(boolean bl) {
        OTButtonGroup oTButtonGroup = (OTButtonGroup)this.retrieve(FID_POLARIZATION);
        assert (oTButtonGroup != null) : "Unable to find polarization buttons";
        Enumeration<AbstractButton> enumeration = oTButtonGroup.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!StringUtils.equals((CharSequence)abstractButton.getText(), (CharSequence)SpectralSetupParameters.POLARISATION_FULL)) continue;
            abstractButton.setVisible(bl);
            break;
        }
    }

    private void determineSpectralModeSpecificPolarisationOptions(SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice) {
        AbstractButton abstractButton;
        ButtonGroup buttonGroup = this.polarisationButtonGroup.getButtonGroup();
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        AbstractButton abstractButton2 = null;
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getMyModel().getDocument());
        boolean bl = false;
        try {
            if (spectralSetupParameters.getObservatoryGoal() == null) {
                bl = spectralSetupParameters.getScienceGoal().getObsProposal().isVLBI();
            }
        }
        catch (UnknownEntityException | NullPointerException throwable) {
            bl = false;
        }
        if (bl) {
            return;
        }
        Enumeration<AbstractButton> enumeration2 = buttonGroup.getElements();
        while (enumeration2.hasMoreElements()) {
            abstractButton = enumeration2.nextElement();
            abstractButton.setEnabled(!bl);
        }
        if (bl) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            abstractButton = enumeration.nextElement();
            if (!abstractButton.getText().equals("FULL")) continue;
            abstractButton2 = abstractButton;
        }
        assert (abstractButton2 != null);
        if (abstractButton2 == null) {
            return;
        }
        if (AlmaCapabilities.getInstance().getIsFullPolarizationRestricted() && !spectralSetupTypeChoice.equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE) && !spectralSetupTypeChoice.equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM) && !Telescope.isOTConfiguredAs(Telescope.CSVALMA) || spectralSetupTypeChoice.equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALSCAN) && Telescope.isOTConfiguredAs(Telescope.CSVALMA)) {
            abstractButton2.setEnabled(false);
            if (this.getMyModel().getSpectralSetupParameters().getPolarisation().equals(CorrPolarization.FULL.toString())) {
                this.getMyModel().update(this, FID_POLARIZATION, CorrPolarization.DOUBLE.polarization);
            }
        } else {
            abstractButton2.setEnabled(true);
        }
    }

    private void updateView(SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice) {
        this.spectralLineGroup.setVisible(false);
        this.singleContinuumGroup.setVisible(false);
        this.spectralScanGroup.setVisible(false);
        this.spectralScanGroup.setVisible(false);
        this.advancedSpectralGroup.setVisible(false);
        this.feedbackArea.setText(null);
        switch (spectralSetupTypeChoice) {
            case SPECTRALLINE: {
                for (int i = 0; i < 4; ++i) {
                    this.spectralLineEditor.getMyModel().getSubModel(i).publish();
                }
                this.spectralLineEditor.setReadOnlyTable(false);
                this.spectralLineGroup.setVisible(true);
                this.singleContinuumGroup.setVisible(false);
                this.spectralScanGroup.setVisible(false);
                this.getMyModel().setWalshSwitchingUserAvailability();
                break;
            }
            case SINGLECONTINUUM: {
                for (int i = 0; i < 4; ++i) {
                    this.spectralContinuumLineEditor.getMyModel().getSubModel(i).publish();
                }
                this.spectralContinuumLineEditor.setButtonBoxesVisible(false);
                this.spectralContinuumLineEditor.setReadOnlyTable(true);
                this.singleContinuumGroup.setVisible(true);
                this.spectralLineGroup.setVisible(false);
                this.spectralScanGroup.setVisible(false);
                this.getMyModel().setWalshSwitchingUserAvailability();
                break;
            }
            case SPECTRALSCAN: {
                this.spectralLineGroup.setVisible(false);
                this.singleContinuumGroup.setVisible(false);
                this.spectralScanGroup.setVisible(true);
                this.getMyModel().setWalshSwitchingUserAvailability();
                break;
            }
            default: {
                Log.logger((Object)this).warning("Unexpected TypeChoice : " + (Object)((Object)spectralSetupTypeChoice));
            }
        }
        this.getLayout().layoutContainer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void feedbackAdvancedSetup(TableModelEvent tableModelEvent) throws InvalidGroupIndexException {
        this.setSpectralSetupAdvisorySeverity(SpectralFeedback.AdvisoryType.ERROR);
        SpectralSetupParameters spectralSetupParameters = this.getMyModel().getSpectralSetupParameters();
        if (spectralSetupParameters == null || !this.feedbackComplete) {
            return;
        }
        this.feedbackComplete = false;
        try {
            int n = ((MultiResolutionElementTableModel)tableModelEvent.getSource()).getTargetIndex();
            String string = spectralSetupParameters.feedbackAdvancedSetup(n);
            if (this.feedbackArea != null) {
                this.feedbackArea.setForeground(Color.RED);
                this.feedbackArea.setText(string);
            }
            return;
        }
        finally {
            this.feedbackComplete = true;
        }
    }

    private void feedbackSingleContinuumSetup() {
        this.setSpectralSetupAdvisorySeverity(SpectralFeedback.AdvisoryType.ERROR);
        SpectralSetupParameters spectralSetupParameters = this.getMyModel().getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return;
        }
        if (spectralSetupParameters.getSoleFrequency().isZero()) {
            return;
        }
        String string = spectralSetupParameters.feedbackSingleContinuumSetup();
        if (this.feedbackArea != null) {
            this.feedbackArea.setForeground(Color.RED);
            this.feedbackArea.setText(string);
        }
    }

    public void addScienceSpectralWindowSelectionListener(ScienceSpectralWindowSelectionListener scienceSpectralWindowSelectionListener) {
        this.listeners.add(scienceSpectralWindowSelectionListener);
    }

    private void scienceSpectralWindowSelectionChanged(AbstractScienceSpectralWindow abstractScienceSpectralWindow) {
        for (ScienceSpectralWindowSelectionListener scienceSpectralWindowSelectionListener : this.listeners) {
            scienceSpectralWindowSelectionListener.scienceSpectralWindowSelectionChanged(abstractScienceSpectralWindow);
        }
    }

    private void addSpectralSelectionListener(final SpectralSetupParametersEditor spectralSetupParametersEditor, final int n) {
        ListSelectionListener listSelectionListener = new ListSelectionListener(){
            final SpectralSetupParametersEditor parentEditor;
            final int subEditorIndex;
            {
                this.parentEditor = spectralSetupParametersEditor;
                this.subEditorIndex = n;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n2 = this.parentEditor.getSelectedScienceSpectralWindowIndex(this.subEditorIndex);
                if (n2 < 0) {
                    return;
                }
                if (this.parentEditor.isVisible()) {
                    SfiSpectralSetupEditor.this.scienceSpectralWindowSelectionChanged(this.parentEditor.getSelectedScienceSpectralWindow(this.subEditorIndex));
                    for (int i = 0; i < 4; ++i) {
                        if (this.subEditorIndex == i) continue;
                        ListSelectionListener listSelectionListener = this.parentEditor.getListSelectionListener(i);
                        this.parentEditor.removeListSelectionListener(i, listSelectionListener);
                        this.parentEditor.clearSelection(i);
                        this.parentEditor.addListSelectionListener(i, listSelectionListener);
                    }
                }
            }
        };
        spectralSetupParametersEditor.addListSelectionListener(n, listSelectionListener);
    }

    private void addSpectralSelectionListeners(SpectralSetupParametersEditor spectralSetupParametersEditor) {
        for (int i = 0; i < 4; ++i) {
            this.addSpectralSelectionListener(spectralSetupParametersEditor, i);
        }
    }

    public JTable getTargetsTable() {
        return this.targetsTable;
    }

    private void addSourceVelocityGroup(SingleFieldScienceGoalModel singleFieldScienceGoalModel) {
        JPanel jPanel = null;
        jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.targetsTable = new Table(this.targetsTableModel);
        this.targetsTable.setName("SfiSpectralSetupEditor.targetsTable");
        this.targetsTable.setDefaultRenderer(Object.class, new ResourceColumnRenderer());
        this.targetsTable.setDefaultRenderer(Double.class, new ResourceColumnRenderer());
        this.targetsTable.setSelectionMode(0);
        this.targetsTable.setColumnSelectionAllowed(false);
        this.targetsTable.setRowSelectionAllowed(true);
        this.targetsTable.getTableHeader().setReorderingAllowed(false);
        ColumnResizer.initColumnSizes(this.targetsTable, this.targetsTableModel.getLongValues());
        this.addSourceVelocitySelectionListener(this.targetsTable);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.targetsTable);
        this.addComponent(0, jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        JPanel jPanel2 = this.addGroup(jPanel, "Targets");
        CSH.setHelpIDString((Component)jPanel2, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup-Targets");
    }

    private void setSpectralSetupAdvisorySeverity(SpectralFeedback.AdvisoryType advisoryType) {
        this.feedbackArea.setBorder(BorderFactory.createTitledBorder("Spectral Setup " + advisoryType.getLabel()));
    }

    public void addSourceVelocitySelectionListener(JTable jTable) {
        ListSelectionListener listSelectionListener = new ListSelectionListener(){
            private int oldTargetIndex = -1;

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.getValueIsAdjusting()) {
                    int n = listSelectionModel.getMaxSelectionIndex();
                    if (n == -1 || n == this.oldTargetIndex) {
                        return;
                    }
                    this.oldTargetIndex = n;
                    if (SfiSpectralSetupEditor.this.spectralLineGroup.isVisible()) {
                        for (int i = 0; i < 4; ++i) {
                            MultiResolutionElementTableModel multiResolutionElementTableModel = SfiSpectralSetupEditor.this.spectralLineEditor.getSubEditor(i).getMyModel().getTableModel();
                            multiResolutionElementTableModel.setTargetIndex(n);
                        }
                    } else if (SfiSpectralSetupEditor.this.singleContinuumGroup.isVisible()) {
                        for (int i = 0; i < 4; ++i) {
                            MultiResolutionElementTableModel multiResolutionElementTableModel = SfiSpectralSetupEditor.this.spectralContinuumLineEditor.getSubEditor(i).getMyModel().getTableModel();
                            multiResolutionElementTableModel.setTargetIndex(n);
                        }
                        SfiSpectralSetupEditor.this.singleContinuumEditor.getModel().getObservingFrequency().setTargetIndex(n);
                    } else if (SfiSpectralSetupEditor.this.spectralScanGroup.isVisible()) {
                        SfiSpectralSetupEditor.this.scanEditor.getModel().setTargetIndex(n);
                    }
                }
            }
        };
        jTable.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    @Override
    public void finalizeUserEdits() {
        this.spectralLineEditor.finalizeUserEdits();
    }

    public static void main(String[] stringArray) throws Exception {
        for (UIManager.LookAndFeelInfo object2 : UIManager.getInstalledLookAndFeels()) {
            if (!"Metal".equals(object2.getName())) continue;
            UIManager.setLookAndFeel(object2.getClassName());
            break;
        }
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Single Field Spectral Setup Editor");
        jFrame.setDefaultCloseOperation(3);
        ObsProject obsProject = ObsProject.createObsProject();
        ObsProposal obsProposal = ObsProposal.createObsProposal();
        obsProject.setObsProposal(obsProposal);
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        obsProposal.addAbstractScienceGoal((AbstractScienceGoal)((Object)scienceGoal));
        scienceGoal.getKeyTargetParameters().getSourceVelocity().getCenterVelocity().setContentAndUnit(1000.0, Speed.UNIT_KM_S);
        TargetParameters targetParameters = TargetParameters.createTargetParameters();
        targetParameters.getSourceVelocity().getCenterVelocity().setContentAndUnit(170000.0, Speed.UNIT_KM_S);
        scienceGoal.addTargetParameters(targetParameters);
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        spectralSetupParameters.setPolarisation(SpectralSetupParameters.POLARISATION_DOUBLE);
        spectralSetupParameters.clearAbstractScienceSpectralWindow();
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow(88.6316, "HCN v=0 J=1-0", 62.5, 0.06103515625);
        ScienceSpectralWindow scienceSpectralWindow2 = ScienceSpectralWindow.createScienceSpectralWindow(89.18853, "HCO+ v=0 1-0", 62.5, 0.06103515625);
        ScienceSpectralWindow scienceSpectralWindow3 = ScienceSpectralWindow.createScienceSpectralWindow(89.48741000000001, "HOC+ v=0 1-0", 62.5, 0.06103515625);
        scienceSpectralWindow.setGroupResourceUse(ScienceSpectralWindow.GROUPRESOURCEUSE_QUARTER);
        scienceSpectralWindow2.setGroupResourceUse(ScienceSpectralWindow.GROUPRESOURCEUSE_QUARTER);
        scienceSpectralWindow3.setGroupResourceUse(ScienceSpectralWindow.GROUPRESOURCEUSE_QUARTER);
        ScienceSpectralWindow scienceSpectralWindow4 = ScienceSpectralWindow.createScienceSpectralWindow(102.21757000000001, "NH2CHO 2(1,2)-1(0,1)", 62.5, 0.030517578125000003);
        ScienceSpectralWindow scienceSpectralWindow5 = ScienceSpectralWindow.createScienceSpectralWindow(102.58748, "CF+ v=0 1-0", 62.5, 0.030517578125000003);
        scienceSpectralWindow4.setGroupResourceUse(ScienceSpectralWindow.GROUPRESOURCEUSE_HALF);
        scienceSpectralWindow5.setGroupResourceUse(ScienceSpectralWindow.GROUPRESOURCEUSE_HALF);
        spectralSetupParameters.addScienceSpectralWindow(0, 0, scienceSpectralWindow);
        spectralSetupParameters.addScienceSpectralWindow(0, 1, scienceSpectralWindow2);
        spectralSetupParameters.addScienceSpectralWindow(0, 2, scienceSpectralWindow3);
        spectralSetupParameters.addScienceSpectralWindow(1, 0, scienceSpectralWindow4);
        spectralSetupParameters.addScienceSpectralWindow(1, 1, scienceSpectralWindow5);
        spectralSetupParameters.setType(SpectralSetupParameters.TYPE_FULL);
        SingleFieldScienceGoalModel singleFieldScienceGoalModel = new SingleFieldScienceGoalModel(null);
        SpectralSetupParametersModel spectralSetupParametersModel = singleFieldScienceGoalModel.getSpectralSetupParametersModel();
        SfiSpectralSetupEditor sfiSpectralSetupEditor = new SfiSpectralSetupEditor(spectralSetupParametersModel);
        singleFieldScienceGoalModel.setDocument(scienceGoal);
        TestUtilities.runTestApp(sfiSpectralSetupEditor);
    }

    public static interface ScienceSpectralWindowSelectionListener
    extends EventListener {
        public void scienceSpectralWindowSelectionChanged(AbstractScienceSpectralWindow var1);
    }

    public static interface ScienceSpectralWindowSelector {
        public AbstractScienceSpectralWindow getSelectedScienceSpectralWindow();
    }

    protected class AdvancedSpectralPanel
    extends NotSupportedYetPanel
    implements ScienceSpectralWindowSelector {
        AdvancedSpectralPanel(String string) {
            super(string);
        }

        @Override
        public AbstractScienceSpectralWindow getSelectedScienceSpectralWindow() {
            return null;
        }
    }
}

