/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.common.sourcecatalog.utilities.TextUtils;
import alma.entity.xmlbinding.obsproject.types.PerformanceParametersTTimingConstraintsTypeType;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.FieldTypeInfo;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.ot.editors.sciencegoals.EstimatedTimeInfoBuilder;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateInterface;
import alma.obsprep.services.etc.SchedBlockObservingTimeCalculator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.valuetypes.Time;
import java.awt.Dimension;

public class SolarTimeEstimate
implements TimeEstimateInterface {
    @Override
    public EstimatedTimeInfoBuilder.TimeEstimateModel generateTimeEstimateModel(ScienceGoal scienceGoal) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator;
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        EstimatedTimeInfoBuilder.TimeEstimateModel timeEstimateModel = new EstimatedTimeInfoBuilder.TimeEstimateModel();
        timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 500));
        Time time = Time.createTime();
        Integer n = 1;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Time time2 = performanceParameters.getDesiredTime().deepCopy().convertToFriendlyUnit();
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        if (performanceParameters.getIsTimeConstrained() && performanceParameters.getTimingConstraintsType() != null && performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.MULTIPLEVISITS.toString())) {
            n = performanceParameters.getVisitConstraintCount();
        }
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = null;
        try {
            scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to get details of configurations " + invalidObsProgramParametersException.getMessage());
        }
        timeEstimateModel.setScienceGoalConfigurations(scienceGoalConfigurations);
        if (targetParameters.getType().equals(FieldTypeInfo.F_SingleRectangle.getValue()) && ((object = targetParameters.getFieldRectangle()[0]).getLong().isZero() || object.getShort().isZero())) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Rectangle definition incomplete - please define the rectangle in your field setup correctly");
        }
        object = new SchedBlockObservingTimeCalculator.Builder();
        ((SchedBlockObservingTimeCalculator.Builder)object).scienceGoal(scienceGoal);
        try {
            schedBlockObservingTimeCalculator = new SchedBlockObservingTimeCalculator((SchedBlockObservingTimeCalculator.Builder)object);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(invalidObsProgramParametersException.getMessage());
        }
        timeEstimateModel.addToHeader("<h3>Requested Solar Time</h3>", "");
        for (ScienceGoal scienceGoal2 : schedBlockObservingTimeCalculator.getScienceGoalsWithClusters()) {
            timeEstimateModel.setClusterSpecificScienceGoal(scienceGoal2);
            Time time3 = Time.createTime();
            timeEstimateModel.addClusterSpecificKeyValuePair("Interferometric observation (TM1)", TextUtils.format((ValueUnitPair)time2.convertToFriendlyUnit(), (int)2));
            Boolean bl = performanceParameters.gettrueUseTP();
            double d = 0.0;
            if (Boolean.TRUE.equals(bl)) {
                try {
                    d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal);
                    time3 = (Time)time2.multiply(d);
                    timeEstimateModel.addClusterSpecificKeyValuePair("ACA TP observation", TextUtils.format((ValueUnitPair)time3.convertToFriendlyUnit(), (int)2));
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    Log.logger(EstimatedTimeInfoBuilder.class).warning("Unable to determine multiplier for ACA TP");
                    timeEstimateModel.addClusterSpecificKeyValuePair("ACA TP time (t_12m x ?)", "ACA invalid with this configuration");
                }
            }
            Time time4 = ((Time)time2.plus((AbstractDoubleWithUnit)time3)).convertToFriendlyUnit();
            if (n > 1) {
                timeEstimateModel.addClusterSpecificKeyValuePair("Number of visits", n.toString());
                timeEstimateModel.addClusterSpecificKeyValuePair("<h3>Total time </h3>", TextUtils.format((ValueUnitPair)((Time)time4.multiply(n.intValue())).convertToFriendlyUnit(), (int)2));
            } else {
                timeEstimateModel.addClusterSpecificKeyValuePair("<h3>Total time</h3", TextUtils.format((ValueUnitPair)time4.convertToFriendlyUnit(), (int)2));
            }
            time.aggregate((Time)time4.multiply(n.intValue()));
            timeEstimateModel.commitClusterSpecificData();
        }
        timeEstimateModel.addToHeader("Total requested solar time", TextUtils.format((ValueUnitPair)time.convertToFriendlyUnit(), (int)2));
        return timeEstimateModel;
    }
}

