/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.ot.editors.spectralvisual.BooleanColumnRenderer;
import alma.obsprep.ot.editors.spectralvisual.ResourceColumnRenderer;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.models.sciencegoals.SpectralScanTuningTableModel;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class SpectralScanTuningsTable
extends Table {
    private static final Map<Integer, String> columnToolTips;
    public static final int DEFAULT_WIDTH = 800;

    public SpectralScanTuningsTable(TableModel tableModel) {
        super(tableModel);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setupRenderers();
    }

    private SpectralScanTuningTableModel getMyModel() {
        return (SpectralScanTuningTableModel)this.dataModel;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnModel.getColumnIndexAtX(point.x);
                int n2 = this.columnModel.getColumn(n).getModelIndex();
                if (columnToolTips.containsKey(n2)) {
                    return (String)columnToolTips.get(n2);
                }
                return null;
            }
        };
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
    }

    private void setupRenderers() {
        this.setDefaultRenderer(Object.class, new ResourceColumnRenderer());
        this.setDefaultRenderer(Boolean.class, new BooleanColumnRenderer());
        this.setDefaultRenderer(Integer.class, new ResourceColumnRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Integer n3 = (Integer)object;
                return super.getTableCellRendererComponent(jTable, n3.toString(), bl, bl2, n, n2);
            }
        });
        this.setDefaultRenderer(Double.class, new ResourceColumnRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Double d = (Double)object;
                StringBuilder stringBuilder = new StringBuilder();
                Formatter formatter = new Formatter(stringBuilder, Locale.ENGLISH);
                formatter.format("%.4f", d);
                formatter.close();
                return super.getTableCellRendererComponent(jTable, stringBuilder, bl, bl2, n, n2);
            }
        });
        this.setDefaultRenderer(Frequency.class, new ResourceColumnRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Frequency frequency = (Frequency)((Object)object);
                String string = TextUtils.format(frequency, 4);
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        ColumnResizer.initColumnSizes(this, this.getMyModel().getLongValues());
    }

    static {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(SpectralScanTuningTableModel.ColumnDescriptor.TUNINGNUMBER.getColumnIndex(), "Tuning");
        hashMap.put(SpectralScanTuningTableModel.ColumnDescriptor.SPWONE.getColumnIndex(), "Spectral window 1");
        hashMap.put(SpectralScanTuningTableModel.ColumnDescriptor.SPWTWO.getColumnIndex(), "Spectral window 2");
        hashMap.put(SpectralScanTuningTableModel.ColumnDescriptor.SPWTHREE.getColumnIndex(), "Spectral window 3");
        hashMap.put(SpectralScanTuningTableModel.ColumnDescriptor.SPWFOUR.getColumnIndex(), "Spectral window 4");
        hashMap.put(SpectralScanTuningTableModel.ColumnDescriptor.SPWFIVE.getColumnIndex(), "Spectral window 5");
        hashMap.put(SpectralScanTuningTableModel.ColumnDescriptor.SPWSIX.getColumnIndex(), "Spectral window 6");
        hashMap.put(SpectralScanTuningTableModel.ColumnDescriptor.SPWSEVEN.getColumnIndex(), "Spectral window 7");
        hashMap.put(SpectralScanTuningTableModel.ColumnDescriptor.SPWEIGHT.getColumnIndex(), "Spectral window 8");
        columnToolTips = Collections.unmodifiableMap(hashMap);
    }
}

