/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.ContextSwitchInterface;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.editors.sciencegoals.MultiResolutionElementTable;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.MultiResolutionElementTableModel;
import alma.obsprep.ot.models.sciencegoals.SpectralWindowGroupModel;
import alma.obsprep.services.experts.spectralline.DialogSpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.SpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLinePublisher;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SpectralWindowGroupEditor
extends Editor
implements SfiSpectralSetupEditor.ScienceSpectralWindowSelector {
    public static FieldID FID_DISPLAY_IMAGE_TABLE_CHECKBOX_USER_CONTROLLABLE = new FieldID("SpectralWindowSetupSuperEditor.enableDisplayImageTableCheckBox");
    public static final FieldID FID_TABLE = new FieldID("SpectralWindowSetupSuperEditor.table");
    public static final FieldID FID_IMAGE_TABLE = new FieldID("SpectralWindowSetupSuperEditor.imageTable");
    public static final FieldID FID_SELECT_LINES = new FieldID("SpectralWindowSetupSuperEditor select lines");
    public static final FieldID FID_DISPLAY_IMAGE_TABLE_CHECKBOX = new FieldID("SpectralWindowSetupSuperEditor.displayImageTable");
    private final SpectralLineChooser lineChooser;
    private SpectralLineButtonBox buttonBox;
    private Table spwTable;
    private ListSelectionListener listSelectionListener = null;
    private TableColumn walshSwitchTableColumn;
    private ScrollWhenFocusedPane spwTableScrolledPanel;
    private JPanel spectralLineButtonContainer;

    public SpectralWindowGroupEditor(SpectralWindowGroupModel spectralWindowGroupModel, SpectralLineChooser spectralLineChooser) {
        this.setModel(spectralWindowGroupModel);
        this.setName("SpectralWindowSetupSuperEditor/BB-" + spectralWindowGroupModel.getGroupIndex());
        this.lineChooser = spectralLineChooser;
        this.build();
        spectralWindowGroupModel.publish();
    }

    public SpectralWindowGroupEditor(SpectralWindowGroupModel spectralWindowGroupModel) {
        this(spectralWindowGroupModel, DialogSpectralLineChooser.getInstance());
    }

    public SpectralWindowGroupModel getMyModel() {
        return (SpectralWindowGroupModel)this.getModel();
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.spwTable.getModel().addTableModelListener(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.spwTable.getModel().removeTableModelListener(tableModelListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionListener = listSelectionListener;
        this.spwTable.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.spwTable.getSelectionModel().removeListSelectionListener(listSelectionListener);
        this.listSelectionListener = null;
    }

    public ListSelectionListener getListSelectionListener() {
        return this.listSelectionListener;
    }

    public ScienceSpectralWindow getSelectedScienceSpectralWindow() {
        int n = this.spwTable.getSelectedRow();
        ScienceSpectralWindow[] scienceSpectralWindowArray = this.getMyModel().getSpectralWindows();
        if (n == -1 || n >= scienceSpectralWindowArray.length) {
            return null;
        }
        return scienceSpectralWindowArray[n];
    }

    public void clearSelection() {
        this.spwTable.clearSelection();
    }

    public int getSelectedScienceSpectralWindowIndex() {
        return this.spwTable.getSelectedRow();
    }

    @Override
    protected void build() {
        this.setLayout(new BoxLayout(this, 3));
        this.spwTable = new MultiResolutionElementTable(this.getMyModel().getTableModel());
        UserEditRestrictionController.getInstance().registerUserChangeRestrictionAffectedComponents((List<JComponent>)ImmutableList.of((Object)this.spwTable));
        this.spwTable.setSelectionMode(0);
        this.spwTable.setColumnSelectionAllowed(false);
        this.register(this.spwTable, FID_TABLE);
        this.addListSelectionListener(listSelectionEvent -> this.setButtons());
        Dimension dimension = new Dimension(550, this.spwTable.getRowHeight() * 4);
        this.spwTable.setPreferredScrollableViewportSize(dimension);
        this.spwTableScrolledPanel = new ScrollWhenFocusedPane(this.spwTable);
        this.add((Component)this.spwTableScrolledPanel, "Center");
        this.spectralLineButtonContainer = this.createLineContainer();
        this.buttonBox = new SpectralLineButtonBox(this.getMyModel().getGroupIndex());
        this.spectralLineButtonContainer.add(this.buttonBox);
        JCheckBox jCheckBox = this.makeCheckBox(FID_DISPLAY_IMAGE_TABLE_CHECKBOX, "Show image spectral windows", "When selected, displays the image sidebands in the event that 90-degrees Walsh switching is enabled");
        this.spectralLineButtonContainer.add(jCheckBox);
        jCheckBox.setFocusPainted(false);
        jCheckBox.setSelected(false);
        jCheckBox.setEnabled(false);
        this.add((Component)this.spectralLineButtonContainer, "South");
        Integer n = this.getMyModel().getGroupIndex() + 1;
        this.setBorder(BorderFactory.createTitledBorder("Baseband-" + n));
        this.setMaxRows(SpectralWindowGroupModel.MAX_WINDOWS_PER_BASEBAND);
    }

    public void removeTableHeader() {
        this.spwTable.setTableHeader(null);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(FID_TABLE)) {
            this.setButtons();
            if (this.spwTable.getSelectedRowCount() == 0 && this.spwTable.getRowCount() > 0) {
                this.spwTable.getSelectionModel().setSelectionInterval(0, 0);
            }
            return;
        }
        if (fieldID.equals(FID_SELECT_LINES)) {
            this.buttonBox.setButtons();
        } else if (fieldID.equals(SfiSpectralSetupEditor.FID_WALSH_SWITCHING)) {
            boolean bl;
            TableColumnModel tableColumnModel = this.spwTable.getColumnModel();
            int n = MultiResolutionElementTableModel.ColumnDescriptor.WALSHSWITCH.getColumnIndex();
            try {
                bl = this.spwTable.getColumnName(n).equals(MultiResolutionElementTableModel.ColumnDescriptor.WALSHSWITCH.getColumnName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
            boolean bl2 = (Boolean)object;
            SpectralSetupParameters spectralSetupParameters = this.getMyModel().getSpectralSetupParameters();
            if (bl2 && spectralSetupParameters.isSpectralLine()) {
                if (!bl && this.walshSwitchTableColumn != null) {
                    this.spwTable.addColumn(this.walshSwitchTableColumn);
                    this.spwTable.moveColumn(tableColumnModel.getColumnCount() - 1, n);
                }
            } else if (bl) {
                this.walshSwitchTableColumn = tableColumnModel.getColumn(n);
                this.spwTable.removeColumn(this.walshSwitchTableColumn);
            }
        } else if (fieldID.equals(FID_DISPLAY_IMAGE_TABLE_CHECKBOX)) {
            TableCellEditor tableCellEditor;
            if (object == null) {
                return;
            }
            boolean bl = (Boolean)object;
            if (bl && (tableCellEditor = this.spwTable.getCellEditor()) != null && !tableCellEditor.stopCellEditing()) {
                this.getMyModel().update(null, FID_DISPLAY_IMAGE_TABLE_CHECKBOX, false);
                object = false;
            }
        } else if (fieldID.equals(FID_DISPLAY_IMAGE_TABLE_CHECKBOX_USER_CONTROLLABLE)) {
            boolean bl = (Boolean)object;
            this.retrieve(FID_DISPLAY_IMAGE_TABLE_CHECKBOX).setEnabled(bl);
        }
        super.update(fieldID, object);
    }

    protected boolean showsFraction() {
        return true;
    }

    public void setMaxRows(int n) {
        this.buttonBox.setMaxRows(n);
    }

    public JButton getSelectButton() {
        return this.buttonBox.selectButton;
    }

    private void setButtons() {
        if (!this.isEnabled()) {
            return;
        }
        this.buttonBox.setButtons();
    }

    public void setButtonBoxVisible(boolean bl) {
        this.buttonBox.setVisible(bl);
    }

    public int getTableColumnWidth(int n) throws IndexOutOfBoundsException {
        TableColumn tableColumn = this.spwTable.getColumnModel().getColumn(n);
        return tableColumn.getPreferredWidth();
    }

    public void setTableColumnWidth(int n, int n2) throws IndexOutOfBoundsException {
        TableColumn tableColumn = this.spwTable.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
    }

    public int getTableColumnCount() {
        return this.spwTable.getColumnCount();
    }

    public void addTableColumnListener(TableColumnModelListener tableColumnModelListener) {
        this.spwTable.getColumnModel().addColumnModelListener(tableColumnModelListener);
    }

    public void removeTableColumnListener(TableColumnModelListener tableColumnModelListener) {
        this.spwTable.getColumnModel().removeColumnModelListener(tableColumnModelListener);
    }

    public void setTablePreferredScrollableViewportSize(Dimension dimension) {
        this.spwTable.setPreferredScrollableViewportSize(dimension);
    }

    public void printElements() {
        ScienceSpectralWindow[] scienceSpectralWindowArray = this.getMyModel().getSpectralWindows();
        System.out.println(scienceSpectralWindowArray.length + " ScienceSpectralWindow");
        int n = 0;
        for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[" + n++ + "] bbc = " + scienceSpectralWindow.getGroupIndex());
            stringBuffer.append(", centerFrequency = " + (Object)((Object)scienceSpectralWindow.getCenterFrequency()));
            stringBuffer.append(", mode = " + scienceSpectralWindow.getCorrConfigMode());
            System.out.println(stringBuffer.toString());
        }
    }

    protected void cancelCellEditing() {
        if (this.spwTable == null) {
            return;
        }
        Enumeration<TableColumn> enumeration = this.spwTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableCellEditor tableCellEditor;
            TableColumn tableColumn = enumeration.nextElement();
            if (tableColumn == null || (tableCellEditor = tableColumn.getCellEditor()) == null) continue;
            tableCellEditor.cancelCellEditing();
        }
    }

    @Override
    public void finalizeUserEdits() {
        if (this.spwTable == null) {
            return;
        }
        Enumeration<TableColumn> enumeration = this.spwTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableCellEditor tableCellEditor;
            TableColumn tableColumn = enumeration.nextElement();
            if (tableColumn == null || (tableCellEditor = tableColumn.getCellEditor()) == null || !ContextSwitchInterface.class.isAssignableFrom(tableCellEditor.getClass())) continue;
            ContextSwitchInterface contextSwitchInterface = (ContextSwitchInterface)((Object)tableCellEditor);
            try {
                contextSwitchInterface.finalizeUserEdits();
            }
            catch (Exception exception) {
                Log.logger(SpectralWindowGroupEditor.class).warning("Unable to finalise user edits : " + exception.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config/otData");
        InitServices.initModelSupportClasses();
        SpectralSetupParameters spectralSetupParameters = SpectralSetupParameters.createSpectralSetupParameters();
        SpectralWindowGroupModel spectralWindowGroupModel = new SpectralWindowGroupModel(spectralSetupParameters, 0);
        SpectralWindowGroupEditor spectralWindowGroupEditor = new SpectralWindowGroupEditor(spectralWindowGroupModel, DialogSpectralLineChooser.getInstance());
        spectralSetupParameters.setPolarisation(CorrPolarization.SINGLE_X.polarization);
        JFrame jFrame = new JFrame("SpectralElementSetupEditor Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(spectralWindowGroupEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private class SpectralLineButtonBox
    extends JPanel {
        private int maxRows = -1;
        private JButton selectButton;
        private JButton addButton;
        private JButton deleteButton;

        private SpectralLine convertToSpectralLine(ScienceSpectralWindow scienceSpectralWindow) {
            SpectralLine spectralLine = new SpectralLine();
            spectralLine.setFrequency(scienceSpectralWindow.getCenterFrequency());
            spectralLine.setLineId(scienceSpectralWindow.getSplatalogId());
            spectralLine.setTitle(scienceSpectralWindow.getTransitionName());
            spectralLine.setType(SpectralLine.Type.LINE);
            spectralLine.setScienceSpectralWindowUUID(scienceSpectralWindow.getUUID());
            return spectralLine;
        }

        public SpectralLineButtonBox(int n) {
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
            this.selectButton = new JButton("Add spectral window centred on a spectral line");
            this.selectButton.setToolTipText("Add spectral windows by selecting lines to observe from the spectral line catalog");
            this.selectButton.addActionListener(actionEvent -> {
                this.selectButton.setEnabled(false);
                ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
                for (ScienceSpectralWindow scienceSpectralWindow : SpectralWindowGroupEditor.this.getMyModel().getSpectralWindows()) {
                    arrayList.add(this.convertToSpectralLine(scienceSpectralWindow));
                }
                ArrayList arrayList2 = new ArrayList();
                for (ScienceSpectralWindow scienceSpectralWindow : SpectralWindowGroupEditor.this.getMyModel().getSpectralWindowsInOtherGroups()) {
                    arrayList2.add(this.convertToSpectralLine(scienceSpectralWindow));
                }
                Velocity velocity = SpectralWindowGroupEditor.this.getMyModel().getTableModel().getTargetVelocity();
                SpectralLinePublisher spectralLinePublisher = SpectralWindowGroupEditor.this.lineChooser.createPublisher(SpectralWindowGroupEditor.this, FID_SELECT_LINES, this.selectButton);
                SpectralWindowGroupEditor.this.lineChooser.chooseMultipleLines(spectralLinePublisher, velocity, arrayList, arrayList2);
            });
            this.add(this.selectButton);
            this.add(Box.createHorizontalStrut(17));
            this.addButton = new JButton("Add spectral window manually");
            this.addButton.setToolTipText("Add an empty spectral window to enter your own frequency");
            this.addButton.addActionListener(actionEvent -> {
                int n = this.getSelectedIndex();
                SpectralLine spectralLine = new SpectralLine();
                spectralLine.setTitle("...Enter Name Here...");
                spectralLine.setFrequency(Frequency.createFrequencyGHZ(0.0));
                SpectralWindowGroupEditor.this.getMyModel().addSpectralLine(n + 1, spectralLine);
                this.setSelectedIndex(n + 1);
                this.setButtons();
            });
            this.add(this.addButton);
            this.add(Box.createHorizontalStrut(5));
            this.deleteButton = new JButton("Delete");
            this.deleteButton.setToolTipText("Delete selected spectral window");
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SpectralLineButtonBox.this.getSelectedIndex();
                    if (n == -1) {
                        return;
                    }
                    SpectralLineButtonBox.this.deleteSpectralLine(n);
                    int n2 = SpectralLineButtonBox.this.count();
                    if (n == 0) {
                        if (n2 != 0) {
                            SpectralLineButtonBox.this.setSelectedIndex(n);
                        }
                    } else if (n == n2) {
                        SpectralLineButtonBox.this.setSelectedIndex(n - 1);
                    } else if (n != -1) {
                        SpectralLineButtonBox.this.setSelectedIndex(n);
                    }
                    SpectralLineButtonBox.this.setButtons();
                }
            });
            this.add(this.deleteButton);
            this.add(Box.createHorizontalGlue());
            this.selectButton.setName("BtnSelectSpectralLines");
            this.addButton.setName("BtnAddSpectralWindow");
            this.deleteButton.setName("BtnDeleteSpectralWindow");
        }

        public void setMaxRows(int n) {
            this.maxRows = n;
        }

        public void setButtons() {
            if (!this.isEnabled()) {
                return;
            }
            int n = this.count();
            if (this.maxRows >= 0) {
                boolean bl = n < this.maxRows;
                this.addButton.setEnabled(bl);
            }
            this.deleteButton.setEnabled(n > 0 && this.getSelectedIndex() != -1);
        }

        public int count() {
            return SpectralWindowGroupEditor.this.getMyModel().getWindowCount();
        }

        public void deleteSpectralLine(int n) {
            SpectralWindowGroupEditor.this.getMyModel().deleteWindow(n);
        }

        public int getSelectedIndex() {
            return SpectralWindowGroupEditor.this.spwTable.getSelectedRow();
        }

        public void setSelectedIndex(int n) {
            SpectralWindowGroupEditor.this.spwTable.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    public static enum SpectralWindowTableEnum {
        IMAGETABLE,
        NONIMAGETABLE;

    }
}

