/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.entity.xmlbinding.obsproject.types.PerformanceParametersTTimingConstraintsTypeType;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.editors.sciencegoals.ProjectTimeEstimateSummary;
import alma.obsprep.ot.editors.sciencegoals.ProjectTimeEstimateSummaryInterface;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SchedBlockObservingTimeCalculator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.ToBeSupportedException;
import alma.valuetypes.DataRate;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;

public class StandardProjectTimeEstimateSummary
extends ProjectTimeEstimateSummary
implements ProjectTimeEstimateSummaryInterface {
    private AbstractScienceGoal[] abstractScienceGoals;

    public StandardProjectTimeEstimateSummary(AbstractScienceGoal[] abstractScienceGoalArray) {
        if (abstractScienceGoalArray == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: abstractScienceGoals");
        }
        if (abstractScienceGoalArray.length == 0) {
            throw new IllegalArgumentException("No science goals have been defined");
        }
        this.abstractScienceGoals = abstractScienceGoalArray;
        boolean bl = false;
        for (AbstractScienceGoal abstractScienceGoal : abstractScienceGoalArray) {
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("No science goals have been defined");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String info() throws ProjectTimeEstimateSummaryInterface.UnableToGenerateProjectTimeSummaryException, UnknownEntityException {
        this.badlyConfiguredScienceGoals.clear();
        this.estimatedDataRates.clear();
        this.estimatedDataVolume.clear();
        this.estimatedCalibrationTimeData.clear();
        this.estimatedTotalTimeData.clear();
        this.scienceGoalNameMap.clear();
        HashSet<String> hashSet = new HashSet<String>();
        for (AbstractScienceGoal abstractScienceGoal : this.abstractScienceGoals) {
            if (hashSet.contains(abstractScienceGoal.getName())) {
                throw new ProjectTimeEstimateSummaryInterface.UnableToGenerateProjectTimeSummaryException("All science goals must have unique names");
            }
            hashSet.add(abstractScienceGoal.getName());
        }
        for (AbstractScienceGoal abstractScienceGoal : this.abstractScienceGoals) {
            SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator;
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            SchedBlockObservingTimeCalculator.Builder builder = new SchedBlockObservingTimeCalculator.Builder();
            builder.scienceGoal(scienceGoal);
            try {
                schedBlockObservingTimeCalculator = new SchedBlockObservingTimeCalculator(builder);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new ProjectTimeEstimateSummaryInterface.UnableToGenerateProjectTimeSummaryException(invalidObsProgramParametersException.getMessage());
            }
            Collection<ScienceGoal> collection = schedBlockObservingTimeCalculator.getScienceGoalsWithClusters();
            for (ScienceGoal scienceGoal2 : collection) {
                HashMap<Enum, Time> hashMap;
                Object object;
                Object object2;
                boolean bl = scienceGoal2.isStandAloneACA();
                boolean bl2 = scienceGoal2.isSolarScienceGoal();
                String string = scienceGoal2.getName();
                this.scienceGoalNameMap.put(scienceGoal2, string);
                boolean bl3 = scienceGoal2.getPerformanceParameters().getUseACA();
                boolean bl4 = scienceGoal2.getPerformanceParameters().getUseACA() && scienceGoal2.getPerformanceParameters().getUseTP();
                try {
                    void var25_39;
                    PerformanceParameters performanceParameters = scienceGoal2.getPerformanceParameters();
                    object2 = new ObservingTimeCalculator(scienceGoal2);
                    object = null;
                    if (performanceParameters.getNeedsMoreTime()) {
                        object = performanceParameters.getDesiredTime().deepCopy();
                        assert (object != null);
                    }
                    int n = 1;
                    if (performanceParameters.getIsTimeConstrained() && performanceParameters.getTimingConstraintsType() != null && performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.MULTIPLEVISITS.toString())) {
                        n = performanceParameters.getVisitConstraintCount();
                    }
                    hashMap = new HashMap();
                    if (object == null) {
                        for (Enum enum_ : ProjectTimeEstimateSummary.TimeTableColTypes.values()) {
                            hashMap.put(enum_, ZEROTIME);
                        }
                        if (!bl) {
                            hashMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMEXT, ((ObservingTimeCalculator)object2).getTotalRequestedTime(Array.ARRAY_12M, false, false, true));
                            if (!bl2) {
                                hashMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMCOMPACT, ((ObservingTimeCalculator)object2).getTotalRequestedTime(Array.ARRAY_12M, false, true, true));
                            }
                        }
                        if (bl3) {
                            if (!bl2) {
                                hashMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, ((ObservingTimeCalculator)object2).getTotalRequestedTime(Array.ARRAY_7M, false, false, true));
                            }
                            if (bl4) {
                                hashMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, ((ObservingTimeCalculator)object2).getTotalRequestedTime(Array.ARRAY_TP, false, false, true));
                            }
                        }
                    } else {
                        for (Enum enum_ : ProjectTimeEstimateSummary.TimeTableColTypes.values()) {
                            hashMap.put(enum_, ZEROTIME);
                        }
                        if (!bl) {
                            hashMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMEXT, (Time)object.multiply((double)n));
                            if (!bl2) {
                                hashMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMCOMPACT, (Time)((Time)object.multiply((double)n)).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, scienceGoal2)));
                            }
                        }
                        if (bl3) {
                            if (!bl2) {
                                hashMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, (Time)((Time)object.multiply((double)n)).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACA7M, scienceGoal2)));
                            }
                            if (bl4) {
                                hashMap.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, (Time)((Time)object.multiply((double)n)).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal2)));
                            }
                        }
                    }
                    this.estimatedTotalTimeData.put(scienceGoal2, hashMap);
                    HashMap hashMap2 = new HashMap();
                    Object object3 = ProjectTimeEstimateSummary.TimeTableColTypes.values();
                    int n2 = ((ProjectTimeEstimateSummary.TimeTableColTypes[])object3).length;
                    boolean bl5 = false;
                    while (var25_39 < n2) {
                        ProjectTimeEstimateSummary.TimeTableColTypes timeTableColTypes = object3[var25_39];
                        hashMap2.put(timeTableColTypes, ZEROTIME);
                        ++var25_39;
                    }
                    if (object == null) {
                        object3 = EnumSet.of(ObservingTimeCalculator.Overheads.CALIBRATIONEXECTIMES, ObservingTimeCalculator.Overheads.CALIBRATIONOVERHEADS, ObservingTimeCalculator.Overheads.CALIBRATIONSLEWTIME);
                        if (!bl) {
                            hashMap2.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMEXT, scienceGoal2.getOverheadTimes((EnumSet<ObservingTimeCalculator.Overheads>)object3, Array.ARRAY_12M, scienceGoal2.getSoleTargetParameters(), false));
                            if (!bl2) {
                                hashMap2.put(ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMCOMPACT, ((Time)hashMap2.get((Object)ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMEXT)).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, scienceGoal2)));
                            }
                        } else {
                            hashMap2.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, scienceGoal2.getOverheadTimes((EnumSet<ObservingTimeCalculator.Overheads>)object3, Array.ARRAY_7M, scienceGoal2.getSoleTargetParameters(), false));
                        }
                        if (!bl) {
                            if (performanceParameters.getUseACA()) {
                                if (!bl2) {
                                    hashMap2.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, ((Time)hashMap2.get((Object)ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMEXT)).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACA7M, scienceGoal2)));
                                }
                                if (performanceParameters.getUseTP()) {
                                    hashMap2.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, ((Time)hashMap2.get((Object)ProjectTimeEstimateSummary.TimeTableColTypes.TWELVEMEXT)).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal2)));
                                } else {
                                    hashMap2.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, ZEROTIME);
                                }
                            } else {
                                hashMap2.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACATP, ZEROTIME);
                                hashMap2.put(ProjectTimeEstimateSummary.TimeTableColTypes.ACA7M, ZEROTIME);
                            }
                        }
                    } else {
                        void var25_41;
                        object3 = ProjectTimeEstimateSummary.TimeTableColTypes.values();
                        n2 = ((ProjectTimeEstimateSummary.TimeTableColTypes[])object3).length;
                        boolean bl6 = false;
                        while (var25_41 < n2) {
                            ProjectTimeEstimateSummary.TimeTableColTypes timeTableColTypes = object3[var25_41];
                            hashMap2.put(timeTableColTypes, ZEROTIME);
                            ++var25_41;
                        }
                    }
                    this.estimatedCalibrationTimeData.put(scienceGoal2, hashMap2);
                    object3 = new HashMap();
                    HashMap<ProjectTimeEstimateSummary.DataTableColTypes, Object> hashMap3 = new HashMap<ProjectTimeEstimateSummary.DataTableColTypes, Object>();
                    DataRate dataRate = DataRate.createDataRate();
                    for (ProjectTimeEstimateSummary.DataTableColTypes dataTableColTypes : ProjectTimeEstimateSummary.DataTableColTypes.values()) {
                        object3.put(dataTableColTypes, dataRate);
                    }
                    if (!bl) {
                        object3.put(ProjectTimeEstimateSummary.DataTableColTypes.TWELVEM, scienceGoal2.getAverageDataRate(Array.ARRAY_12M));
                    } else {
                        object3.put(ProjectTimeEstimateSummary.DataTableColTypes.TWELVEM, DataRate.createDataRate());
                    }
                    PerformanceParameters performanceParameters2 = scienceGoal2.getPerformanceParameters();
                    if (performanceParameters2.getUseACA()) {
                        object3.put(ProjectTimeEstimateSummary.DataTableColTypes.ACA7M, scienceGoal2.getAverageDataRate(Array.ARRAY_7M));
                        if (performanceParameters2.getUseTP()) {
                            object3.put(ProjectTimeEstimateSummary.DataTableColTypes.ACATP, scienceGoal2.getAverageDataRate(Array.ARRAY_TP));
                        } else {
                            object3.put(ProjectTimeEstimateSummary.DataTableColTypes.ACATP, dataRate);
                        }
                    }
                    if (!bl) {
                        try {
                            hashMap3.put(ProjectTimeEstimateSummary.DataTableColTypes.TWELVEM, scienceGoal2.getDataVolume(Array.ARRAY_12M).multiply(n));
                        }
                        catch (ToBeSupportedException toBeSupportedException) {
                            Log.logger(StandardProjectTimeEstimateSummary.class).warning(String.format("Unable to determine data volume for science goal %s for the array %s", new Object[]{string, Array.ARRAY_12M}));
                            hashMap3.put(ProjectTimeEstimateSummary.DataTableColTypes.TWELVEM, (Object)StorageVolume.createStorageVolume());
                        }
                    } else {
                        hashMap3.put(ProjectTimeEstimateSummary.DataTableColTypes.TWELVEM, (Object)StorageVolume.createStorageVolume());
                    }
                    hashMap3.put(ProjectTimeEstimateSummary.DataTableColTypes.ACA7M, (Object)StorageVolume.createStorageVolume());
                    hashMap3.put(ProjectTimeEstimateSummary.DataTableColTypes.ACATP, (Object)StorageVolume.createStorageVolume());
                    if (performanceParameters2.getUseACA()) {
                        try {
                            hashMap3.put(ProjectTimeEstimateSummary.DataTableColTypes.ACA7M, scienceGoal2.getDataVolume(Array.ARRAY_7M).multiply(n));
                        }
                        catch (ToBeSupportedException toBeSupportedException) {
                            Log.logger(StandardProjectTimeEstimateSummary.class).warning(String.format("Unable to determine data volume for science goal %s for the array %s", new Object[]{string, Array.ARRAY_7M}));
                        }
                        try {
                            StorageVolume storageVolume = (StorageVolume)scienceGoal2.getDataVolume(Array.ARRAY_TP).multiply(n);
                            if (Double.isNaN(storageVolume.getContent())) {
                                storageVolume = StorageVolume.createStorageVolume();
                            }
                            hashMap3.put(ProjectTimeEstimateSummary.DataTableColTypes.ACATP, (Object)storageVolume);
                        }
                        catch (ToBeSupportedException toBeSupportedException) {
                            Log.logger(StandardProjectTimeEstimateSummary.class).warning(String.format("Unable to determine data volume for science goal %s for the array %s", new Object[]{string, Array.ARRAY_TP}));
                        }
                    }
                    this.estimatedDataRates.put(scienceGoal2, object3);
                    this.estimatedDataVolume.put(scienceGoal2, hashMap3);
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    object2 = new HashMap();
                    object = new HashMap();
                    HashMap<Enum, Time> hashMap4 = new HashMap<Enum, Time>();
                    hashMap = new HashMap<Enum, Time>();
                    for (Enum enum_ : ProjectTimeEstimateSummary.DataTableColTypes.values()) {
                        object.put(enum_, StorageVolume.createStorageVolume());
                        object2.put(enum_, DataRate.createDataRate());
                    }
                    for (Enum enum_ : ProjectTimeEstimateSummary.TimeTableColTypes.values()) {
                        hashMap4.put(enum_, ZEROTIME);
                        hashMap.put(enum_, ZEROTIME);
                    }
                    this.estimatedDataRates.put(scienceGoal2, object2);
                    this.estimatedDataVolume.put(scienceGoal2, object);
                    this.estimatedCalibrationTimeData.put(scienceGoal2, hashMap);
                    this.estimatedTotalTimeData.put(scienceGoal2, hashMap4);
                    this.badlyConfiguredScienceGoals.put(scienceGoal2, true);
                }
            }
        }
        return this.build();
    }
}

