/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.entity.xmlbinding.obsproject.types.PerformanceParametersTTimingConstraintsTypeType;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.FieldTypeInfo;
import alma.obsprep.bo.obsproject.MonitoringConstraint;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.ot.editors.sciencegoals.EstimatedTimeInfoBuilder;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateInterface;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.valdef.obsproject.PerformanceParametersValidator;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SchedBlockObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.MatchedConfiguration;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StandardTimeEstimate
implements TimeEstimateInterface {
    private Log.Logger logger = Log.logger((Object)this);

    @Override
    public EstimatedTimeInfoBuilder.TimeEstimateModel generateTimeEstimateModel(ScienceGoal scienceGoal) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator;
        Rectangle rectangle;
        Object object;
        Object object2;
        Object exception;
        Collection<ScienceGoal> collection;
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(invalidObsProgramParametersException.getMessage());
        }
        for (ScienceGoal object42 : collection) {
            boolean userSensitivity = false;
            try {
                double exception2;
                exception = scienceGoal.getPerformanceParameters().getAngularResolutionMode();
                if (EnumSet.of(AngularResolutionMode.SACA, AngularResolutionMode.Any).contains(exception)) {
                    userSensitivity = true;
                } else if (((Enum)exception).equals(AngularResolutionMode.Range)) {
                    exception2 = object42.getPerformanceParameters().getRepresentativeFrequencyWithSkyOffset().getContentInGHz();
                    object2 = Configuration.getBestConfiguration(exception2, RequestedArray.TWELVE_M, object42);
                    if (object2.equals(Configuration.ILLEGAL_CONFIG)) {
                        throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to determine any 12-m configurations within the range for cluster");
                    }
                    userSensitivity = true;
                } else {
                    exception2 = object42.getPerformanceParameters().getRepresentativeFrequencyWithSkyOffset().getContentInGHz();
                    userSensitivity = PerformanceParametersValidator.isDesiredAngularResolutionAchievableWith12mConfigs(object42.getPerformanceParameters(), object42.getPerformanceParameters().getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC), exception2);
                }
            }
            catch (Configuration.UnableToDetermineConfigurationException | InvalidConfigurationParametersException | InvalidObsProgramParametersException exception3) {
                throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("<html> No array configuration can be determined for the observing parameters specified: <ul> <li> Check that the desired angular resolution is within the range allowed by the available arrays and configuration</li></ul</html>");
            }
            if (userSensitivity) continue;
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("<html> No array configuration can be determined for the observing parameters specified: <ul> <li> Check that the desired angular resolution is within the range allowed by the available arrays and configuration</li></ul</html>");
        }
        EstimatedTimeInfoBuilder.TimeEstimateModel timeEstimateModel = new EstimatedTimeInfoBuilder.TimeEstimateModel();
        timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 950));
        timeEstimateModel.addToHeader("Note: The time in brackets is that required to reach the sensitivity. <P>Operational requirements often mean that the actual observed time <P>is longer, especially for mosaics. Please see the User Manual for more details.<P>", "");
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        UserSensitivity userSensitivity = performanceParameters.getDesiredSensitivity().deepCopy();
        if (performanceParameters.isAngularResolutionModeRange()) {
            object = null;
            try {
                exception = Configuration.getConfigurationsToBeScheduled(scienceGoal);
                object = ConfigurationHelper.getBestMatchedConfiguration(performanceParameters.getRepresentativeFrequency().getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal, (ScienceGoalConfigurations<ConfigurationSet>)exception, Configuration.DesiredAngularResolution.FINEST, false);
            }
            catch (InvalidConfigurationParametersException | InvalidObsProgramParametersException rectangle2) {
                throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(rectangle2);
            }
            assert (object != null);
            userSensitivity.setBeamsize(((MatchedConfiguration)object).getConfigurationAR());
        }
        object = Sensitivity.createSensitivity();
        object.setContentAndUnit(userSensitivity.getContentInDefaultUnits(), userSensitivity.defaultUnit());
        object.convertToUnit(object.getFriendlyUnit());
        if (object.isZero(1.0E-9)) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to generate time estimate: the requested sensitivity " + object + " is invalid");
        }
        exception = scienceGoal.getSoleTargetParameters();
        if (((TargetParameters)exception).getType().equals(FieldTypeInfo.F_SingleRectangle.getValue()) && ((rectangle = exception.getFieldRectangle()[0]).getLong().isZero() || rectangle.getShort().isZero())) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Rectangle definition incomplete - please define the rectangle in your field setup correctly");
        }
        if (spectralSetupParameters.getScienceSpectralWindowCount() == 0 && !spectralSetupParameters.isSpectralScan()) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("No Spectral Window/Element is set.");
        }
        if (PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_USER.equals(performanceParameters.getDesiredSensitivityFrequencyMeasure()) && performanceParameters.getDesiredSensitivityReferenceFrequencyWidth().getContent() <= 0.0) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Positive \"Frequency Width\" value must be set in choosing \"User\" type as \"Bandwidth used for Sensitivity\".");
        }
        timeEstimateModel.addToHeader("<b>Input Parameters</b>", "");
        timeEstimateModel.addToHeader("Requested sensitivity", String.format("%.4g %s", object.getContentInUnits(object.getFriendlyUnit()), object.getFriendlyUnit()));
        Frequency frequency = performanceParameters.getSensitivityFrequencyWidth();
        String string = TextUtils.format(frequency, 3);
        if (performanceParameters.isUserSpecificFrequencyWidth() && frequency instanceof UserFrequency && !((UserFrequency)(object2 = (UserFrequency)((Object)frequency))).inModelUnit()) {
            string = String.format("%.3f %s", ((UserFrequency)object2).getUserContent(), object2.getUserUnit());
        }
        object2 = spectralSetupParameters.isSpectralScan() ? scienceGoal.getRepresentativeFrequency() : scienceGoal.getRepresentativeFrequencyInSky();
        timeEstimateModel.addToHeader("Bandwidth used for sensitivity", string);
        timeEstimateModel.addToHeader("Representative frequency (sky, first source)", TextUtils.format(object2, 2));
        SchedBlockObservingTimeCalculator.Builder builder = new SchedBlockObservingTimeCalculator.Builder();
        builder.scienceGoal(scienceGoal);
        try {
            schedBlockObservingTimeCalculator = new SchedBlockObservingTimeCalculator(builder);
        }
        catch (InvalidObsProgramParametersException time) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(time.getMessage());
        }
        Time time = Time.createTime();
        int n = 1;
        for (ScienceGoal scienceGoal2 : schedBlockObservingTimeCalculator.getScienceGoalsWithClusters()) {
            if (scienceGoal2.isStandAloneACA()) {
                this.createStandaloneACATimeEstimate(schedBlockObservingTimeCalculator, scienceGoal2, timeEstimateModel, time, n);
            } else {
                this.createStandard12mBasedTimeEstimate(schedBlockObservingTimeCalculator, scienceGoal2, timeEstimateModel, time, n);
            }
            ++n;
        }
        timeEstimateModel.addToHeader("<h3>Estimated Total time for Science Goal</h3>", "<h3>" + TextUtils.format(time.convertToFriendlyUnit(), 2) + "</h3>");
        return timeEstimateModel;
    }

    /*
     * WARNING - void declaration
     */
    private EstimatedTimeInfoBuilder.TimeEstimateModel createStandard12mBasedTimeEstimate(SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator, ScienceGoal scienceGoal, EstimatedTimeInfoBuilder.TimeEstimateModel timeEstimateModel, Time time, int n) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        Object object;
        String string;
        Object object2;
        Comparable<Time> comparable;
        void var15_20;
        void var28_40;
        if (timeEstimateModel == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: timeEstimateModel");
        }
        Array array = Array.ARRAY_12M;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Integer n2 = 1;
        Integer n3 = 0;
        Time time2 = Time.createTimeSec(0.0);
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        timeEstimateModel.setClusterSpecificScienceGoal(scienceGoal);
        if (performanceParameters.getIsTimeConstrained() && performanceParameters.getTimingConstraintsType() != null) {
            if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.MULTIPLEVISITS.toString())) {
                n2 = performanceParameters.getVisitConstraintCount();
            } else if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.CONTINUOUSMONITORING.toString())) {
                for (MonitoringConstraint object42 : performanceParameters.getMonitoringConstraint()) {
                    time2.aggregate(schedBlockObservingTimeCalculator.adjustForFullPolarization(object42.getMonitoringLength()));
                }
                n3 = performanceParameters.getMonitoringConstraint().length;
            }
        }
        Object object5 = null;
        Time time3 = null;
        Time time4 = null;
        Object var15_18 = null;
        Time time5 = null;
        Time time6 = null;
        Time time7 = null;
        Time time8 = null;
        Time time9 = Time.createTime();
        Time time10 = Time.createTime();
        Time time11 = Time.createTime();
        Integer n4 = null;
        Integer n5 = 1;
        int n6 = 0;
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = null;
        try {
            scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            timeEstimateModel.setScienceGoalConfigurations(scienceGoalConfigurations);
            time4 = schedBlockObservingTimeCalculator.singlePointOnSourceTime(scienceGoal, array, targetParameters, false).convertToFriendlyUnit();
            time5 = schedBlockObservingTimeCalculator.getTotalOnSourceTime(scienceGoal, array, false).convertToFriendlyUnit();
            time3 = schedBlockObservingTimeCalculator.singlePointOnSourceTimeFromSB(scienceGoal, targetParameters, array).convertToFriendlyUnit();
            Time time12 = schedBlockObservingTimeCalculator.getTotalExtendedArraySBScienceIntegrationTime(true, scienceGoal, array).convertToFriendlyUnit();
            time6 = schedBlockObservingTimeCalculator.getTotalRequestedTime(array, true, false, scienceGoal).convertToFriendlyUnit();
            n4 = schedBlockObservingTimeCalculator.getSBExecutionCount(scienceGoal, array);
            n5 = schedBlockObservingTimeCalculator.getNumberOfAntennaConfigurations(scienceGoal, RequestedArray.TWELVE_M);
            time7 = scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.Overheads.ONSOURCEOVERHEADS), array, scienceGoal.getSoleTargetParameters(), true).convertToFriendlyUnit();
            time8 = scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.Overheads.CALIBRATIONEXECTIMES, ObservingTimeCalculator.Overheads.CALIBRATIONOVERHEADS, ObservingTimeCalculator.Overheads.CALIBRATIONSLEWTIME), array, scienceGoal.getSoleTargetParameters(), false);
            assert (time8 != null);
            time11 = (Time)scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.Overheads.CALIBRATIONOVERHEADS, ObservingTimeCalculator.Overheads.CALIBRATIONSLEWTIME), array, scienceGoal.getSoleTargetParameters(), false).divide(n4.intValue());
            assert (time11 != null);
            if (time12 != null) {
                this.logger.fine("Total 12m ext array on-source time from SB generator " + time12.convertToFriendlyUnit());
            }
            this.logger.fine("Total 12m ext array on-source time from SB OTC " + time12.convertToFriendlyUnit());
            n6 = schedBlockObservingTimeCalculator.getWaterVapourContentUsed(scienceGoal);
            timeEstimateModel.addClusterSpecificKeyValuePair("<b>Input Parameters</b>", "");
            timeEstimateModel.addClusterSpecificKeyValuePair("Precipitable water vapour (all sources)", WaterVaporColumns.getWVIndexLabel(n6));
            timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        }
        catch (UnknownEntityException | SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException throwable) {
            object5 = throwable.getMessage();
        }
        if (object5 != null) {
            Matcher matcher = Pattern.compile("([\\$\\w\\.]*:[ ])*(.*)", 2).matcher((CharSequence)object5);
            object5 = matcher.matches() ? matcher.group(matcher.groupCount()).trim() : ((String)object5).trim();
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to generate time estimate : " + (String)object5);
        }
        Integer n7 = 0;
        for (TargetParameters targetParameters2 : scienceGoal.gettrueTargetParameters()) {
            n7 = n7 + targetParameters2.getNumberOfPointings(Array.ARRAY_12M);
        }
        Object var28_36 = null;
        if (scienceGoalConfigurations == null || scienceGoalConfigurations.getExtendedConfigurations().size() == 0) {
            String string2 = "Unable to determine configuration";
        } else if (scienceGoal.getPerformanceParameters().isAngularResolutionModeRange()) {
            ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations2;
            try {
                scienceGoalConfigurations2 = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to generate time estimate " + invalidObsProgramParametersException.getMessage());
            }
            Comparator comparator = (configuration, configuration2) -> Double.compare(configuration.getMaxBaseline(), configuration2.getMaxBaseline());
            String string3 = ((Configuration)scienceGoalConfigurations2.getExtendedConfigurations().stream().max(comparator).get()).getName();
        } else {
            String string4 = scienceGoalConfigurations.getExtendedConfigurations().get(0).getName();
        }
        assert (var28_40 != null);
        timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<b>Time required for 12m (1) [%s]</b>", var28_40), "");
        Object object3 = object5 != null ? object5 : this.getFirstPointOnSourceData(scienceGoal, array, time3, time4);
        timeEstimateModel.addClusterSpecificKeyValuePair("Time on source per pointing (first source)", (String)object3);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total number of pointings (all sources)", n7.toString());
        try {
            timeEstimateModel.addClusterSpecificKeyValuePair("Number of tunings", Integer.toString(schedBlockObservingTimeCalculator.getNumRetunings(scienceGoal)));
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to determine the number of tunings");
        }
        object3 = object5 != null ? object5 : TextUtils.format(var15_20.convertToFriendlyUnit(), 2) + " [" + StringUtils.trim((String)TextUtils.format(time5.convertToFriendlyUnit(), 2)) + "]";
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time on source", (String)object3);
        object3 = object5 != null ? object5 : TextUtils.format(time8.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total calibration time", (String)object3);
        object3 = object5 != null ? object5 : TextUtils.format(time7.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Other overheads", (String)object3);
        object3 = object5 != null ? object5 : TextUtils.format(((Time)time6.divide(n4.intValue())).convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time for 1 SB execution", (String)object3);
        object3 = object5 != null ? object5 : n4.toString();
        timeEstimateModel.addClusterSpecificKeyValuePair("Number of SB executions", (String)object3);
        object3 = object5 != null ? object5 : TextUtils.format(time6.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time to complete SB", (String)object3);
        if (performanceParameters.getNeedsMoreTime()) {
            Time time13 = performanceParameters.getDesiredTime().deepCopy();
            object3 = TextUtils.format(time13.convertToFriendlyUnit(), 2);
            timeEstimateModel.addClusterSpecificKeyValuePair("Time override", (String)object3);
        }
        timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        if (object5 != null) {
            return timeEstimateModel;
        }
        if (schedBlockObservingTimeCalculator.isSBToBeExecutedUsingSessions()) {
            timeEstimateModel.addClusterSpecificKeyValuePair("<b>Calibration Breakdown per SB execution<sup>*</sup></b>", "");
        } else {
            timeEstimateModel.addClusterSpecificKeyValuePair("<b>Calibration Breakdown per SB execution</b>", "");
        }
        Map<CalType, ObservingTimeCalculator.TimeSummary> map = schedBlockObservingTimeCalculator.getTimeSummary(scienceGoal);
        if (map == null || map.isEmpty()) {
            try {
                schedBlockObservingTimeCalculator.getCalibrationExecutionTimeStats(scienceGoal, true, array, targetParameters, true);
                map = schedBlockObservingTimeCalculator.getTimeSummary(scienceGoal);
            }
            catch (SourceNeverVisibleException | InvalidObsProgramParametersException exception) {
                throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to generate time estimate " + exception.getMessage());
            }
        }
        for (ObservingTimeCalculator.TimeSummary timeSummary : map.values()) {
            comparable = ((Time)timeSummary.getTotalTime().divide(n4.intValue())).convertToFriendlyUnit();
            Long l = timeSummary.getNumExec() / (long)n4.intValue();
            object2 = timeSummary.getType();
            String string5 = string = object2.toString().equals("Delay") ? "Phase reference check source" : object2.toString();
            if (timeSummary.getType().equals((Object)CalType.Bandpass) && timeSummary.isStandardSystemCalibrationStrategyUsed()) {
                string = "Amplitude/bandpass";
            }
            object = l + " x " + string.toString();
            object3 = object5 != null ? object5 : TextUtils.format(((Time)comparable).convertToFriendlyUnit(), 2);
            timeEstimateModel.addClusterSpecificKeyValuePair("&nbsp;" + (String)object, (String)object3);
        }
        object3 = object5 != null ? object5 : TextUtils.format(time11.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Calibration overheads", (String)object3);
        if (schedBlockObservingTimeCalculator.isSBToBeExecutedUsingSessions()) {
            timeEstimateModel.addClusterSpecificKeyValuePair("<html><small><sup>*</sup>Sessions assumed: some calibrations are only observed <P>during the first SB execution</small></html>", "");
        }
        timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        boolean bl = false;
        if (n5 > 1) {
            if (!bl) {
                timeEstimateModel.addClusterSpecificKeyValuePair("<b>Additional Arrays</b>", "");
                bl = true;
            }
            Time time14 = time6.deepCopy();
            if (performanceParameters.getNeedsMoreTime()) {
                Time time15 = performanceParameters.getDesiredTime().deepCopy();
            }
            try {
                void var32_56;
                object3 = TextUtils.format(schedBlockObservingTimeCalculator.getTimeForSecond12mCompactArray(scienceGoal, (Time)var32_56, true, true).convertToFriendlyUnit(), 2);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                object5 = invalidObsProgramParametersException.getMessage();
            }
            timeEstimateModel.addClusterSpecificKeyValuePair("Time required for additional 12-m", (String)object3);
        }
        Boolean bl2 = performanceParameters.gettrueUseACA();
        comparable = performanceParameters.gettrueUseTP();
        if (Boolean.TRUE.equals(bl2)) {
            timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 1000));
            if (!bl) {
                timeEstimateModel.addClusterSpecificKeyValuePair("<b>Additional Arrays</b>", "");
                bl = true;
            }
            double d = 0.0;
            string = "Undefined";
            try {
                d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACA7M, scienceGoal);
                string = String.format("ACA 7-m time (t_12m x %.3g)", d);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger(StandardTimeEstimate.class).warning("Unable to determine multiplier for ACA 7m");
                timeEstimateModel.addClusterSpecificKeyValuePair("ACA 7-m time (t_12m x ?", "ACA invalid with this configuration");
            }
            if (d != 0.0) {
                try {
                    time9 = schedBlockObservingTimeCalculator.getTotalRequestedTime(Array.ARRAY_7M, true, false, scienceGoal).convertToFriendlyUnit();
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    object5 = invalidObsProgramParametersException.getMessage();
                }
                timeEstimateModel.addClusterSpecificKeyValuePair(string, (String)(object5 != null ? object5 : TextUtils.format(time9, 2)));
            }
            if (Boolean.TRUE.equals(comparable)) {
                d = 0.0;
                try {
                    d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal);
                    string = String.format("ACA TP time (t_12m x %.3g)", d);
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    Log.logger(StandardTimeEstimate.class).warning("Unable to determine multiplier for ACA TP");
                    timeEstimateModel.addClusterSpecificKeyValuePair("ACA TP time (t_12m x ?)", "ACA invalid with this configuration");
                }
                if (d != 0.0) {
                    try {
                        time10 = schedBlockObservingTimeCalculator.getTotalRequestedTime(Array.ARRAY_TP, true, false, scienceGoal).convertToFriendlyUnit();
                    }
                    catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                        object5 = invalidObsProgramParametersException.getMessage();
                    }
                    object3 = object5 != null ? object5 : TextUtils.format(time10, 2);
                    timeEstimateModel.addClusterSpecificKeyValuePair(string, (String)object3);
                }
            }
            object = time9.isGreaterThan((AbstractDoubleWithUnit)time10) ? time9 : time10;
            object3 = TextUtils.format(object, 2);
            timeEstimateModel.addClusterSpecificKeyValuePair("Total ACA time (max[t_7-m,t_TP])", (String)object3);
            timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        }
        Time time16 = time6;
        if (performanceParameters.getNeedsMoreTime()) {
            time16 = performanceParameters.getDesiredTime().deepCopy().convertToFriendlyUnit();
        }
        time16 = schedBlockObservingTimeCalculator.adjustForFullPolarization(time16).convertToFriendlyUnit();
        try {
            object2 = time9.isGreaterThan((AbstractDoubleWithUnit)time10) ? time9 : time10;
            boolean bl3 = performanceParameters.gettrueIsSimultaneous12and7();
            time16 = bl3 ? ((Time)time16.plus((AbstractDoubleWithUnit)object2)).convertToFriendlyUnit() : ((Time)((Time)time16.plus((AbstractDoubleWithUnit)schedBlockObservingTimeCalculator.getTimeForSecond12mCompactArray(scienceGoal, time16, true, true))).plus((AbstractDoubleWithUnit)object2)).convertToFriendlyUnit();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger((Object)this).info("Unable to determine the total time for a science goal " + invalidObsProgramParametersException.getMessage());
        }
        if (n2 > 1) {
            timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 1050));
            timeEstimateModel.addClusterSpecificKeyValuePair("Number of visits", n2.toString());
            object3 = "<h3>" + TextUtils.format(((Time)time16.multiply(n2.intValue())).convertToFriendlyUnit(), 2) + "</h3>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for cluster %d</h3>", n), (String)object3);
        } else if (n3 > 0) {
            timeEstimateModel.addClusterSpecificKeyValuePair("No of continuous monitoring visits", n3.toString());
            object3 = "<h3>" + TextUtils.format(time2.convertToFriendlyUnit(), 2) + "</h3>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for continuous monitoring time for cluster %d </h3>", n), (String)object3);
        } else {
            object3 = "<b>" + TextUtils.format(time16.convertToFriendlyUnit(), 2) + "</b>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for cluster %d</h3>", n), (String)object3);
        }
        time.aggregate((Time)time16.multiply(n2.intValue()));
        timeEstimateModel.commitClusterSpecificData();
        return timeEstimateModel;
    }

    private String getFirstPointOnSourceData(ScienceGoal scienceGoal, Array array, Time time, Time time2) {
        String string = null;
        double d = 1.0;
        double d2 = 0.0;
        try {
            d = Configuration.getShadowMultiplierForArray(array, scienceGoal);
            d2 = Configuration.getShadowingPercentage(array, scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            // empty catch block
        }
        String string2 = "";
        if (d != 1.0) {
            string2 = String.format(", shadowing = %.2g%%", d2);
        }
        string = String.format("%s [%s%s] ", TextUtils.format(time.convertToFriendlyUnit(), 2), TextUtils.format(time2.convertToFriendlyUnit(), 2), string2);
        assert (string != null);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private EstimatedTimeInfoBuilder.TimeEstimateModel createStandaloneACATimeEstimate(SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator, ScienceGoal scienceGoal, EstimatedTimeInfoBuilder.TimeEstimateModel timeEstimateModel, Time time, int n) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        void var30_69;
        Object object;
        void var15_20;
        void var26_37;
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations;
        Array array = Array.ARRAY_7M;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Integer n2 = 1;
        Integer n3 = 0;
        Time time2 = Time.createTimeSec(0.0);
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        timeEstimateModel.setClusterSpecificScienceGoal(scienceGoal);
        if (performanceParameters.getIsTimeConstrained() && performanceParameters.getTimingConstraintsType() != null) {
            if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.MULTIPLEVISITS.toString())) {
                n2 = performanceParameters.getVisitConstraintCount();
            } else if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.CONTINUOUSMONITORING.toString())) {
                for (MonitoringConstraint object32 : performanceParameters.getMonitoringConstraint()) {
                    time2.aggregate(schedBlockObservingTimeCalculator.adjustForFullPolarization(object32.getMonitoringLength()));
                }
                n3 = performanceParameters.getMonitoringConstraint().length;
            }
        }
        Object object4 = null;
        Time time3 = null;
        Time time4 = null;
        Object var15_18 = null;
        Time time5 = null;
        Time time6 = null;
        Time time7 = null;
        Time time8 = null;
        Time time9 = Time.createTime();
        Time time10 = Time.createTime();
        Integer n4 = null;
        int n5 = 0;
        try {
            scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal, RequestedArray.SEVEN_M);
        }
        catch (InvalidObsProgramParametersException n6) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(n6.getMessage());
        }
        timeEstimateModel.setScienceGoalConfigurations(scienceGoalConfigurations);
        try {
            time4 = schedBlockObservingTimeCalculator.singlePointOnSourceTime(scienceGoal, array, targetParameters, false).convertToFriendlyUnit();
            time5 = schedBlockObservingTimeCalculator.getTotalOnSourceTime(array, false).convertToFriendlyUnit();
            time3 = schedBlockObservingTimeCalculator.singlePointOnSourceTimeFromSB(scienceGoal, targetParameters, array).convertToFriendlyUnit();
            Time time11 = schedBlockObservingTimeCalculator.getTotalExtendedArraySBScienceIntegrationTime(true, scienceGoal, array).convertToFriendlyUnit();
            time6 = schedBlockObservingTimeCalculator.getTotalRequestedTime(array, true, false, scienceGoal).convertToFriendlyUnit();
            n4 = schedBlockObservingTimeCalculator.getSBExecutionCount(scienceGoal, Array.ARRAY_7M);
            time7 = scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.Overheads.ONSOURCEOVERHEADS), array, scienceGoal.getSoleTargetParameters(), true).convertToFriendlyUnit();
            time8 = scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.Overheads.CALIBRATIONEXECTIMES, ObservingTimeCalculator.Overheads.CALIBRATIONOVERHEADS, ObservingTimeCalculator.Overheads.CALIBRATIONSLEWTIME), array, scienceGoal.getSoleTargetParameters(), false);
            assert (time8 != null);
            time10 = (Time)scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.Overheads.CALIBRATIONOVERHEADS, ObservingTimeCalculator.Overheads.CALIBRATIONSLEWTIME), array, scienceGoal.getSoleTargetParameters(), false).divide(n4.intValue());
            assert (time10 != null);
            if (time11 != null) {
                this.logger.fine("Total 7m ext array on-source time from SB generator " + time11.convertToFriendlyUnit());
            }
            this.logger.fine("Total 7m ext array on-source time from SB OTC " + time11.convertToFriendlyUnit());
            n5 = schedBlockObservingTimeCalculator.getWaterVapourContentUsed(scienceGoal);
            timeEstimateModel.addClusterSpecificKeyValuePair("<b>Input Parameters</b>", "");
            timeEstimateModel.addClusterSpecificKeyValuePair("Precipitable water vapour (all sources)", WaterVaporColumns.getWVIndexLabel(n5));
            timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        }
        catch (UnknownEntityException | SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException throwable) {
            object4 = throwable.getMessage();
        }
        if (object4 != null) {
            Matcher matcher = Pattern.compile("([\\$\\w\\.]*:[ ])*(.*)", 2).matcher((CharSequence)object4);
            object4 = matcher.matches() ? matcher.group(matcher.groupCount()).trim() : ((String)object4).trim();
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("<html>Unable to generate time estimate : <b>" + (String)object4 + "</b></html>");
        }
        Integer n6 = 0;
        for (TargetParameters targetParameters2 : scienceGoal.gettrueTargetParameters()) {
            n6 = n6 + targetParameters2.getNumberOfPointings(Array.ARRAY_7M);
        }
        timeEstimateModel.addClusterSpecificKeyValuePair("<b>Time required for ACA 7-m array</b>", "");
        if (object4 != null) {
            Object object2 = object4;
        } else {
            String string = this.getFirstPointOnSourceData(scienceGoal, array, time3, time4);
        }
        timeEstimateModel.addClusterSpecificKeyValuePair("Time on source per pointing (first source)", (String)var26_37);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total number of pointings (all sources)", n6.toString());
        try {
            timeEstimateModel.addClusterSpecificKeyValuePair("Number of tunings", Integer.toString(schedBlockObservingTimeCalculator.getNumRetunings(scienceGoal)));
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to determine the number of tunings");
        }
        Object object3 = object4 != null ? object4 : TextUtils.format(var15_20.convertToFriendlyUnit(), 2) + " [" + StringUtils.trim((String)TextUtils.format(time5.convertToFriendlyUnit(), 2)) + "]";
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time on source", (String)object3);
        Object object5 = object4 != null ? object4 : TextUtils.format(time8.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total calibration time", (String)object5);
        Object object6 = object4 != null ? object4 : TextUtils.format(time7.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Other overheads", (String)object6);
        Object object7 = object4 != null ? object4 : TextUtils.format(((Time)time6.divide(n4.intValue())).convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time for 1 SB execution", (String)object7);
        Object object8 = object4 != null ? object4 : n4.toString();
        timeEstimateModel.addClusterSpecificKeyValuePair("Number of SB executions", (String)object8);
        Object object9 = object4 != null ? object4 : TextUtils.format(time6.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time to complete SB", (String)object9);
        Time time12 = null;
        if (performanceParameters.getNeedsMoreTime()) {
            time12 = performanceParameters.getDesiredTime().deepCopy();
            String string = TextUtils.format(time12.convertToFriendlyUnit(), 2);
            timeEstimateModel.addClusterSpecificKeyValuePair("Time override", string);
        }
        timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        if (object4 != null) {
            return timeEstimateModel;
        }
        timeEstimateModel.addClusterSpecificKeyValuePair("<b>Calibration Breakdown per SB execution</b>", "");
        Map<CalType, ObservingTimeCalculator.TimeSummary> map = schedBlockObservingTimeCalculator.getTimeSummary(scienceGoal);
        if (map == null || map.isEmpty()) {
            try {
                schedBlockObservingTimeCalculator.getCalibrationExecutionTimeStats(scienceGoal, true, array, targetParameters, true);
                map = schedBlockObservingTimeCalculator.getTimeSummary(scienceGoal);
            }
            catch (SourceNeverVisibleException | InvalidObsProgramParametersException exception) {
                throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to generate time estimate " + exception.getMessage());
            }
        }
        for (ObservingTimeCalculator.TimeSummary timeSummary : map.values()) {
            Time time13 = ((Time)timeSummary.getTotalTime().divide(n4.intValue())).convertToFriendlyUnit();
            Long l = timeSummary.getNumExec() / (long)n4.intValue();
            object = timeSummary.getType();
            String string = object.toString().equals("Delay") ? "Phase reference check source" : object.toString();
            String string2 = l + " x " + string.toString();
            Object object10 = object4 != null ? object4 : TextUtils.format(time13.convertToFriendlyUnit(), 2);
            timeEstimateModel.addClusterSpecificKeyValuePair("&nbsp;" + string2, (String)object10);
        }
        Object object11 = object4 != null ? object4 : TextUtils.format(time10.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Calibration overheads", (String)object11);
        timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        boolean bl = performanceParameters.gettrueUseTP();
        Time time14 = time6;
        if (bl) {
            void var30_68;
            timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 1000));
            timeEstimateModel.addClusterSpecificKeyValuePair("<b>Additional Arrays</b>", "");
            double d = 0.0;
            object = null;
            try {
                d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal);
                object = String.format("ACA TP time (t_7m x %.3g)", d);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                Log.logger(StandardTimeEstimate.class).warning("Unable to determine multiplier for ACA TP");
                timeEstimateModel.addClusterSpecificKeyValuePair("ACA TP time (t_7m x ?)", "ACA invalid with this configuration");
            }
            if (d != 0.0) {
                if (time12 != null) {
                    time9 = (Time)time12.multiply(d);
                } else {
                    try {
                        time9 = schedBlockObservingTimeCalculator.getTotalRequestedTime(Array.ARRAY_TP, true, false, scienceGoal).convertToFriendlyUnit();
                    }
                    catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                        object4 = invalidObsProgramParametersException.getMessage();
                    }
                }
                assert (object != null);
                Object object12 = object4 != null ? object4 : TextUtils.format(time9, 2);
                timeEstimateModel.addClusterSpecificKeyValuePair((String)object, (String)object12);
            }
            if (time12 != null) {
                Time time15 = time12.isGreaterThan((AbstractDoubleWithUnit)time9) ? time12 : time9;
            } else {
                Time time16 = time6.isGreaterThan((AbstractDoubleWithUnit)time9) ? time6 : time9;
            }
            String string = TextUtils.format(var30_68, 2);
            timeEstimateModel.addClusterSpecificKeyValuePair("Total ACA time (max[t_7-m,t_TP])", string);
            timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        }
        Time time17 = var30_69;
        if (time12 != null && bl) {
            time17 = (Time)time12.plus((AbstractDoubleWithUnit)var30_69);
        }
        if (n2 > 1) {
            timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 1050));
            timeEstimateModel.addClusterSpecificKeyValuePair("Number of visits", n2.toString());
            String string = "<h3>" + TextUtils.format(((Time)time17.multiply(n2.intValue())).convertToFriendlyUnit(), 2) + "</h3>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for cluster %d</h3>", n), string);
        } else if (n3 > 0) {
            timeEstimateModel.addClusterSpecificKeyValuePair("No of continuous monitoring visits", n3.toString());
            String string = "<h3>" + TextUtils.format(time2.convertToFriendlyUnit(), 2) + "</h3>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for continuous monitoring time for cluster %d </h3>", n), string);
        } else {
            String string = "<b>" + TextUtils.format(time17.convertToFriendlyUnit(), 2) + "</b>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for cluster %d</h3>", n), string);
        }
        time.aggregate((Time)time17.multiply(n2.intValue()));
        timeEstimateModel.commitClusterSpecificData();
        return timeEstimateModel;
    }
}

