/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.ValueUnitPairCellRenderer;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.TargetListModel;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;

public class TargetListEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    public static final FieldID opticalPointingFID = new FieldID("opticalPointingFID");
    public static final FieldID addOPFID = new FieldID("addOptPointFID");
    public static final FieldID delOPFID = new FieldID("delOptPointFID");
    public static final FieldID upOPFID = new FieldID("upOptPointFID");
    public static final FieldID downOPFID = new FieldID("downOptPointFID");
    public static final FieldID saveOPFID = new FieldID("saveOptPointFID");
    public static final FieldID opCountLabelFID = new FieldID("opCountLabelFID");
    private static final DialogId DIALOG_OVERWRITE_FILE = new DialogId("SaveOpticalPointingTarget.OverwriteFile");
    private JButton opAddButton = null;
    private JButton opDelButton = null;
    private JButton opUpButton = null;
    private JButton opDownButton = null;
    private JButton opSaveButton = null;
    private JTable opTable = null;
    private JLabel countLabel = null;
    private final String COUNT_LABEL_STRING = "Number of the listed targets : ";
    public static final int TABLE_WIDTH = 700;
    public static final int TABLE_HEIGHT = 150;

    public TargetListEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    protected TargetListEditor() {
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addLabel(jPanel, gridBagLayout, gridBagConstraints, opCountLabelFID, "", "The number of optical pointing targets");
        this.addTable(jPanel, gridBagLayout, gridBagConstraints, string);
        this.addNonCollapsingGroup(jPanel, "Table Editor Component");
        jPanel.setBorder(null);
    }

    protected void addTable(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        TargetListModel targetListModel = (TargetListModel)this.getModel();
        this.opAddButton = this.makeButton(addOPFID, "Add", "Add a Target");
        this.opDelButton = this.makeButton(delOPFID, "Delete", "Delete the Target");
        this.opUpButton = this.makeButton(upOPFID, "Up", "Move the target up the list");
        this.opDownButton = this.makeButton(downOPFID, "Down", "Move the target down the list");
        this.opSaveButton = this.makeButton(saveOPFID, "Save", "Save the list to local file");
        int n = 90;
        this.opAddButton.setPreferredSize(new Dimension(n, 30));
        this.opDelButton.setPreferredSize(new Dimension(n, 30));
        this.opUpButton.setPreferredSize(new Dimension(n, 30));
        this.opDownButton.setPreferredSize(new Dimension(n, 30));
        this.opSaveButton.setPreferredSize(new Dimension(n, 30));
        this.opTable = new Table(targetListModel.getTableWidgetTableModel()){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = this.getSelectedRow();
                super.tableChanged(tableModelEvent);
                if (n < this.getRowCount() && n >= 0) {
                    this.setRowSelectionInterval(n, n);
                }
            }
        };
        this.opTable.setDefaultEditor(Angle.class, new ValueUnitPairCellEditor.AngleEditor());
        this.opTable.setDefaultEditor(AngularVelocity.class, new ValueUnitPairCellEditor.AngularVelocityEditor());
        this.opTable.setDefaultRenderer(AbstractDoubleWithUnit.class, new ValueUnitPairCellRenderer());
        ((TargetListModel)this.getModel()).setOpTable(this.opTable);
        this.opTable.getTableHeader().setReorderingAllowed(false);
        this.opTable.setSelectionMode(0);
        this.opTable.setColumnSelectionAllowed(false);
        this.opTable.getSelectionModel().addListSelectionListener(this);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.opTable);
        scrollWhenFocusedPane.setPreferredSize(new Dimension(700, 150));
        this.opTable.setToolTipText("List of Optical Pointing Targets");
        this.initColumnSizes();
        this.initEvents(this.opTable, opticalPointingFID);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.opAddButton);
        jPanel2.add(this.opDelButton);
        jPanel2.add(this.opUpButton);
        jPanel2.add(this.opDownButton);
        jPanel2.add(this.opSaveButton);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
    }

    @Override
    protected void build() {
        super.build("Table Editor");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        TargetListModel targetListModel = (TargetListModel)this.getModel();
        if (fieldID.equals(addOPFID)) {
            int n = this.opTable.getSelectedRow();
            targetListModel.addOpticalPointingTargetParameters(n + 1);
        } else if (fieldID.equals(delOPFID)) {
            int n = this.opTable.getSelectedRow();
            targetListModel.deleteOpticalPointingTargetParameters(n);
            if (n == 0) {
                if (targetListModel.getOpticalPointingTargetParametersCount() != 0) {
                    this.opTable.setRowSelectionInterval(n, n);
                }
            } else if (n == targetListModel.getOpticalPointingTargetParametersCount()) {
                this.opTable.setRowSelectionInterval(n - 1, n - 1);
            } else if (n != -1) {
                this.opTable.setRowSelectionInterval(n, n);
            }
        } else if (fieldID.equals(upOPFID)) {
            int n = this.opTable.getSelectedRow();
            if (n > 0) {
                targetListModel.upOpticalPointingTargetParameters(n);
                this.opTable.setRowSelectionInterval(n - 1, n - 1);
            }
        } else if (fieldID.equals(downOPFID)) {
            int n = this.opTable.getSelectedRow();
            if (n != -1 && n < targetListModel.getOpticalPointingTargetParametersCount() - 1) {
                targetListModel.downOpticalPointingTargetParameters(n);
                this.opTable.setRowSelectionInterval(n + 1, n + 1);
            }
        } else if (fieldID.equals(saveOPFID)) {
            JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser(this);
            jFileChooser.setDialogTitle("Save");
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                Object object2;
                File file = jFileChooser.getSelectedFile();
                if (file.exists()) {
                    object2 = "";
                    try {
                        object2 = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String string = "File " + (String)object2 + " already exists." + "\nDo you want to replace it?";
                    boolean bl = GUIUtilities.confirm(DIALOG_OVERWRITE_FILE, string);
                    if (!bl) {
                        return;
                    }
                }
                object2 = ((TargetListModel)this.getModel()).getOpticalPointingScienceGoal();
                try {
                    ((OpticalPointingScienceGoal)object2).saveToFile(file);
                }
                catch (IOException iOException) {
                    GUIUtilities.warning(null, "Failed to save");
                    Log.logger((Object)this).log(Level.WARNING, "Failed to save", (Throwable)iOException);
                }
            }
        } else if (!fieldID.equals(opCountLabelFID) && !fieldID.equals(opticalPointingFID)) {
            super.update(fieldID, object);
        }
        this.updateTargetCountLabel();
        this.setButtons(targetListModel);
    }

    public void updateTargetCountLabel() {
        JLabel jLabel = (JLabel)this.retrieve(opCountLabelFID);
        TargetListModel targetListModel = (TargetListModel)this.getModel();
        jLabel.setText("Number of the listed targets : " + targetListModel.getOpticalPointingTargetParametersCount());
    }

    private void setButtons(TargetListModel targetListModel) {
        if (this.opAddButton == null || this.opDelButton == null) {
            return;
        }
        int n = targetListModel.getOpticalPointingTargetParametersCount();
        this.setEnabled(this.opAddButton, true);
        this.setEnabled(this.opDelButton, n > 0 && this.opTable.getSelectedRow() != -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons((TargetListModel)this.getModel());
    }

    private void initColumnSizes() {
        Object[] objectArray = new Object[]{"  Some random name", "  00:00:00.00", "  +00:00:00.00", AngularVelocity.createAngularVelocity(), AngularVelocity.createAngularVelocity(), Angle.createAngle(), new Double(123.456)};
        ColumnResizer.initColumnSizes(this.opTable, objectArray);
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        TargetListModel targetListModel = new TargetListModel(null);
        TargetListEditor targetListEditor = new TargetListEditor(targetListModel);
        OpticalPointingScienceGoal opticalPointingScienceGoal = OpticalPointingScienceGoal.createOpticalPointingScienceGoal();
        targetListModel.setDocument(opticalPointingScienceGoal);
        TargetListEditor.runTestApp(targetListEditor);
    }
}

