/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.entity.xmlbinding.obsproject.types.PerformanceParametersTTimingConstraintsTypeType;
import alma.obsprep.bo.obsproject.FieldTypeInfo;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.ot.editors.sciencegoals.EstimatedTimeInfoBuilder;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateInterface;
import alma.obsprep.services.etc.SchedBlockObservingTimeCalculator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Time;
import java.awt.Dimension;

public class VLBITimeEstimate
implements TimeEstimateInterface {
    @Override
    public EstimatedTimeInfoBuilder.TimeEstimateModel generateTimeEstimateModel(ScienceGoal scienceGoal) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator;
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sg");
        }
        EstimatedTimeInfoBuilder.TimeEstimateModel timeEstimateModel = new EstimatedTimeInfoBuilder.TimeEstimateModel();
        timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 550));
        Time time = Time.createTime();
        Integer n = 1;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Time time2 = performanceParameters.getDesiredTime().deepCopy().convertToFriendlyUnit();
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        if (performanceParameters.getIsTimeConstrained() && performanceParameters.getTimingConstraintsType() != null && performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.MULTIPLEVISITS.toString())) {
            n = performanceParameters.getVisitConstraintCount();
        }
        if (targetParameters.getType().equals(FieldTypeInfo.F_SingleRectangle.getValue()) && ((object = targetParameters.getFieldRectangle()[0]).getLong().isZero() || object.getShort().isZero())) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Rectangle definition incomplete - please define the rectangle in your field setup correctly");
        }
        object = new SchedBlockObservingTimeCalculator.Builder();
        ((SchedBlockObservingTimeCalculator.Builder)object).scienceGoal(scienceGoal);
        try {
            schedBlockObservingTimeCalculator = new SchedBlockObservingTimeCalculator((SchedBlockObservingTimeCalculator.Builder)object);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(invalidObsProgramParametersException.getMessage());
        }
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = null;
        try {
            scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to get details of configurations " + invalidObsProgramParametersException.getMessage());
        }
        timeEstimateModel.setScienceGoalConfigurations(scienceGoalConfigurations);
        timeEstimateModel.addToHeader("<h3>VLBI requested time</h3>", "");
        int n2 = 1;
        for (ScienceGoal scienceGoal2 : schedBlockObservingTimeCalculator.getScienceGoalsWithClusters()) {
            timeEstimateModel.setClusterSpecificScienceGoal(scienceGoal2);
            timeEstimateModel.addClusterSpecificKeyValuePair("Interferometric observation", TextUtils.format(time2.convertToFriendlyUnit(), 2));
            Time time3 = time2.convertToFriendlyUnit();
            if (n > 1) {
                timeEstimateModel.addClusterSpecificKeyValuePair("Number of visits", n.toString());
                timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Total time for cluster %d</h3>", n2++), TextUtils.format(((Time)time3.multiply(n.intValue())).convertToFriendlyUnit(), 2));
            } else {
                timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Total time for cluster %d</h3>", n2++), TextUtils.format(time3.convertToFriendlyUnit(), 2));
            }
            timeEstimateModel.commitClusterSpecificData();
            time.aggregate((Time)time3.multiply(n.intValue()));
        }
        timeEstimateModel.addToHeader("Total time for VLBI", TextUtils.format(time.convertToFriendlyUnit(), 2));
        return timeEstimateModel;
    }
}

