/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTComboBox;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.misc.CompactIsoDatePicker;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintListEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.VisitConstraintsListModel;
import alma.obsprep.ot.models.valuetypes.AbstractValueUnitPairModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class VisitConstraintEditor
extends EditorWithGridBagLayout
implements TableCellEditor {
    private static final long serialVersionUID = -4606878953621068475L;
    protected transient ChangeEvent changeEvent = null;
    public static final FieldID START_TIME_FID = new FieldID("VisitConstraintEditor.startTime");
    public static final FieldID FIXED_START_FID = new FieldID("VisitConstraintEditor.isSpecificDateFID");
    public static final FieldID VISIT_ID_FID = new FieldID("VisitConstraintEditor.visitFID");
    public static final FieldID PREVIOUS_VISIT_FID = new FieldID("VisitConstraintEditor.previousVisitFID");
    public static final FieldID CLOSE_BUTTON_FID = new FieldID("VisitConstraintEditor.okButtonFID");
    public static final FieldID VISIT_CONSTRAINT_FID = new FieldID("VisitConstraintEditor.CurrentVisitConstraint");
    public static final String SPECIFIC_START_LABEL = "Specific Date";
    public static final String RELATIVE_START_LABEL = "Relative Date";
    public static final String[] START_TYPE_OPTIONS = new String[]{"Specific Date", "Relative Date"};
    public static final String[] START_TYPE_LABELS = new String[]{"Requires a specific start time", "Schedule relative to a previous constraint"};
    private JComponent specificStartOptions = null;
    private JComponent relativeStartOptions = null;
    private OTButtonGroup isSelectedGrp = null;
    private OTComboBox previousVisitBox = null;
    private CompactIsoDatePicker dtPanel = null;
    private UnitMap reasonableTimeUnits = UnitMap.getUnits((String)"BasicTime");
    private int clickCountToStart = 1;

    public VisitConstraintEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    protected void addComponents(String string) {
        this.isSelectedGrp = this.makeOTButtonGroup(FIXED_START_FID, START_TYPE_OPTIONS, START_TYPE_LABELS);
        this.add(this.isSelectedGrp);
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createHorizontalGlue());
        this.specificStartOptions = this.createSpecificStartOptions();
        this.add(this.specificStartOptions);
        this.relativeStartOptions = this.createRelativeStartOptions();
        this.add(this.relativeStartOptions);
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        this.displaySpecificStartComponents(visitConstraintsListModel.isFixedStart());
        this.add(this.makeButton(CLOSE_BUTTON_FID, "Close", "Finishing editing"));
    }

    private void displaySpecificStartComponents(boolean bl) {
        this.isSelectedGrp.setSelectedItem(bl ? SPECIFIC_START_LABEL : RELATIVE_START_LABEL);
        if (bl) {
            this.specificStartOptions.setVisible(true);
            this.relativeStartOptions.setVisible(false);
        } else {
            this.specificStartOptions.setVisible(false);
            this.relativeStartOptions.setVisible(true);
        }
    }

    private JComponent createSpecificStartOptions() {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        JPanel jPanel = this.createNewGroup();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(this.makeLabel("Date"));
        this.dtPanel = this.makeCompactIsoDateTimePanel(this, START_TIME_FID, "start time for monitoring visit", VisitConstraint.nowInUTC());
        this.dtPanel.getIsoDateTimeField().setVisible(false);
        jPanel.add(this.dtPanel);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        ValueUnitPairEditor valueUnitPairEditor = this.makeValueUnitPairEditor((AbstractValueUnitPairModel)visitConstraintsListModel.getAllowedMarginModel(), this.reasonableTimeUnits, "Allowed margin from the specified delay");
        jPanel.add(this.makeLabel("<html>Margin (&plusmn;)</html>"));
        jPanel.add(valueUnitPairEditor);
        int n = (int)valueUnitPairEditor.getUnits().getPreferredSize().getHeight();
        valueUnitPairEditor.getInput().setMaximumSize(new Dimension(500, n));
        return jPanel;
    }

    private ArrayList<String> getPreviousIds() {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(visitConstraintsListModel.getPreviousVistIds()));
        arrayList.add(0, "None");
        return arrayList;
    }

    private JComponent createRelativeStartOptions() {
        JPanel jPanel = this.createNewGroup();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        jPanel.add(this.makeLabel("Delay"));
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.makeValueUnitPairEditor((AbstractValueUnitPairModel)visitConstraintsListModel.getRequiredDelayModel(), this.reasonableTimeUnits, "Required delay after previous visit"));
        jPanel.add(this.makeLabel("after visit"));
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.previousVisitBox = new OTComboBox(this.getPreviousIds().toArray());
        this.initEvents(this.previousVisitBox, PREVIOUS_VISIT_FID);
        this.previousVisitBox.setToolTipText("select the id of a previous visit from the list");
        jPanel.add(this.previousVisitBox);
        ValueUnitPairEditor valueUnitPairEditor = this.makeValueUnitPairEditor((AbstractValueUnitPairModel)visitConstraintsListModel.getAllowedMarginModel(), this.reasonableTimeUnits, "Allowed margin from the specified delay");
        jPanel.add(this.makeLabel("<html>Margin (&plusmn;)</html>"));
        jPanel.add(valueUnitPairEditor);
        return jPanel;
    }

    @Override
    protected void build() {
        super.build("");
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (fieldID.equals(FIXED_START_FID)) {
            Boolean bl = object.toString().equals(SPECIFIC_START_LABEL);
            this.displaySpecificStartComponents(bl);
        } else if (fieldID.equals(START_TIME_FID)) {
            this.dtPanel.getIsoDateTimeField().setText((String)object);
        } else if (fieldID.equals(PREVIOUS_VISIT_FID)) {
            this.set2(this.previousVisitBox, object);
        } else if (fieldID.equals(CLOSE_BUTTON_FID)) {
            this.stopCellEditing();
        }
        return super.widgetUpdated(fieldID, object);
    }

    @Override
    public Object getCellEditorValue() {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        return visitConstraintsListModel.getCurrentVisitConstraint();
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        if (object instanceof VisitConstraint) {
            VisitConstraint visitConstraint = (VisitConstraint)((Object)object);
            visitConstraintsListModel.setCurrentVisitConstraint((Object)visitConstraint);
            this.update(FIXED_START_FID, visitConstraint.getIsFixedStart() ? SPECIFIC_START_LABEL : RELATIVE_START_LABEL);
            this.update(START_TIME_FID, visitConstraint.getStartTime());
            this.update(PREVIOUS_VISIT_FID, visitConstraint.getPreviousVisitId());
            return this;
        }
        return null;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(VisitConstraintListEditor.addTPFID)) {
            this.previousVisitBox.updateOptions(this.getPreviousIds());
        } else if (fieldID.equals(FIXED_START_FID)) {
            Boolean bl = object.toString().equals(SPECIFIC_START_LABEL);
            this.displaySpecificStartComponents(bl);
        } else if (fieldID.equals(PREVIOUS_VISIT_FID)) {
            this.previousVisitBox.updateOptions(this.getPreviousIds());
            object = "0".equals(object.toString()) ? "None" : object;
        } else if (fieldID.equals(VisitConstraintListEditor.VISIT_CONSTRAINT_TABLE_FID)) {
            this.previousVisitBox.updateOptions(this.getPreviousIds());
        } else if (fieldID.equals(START_TIME_FID) && null != object && "" != object) {
            this.dtPanel.getIsoDateTimeField().setText((String)object);
        }
        super.update(fieldID, object);
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Visit Constraint Editor");
        jFrame.setDefaultCloseOperation(3);
        PerformanceParameters performanceParameters = PerformanceParameters.createPerformanceParameters();
        VisitConstraintsListModel visitConstraintsListModel = new VisitConstraintsListModel(null);
        VisitConstraintEditor visitConstraintEditor = new VisitConstraintEditor(visitConstraintsListModel);
        visitConstraintsListModel.setDocument(performanceParameters);
        TestUtilities.runTestApp(visitConstraintEditor);
    }
}

