/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintEditor;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintTableModel;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintsTable;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.VisitConstraintsListModel;
import alma.valuetypes.Time;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VisitConstraintListEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    private static final long serialVersionUID = 6076446159232048976L;
    public static final FieldID VISIT_CONSTRAINT_TABLE_FID = new FieldID("VisitConstraintTable");
    public static final FieldID addTPFID = new FieldID("addTempParmFID");
    public static final FieldID delTPFID = new FieldID("delTempParmFID");
    public static final FieldID delAllTPFID = new FieldID("delAllTempParmFID");
    public static final FieldID tpCountLabelFID = new FieldID("tpCountLabelFID");
    public static final FieldID hintsLabel = new FieldID("hintsLabel");
    public static final FieldID timingParamStartDate = new FieldID("startDate");
    public static final FieldID selectIfExclusive = new FieldID("selectIfExclusive");
    public static final FieldID updateNote = new FieldID("updateNote");
    private JButton tpAddButton = null;
    private JButton tpDelButton = null;
    private JButton tpDelAllButton = null;
    private VisitConstraintsTable vcTable = null;
    private final String COUNT_LABEL_STRING = "Visits specified : ";
    public static final int TABLE_WIDTH = 850;
    public static final int TABLE_HEIGHT = 150;
    public static final int ROW_HEIGHT = 35;

    public VisitConstraintListEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    protected VisitConstraintListEditor() {
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addLabel(jPanel, gridBagLayout, gridBagConstraints, tpCountLabelFID, "", "Visits specified : ");
        this.addTable(jPanel, gridBagLayout, gridBagConstraints, string);
        this.addNonCollapsingGroup(jPanel, string);
        jPanel.setBorder(null);
    }

    protected void addTable(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        this.tpAddButton = this.makeButton(addTPFID, "Add", "Add Time Range");
        this.tpDelButton = this.makeButton(delTPFID, "Delete", "Delete Time Range");
        this.tpDelAllButton = this.makeButton(delAllTPFID, "Delete All", "Delete All");
        int n = 273;
        int n2 = this.tpAddButton.getPreferredSize().height;
        this.tpAddButton.setPreferredSize(new Dimension(n, n2));
        this.tpDelButton.setPreferredSize(new Dimension(n, n2));
        this.tpDelAllButton.setPreferredSize(new Dimension(n, n2));
        this.vcTable = new VisitConstraintsTable(visitConstraintsListModel.getVisitConstraintsTableModel());
        this.vcTable.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
        this.vcTable.setRowHeight(35);
        this.vcTable.getTableHeader().setReorderingAllowed(false);
        this.vcTable.setSelectionMode(0);
        this.vcTable.setColumnSelectionAllowed(false);
        this.vcTable.getSelectionModel().addListSelectionListener(this);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.vcTable);
        scrollWhenFocusedPane.setPreferredSize(new Dimension(850, 150));
        this.vcTable.setToolTipText("Details of Visits");
        this.vcTable.setName("VisitConstraintListEditor.tpTable");
        this.initEvents(this.vcTable, VISIT_CONSTRAINT_TABLE_FID);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.tpAddButton);
        jPanel2.add(this.tpDelButton);
        jPanel2.add(this.tpDelAllButton);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
    }

    @Override
    protected void build() {
        super.build("");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        if (fieldID.equals(addTPFID)) {
            int n = this.vcTable.getSelectedRow();
            this.closeEditorIfOpen();
            n = this.getVisitConstraintCount();
            visitConstraintsListModel.addVisitConstraint(n);
        } else if (fieldID.equals(delTPFID)) {
            int n = this.vcTable.getSelectedRow();
            this.closeEditorIfOpen();
            visitConstraintsListModel.deleteVisitConstraint(n);
            if (n == 0) {
                if (visitConstraintsListModel.getVisitConstraintCount() != 0) {
                    this.vcTable.setRowSelectionInterval(n, n);
                }
            } else if (n == visitConstraintsListModel.getVisitConstraintCount()) {
                this.vcTable.setRowSelectionInterval(n - 1, n - 1);
            } else if (n != -1) {
                this.vcTable.setRowSelectionInterval(n, n);
            }
        } else if (fieldID.equals(delAllTPFID)) {
            this.closeEditorIfOpen();
            visitConstraintsListModel.clearVisitConstraintList();
        } else if (fieldID.equals(timingParamStartDate)) {
            int n = this.vcTable.getSelectedRow();
            int n2 = this.vcTable.getSelectedColumn();
            this.vcTable.setValueAt((String)object, n, n2);
        } else if (!fieldID.equals(tpCountLabelFID)) {
            if (fieldID.equals(VisitConstraintEditor.CLOSE_BUTTON_FID)) {
                visitConstraintsListModel.orderVisitConstraints();
            } else {
                if (fieldID.equals(VISIT_CONSTRAINT_TABLE_FID)) {
                    this.fireTableDataChanged();
                    return;
                }
                if (fieldID.equals(updateNote)) {
                    String string = object.toString();
                    visitConstraintsListModel.updateAssociatedeNote(string);
                    return;
                }
                super.update(fieldID, object);
            }
        }
        this.updateTargetCountLabel();
        this.setButtons(visitConstraintsListModel);
    }

    private void closeEditorIfOpen() {
        VisitConstraintEditor visitConstraintEditor = (VisitConstraintEditor)this.vcTable.getEditorComponent();
        if (visitConstraintEditor != null) {
            int n = this.vcTable.getSelectedRow();
            visitConstraintEditor.stopCellEditing();
            this.vcTable.setRowSelectionInterval(n, n);
        }
    }

    private void fireTableDataChanged() {
        VisitConstraintTableModel visitConstraintTableModel = (VisitConstraintTableModel)this.vcTable.getModel();
        visitConstraintTableModel.fireTableDataChanged();
    }

    private int getVisitConstraintCount() {
        VisitConstraintsListModel visitConstraintsListModel = (VisitConstraintsListModel)this.getModel();
        return null == visitConstraintsListModel ? 0 : visitConstraintsListModel.getVisitConstraintCount();
    }

    public void updateTargetCountLabel() {
        JLabel jLabel = (JLabel)this.retrieve(tpCountLabelFID);
        jLabel.setText("Visits specified : " + this.getVisitConstraintCount());
    }

    private void setButtons(VisitConstraintsListModel visitConstraintsListModel) {
        if (this.tpAddButton == null || this.tpDelButton == null) {
            return;
        }
        int n = this.getVisitConstraintCount();
        this.setEnabled(this.tpAddButton, true);
        this.setEnabled(this.tpDelButton, n > 0 && this.vcTable.getSelectedRow() != -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons((VisitConstraintsListModel)this.getModel());
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Single Field Editor");
        jFrame.setDefaultCloseOperation(3);
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC).withNano(0).plusDays(1L);
        VisitConstraint visitConstraint = VisitConstraint.createVisitConstraint();
        visitConstraint.setStartTimeInDate(zonedDateTime);
        visitConstraint.setAllowedMargin(Time.createTime((double)0.0, (String)Time.UNIT_MIN));
        performanceParameters.addVisitConstraint(visitConstraint);
        VisitConstraintsListModel visitConstraintsListModel = new VisitConstraintsListModel(null);
        VisitConstraintListEditor visitConstraintListEditor = new VisitConstraintListEditor(visitConstraintsListModel);
        visitConstraintsListModel.setDocument(performanceParameters);
        TestUtilities.runTestApp(visitConstraintListEditor);
    }
}

