/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.spatialvisual.SpatialPartModel;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualEditor;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParameters;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParametersModel;
import alma.obsprep.ot.editors.spatialvisual.VisualModelHelper;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapperModel;
import alma.obsprep.ot.models.schedblock.FieldPatternChangeListener;

public abstract class BaseSpatialVisualModel
extends Model {
    protected SpatialPartModel formModel;
    protected SpatialVisualParametersModel paramsModel;
    protected VisualModelHelper visualModelHelper;

    public BaseSpatialVisualModel(Object object, SpatialPartModel spatialPartModel) {
        super(object);
        this.formModel = spatialPartModel;
        this.paramsModel = new SpatialVisualParametersModel(this);
    }

    public SpatialDocument getSpatialDocument() {
        return (SpatialDocument)super.getDocument();
    }

    public SpatialPartModel getFormModel() {
        return this.formModel;
    }

    public SpatialVisualParametersModel getSpatialVisualParametersModel() {
        return this.paramsModel;
    }

    public VisualModelHelper getVisualModelHelper() {
        return this.visualModelHelper;
    }

    public abstract Model getSourceCoordinatesModel();

    public abstract Model getPointingPatternModel();

    public abstract Model getRectanglePatternModel();

    @Override
    public void publish() {
        ((Model)((Object)this.getFormModel())).publish();
        this.publishVisual();
    }

    public void publishVisual() {
        SpatialVisualParameters spatialVisualParameters;
        this.getSpatialVisualParametersModel().publish();
        if (this.document != null && (spatialVisualParameters = this.getSpatialVisualParametersModel().getSpatialVisualParameters()) != null) {
            this.publish(SpatialVisualEditor.FID_IMAGEFILENAME, spatialVisualParameters.getFilename());
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return null;
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument((SpatialDocument)object);
        this.publish();
    }

    @Override
    public void setonlyDocument(Object object) {
        SpatialDocument spatialDocument = (SpatialDocument)object;
        this.document = spatialDocument;
        if (object != null) {
            ((Model)((Object)this.getFormModel())).setonlyDocument(spatialDocument);
            SpatialPartOfSpatialDocument spatialPartOfSpatialDocument = this.getSpatialDocument().getSpatialPartOfSpatialDocument();
            if (spatialPartOfSpatialDocument != null) {
                SpatialVisualParameters spatialVisualParameters = spatialPartOfSpatialDocument.getSpatialVisualParameters();
                spatialVisualParameters.setContextDocument(spatialDocument);
                SpatialVisualParametersModel spatialVisualParametersModel = this.getSpatialVisualParametersModel();
                spatialVisualParametersModel.setonlyDocument(spatialPartOfSpatialDocument.getSpatialVisualParameters());
            }
        }
    }

    protected void configureFormChangeListener() {
        this.configureFormChangeListenerForCenterMapper();
        this.configureFormChangeListenerForPointingMapper();
        this.configureFormChangeListenerForRectangleMapper();
    }

    protected void configureFormChangeListenerForCenterMapper() {
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                BaseSpatialVisualModel.this.visualModelHelper.getCenterMapperModel().publish();
            }
        };
        this.getSourceCoordinatesModel().rsubscribe(modelChangeSubscriber);
    }

    protected void configureFormChangeListenerForPointingMapper() {
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                BaseSpatialVisualModel.this.visualModelHelper.getPointingMapperModel().publish();
            }
        };
        this.getSourceCoordinatesModel().rsubscribe(modelChangeSubscriber);
        this.getPointingPatternModel().subscribe(modelChangeSubscriber);
        ((Model)((Object)this.getFormModel())).subscribe(modelChangeSubscriber);
        ModelChangeSubscriber modelChangeSubscriber2 = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                PointingMapperModel pointingMapperModel = BaseSpatialVisualModel.this.visualModelHelper.getPointingMapperModel();
                pointingMapperModel.initialize();
                pointingMapperModel.publish();
                RoiMapperModel roiMapperModel = BaseSpatialVisualModel.this.visualModelHelper.getSDRoiMapperModel();
                roiMapperModel.initialize();
                roiMapperModel.publish();
                RoiMapperModel roiMapperModel2 = BaseSpatialVisualModel.this.visualModelHelper.getRoiMapperModel();
                roiMapperModel2.initialize();
                roiMapperModel2.publish();
            }
        };
        this.getSpatialVisualParametersModel().rsubscribe(modelChangeSubscriber2);
    }

    protected ModelChangeSubscriber getRectangleChangeListener() {
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                BaseSpatialVisualModel.this.visualModelHelper.getRoiMapperModel().publish();
                BaseSpatialVisualModel.this.visualModelHelper.getSDRoiMapperModel().publish();
            }
        };
        return modelChangeSubscriber;
    }

    protected void configureFormChangeListenerForRectangleMapper() {
        ModelChangeSubscriber modelChangeSubscriber = this.getRectangleChangeListener();
        this.getSourceCoordinatesModel().rsubscribe(modelChangeSubscriber);
        this.getRectanglePatternModel().rsubscribe(modelChangeSubscriber);
    }

    public void addFieldPatternChangeListener(FieldPatternChangeListener fieldPatternChangeListener) {
        this.visualModelHelper.addFieldPatternChangeListener(fieldPatternChangeListener);
    }

    public boolean removeFieldPatternChangeListener(FieldPatternChangeListener fieldPatternChangeListener) {
        return this.visualModelHelper.removeFieldPatternChangeListener(fieldPatternChangeListener);
    }
}

