/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.annotations.RectanglePatternI;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.ot.editors.spatialvisual.subform.MosaicParameters;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RectangleMosaic {
    private Map<TilingPattern, TilingAlgorithm> tilings = new HashMap<TilingPattern, TilingAlgorithm>();
    final AlmaPolicies apol = AlmaPolicies.getInstance();
    final int MAX_POINTING_COUNTS = this.apol.getMaxNumberPointings();
    final int WARN_NUMBER_POINTINGS = this.apol.getWarningNumberPointings();
    private RectanglePatternI rectangle;
    private Antenna antenna;

    public RectangleMosaic(RectanglePatternI rectanglePatternI, Antenna antenna) {
        this.rectangle = rectanglePatternI;
        this.antenna = antenna;
        this.tilings.put(TilingPattern.TILE_RECTANGLE, new RectangularTiling(rectanglePatternI));
        this.tilings.put(TilingPattern.TILE_TRIANGLE, new TriangularTiling(rectanglePatternI));
    }

    public RectangleMosaic(RectanglePatternI rectanglePatternI) {
        this(rectanglePatternI, Antenna.ANTENNA_12M);
    }

    public boolean showsTooManyPointingsWarning() {
        return true;
    }

    public boolean abortsByTooManyPointings() {
        return false;
    }

    public TilingAlgorithm getTiling() {
        MosaicParameters mosaicParameters = this.rectangle.getMosaicParameters();
        if (mosaicParameters == null) {
            return null;
        }
        return this.tilings.get((Object)TilingPattern.getTilingPattern(mosaicParameters.getType()));
    }

    public List<Point2D> getPointings() {
        if (this.rectangle == null) {
            return null;
        }
        TilingAlgorithm tilingAlgorithm = this.getTiling();
        if (tilingAlgorithm == null) {
            return null;
        }
        return tilingAlgorithm.getPointings();
    }

    public PointingPattern getPointingPattern() {
        Object object;
        List<Point2D> list = this.getPointings();
        if (list.size() > this.MAX_POINTING_COUNTS) {
            object = "There are too many (" + list.size() + ") pointings in this region.\n" + "Cannot create the pointed mosaic, try reducing map size or increasing spacing";
            Log.logger((Object)this).warning((String)object);
        }
        object = PointingPattern.createPointingPattern();
        SkyCoordinates skyCoordinates = this.rectangle.getOrigin();
        SkyCoordinates skyCoordinates2 = this.rectangle.getFieldCenterCoordinates().getAbsoluteCoordinates(skyCoordinates);
        PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter(skyCoordinates2);
        PointingCoordsConverter pointingCoordsConverter2 = new PointingCoordsConverter(skyCoordinates);
        for (Point2D point2D : list) {
            SkyCoordinates skyCoordinates3 = SkyCoordinates.createOffsetCoordinates();
            skyCoordinates3.getLongitude().setContentAndUnit(point2D.getX(), Longitude.UNIT_DEG);
            skyCoordinates3.getLatitude().setContentAndUnit(point2D.getY(), Latitude.UNIT_DEG);
            skyCoordinates3.setSystem(skyCoordinates.getSystem());
            SkyCoordinates skyCoordinates4 = pointingCoordsConverter2.absoluteToOffset(pointingCoordsConverter.offsetToAbsolute(skyCoordinates3));
            object.addPhaseCenterCoordinates(skyCoordinates4);
        }
        return object;
    }

    public PointingPattern getPointingPattern(SkyCoordinates skyCoordinates) {
        Object object;
        SkyCoordinates skyCoordinates2 = this.rectangle.getFieldCenterCoordinates();
        List<Point2D> list = this.getPointings();
        if (list.size() > this.MAX_POINTING_COUNTS) {
            object = "There are too many (" + list.size() + ") pointings in this region.\n" + "Cannot create the pointed mosaic, try reducing map size or increasing spacing";
            Log.logger((Object)this).warning((String)object);
        }
        object = PointingPattern.createPointingPattern();
        SkyCoordinates skyCoordinates3 = skyCoordinates.getAbsoluteCoordinates(skyCoordinates2);
        PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter(skyCoordinates2);
        PointingCoordsConverter pointingCoordsConverter2 = new PointingCoordsConverter(skyCoordinates3);
        for (Point2D point2D : list) {
            SkyCoordinates skyCoordinates4 = SkyCoordinates.createOffsetCoordinates();
            skyCoordinates4.getLongitude().setContentAndUnit(point2D.getX(), Longitude.UNIT_DEG);
            skyCoordinates4.getLatitude().setContentAndUnit(point2D.getY(), Latitude.UNIT_DEG);
            skyCoordinates4.setSystem(skyCoordinates.getSystem());
            SkyCoordinates skyCoordinates5 = pointingCoordsConverter2.absoluteToOffset(pointingCoordsConverter.offsetToAbsolute(skyCoordinates4));
            object.addPhaseCenterCoordinates(skyCoordinates5);
        }
        return object;
    }

    private Point2D.Double applyRotate(Point2D point2D, double d, double d2) {
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        Point2D.Double double_ = new Point2D.Double(d * d3 - d2 * d4, d2 * d3 + d * d4);
        return double_;
    }

    private boolean isEven(int n) {
        return n % 2 == 0;
    }

    public class ShiftTriangularTiling
    extends AbstractTriangularTiling {
        public ShiftTriangularTiling(RectanglePatternI rectanglePatternI) {
            super(rectanglePatternI);
        }

        @Override
        public List<Point2D> getPointings(double d, double d2, double d3) {
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            double d4 = d3;
            double d5 = Math.sqrt(3.0) / 2.0 * d3;
            int n = (int)Math.floor(d / 2.0 / d4 + 0.5);
            n += this.needsFiller(d, d4, n * 2);
            int n2 = (int)Math.floor(d / 2.0 / d4);
            n2 += this.needsFiller(d, d4, n2 * 2 + 1);
            int n3 = (int)Math.floor((d2 - d5) / 2.0 / d5 + 1.0);
            n3 += this.needsFiller(d2, d5, n3 * 2);
            for (int i = -n3; i < n3; ++i) {
                Point2D.Double double_;
                int n4;
                if (RectangleMosaic.this.isEven(i)) {
                    for (n4 = -n; n4 < n; ++n4) {
                        double_ = new Point2D.Double(((double)n4 + 0.5) * d4, ((double)i + 0.5) * d5);
                        arrayList.add(double_);
                    }
                    continue;
                }
                for (n4 = -n2; n4 <= n2; ++n4) {
                    double_ = new Point2D.Double((double)n4 * d4, ((double)i + 0.5) * d5);
                    arrayList.add(double_);
                }
            }
            if (arrayList.size() == 1) {
                arrayList.clear();
                arrayList.add(new Point2D.Double(0.0, 0.0));
            }
            return arrayList;
        }
    }

    private class BaseTriangularTiling
    extends AbstractTriangularTiling {
        public BaseTriangularTiling(RectanglePatternI rectanglePatternI) {
            super(rectanglePatternI);
        }

        @Override
        public List<Point2D> getPointings(double d, double d2, double d3) {
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            if (d3 <= 0.0) {
                return arrayList;
            }
            double d4 = d3;
            double d5 = Math.sqrt(3.0) / 2.0 * d3;
            int n = (int)Math.floor(d / 2.0 / d4);
            n += this.needsFiller(d, d4, n * 2 + 1);
            int n2 = (int)Math.floor(d / 2.0 / d4 + 0.5);
            n2 += this.needsFiller(d, d4, n2 * 2);
            int n3 = (int)Math.floor(d2 / 2.0 / d5);
            n3 += this.needsFiller(d2, d5, n3 * 2 + 1);
            for (int i = -n3; i <= n3; ++i) {
                Point2D.Double double_;
                int n4;
                if (RectangleMosaic.this.isEven(i)) {
                    for (n4 = -n; n4 <= n; ++n4) {
                        double_ = new Point2D.Double((double)n4 * d4, (double)i * d5);
                        arrayList.add(double_);
                    }
                    continue;
                }
                for (n4 = -n2; n4 < n2; ++n4) {
                    double_ = new Point2D.Double(((double)n4 + 0.5) * d4, (double)i * d5);
                    arrayList.add(double_);
                }
            }
            if (arrayList.size() == 1) {
                arrayList.clear();
                arrayList.add(new Point2D.Double(0.0, 0.0));
            }
            return arrayList;
        }
    }

    public abstract class AbstractTriangularTiling
    extends TilingAlgorithm {
        public AbstractTriangularTiling(RectanglePatternI rectanglePatternI) {
            super(rectanglePatternI);
        }

        @Override
        public List<Point2D> getPointings() {
            double d = this.rect.getLongitudeLength().getContentInUnits(Angle.UNIT_DEG);
            double d2 = this.rect.getLatitudeLength().getContentInUnits(Angle.UNIT_DEG);
            double d3 = this.rect.getRotationAngle().getContentInUnits(Angle.UNIT_RAD);
            double d4 = this.getSpacing().getContentInUnits(Angle.UNIT_DEG);
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            if (this.isLandscape()) {
                double d5 = Math.cos(d3);
                double d6 = Math.sin(d3);
                for (Point2D point2D : this.getPointings(d, d2, d4)) {
                    arrayList.add(RectangleMosaic.this.applyRotate(point2D, d5, d6));
                }
            } else {
                double d7 = Math.cos(d3 + 1.5707963267948966);
                double d8 = Math.sin(d3 + 1.5707963267948966);
                for (Point2D point2D : this.getPointings(d2, d, d4)) {
                    arrayList.add(RectangleMosaic.this.applyRotate(point2D, d7, d8));
                }
            }
            if (arrayList.size() == 1) {
                arrayList.clear();
                arrayList.add(new Point2D.Double(0.0, 0.0));
            }
            return arrayList;
        }

        @Override
        public Rectangle getEnvelopeRectangle() {
            if (!(this.rect instanceof Rectangle)) {
                String string = "getEnvelopeRectangle does not support RectanglePattern object";
                Log.logger((Object)this).warning(string);
                throw new RuntimeException(string);
            }
            Rectangle rectangle = Rectangle.createRectangle();
            rectangle.setCentre(this.rect.getFieldCenterCoordinates());
            rectangle.setSpacing((UserAngle)((Object)this.rect.getSpacing()));
            rectangle.setRotationAngle(this.rect.getRotationAngle());
            rectangle.setReferenceFrequency(this.rect.getObservingFrequency());
            double d = this.getSpacing().getContentInUnits(Angle.UNIT_DEG);
            if (d == 0.0) {
                return ((Rectangle)this.rect).deepCopy();
            }
            double d2 = -1.7976931348623157E308;
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            double d5 = Double.MAX_VALUE;
            for (Point2D point2D : this.getPointings(this.getLongSideDeg(), this.getShortSideDeg(), d)) {
                double d6 = point2D.getX();
                double d7 = point2D.getY();
                d2 = d2 < d6 ? d6 : d2;
                d3 = d3 > d6 ? d6 : d3;
                d4 = d4 < d7 ? d7 : d4;
                d5 = d5 > d7 ? d7 : d5;
            }
            double d8 = d2 - d3;
            double d9 = d4 - d5;
            if (this.isLandscape()) {
                rectangle.getLong().setContentAndUnit(d8, Angle.UNIT_DEG);
                rectangle.getShort().setContentAndUnit(d9, Angle.UNIT_DEG);
            } else {
                rectangle.getShort().setContentAndUnit(d8, Angle.UNIT_DEG);
                rectangle.getLong().setContentAndUnit(d9, Angle.UNIT_DEG);
            }
            return rectangle;
        }
    }

    public class TriangularTiling
    extends TilingAlgorithm {
        private TilingAlgorithm shiftTriangularTiling;
        private TilingAlgorithm baseTriangularTiling;

        public TriangularTiling(RectanglePatternI rectanglePatternI) {
            super(rectanglePatternI);
            this.baseTriangularTiling = new BaseTriangularTiling(rectanglePatternI);
            this.shiftTriangularTiling = new ShiftTriangularTiling(rectanglePatternI);
        }

        private TilingAlgorithm getTiling() {
            double d = Math.sqrt(3.0) / 2.0 * this.getSpacing().getContentInUnits(Angle.UNIT_DEG);
            int n = (int)Math.ceil(this.getShortSideDeg() / d);
            return n % 2 == 0 ? this.shiftTriangularTiling : this.baseTriangularTiling;
        }

        @Override
        public List<Point2D> getPointings(double d, double d2, double d3) {
            return this.getTiling().getPointings(d, d2, d3);
        }

        @Override
        public List<Point2D> getPointings() {
            return this.getTiling().getPointings();
        }

        @Override
        public Rectangle getEnvelopeRectangle() {
            return this.getTiling().getEnvelopeRectangle();
        }
    }

    public class RectangularTiling
    extends TilingAlgorithm {
        public RectangularTiling(RectanglePatternI rectanglePatternI) {
            super(rectanglePatternI);
        }

        private int getNumberPointingsWidth(double d, double d2) {
            return (int)Math.floor(d / 2.0 / d2);
        }

        private int getNumberPointingsHeight(double d, double d2) {
            return (int)Math.floor(d / 2.0 / d2);
        }

        @Override
        public List<Point2D> getPointings(double d, double d2, double d3) {
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            int n = this.getNumberPointingsWidth(d, d3);
            int n2 = this.getNumberPointingsHeight(d2, d3);
            for (int i = -n2; i <= n2; ++i) {
                for (int j = -n; j <= n; ++j) {
                    arrayList.add(new Point2D.Double((double)j * d3, (double)i * d3));
                }
            }
            return arrayList;
        }

        @Override
        public List<Point2D> getPointings() {
            double d = this.rect.getLongitudeLength().getContentInUnits(Angle.UNIT_DEG);
            double d2 = this.rect.getLatitudeLength().getContentInUnits(Angle.UNIT_DEG);
            double d3 = this.rect.getRotationAngle().getContentInUnits(Angle.UNIT_RAD);
            double d4 = this.getSpacing().getContentInUnits(Angle.UNIT_DEG);
            double d5 = Math.cos(d3);
            double d6 = Math.sin(d3);
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            for (Point2D point2D : this.getPointings(d, d2, d4)) {
                arrayList.add(RectangleMosaic.this.applyRotate(point2D, d5, d6));
            }
            return arrayList;
        }

        @Override
        public Rectangle getEnvelopeRectangle() {
            if (!(this.rect instanceof Rectangle)) {
                String string = "getEnvelopeRectangle does not support RectanglePattern object";
                Log.logger((Object)this).warning(string);
                throw new RuntimeException(string);
            }
            double d = this.rect.getLongitudeLength().getContentInUnits(Angle.UNIT_DEG);
            double d2 = this.rect.getLatitudeLength().getContentInUnits(Angle.UNIT_DEG);
            double d3 = this.getSpacing().getContentInUnits(Angle.UNIT_DEG);
            Rectangle rectangle = ((Rectangle)this.rect).deepCopy();
            rectangle.getLong().setContentAndUnit((double)(this.getNumberPointingsWidth(d, d3) * 2) * d3, Angle.UNIT_DEG);
            rectangle.getShort().setContentAndUnit((double)(this.getNumberPointingsHeight(d2, d3) * 2) * d3, Angle.UNIT_DEG);
            return rectangle;
        }
    }

    public abstract class TilingAlgorithm {
        protected RectanglePatternI rect;

        public TilingAlgorithm(RectanglePatternI rectanglePatternI) {
            this.rect = rectanglePatternI;
        }

        public abstract List<Point2D> getPointings(double var1, double var3, double var5);

        public abstract List<Point2D> getPointings();

        public abstract Rectangle getEnvelopeRectangle();

        public boolean isLandscape() {
            double d;
            double d2 = this.rect.getLongitudeLength().getContentInUnits(Angle.UNIT_DEG);
            return d2 >= (d = this.rect.getLatitudeLength().getContentInUnits(Angle.UNIT_DEG));
        }

        public double getLongSideDeg() {
            if (this.isLandscape()) {
                return this.rect.getLongitudeLength().getContentInUnits(Angle.UNIT_DEG);
            }
            return this.rect.getLatitudeLength().getContentInUnits(Angle.UNIT_DEG);
        }

        public double getShortSideDeg() {
            if (this.isLandscape()) {
                return this.rect.getLatitudeLength().getContentInUnits(Angle.UNIT_DEG);
            }
            return this.rect.getLongitudeLength().getContentInUnits(Angle.UNIT_DEG);
        }

        protected Angle getBeamsize() {
            Frequency frequency = this.rect.getObservingFrequency();
            if (frequency == null || frequency.getContent() == 0.0) {
                return null;
            }
            return RectangleMosaic.this.antenna.getBeamSize(frequency);
        }

        protected int needsFiller(double d, double d2, int n) {
            if (RectangleMosaic.this.antenna == null) {
                return 0;
            }
            Angle angle = this.getBeamsize();
            if (angle == null) {
                return 0;
            }
            double d3 = angle.getContentInUnits(Angle.UNIT_DEG);
            return d > d2 * (double)(n - 1) + d3 ? 1 : 0;
        }

        protected Angle getSpacing() {
            if (this.rect instanceof RectanglePattern) {
                return Angle.createAngle((double)this.rect.getMosaicParameters().getSpacing(), (String)Angle.UNIT_ARCSEC);
            }
            Angle angle = this.rect.getSpacing();
            if (!(angle instanceof UserAngle)) {
                return angle;
            }
            UserAngle userAngle = (UserAngle)((Object)angle);
            if (userAngle.inModelUnit()) {
                return userAngle;
            }
            Angle angle2 = this.getBeamsize();
            Angle angle3 = angle2 == null ? Angle.createAngle() : (Angle)this.getBeamsize().multiply(userAngle.getUserContent());
            return angle3;
        }
    }

    public static enum TilingPattern {
        TILE_RECTANGLE("Rectangle Grid"),
        TILE_TRIANGLE("Triangle Grid");

        private String label;

        private TilingPattern(String string2) {
            this.label = string2;
        }

        public static TilingPattern getTilingPattern(String string) {
            for (TilingPattern tilingPattern : TilingPattern.values()) {
                if (!tilingPattern.label.equals(string)) continue;
                return tilingPattern;
            }
            return null;
        }

        public String toString() {
            return this.label;
        }
    }
}

