/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SpatialVisualParameters
implements Serializable {
    public static final String DEFAULT_IMAGESERVER = "Digitized Sky (Version II) at ESO";
    private static final Collection<String> TWELVE_M_ARRAYS;
    private SpatialDocument spatialDocument;
    private SpatialPartOfSpatialDocument parentSpatialPart;
    private final Frequency frequency = Frequency.createFrequency();
    private String frequencySource = "";
    private Antenna antenna = Antenna.ANTENNA_12M;
    private boolean showsFov = true;
    private String imageServer = "Digitized Sky (Version II) at ESO";
    private double size = 10.0;
    private String filename = null;

    public SpatialVisualParameters(SpatialPartOfSpatialDocument spatialPartOfSpatialDocument) {
        this.parentSpatialPart = spatialPartOfSpatialDocument;
    }

    public Antenna getAntenna() {
        return this.antenna;
    }

    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public String getSingleFrequencySource() {
        return this.frequencySource;
    }

    public void setSingleFrequencySource(String string) {
        this.frequencySource = string;
    }

    public boolean getShowsFov() {
        return this.showsFov;
    }

    public void setShowsFov(boolean bl) {
        this.showsFov = bl;
    }

    public SpatialPartOfSpatialDocument getParentSpatialPart() {
        return this.parentSpatialPart;
    }

    public void setContextDocument(SpatialDocument spatialDocument) {
        SchedBlock schedBlock;
        BusinessObject businessObject;
        BusinessObject businessObject2;
        this.spatialDocument = spatialDocument;
        this.setSingleFrequency(spatialDocument.getSingleFrequency());
        this.setSingleFrequencySource(spatialDocument.getSingleFrequencySource());
        if (spatialDocument instanceof BusinessObject && (businessObject2 = (businessObject = (BusinessObject)spatialDocument).getParent()) instanceof SchedBlock && (schedBlock = (SchedBlock)businessObject2) != null) {
            Antenna antenna = TWELVE_M_ARRAYS.contains(schedBlock.getObsUnitControl().getArrayRequested()) ? Antenna.ANTENNA_12M : Antenna.ANTENNA_7M;
            this.setAntenna(antenna);
        }
    }

    public SpatialDocument getContextDocument() {
        return this.spatialDocument;
    }

    public Angle getFovSize() {
        return this.antenna.getBeamSize(this.getFrequency());
    }

    public SpatialPartOfSpatialDocument getParent() {
        return this.parentSpatialPart;
    }

    public String getSourceName() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getSourceName();
    }

    public SkyCoordinates getSourceCoordinates() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getSourceCoordinates();
    }

    public void setImageServer(String string) {
        this.imageServer = string;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getImageServer() {
        return this.imageServer;
    }

    public double getSize() {
        return this.size;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setSingleFrequency(Frequency frequency) {
        Frequency frequency2 = frequency == null ? Frequency.createFrequency() : frequency;
        this.getFrequency().setContentAndUnit((ValueUnitPair)frequency2);
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ObsUnitControl.ARRAYREQUESTED_TWELVE_M);
        arrayList.add(ObsUnitControl.ARRAYREQUESTED_TP_ARRAY);
        TWELVE_M_ARRAYS = Collections.unmodifiableCollection(arrayList);
    }
}

