/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.annotations.RectanglePatternI;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.CenterMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.OverlayPointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.SlaveRoiMapperModel;
import alma.obsprep.ot.models.schedblock.FieldPatternChangeListener;
import alma.valuetypes.SkyCoordinates;

public abstract class VisualModelHelper
implements FieldPatternChangeListener {
    protected BaseSpatialVisualModel model;
    private CenterMapperModel centerMapperModel;
    private PointingMapperModel pointingMapperModel;
    private RoiMapperModel roiMapperModel;
    private RoiMapperModel sdroiMapperModel;

    public VisualModelHelper(BaseSpatialVisualModel baseSpatialVisualModel) {
        this.model = baseSpatialVisualModel;
        this.centerMapperModel = new CenterMapperModel(baseSpatialVisualModel);
        this.pointingMapperModel = new PointingMapperModel(baseSpatialVisualModel);
        this.roiMapperModel = new RoiMapperModel(baseSpatialVisualModel);
        this.sdroiMapperModel = new SlaveRoiMapperModel(baseSpatialVisualModel, this.roiMapperModel);
    }

    public CenterMapperModel getCenterMapperModel() {
        return this.centerMapperModel;
    }

    public PointingMapperModel getPointingMapperModel() {
        return this.pointingMapperModel;
    }

    public RoiMapperModel getRoiMapperModel() {
        return this.roiMapperModel;
    }

    public OverlayPointingMapperModel getOverlayPointingMapperModel() {
        return this.roiMapperModel.getOverlayPointingMapperModel();
    }

    public RoiMapperModel getSDRoiMapperModel() {
        return this.sdroiMapperModel;
    }

    @Override
    public void fieldPatternChanged(FieldPattern.FieldPatternType fieldPatternType) {
        this.getPointingMapperModel().setFieldPatternType(fieldPatternType);
        this.getRoiMapperModel().setFieldPatternType(fieldPatternType);
        this.getSDRoiMapperModel().setFieldPatternType(fieldPatternType);
    }

    public void updateFormEditor(MapperModel mapperModel) {
    }

    public void changeFieldPattern(FieldPattern.FieldPatternType fieldPatternType) {
    }

    public SkyCoordinates getTargetCenter() {
        return null;
    }

    public FieldPatternI getFieldPattern() {
        return null;
    }

    public FieldPattern.FieldPatternType getFieldPatternType() {
        return null;
    }

    public SkyCoordinates[] getTargetCenters() {
        return null;
    }

    public SkyCoordinates addTargetCenter() {
        return null;
    }

    public void deleteTargetCenter(SkyCoordinates skyCoordinates) {
    }

    public SkyCoordinates[] getPointings() {
        return null;
    }

    public SkyCoordinates addPointing() {
        return null;
    }

    public void deletePointing(SkyCoordinates skyCoordinates) {
    }

    public RectanglePatternI[] getRectangleRois() {
        return null;
    }

    public RectanglePatternI addRectangleRoi() {
        return null;
    }

    public void deleteRectangleRoi(RectanglePatternI rectanglePatternI) {
    }

    public abstract void addFieldPatternChangeListener(FieldPatternChangeListener var1);

    public abstract boolean removeFieldPatternChangeListener(FieldPatternChangeListener var1);
}

