/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.RectangleMosaic;
import alma.obsprep.ot.editors.spatialvisual.mapper.PatternFigure;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.ShowPointingsException;
import alma.obsprep.ot.editors.spatialvisual.subform.FovParameterEditor;
import alma.obsprep.services.generator.refactored.targetcreator.TargetParametersFieldSourceWorker;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.util.Arrays;
import java.util.Optional;
import jsky.image.gui.MainImageDisplay;

public class OverlayPointingMapperModel
extends PointingMapperModel {
    private PointingPattern pointingPattern;
    private RoiMapperModel roiMapperModel;

    public OverlayPointingMapperModel(BaseSpatialVisualModel baseSpatialVisualModel, RoiMapperModel roiMapperModel) {
        super(baseSpatialVisualModel);
        this.roiMapperModel = roiMapperModel;
        baseSpatialVisualModel.getSpatialVisualParametersModel().subscribe((model, fieldID, object) -> {
            if (fieldID == FovParameterEditor.FID_ANTENNA) {
                try {
                    this.configurePointingPattern();
                }
                catch (ShowPointingsException showPointingsException) {
                    // empty catch block
                }
            }
        });
    }

    public void configurePointingPattern() throws ShowPointingsException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Rectangle rectangle;
        try {
            rectangle = (Rectangle)this.roiMapperModel.getFieldPattern();
        }
        catch (ClassCastException classCastException) {
            throw new ShowPointingsException("This feature is not available for the selected field setup");
        }
        if (rectangle == null) {
            this.pointingPattern = null;
            return;
        }
        double d = rectangle.getSpacing().getContentInUnits(Angle.UNIT_ARCSEC);
        if (d <= 0.0) {
            String string = "Spacing must be positive.";
            Log.logger((Object)this).warning(string);
            throw new ShowPointingsException(string);
        }
        double d2 = 0.0;
        Optional<Object> optional = Optional.empty();
        if (this.imageCoordinateSystem != null && rectangle.getTargetParameters() != null) {
            object4 = rectangle.getTargetParameters().getSourceCoordinates();
            object3 = null;
            if (SkyCoordinates.isEquatorial(object4.getSystem()) && this.imageCoordinateSystem.equals((Object)MainImageDisplay.CoordSystemType.GALACTIC)) {
                optional = Optional.of(TargetParametersFieldSourceWorker.SystemRotationConversion.ICRSToGalactic);
                object3 = RoiMapper.RotationCase.GalacticImageAndICRSSource;
            } else if (SkyCoordinates.isGalactic(object4.getSystem()) && this.imageCoordinateSystem.equals((Object)MainImageDisplay.CoordSystemType.EQUATORIAL)) {
                optional = Optional.of(TargetParametersFieldSourceWorker.SystemRotationConversion.GalacticToICRS);
                object3 = RoiMapper.RotationCase.ICRSImageAndGalacticSource;
            }
            if (optional.isPresent()) {
                assert (object3 != null);
                object2 = (TargetParametersFieldSourceWorker.SystemRotationConversion)((Object)optional.get());
                rectangle = this.convertRectangleCoordinateSystem((TargetParametersFieldSourceWorker.SystemRotationConversion)((Object)object2), rectangle);
                SkyCoordinates skyCoordinates = rectangle.getFieldCenterCoordinates();
                object = skyCoordinates.getType().equals(SkyCoordinates.TYPE_RELATIVE) ? skyCoordinates.getAbsoluteCoordinates(rectangle.getOrigin()) : skyCoordinates;
                SkyCoordinates skyCoordinates2 = ((SkyCoordinates)object).getICRSSkyCoordinates();
                d2 = TargetParametersFieldSourceWorker.transformPABetweenCoordinateSystems(rectangle.getRotationAngle().getDegs() * -1.0, skyCoordinates2.getLongitude().getContentInDeg(), skyCoordinates2.getLatitude().getContentInDeg(), object2);
                Log.logger(OverlayPointingMapperModel.class).fine("coordinateSystemCompensatedRotationDegs: " + d2);
                double d3 = Math.toDegrees(RoiMapper.getROIRotationAngle(Math.toRadians(d2), (RoiMapper.RotationCase)((Object)object3), 0.0, this.isImageFlipped()));
                rectangle.setRotationAngle(Angle.createAngle((double)d3, (String)Angle.UNIT_DEG));
            }
        }
        Log.logger(OverlayPointingMapperModel.class).fine("Overlay rectangle rotation: " + (Object)((Object)rectangle.getRotationAngle()));
        object4 = Antenna.ANTENNA_12M;
        object3 = this.getSpatialVisualModel().getSpatialVisualParametersModel().getSpatialVisualParameters();
        if (object3 != null) {
            object4 = object3.getAntenna();
        }
        object2 = new RectangleMosaic(rectangle, (Antenna)((Object)object4));
        this.pointingPattern = ((RectangleMosaic)object2).getPointingPattern();
        boolean bl = true;
        if (this.pointingPattern == null) {
            object = "Too many pointings";
            Log.logger((Object)this).warning((String)object);
            bl = false;
            throw new ShowPointingsException((String)object);
        }
        bl = AlmaPolicies.getInstance().getMaxNumberPointings() > this.pointingPattern.getPhaseCenterCoordinatesCount();
        this.setChanged();
        this.notifyObservers(bl);
    }

    private Rectangle convertRectangleCoordinateSystem(TargetParametersFieldSourceWorker.SystemRotationConversion systemRotationConversion, Rectangle rectangle) {
        if (systemRotationConversion == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: coordinateSystemConversion");
        }
        if (rectangle == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: rectangleToCopy");
        }
        if (systemRotationConversion.equals((Object)TargetParametersFieldSourceWorker.SystemRotationConversion.NoConversionRequired)) {
            return rectangle;
        }
        TargetParameters targetParameters = rectangle.getTargetParameters().deepCopy();
        targetParameters.clearField();
        Rectangle rectangle2 = rectangle.deepCopy();
        rectangle2.setCentre(rectangle.getCentre().deepCopy());
        rectangle2.referrers.get(Referring.By.UmlComposition).stream().forEach(iBusinessObject -> rectangle2.removedFrom((IBusinessObject)iBusinessObject, Referring.By.UmlComposition));
        targetParameters.addField((Field)((Object)rectangle2));
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates();
        SkyCoordinates skyCoordinates2 = rectangle2.getSourceCoordinates();
        switch (systemRotationConversion) {
            case GalacticToICRS: {
                skyCoordinates.convertToICRS();
                skyCoordinates2.convertToICRS();
                skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
                skyCoordinates2.setSystem(SkyCoordinates.SYSTEM_ICRS);
                break;
            }
            case ICRSToGalactic: {
                skyCoordinates.convertToGalactic();
                skyCoordinates2.convertToGalactic();
                skyCoordinates.setSystem(SkyCoordinates.SYSTEM_GALACTIC);
                skyCoordinates2.setSystem(SkyCoordinates.SYSTEM_GALACTIC);
                break;
            }
        }
        return rectangle2;
    }

    public static TargetParameters getPointingSourceInICRS(TargetParameters targetParameters) {
        if (targetParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: targetParameters");
        }
        TargetParameters targetParameters2 = targetParameters.deepCopy();
        SkyCoordinates skyCoordinates2 = targetParameters.getSourceCoordinates();
        if (skyCoordinates2.isGalactic()) {
            targetParameters2.setSourceCoordinates(skyCoordinates2.getICRSSkyCoordinates());
            PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter(targetParameters2.getSourceCoordinates());
            boolean bl = targetParameters.isOffsetPointingPattern();
            SkyCoordinates[] skyCoordinatesArray = (SkyCoordinates[])Arrays.asList(targetParameters2.getPointingPattern().getPhaseCenterCoordinates()).stream().map(skyCoordinates -> {
                if (bl) {
                    pointingCoordsConverter.matchSystemToOrigin((SkyCoordinates)skyCoordinates);
                } else {
                    skyCoordinates.convertToSystem(SkyCoordinates.SYSTEM_ICRS);
                }
                return skyCoordinates;
            }).toArray(SkyCoordinates[]::new);
            if (targetParameters2.getPointingPattern().isPointingPattern()) {
                targetParameters2.getPointingPattern().setPhaseCenterCoordinates(skyCoordinatesArray);
            }
        }
        return targetParameters2;
    }

    public void clearPointingPattern() {
        this.pointingPattern = null;
    }

    @Override
    public FieldPatternI getFieldPattern() {
        return this.pointingPattern;
    }

    @Override
    public boolean isFovFigureSelectionEnabled() {
        return false;
    }

    @Override
    protected void updateBO(PatternFigure patternFigure) {
    }

    @Override
    public void updateFormEditor() {
    }
}

