/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.annotations.RectanglePatternI;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.guiutil.jsky.image.graphics.AlmaRectangleGeometry;
import alma.obsprep.guiutil.jsky.image.graphics.AlmaRoiRectangle;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParametersModel;
import alma.obsprep.ot.editors.spatialvisual.VisualModelHelper;
import alma.obsprep.ot.editors.spatialvisual.mapper.BOFigureListManager;
import alma.obsprep.ot.editors.spatialvisual.mapper.FieldMapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.FovFigure;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapperModel;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ListSelectionModel;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureEvent;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasFigureListenerAdapter;
import jsky.image.graphics.RoiFigure;

public class PointingMapper
extends FieldMapper {
    private Boolean showPointings = false;
    private ListSelectionModel tableSelectionModel;
    protected PointingCoordsConverter pointingCoordsConverter;
    private boolean fovFigureSelectionEnable = true;
    private Rectangle tpRectangle = Rectangle.createRectangle();
    private AlmaRoiRectangle tpRectangleFig;

    public PointingMapper(AlmaNavigatorImageDisplayPanel almaNavigatorImageDisplayPanel, PointingMapperModel pointingMapperModel) {
        super(almaNavigatorImageDisplayPanel, pointingMapperModel);
        this.pointingCoordsConverter = new PointingCoordsConverter();
    }

    @Override
    public PointingMapperModel getModel() {
        return (PointingMapperModel)super.getModel();
    }

    public VisualModelHelper getVisualModelHelper() {
        return this.getModel().getSpatialVisualModel().getVisualModelHelper();
    }

    public SpatialVisualParametersModel getSpatialVisualParametersModel() {
        return this.getModel().getSpatialVisualModel().getSpatialVisualParametersModel();
    }

    protected FovFigure draw(MouseEvent mouseEvent) {
        if (!this.isWcsSet(true)) {
            this.setDrawing(false);
            return null;
        }
        FieldPatternI fieldPatternI = this.getModel().getFieldPattern();
        if (fieldPatternI == null || !fieldPatternI.isPointingPattern()) {
            this.getModel().changeFieldPattern(FieldPattern.FieldPatternType.POINT);
            fieldPatternI = this.getModel().getFieldPattern();
        }
        SkyCoordinates skyCoordinates = this.getModel().addPatternPointing();
        FovFigure fovFigure = this.update(skyCoordinates, true);
        double d = (double)mouseEvent.getX() - fovFigure.getBounds().getCenterX();
        double d2 = (double)mouseEvent.getY() - fovFigure.getBounds().getCenterY();
        fovFigure.translate(d, d2);
        return fovFigure;
    }

    private AlmaRoiRectangle updateTPRasterScanRectangle() {
        if (this.getSpatialVisualModel().getDocument() instanceof ScienceGoal) {
            boolean bl;
            ScienceGoal scienceGoal = (ScienceGoal)this.getSpatialVisualModel().getDocument();
            PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
            SpatialVisualParametersModel spatialVisualParametersModel = this.getSpatialVisualModel().getSpatialVisualParametersModel();
            assert (spatialVisualParametersModel != null);
            TargetParameters targetParameters = spatialVisualParametersModel.getTargetParams();
            int n = targetParameters.getNumberOfPointings();
            boolean bl2 = n > 0 && targetParameters.getIsMosaic();
            boolean bl3 = bl = n == 1 && !targetParameters.getIsMosaic();
            if (performanceParameters.getUseACA() && performanceParameters.getUseTP() && (bl2 || bl)) {
                Rectangle rectangle = SchedBlockExpert.getBoundingRectangle(targetParameters);
                rectangle.setTargetParameters(targetParameters);
                Rectangle rectangle2 = rectangle.getTPArrayRectangle(scienceGoal.getPerformanceParameters().getRepresentativeFrequencyWithSkyOffset());
                rectangle2.setTargetParameters(targetParameters);
                this.tpRectangle.setTargetParameters(targetParameters);
                rectangle2.duplicate(this.tpRectangle);
                Log.logger(this.getClass()).fine("TP rectangle dimensions (arcsec) : Long " + this.tpRectangle.getLong().getContentInUnits(Angle.UNIT_ARCSEC) + " short " + this.tpRectangle.getShort().getContentInUnits(Angle.UNIT_ARCSEC));
                assert (this.tpRectangle != null);
                Log.logger(PointingMapper.class).fine("tpRectangle: " + this.tpRectangle);
                if (this.boFigureListManager.figureTableContainsBO((BusinessObject)this.tpRectangle)) {
                    this.tpRectangleFig = (AlmaRoiRectangle)this.boFigureListManager.getFigure((BusinessObject)this.tpRectangle);
                } else {
                    this.tpRectangleFig = this.createTPRectangleFigure(this.tpRectangle);
                    this.boFigureListManager.add((BusinessObject)this.tpRectangle, this.tpRectangleFig);
                }
                assert (this.tpRectangleFig != null);
                this.transformTPRectangle((RoiFigure)this.tpRectangleFig, this.tpRectangle);
            } else {
                this.boFigureListManager.remove(this.tpRectangleFig);
            }
        }
        return this.tpRectangleFig;
    }

    protected FovFigure update(SkyCoordinates skyCoordinates, boolean bl) {
        FovFigure fovFigure;
        if (!this.isWcsSet(false) || !this.showPointings.booleanValue() && !this.imagePanel.getMapperManager().getFieldPatternType().equals((Object)FieldPattern.FieldPatternType.POINT)) {
            return null;
        }
        if (bl && !this.getClass().getName().contains("RoiMapper")) {
            this.updateTPRasterScanRectangle();
        }
        SkyCoordinates skyCoordinates2 = skyCoordinates.getAbsoluteCoordinates(this.getModel().getTargetCenter());
        if (this.boFigureListManager.figureTableContainsBO((BusinessObject)skyCoordinates)) {
            fovFigure = (FovFigure)this.boFigureListManager.getFigure((BusinessObject)skyCoordinates);
        } else {
            fovFigure = this.createFov(skyCoordinates);
            this.boFigureListManager.add((BusinessObject)skyCoordinates, fovFigure);
        }
        this.imagePanel.getImageDisplay().translateFigureTo(fovFigure, skyCoordinates2);
        return fovFigure;
    }

    private AlmaRoiRectangle createTPRectangleFigure(Rectangle rectangle) {
        if (!this.isWcsSet(false)) {
            return null;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        AlmaRoiRectangle almaRoiRectangle = new AlmaRoiRectangle(double_){

            @Override
            protected Color getLineColor() {
                return Color.CYAN;
            }
        };
        almaRoiRectangle.setBusinessObject((BusinessObject)rectangle);
        this.imagePanel.getAlmaCanvasDraw().addFigure(almaRoiRectangle);
        return almaRoiRectangle;
    }

    private void clearSelection() {
        if (this.tableSelectionModel != null) {
            this.tableSelectionModel.clearSelection();
        }
    }

    @Override
    public void deleteSelectedPattern() {
        this.enableFovFigureSelection(false);
        List<CanvasFigure> list = this.imagePanel.getAlmaCanvasDraw().getSelectedFovList();
        ListIterator<CanvasFigure> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            FovFigure fovFigure = (FovFigure)listIterator.next();
            SkyCoordinates skyCoordinates = (SkyCoordinates)fovFigure.getBusinessObject();
            if (skyCoordinates == null) continue;
            this.getModel().deletePatternPointing(skyCoordinates);
            this.update(skyCoordinates, true);
            this.boFigureListManager.remove((BusinessObject)skyCoordinates);
        }
        this.enableFovFigureSelection(true);
        this.clearSelection();
    }

    protected void importPointing() {
        if (this.isActivated()) {
            this.initialize();
            if (this.getVisualModelHelper().getPointings().length > 0) {
                this.getModel().publish();
                this.imagePanel.getImageGraphics().clearSelection();
                this.imagePanel.getMapperManager().setFieldPatternType(FieldPattern.FieldPatternType.POINT);
            }
        }
    }

    protected boolean isFovFigureSelectionEnabled() {
        return this.fovFigureSelectionEnable;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isActivated()) {
            return;
        }
        if (this.isDrawing()) {
            FovFigure fovFigure = this.draw(mouseEvent);
            this.setDrawing(false);
            this.getModel().updateBO(fovFigure);
            this.update((SkyCoordinates)fovFigure.getBusinessObject(), true);
        }
    }

    protected boolean isFrequencySet() {
        Frequency frequency = this.getRestFrequency();
        boolean bl = frequency != null && frequency.getContentInGHz() != 0.0;
        return bl;
    }

    protected boolean getShowsFov() {
        return this.getModel().getSpatialPartModel().getSpatialPart().getSpatialVisualParameters().getShowsFov();
    }

    protected Frequency getRestFrequency() {
        return this.getModel().getSpatialPartModel().getSpatialPart().getSpatialVisualParameters().getFrequency();
    }

    protected void setTableSelectionModel(ListSelectionModel listSelectionModel) {
        this.tableSelectionModel = listSelectionModel;
    }

    protected void enableFovFigureSelection(boolean bl) {
        this.fovFigureSelectionEnable = bl;
    }

    protected BOFigureListManager getBoFigureListManager() {
        return this.boFigureListManager;
    }

    @Override
    public void setFieldPatternType(FieldPattern.FieldPatternType fieldPatternType) {
        super.setFieldPatternType(fieldPatternType);
        if (fieldPatternType == FieldPattern.FieldPatternType.POINT) {
            this.setActivated(true);
        } else {
            this.clear();
            this.setActivated(false);
        }
    }

    protected FovFigure createFov(SkyCoordinates skyCoordinates) {
        FovFigure fovFigure;
        SpatialVisualParametersModel spatialVisualParametersModel;
        if (!this.isWcsSet(true)) {
            return null;
        }
        if (this.isFrequencySet() && this.getShowsFov()) {
            spatialVisualParametersModel = this.getSpatialVisualParametersModel();
            Antenna antenna = spatialVisualParametersModel.getSpatialVisualParameters().getAntenna();
            Angle angle = antenna.getBeamSize(this.getRestFrequency());
            double d = angle.getContentInUnits(Angle.UNIT_DEG) / 2.0;
            Point2D.Double double_ = new Point2D.Double(d, d);
            this.imagePanel.getImageDisplay().getCoordinateConverter().worldToScreenCoords(double_, true);
            fovFigure = this.makeFovFigure(0.0, 0.0, double_.getX(), double_.getY());
        } else {
            fovFigure = this.makeFovFigure(0.0, 0.0, 0.0, 0.0);
        }
        fovFigure.setBusinessObject((BusinessObject)skyCoordinates);
        if (this.isFigureSelectable()) {
            spatialVisualParametersModel = this.imagePanel.getImageGraphics().getDraggableSelectionInteractor();
            fovFigure.setInteractor((Interactor)spatialVisualParametersModel);
            fovFigure.addCanvasFigureListener((CanvasFigureListener)new CanvasFigureListenerAdapter((SelectionInteractor)spatialVisualParametersModel){
                final /* synthetic */ SelectionInteractor val$interactor;
                {
                    this.val$interactor = selectionInteractor;
                }

                public void figureMoved(CanvasFigureEvent canvasFigureEvent) {
                    for (Object object : this.val$interactor.getSelectionModel().getSelectionAsArray()) {
                        PointingMapper.this.getModel().updateBO((FovFigure)object);
                        PointingMapper.this.updateTPRasterScanRectangle();
                    }
                }
            });
        }
        this.imagePanel.getAlmaCanvasDraw().addFigure(fovFigure);
        return fovFigure;
    }

    protected boolean isFigureSelectable() {
        return true;
    }

    protected FovFigure makeFovFigure(double d, double d2, double d3, double d4) {
        return this.makeFovFigure(d, d2, d3, d4, 5);
    }

    protected FovFigure makeFovFigure(double d, double d2, double d3, double d4, int n) {
        FovFigure fovFigure = this.imagePanel.getMapperManager().getFieldPatternType().equals((Object)FieldPattern.FieldPatternType.POINT) ? new FovFigure(d, d2, d3, d4, n, true) : new FovFigure(d, d2, d3, d4, n, false);
        return fovFigure;
    }

    protected PointingCoordsConverter getPointingCoordsConverter() {
        return this.pointingCoordsConverter;
    }

    public void setShowPointings(boolean bl) {
        this.showPointings = bl;
    }

    private void transformTPRectangle(RoiFigure roiFigure, RectanglePatternI rectanglePatternI) {
        SkyCoordinates skyCoordinates = rectanglePatternI.getFieldCenterCoordinates();
        SkyCoordinates skyCoordinates2 = skyCoordinates.getType().equals(SkyCoordinates.TYPE_RELATIVE) ? skyCoordinates.getAbsoluteCoordinates(rectanglePatternI.getOrigin()) : skyCoordinates;
        try {
            Log.logger(PointingMapper.class).fine(String.format("Absolute coords of TP rectangle centre RA %s Dec %s", skyCoordinates2.getLongitude().toHHMMSS(), skyCoordinates2.getLatitude().toDDMMSS()));
        }
        catch (InvalidCoordException | OutOfRangeException exception) {
            // empty catch block
        }
        Point2D.Double double_ = new Point2D.Double();
        double_.setLocation(skyCoordinates2.getAbsoluteSkyPointInJ2000Deg());
        try {
            this.imagePanel.getImageDisplay().getCoordinateConverter().worldToScreenCoords(double_, false);
        }
        catch (Exception exception) {
            return;
        }
        double d = rectanglePatternI.getLongitudeLength().getContentInUnits(Angle.UNIT_ARCMIN) / 60.0;
        double d2 = rectanglePatternI.getLatitudeLength().getContentInUnits(Angle.UNIT_ARCMIN) / 60.0;
        Point2D.Double double_2 = new Point2D.Double(d, d2);
        this.imagePanel.getImageDisplay().getCoordinateConverter().worldToScreenCoords(double_2, true);
        d = double_2.getX();
        d2 = double_2.getY();
        AlmaRectangleGeometry almaRectangleGeometry = (AlmaRectangleGeometry)roiFigure.getGeometry();
        RectangularShape rectangularShape = almaRectangleGeometry.getRect();
        rectangularShape.setFrameFromCenter(double_.getX(), double_.getY(), double_.getX() + d / 2.0, double_.getY() + d2 / 2.0);
        Shape shape = (Shape)rectangularShape.clone();
        almaRectangleGeometry.setAutoRefresh(false);
        roiFigure.setShape(shape);
        double d3 = rectanglePatternI.getRotationAngle().getContentInUnits(Angle.UNIT_RAD);
        if (this.getImageFlipped()) {
            d3 += Math.toRadians(this.getImageAngle());
            d3 *= -1.0;
        } else {
            d3 -= Math.toRadians(this.getImageAngle());
        }
        almaRectangleGeometry.setAutoRefresh(true);
        almaRectangleGeometry.setRotateAngle(d3);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d3, rectangularShape.getCenterX(), rectangularShape.getCenterY());
        this.imagePanel.getImageGraphics().deselect((CanvasFigure)roiFigure);
        roiFigure.transform(affineTransform);
        this.imagePanel.getImageGraphics().select((CanvasFigure)roiFigure);
    }
}

