/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.subform;

import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.obsproject.RectangleEditor;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParametersModel;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.valuetypes.Angle;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FovParameterEditor
extends EditorWithGridBagLayout {
    public static final FieldID FID_REPFREQ = new FieldID("FovParameter.ReprFreq");
    public static final FieldID FID_FOVSIZE = new FieldID("FovParameter.FovSize");
    public static final FieldID FID_ANTENNA = new FieldID("FovParameter.Antenna");
    public static final FieldID FID_SHOWFOV = new FieldID("FovParameter.ShowFov");
    static final Map<FieldID, String> tooltips = new HashMap<FieldID, String>();
    private final ModelChangeSubscriber acaEnabledSubscriber = new ModelChangeSubscriber(){
        private final String label12m = Antenna.ANTENNA_12M.getLabel();
        private final String label7m = Antenna.ANTENNA_7M.getLabel();

        @Override
        public void modelChanged(Model model, FieldID fieldID, Object object) {
            if (RectangleEditor.ACA_ENABLED_FID.equals(fieldID) && object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                try {
                    if (!bl.booleanValue() && this.label7m.equals(FovParameterEditor.this.antennas.getSelectedItem())) {
                        FovParameterEditor.this.getController().widgetUpdated(FovParameterEditor.this, FID_ANTENNA, this.label12m);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    return;
                }
                JRadioButton jRadioButton = FovParameterEditor.this.antennas.find(this.label7m);
                if (jRadioButton != null) {
                    jRadioButton.setVisible(bl);
                }
            }
        }
    };
    private OTButtonGroup antennas;

    public ModelChangeSubscriber getAcaEnabledSubscriber() {
        return this.acaEnabledSubscriber;
    }

    public FovParameterEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    public SpatialVisualParametersModel getMyModel() {
        return (SpatialVisualParametersModel)this.getModel();
    }

    @Override
    protected void build() {
        super.build("FovParameter");
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        JTextField jTextField = null;
        jTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FID_REPFREQ, "Representative Frequency (Sky)", tooltips.get(FID_REPFREQ));
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        this.antennas = this.addOTButtonGroup((JComponent)jPanel, gridBagLayout, gridBagConstraints, FID_ANTENNA, "Antenna Diameter", tooltips.get(FID_ANTENNA), Antenna.getLabels());
        jTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FID_FOVSIZE, "Antenna Beamsize (HPBW)", tooltips.get(FID_FOVSIZE));
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        this.addBooleanComponent(jPanel, gridBagLayout, gridBagConstraints, FID_SHOWFOV, "Show Antenna Beamsize", tooltips.get(FID_SHOWFOV));
        this.constraints.weightx = 1.0;
        this.addGroup(jPanel, "FOV Parameters");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FID_ANTENNA) {
            Antenna antenna = (Antenna)((Object)object);
            super.update(fieldID, antenna.getLabel());
            return;
        }
        if (fieldID == SfiControlParameterModel.FID_STANDALONE_ACA) {
            Boolean bl = (Boolean)object;
            if (bl.booleanValue()) {
                super.update(FID_ANTENNA, Antenna.ANTENNA_7M.getLabel());
                this.getMyModel().update(this, FID_ANTENNA, Antenna.ANTENNA_7M.getLabel());
                this.antennas.setEnabled(false);
            } else {
                this.antennas.setEnabled(true);
            }
            return;
        }
        if (fieldID == FID_FOVSIZE) {
            Angle angle = (Angle)((Object)object);
            super.update(fieldID, Antenna.formatBeamSize(angle));
            return;
        }
        super.update(fieldID, object);
    }

    static {
        tooltips.put(FID_REPFREQ, "<html>Representative (sky) frequency as determined from spectral setup.<br>Used when considering performance parameters, particularly integration time</html>");
        tooltips.put(FID_FOVSIZE, "<html>The size of the antenna beamsize : " + Antenna.BEAMSIZE_TIP_STRING + "</html>");
        tooltips.put(FID_ANTENNA, "Antenna Diameter");
        tooltips.put(FID_SHOWFOV, "If checked, circles representing FOV are displayed on the image.");
    }
}

