/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.subform;

import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.spatialvisual.SkycatServers;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParametersModel;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ImageQueryEditor
extends EditorWithGridBagLayout {
    public static final FieldID FID_IMAGE_SERVER = new FieldID("ImageQuery.ImageServer");
    public static final FieldID FID_IMAGE_SIZE = new FieldID("ImageQuery.ImageSize");
    public static final FieldID FID_QUERY_BUTTON = new FieldID("ImageQuery.QueryBtn");
    private AlmaNavigatorImageDisplayPanel imagePanel = null;

    public ImageQueryEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public SpatialVisualParametersModel getModel() {
        return (SpatialVisualParametersModel)super.getModel();
    }

    public void setImagePanel(AlmaNavigatorImageDisplayPanel almaNavigatorImageDisplayPanel) {
        this.imagePanel = almaNavigatorImageDisplayPanel;
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        String[] stringArray = SkycatServers.getImageServerArray();
        JLabel jLabel = new JLabel("Image Server");
        jLabel.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        JComboBox jComboBox = this.addComboBox((JComponent)jPanel, gridBagLayout, gridBagConstraints, FID_IMAGE_SERVER, jLabel, "Image server to Query", stringArray);
        jComboBox.setSelectedIndex(this.getDefaultImageServerIndex(stringArray));
        jComboBox.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        JLabel jLabel2 = this.makeLabel("Image Size(arcmin)");
        componentCollection.remember(jLabel2);
        JComponent[] jComponentArray = new JComponent[1];
        JTextField jTextField = this.makeTextField(FID_IMAGE_SIZE, "Width and height of the image");
        jComponentArray[0] = jTextField;
        componentCollection.remember(jComponentArray);
        jTextField.setColumns(5);
        jTextField.setText("10");
        jTextField.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        jLabel2.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        JButton jButton = this.makeButton(FID_QUERY_BUTTON, "Query", "Query an image");
        jButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        componentCollection.remember(jButton);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.constraints.weightx = 1.0;
        this.addGroup(jPanel, "Image Query");
    }

    @Override
    protected void build() {
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        this.constraints.anchor = 17;
        this.constraints.fill = 2;
        this.constraints.gridy = 0;
        this.constraints.insets = new Insets(4, 4, 4, 4);
        this.addComponents("ImageQuery");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FID_QUERY_BUTTON) {
            this.imagePanel.imageQuery(this.getModel().getSpatialVisualParameters());
            return;
        }
        super.update(fieldID, object);
    }

    private int getDefaultImageServerIndex(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("Digitized Sky (Version II) at ESO")) continue;
            return i;
        }
        return 0;
    }
}

