/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spectralvisual;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.BaseBandHolder;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowPair;
import alma.obsprep.ot.editors.spectralvisual.SpectralRangeRepresentation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BBCLevelManager {
    private BaseBandHolder correlator = null;
    private Map<IBusinessObject, Collection<SpectralRangeRepresentation>> ranges = null;
    private Map<BusinessObject, Integer> levels = null;
    private Map<BusinessObject, Integer> depths = null;
    private boolean isBBFolded = false;
    private boolean isSWFolded = false;
    private int bbcDepth = 2;
    private int minSWLevels = 4;

    private BBCLevelManager() {
    }

    public BBCLevelManager(BaseBandHolder baseBandHolder, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map, boolean bl, boolean bl2) {
        this();
        this.correlator = baseBandHolder;
        this.ranges = map;
        this.isBBFolded = bl;
        this.isSWFolded = bl2;
        this.recalc();
    }

    public BBCLevelManager(BaseBandHolder baseBandHolder, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map, boolean bl, boolean bl2, int n) {
        this();
        this.correlator = baseBandHolder;
        this.ranges = map;
        this.isBBFolded = bl;
        this.isSWFolded = bl2;
        this.bbcDepth = n;
        this.recalc();
    }

    private Map<AbstractSpectralWindow, Integer> calculateUnfoldedSWLevels(BaseBand baseBand) {
        HashMap<AbstractSpectralWindow, Integer> hashMap = new HashMap<AbstractSpectralWindow, Integer>();
        for (int i = 0; i < baseBand.getSingleSpectralWindowCount(); ++i) {
            hashMap.put(baseBand.getSingleSpectralWindow(i), i);
        }
        return hashMap;
    }

    private Map<AbstractSpectralWindow, Integer> calculateFoldedSWLevels(BaseBand baseBand) {
        Object object;
        Vector<Collection<Range>> vector = new Vector<Collection<Range>>();
        for (int i = 0; i < baseBand.getSpectralWindowCount(); ++i) {
            object = baseBand.getSpectralWindow(i);
            if (object.isPair()) {
                this.assignSWLevel(vector, object.getUSB());
                this.assignSWLevel(vector, object.getLSB());
                continue;
            }
            this.assignSWLevel(vector, (SpectralWindowI)object);
        }
        List<Integer> list = Range.partitionCollections(vector);
        object = new HashMap();
        for (int i = 0; i < baseBand.getSpectralWindowCount(); ++i) {
            SpectralWindowI spectralWindowI = baseBand.getSpectralWindow(i);
            if (spectralWindowI.isPair()) {
                SpectralWindowPair spectralWindowPair = (SpectralWindowPair)spectralWindowI;
                object.put(spectralWindowPair.getLSB(), list.get(i));
                object.put(spectralWindowPair.getUSB(), list.get(i));
                continue;
            }
            object.put((AbstractSpectralWindow)spectralWindowI, list.get(i));
        }
        return object;
    }

    private void assignSWLevel(List<Collection<Range>> list, SpectralWindowI spectralWindowI) {
        Collection<SpectralRangeRepresentation> collection = this.ranges.get(spectralWindowI);
        HashSet<Range> hashSet = new HashSet<Range>();
        try {
            for (SpectralRangeRepresentation spectralRangeRepresentation : collection) {
                hashSet.add(spectralRangeRepresentation.getFrequenciesGHz());
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(System.out);
        }
        list.add(hashSet);
    }

    private Map<BaseBand, Integer> calculateUnfoldedBBLevels(BaseBandHolder baseBandHolder) {
        HashMap<BaseBand, Integer> hashMap = new HashMap<BaseBand, Integer>();
        for (int i = 0; i < baseBandHolder.getBaseBandCount(); ++i) {
            hashMap.put(baseBandHolder.getBaseBand(i), i);
        }
        return hashMap;
    }

    private Map<BaseBand, Integer> calculateFoldedBBLevels(BaseBandHolder baseBandHolder) {
        Object object;
        Object object2;
        Vector<Collection<Range>> vector = new Vector<Collection<Range>>();
        for (int i = 0; i < baseBandHolder.getBaseBandCount(); ++i) {
            object2 = baseBandHolder.getBaseBand(i);
            Collection<SpectralRangeRepresentation> collection = this.ranges.get(object2);
            object = new HashSet();
            for (SpectralRangeRepresentation spectralRangeRepresentation : collection) {
                object.add(spectralRangeRepresentation.getFrequenciesGHz());
            }
            vector.add((Collection<Range>)object);
        }
        List<Integer> list = Range.partitionCollections(vector);
        object2 = new HashMap();
        for (int i = 0; i < baseBandHolder.getBaseBandCount(); ++i) {
            object = baseBandHolder.getBaseBand(i);
            object2.put(object, list.get(i));
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    public void recalc() {
        void var6_16;
        int n;
        void var6_14;
        Map<BaseBand, Integer> map = this.isFoldBB() ? this.calculateFoldedBBLevels(this.correlator) : this.calculateUnfoldedBBLevels(this.correlator);
        HashMap<BaseBand, Map<AbstractSpectralWindow, Integer>> hashMap = new HashMap<BaseBand, Map<AbstractSpectralWindow, Integer>>();
        if (this.isFoldSW()) {
            for (BaseBand baseBand : this.correlator.getBaseBand()) {
                hashMap.put(baseBand, this.calculateFoldedSWLevels(baseBand));
            }
        } else {
            for (BaseBand n2 : this.correlator.getBaseBand()) {
                hashMap.put(n2, this.calculateUnfoldedSWLevels(n2));
            }
        }
        int n2 = -1;
        BaseBand[] baseBandArray = this.correlator.getBaseBand();
        int n3 = baseBandArray.length;
        boolean bl = false;
        while (var6_14 < n3) {
            BaseBand baseBand = baseBandArray[var6_14];
            n = map.get(baseBand);
            if (n > n2) {
                n2 = n;
            }
            ++var6_14;
        }
        int n5 = n2 + 1;
        int[] nArray = new int[n5];
        boolean bl2 = false;
        while (var6_16 < n5) {
            nArray[var6_16] = this.minSWLevels;
            ++var6_16;
        }
        BaseBand[] baseBandArray2 = this.correlator.getBaseBand();
        int n4 = baseBandArray2.length;
        for (n = 0; n < n4; ++n) {
            BaseBand baseBand = baseBandArray2[n];
            int n6 = map.get(baseBand);
            Map map2 = (Map)hashMap.get(baseBand);
            for (AbstractSpectralWindow abstractSpectralWindow : baseBand.getSingleSpectralWindow()) {
                int n7 = (Integer)map2.get(abstractSpectralWindow);
                if (n7 <= nArray[n6]) continue;
                nArray[n6] = n7;
            }
        }
        int[] nArray2 = new int[n5 + 1];
        nArray2[0] = 0;
        for (n4 = 1; n4 <= n5; ++n4) {
            nArray2[n4] = nArray2[n4 - 1] + nArray[n4 - 1] + this.getBBCDepth() + 1;
        }
        this.levels = new HashMap<BusinessObject, Integer>();
        this.depths = new HashMap<BusinessObject, Integer>();
        for (BaseBand baseBand : this.correlator.getBaseBand()) {
            int n8 = nArray2[map.get(baseBand)];
            this.levels.put((BusinessObject)baseBand, n8);
            this.depths.put((BusinessObject)baseBand, this.getBBCDepth());
            for (SpectralRangeRepresentation spectralRangeRepresentation : this.ranges.get(baseBand)) {
                spectralRangeRepresentation.setLevel(n8);
                spectralRangeRepresentation.setDepth(this.getBBCDepth());
            }
            Map map3 = (Map)hashMap.get(baseBand);
            for (AbstractSpectralWindow abstractSpectralWindow : baseBand.getSingleSpectralWindow()) {
                int n9 = n8 + (Integer)map3.get(abstractSpectralWindow) + this.getBBCDepth();
                this.levels.put((BusinessObject)abstractSpectralWindow, n9);
                this.depths.put((BusinessObject)abstractSpectralWindow, this.getSWDepth());
                for (SpectralRangeRepresentation spectralRangeRepresentation : this.ranges.get(abstractSpectralWindow)) {
                    spectralRangeRepresentation.setLevel(n9);
                    spectralRangeRepresentation.setDepth(this.getSWDepth());
                }
                for (ChannelAverageRegion channelAverageRegion : abstractSpectralWindow.getChannelAverageRegion()) {
                    this.levels.put((BusinessObject)channelAverageRegion, n9);
                    this.depths.put((BusinessObject)channelAverageRegion, this.getSWDepth());
                    for (SpectralRangeRepresentation spectralRangeRepresentation : this.ranges.get(channelAverageRegion)) {
                        spectralRangeRepresentation.setLevel(n9);
                        spectralRangeRepresentation.setDepth(this.getSWDepth());
                    }
                }
            }
        }
        this.levels.put((BusinessObject)this.correlator, Math.max(nArray2[n5], SpectralSpec.maxBaseBandCount() * (this.getBBCDepth() + this.getMinSWLevels())));
    }

    private boolean isFoldBB() {
        return this.isBBFolded;
    }

    private boolean isFoldSW() {
        return this.isSWFolded;
    }

    public void setBBCDepth(int n) {
        this.bbcDepth = n;
        this.recalc();
    }

    public int getBBCDepth() {
        return this.bbcDepth;
    }

    public int getSWDepth() {
        return 1;
    }

    public void setMinSWLevels(int n) {
        this.minSWLevels = n;
        this.recalc();
    }

    private int getMinSWLevels() {
        return this.minSWLevels;
    }

    public int levelFor(BusinessObject businessObject) {
        if (this.levels.containsKey(businessObject)) {
            return this.levels.get(businessObject);
        }
        return -1;
    }

    public int depthFor(BusinessObject businessObject) {
        if (this.depths.containsKey(businessObject)) {
            return this.depths.get(businessObject);
        }
        return 1;
    }

    public int numLevels() {
        return this.levelFor((BusinessObject)this.correlator);
    }
}

