/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spectralvisual;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.BaseBandHolder;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.boEditors.PanelUtilities;
import alma.obsprep.ot.editors.spectralvisual.BBCLevelManager;
import alma.obsprep.ot.editors.spectralvisual.ObservedAndTargetPanel;
import alma.obsprep.ot.editors.spectralvisual.SpectralRangeRepresentation;
import alma.obsprep.ot.gui.dnd.DNDDescriptor;
import alma.obsprep.ot.gui.dnd.MousePoint;
import alma.obsprep.ot.gui.resources.ColorPalette;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MultipleBBCPanel
extends ObservedAndTargetPanel {
    private static final int BasebandDepth = 3;
    private final double SW_OFFSET_GHZ = 2.0;
    private int selectedBBC;
    private boolean trackSelection;
    private boolean foldBasebands;
    private boolean foldSpectralWindows;
    private boolean drawReceiverBand;
    private boolean drawSideBand;
    private boolean aca;

    public MultipleBBCPanel(ColorPalette colorPalette, double d, double d2) {
        super(d, d2);
        this.palette = colorPalette;
        this.helper = new PanelUtilities(this);
        this.setDrawOtherLines(false);
        this.setDrawTransmission(true);
        this.setInitialFrequencyRange();
        this.setTrackBasebandSelection(false);
        this.setFoldBasebands(false);
        this.setFoldSpectralWindows(false);
        this.setDrawReceiverBand(true);
    }

    protected void paintReceiverBand(Graphics graphics, SpectralSpec spectralSpec) {
        ReceiverBand receiverBand = spectralSpec.getReceiverBand();
        int n = this.scaleOF(receiverBand.getRFMin());
        int n2 = this.scaleOF(receiverBand.getRFMax());
        if (n2 <= 0 || n >= this.getWidth()) {
            return;
        }
        int n3 = this.scaleOF(receiverBand.getLOMin());
        int n4 = this.scaleOF(receiverBand.getLOMax());
        int n5 = (n + n2) / 2;
        n = this.clipXToVisible(n);
        n3 = this.clipXToVisible(n3);
        n4 = this.clipXToVisible(n4);
        n2 = this.clipXToVisible(n2);
        graphics.setColor(this.palette.getRestFrequencyColor());
        graphics.drawRect(n, this.yObservedAxis(), n2 - n, this.yRxBandHeight());
        this.helper.hatch(graphics, n, this.yObservedAxis(), n2 - n, this.yRxBandHeight(), true);
    }

    private void paintBackground(Graphics graphics) {
        this.textHeight = this.helper.calculateTextHeight(graphics);
        this.paintSkyAxis(graphics);
        this.paintRestAxis(graphics);
        if (this.getDrawOtherLines()) {
            // empty if block
        }
        if (this.getDrawTransmission()) {
            // empty if block
        }
    }

    private void paintSideBands(Graphics graphics, SpectralSpec spectralSpec) {
        Range range;
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(spectralSpec.getFrequencySetup().getReceiverBand());
        double d = spectralSpec.getLO1Frequency().getContentInGHz();
        Color color = Colors.transparentColor(this.palette.getSidebandsColor());
        if (receiverBand.hasLower()) {
            range = new Range(d - receiverBand.getIFMax(), d - receiverBand.getIFMin());
            this.paintSideBand(graphics, range, color, false);
        }
        if (receiverBand.hasUpper()) {
            range = new Range(d + receiverBand.getIFMin(), d + receiverBand.getIFMax());
            this.paintSideBand(graphics, range, color, false);
        }
        this.paintObservedSpectralLine(graphics, d, "LO1", this.palette.getSidebandsColor(), 1, false);
    }

    private void paintSimpleChannelAverageRegion(Graphics graphics, double d, double d2, int n, int n2, String string, Color color) {
        int n3 = this.scaleOF(d);
        int n4 = this.scaleOF(d2);
        if (n4 <= 0 || n3 >= this.getWidth()) {
            return;
        }
        n3 = this.clipXToVisible(n3);
        n4 = this.clipXToVisible(n4);
        graphics.setColor(Colors.transparentColor(color, 150));
        graphics.fillRect(n3, n + 1, n4 - n3, n2 - 2);
    }

    private void paintSimpleBaseband(Graphics graphics, double d, double d2, int n, int n2, String string, Color color) {
        int n3 = this.scaleOF(d);
        int n4 = this.scaleOF(d2);
        if (n4 <= 0 || n3 >= this.getWidth()) {
            return;
        }
        int n5 = (n3 + n4) / 2;
        int n6 = n3;
        int n7 = n2 / 3;
        n3 = this.clipXToVisible(n3);
        n4 = this.clipXToVisible(n4);
        graphics.setColor(color);
        graphics.drawRect(n3, n, n4 - n3, n2);
        graphics.fillRect(n3, n, n4 - n3, 2 * n7);
        if (string != null) {
            graphics.setColor(COLOUR_BANDLABEL);
            Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
            int n8 = (int)((float)(n + n7) + float_.height / 2.0f);
            graphics.drawString(string, (int)((float)n5 - float_.width / 2.0f), n8);
        }
    }

    private void paintSimpleSpectralWindow(Graphics graphics, double d, double d2, int n, int n2, int n3, int n4, String string, Color color) {
        int n5 = this.scaleOF(d);
        int n6 = this.scaleOF(d2);
        if (n6 <= 0 || n5 >= this.getWidth()) {
            return;
        }
        n5 = this.clipXToVisible(n5);
        n6 = this.clipXToVisible(n6);
        graphics.setColor(color);
        this.helper.bigH(graphics, n5, n, n6 - n5, n2);
        graphics.setColor(Colors.transparentColor(color, 63));
        graphics.fillRect(n5, n3, n6 - n5, n4);
    }

    protected void paintSRRSpectralWindow(Graphics graphics, Collection<SpectralRangeRepresentation> collection, BBCLevelManager bBCLevelManager) {
        if (collection == null) {
            boolean bl = true;
            return;
        }
        for (SpectralRangeRepresentation spectralRangeRepresentation : collection) {
            Color color;
            switch (spectralRangeRepresentation.getType()) {
                case Primary: {
                    color = this.palette.getSpectralWindowColor();
                    break;
                }
                case Secondary: {
                    color = this.palette.getSpectralWindowColor().darker();
                    break;
                }
                case Suppressed: {
                    color = this.palette.getSuppressedColor();
                    break;
                }
                default: {
                    Log.logger((Object)this).warning(String.format("Unexpected SRR type (%s) in redraw - using orange", new Object[]{spectralRangeRepresentation.getType()}));
                    color = Color.ORANGE;
                }
            }
            if (spectralRangeRepresentation.isError()) {
                color = this.palette.getErrorColor();
            }
            if (spectralRangeRepresentation.isHighlight()) {
                color = color.brighter();
            }
            int n = this.yDepth(bBCLevelManager, spectralRangeRepresentation.getParent().getDepth());
            int n2 = n / 3;
            int n3 = this.yHeight(bBCLevelManager, spectralRangeRepresentation.getParent().getLevel());
            int n4 = this.yHeight(bBCLevelManager, spectralRangeRepresentation.getLevel());
            int n5 = this.yDepth(bBCLevelManager, spectralRangeRepresentation.getDepth());
            this.paintSimpleSpectralWindow(graphics, spectralRangeRepresentation.getMinFrequencyGHz(), spectralRangeRepresentation.getMaxFrequencyGHz(), n4, n5, n3 + n - n2, n2, spectralRangeRepresentation.getLabel(), color);
            for (SpectralRangeRepresentation spectralRangeRepresentation2 : spectralRangeRepresentation.getChildren()) {
                color = this.palette.getAveragingRegionColor();
                if (spectralRangeRepresentation2.isError()) {
                    color = this.palette.getErrorColor();
                }
                if (spectralRangeRepresentation2.isHighlight()) {
                    color = color.brighter();
                }
                this.paintSimpleChannelAverageRegion(graphics, spectralRangeRepresentation2.getMinFrequencyGHz(), spectralRangeRepresentation2.getMaxFrequencyGHz(), n4, n5, spectralRangeRepresentation2.getLabel(), color);
            }
        }
    }

    protected void paintSRRBaseband(Graphics graphics, Collection<SpectralRangeRepresentation> collection, BBCLevelManager bBCLevelManager) {
        if (collection == null) {
            boolean bl = true;
            return;
        }
        for (SpectralRangeRepresentation spectralRangeRepresentation : collection) {
            Color color;
            switch (spectralRangeRepresentation.getType()) {
                case Primary: {
                    color = this.palette.getBasebandColor();
                    break;
                }
                case Secondary: {
                    color = this.palette.getBasebandColor().darker();
                    break;
                }
                default: {
                    Log.logger((Object)this).warning(String.format("Unexpected SRR type (%s) in redraw - using orange", new Object[]{spectralRangeRepresentation.getType()}));
                    color = Color.ORANGE;
                }
            }
            if (spectralRangeRepresentation.isError()) {
                color = this.palette.getErrorColor();
            }
            if (spectralRangeRepresentation.isHighlight()) {
                color = color.brighter();
            }
            this.paintSimpleBaseband(graphics, spectralRangeRepresentation.getMinFrequencyGHz(), spectralRangeRepresentation.getMaxFrequencyGHz(), this.yHeight(bBCLevelManager, spectralRangeRepresentation.getLevel()), this.yDepth(bBCLevelManager, spectralRangeRepresentation.getDepth()), spectralRangeRepresentation.getLabel(), color);
        }
    }

    private void labelSection(Graphics graphics, int n, int n2, String string, int n3) {
        Rectangle2D.Float float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
        if (float_.width >= (float)(n2 - n)) {
            string = string.substring(0, 3) + ".";
            float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
        }
        if (float_.width >= (float)(n2 - n)) {
            string = string.substring(0, 1);
            float_ = (Rectangle2D.Float)graphics.getFontMetrics().getStringBounds(string, graphics);
        }
        if (float_.width < (float)(n2 - n)) {
            graphics.drawString(string, n, n3);
        }
    }

    protected void paintBasebands(Graphics graphics, SpectralSpec spectralSpec, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map, BBCLevelManager bBCLevelManager) {
        BaseBandHolder baseBandHolder = spectralSpec.getBaseBandHolder();
        for (BaseBand baseBand : baseBandHolder.getBaseBand()) {
            this.paintSRRBaseband(graphics, map.get(baseBand), bBCLevelManager);
            for (AbstractSpectralWindow abstractSpectralWindow : baseBand.getSingleSpectralWindow()) {
                this.paintSRRSpectralWindow(graphics, map.get(abstractSpectralWindow), bBCLevelManager);
            }
        }
    }

    public void paintNoSpectralSpec(Graphics graphics) {
        this.paintBackground(graphics);
    }

    private void addRanges(BaseBand baseBand, String string, Frequency frequency, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        SideBandUse sideBandUse;
        double d = baseBand.getCenterFrequencySky().getContentInGHz();
        SideBandUse sideBandUse2 = sideBandUse = d < frequency.getContentInGHz() ? SideBandUse.SIDEBANDUSE_LSB : SideBandUse.SIDEBANDUSE_USB;
        if (string.equals(SpectralSpec.RECEIVERTYPE_SSB) || string.equals(SpectralSpec.RECEIVERTYPE_TSB)) {
            this.addSingleSidebandRanges(baseBand, sideBandUse, map);
        } else if (string.equals(SpectralSpec.RECEIVERTYPE_DSB)) {
            if (baseBand.getBaseBandConfig() == null) {
                SpectralRangeRepresentation.DSBType dSBType = SpectralRangeRepresentation.DSBType.Both;
            } else {
                AbstractBaseBandConfig abstractBaseBandConfig = baseBand.getBaseBandConfig();
                if (abstractBaseBandConfig.getDataProducts().equals(AbstractBaseBandConfig.DATAPRODUCTS_AUTO_ONLY)) {
                    this.addBothSidebandRanges(abstractBaseBandConfig, sideBandUse, frequency, map);
                } else {
                    SpectralRangeRepresentation.DSBType dSBType = abstractBaseBandConfig.isRejectionMode() ? SpectralRangeRepresentation.DSBType.Rejection : SpectralRangeRepresentation.DSBType.Separation;
                    this.addMultipleSidebandRanges(abstractBaseBandConfig, sideBandUse, frequency, dSBType, map);
                }
            }
        } else if (string.equals(SpectralSpec.RECEIVERTYPE_NOSB)) {
            Log.logger((Object)this).warning(String.format("unsupported receiver type %s (ignoring baseband config %s in redraw)", string, baseBand.getBaseBandName()));
        } else {
            Log.logger((Object)this).warning(String.format("unknown receiver type %s (ignoring baseband config %s in redraw)", string, baseBand.getBaseBandName()));
        }
    }

    private SpectralRangeRepresentation addCARtoSW(SpectralRangeRepresentation spectralRangeRepresentation, double d, double d2, ChannelAverageRegion channelAverageRegion, SideBandUse sideBandUse, double d3, SpectralRangeRepresentation.RangeType rangeType, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        double d4;
        double d5;
        switch (sideBandUse) {
            case SIDEBANDUSE_LSB: {
                d5 = d2 - (double)channelAverageRegion.getStartChannel() * d3;
                d4 = d5 - (double)channelAverageRegion.getNumberChannels() * d3;
                break;
            }
            case SIDEBANDUSE_USB: {
                d4 = d + (double)channelAverageRegion.getStartChannel() * d3;
                d5 = d4 + (double)channelAverageRegion.getNumberChannels() * d3;
                break;
            }
            default: {
                Log.logger((Object)this).warning(String.format("unexpected sideband use %s (ignoring averaging region %s in redraw)", new Object[]{sideBandUse, channelAverageRegion}));
                return null;
            }
        }
        SpectralRangeRepresentation spectralRangeRepresentation2 = new SpectralRangeRepresentation(d4, d5, sideBandUse, rangeType);
        Collection<SpectralRangeRepresentation> collection = map.get(channelAverageRegion);
        map.get(channelAverageRegion).add(spectralRangeRepresentation2);
        spectralRangeRepresentation2.setParent(spectralRangeRepresentation);
        return spectralRangeRepresentation2;
    }

    private SpectralRangeRepresentation addSWtoBBC(SpectralRangeRepresentation spectralRangeRepresentation, AbstractSpectralWindow abstractSpectralWindow, SideBandUse sideBandUse, SpectralRangeRepresentation.RangeType rangeType, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        double d = abstractSpectralWindow.getCenterFrequency().getContentInGHz() - 2.0;
        double d2 = abstractSpectralWindow.getEffectiveBandwidth().getContentInGHz();
        double d3 = abstractSpectralWindow.getNominalBandwidth().getContentInGHz();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        switch (sideBandUse) {
            case SIDEBANDUSE_LSB: {
                d5 = spectralRangeRepresentation.getMaxFrequencyGHz() - d + d2 / 2.0;
                d4 = d5 - d2;
                d7 = spectralRangeRepresentation.getMaxFrequencyGHz() - d + d3 / 2.0;
                d6 = d7 - d3;
                break;
            }
            case SIDEBANDUSE_USB: {
                d5 = spectralRangeRepresentation.getMinFrequencyGHz() + d + d2 / 2.0;
                d4 = d5 - d2;
                d7 = spectralRangeRepresentation.getMinFrequencyGHz() + d + d3 / 2.0;
                d6 = d7 - d3;
                break;
            }
            default: {
                Log.logger((Object)this).warning(String.format("unexpected sideband use %s (ignoring spectral window %s in redraw)", new Object[]{sideBandUse, abstractSpectralWindow.getSpectralWindowName()}));
                return null;
            }
        }
        SpectralRangeRepresentation spectralRangeRepresentation2 = new SpectralRangeRepresentation(d4, d5, sideBandUse, rangeType);
        map.get(abstractSpectralWindow).add(spectralRangeRepresentation2);
        spectralRangeRepresentation2.setParent(spectralRangeRepresentation);
        double d8 = d2 / (double)abstractSpectralWindow.getEffectiveNumberOfChannels();
        for (ChannelAverageRegion channelAverageRegion : abstractSpectralWindow.getChannelAverageRegion()) {
            SpectralRangeRepresentation spectralRangeRepresentation3 = this.addCARtoSW(spectralRangeRepresentation2, d4, d5, channelAverageRegion, sideBandUse, d8, rangeType, map);
        }
        return spectralRangeRepresentation2;
    }

    private void addSingleSidebandRanges(BaseBand baseBand, SideBandUse sideBandUse, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        double d = baseBand.getCenterFrequencySky().getContentInGHz();
        double d2 = baseBand.getBandwidth().getContentInGHz() / 2.0;
        double d3 = d - d2;
        double d4 = d + d2;
        SpectralRangeRepresentation spectralRangeRepresentation = new SpectralRangeRepresentation(d3, d4, sideBandUse, SpectralRangeRepresentation.RangeType.Primary);
        spectralRangeRepresentation.setHighlight(baseBand.getBaseBandIndex() == this.getSelectedBBC());
        spectralRangeRepresentation.setLabel(String.format("%s(%s)", baseBand.getBaseBandName(), sideBandUse == SideBandUse.SIDEBANDUSE_USB ? "U" : "L"));
        spectralRangeRepresentation.setDepth(3);
        map.get(baseBand).add(spectralRangeRepresentation);
        for (AbstractSpectralWindow abstractSpectralWindow : baseBand.getSingleSpectralWindow()) {
            this.addSWtoBBC(spectralRangeRepresentation, abstractSpectralWindow, sideBandUse, SpectralRangeRepresentation.RangeType.Primary, map);
        }
    }

    private void addBothSidebandRanges(BaseBand baseBand, SideBandUse sideBandUse, Frequency frequency, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        SpectralRangeRepresentation.RangeType rangeType;
        SpectralRangeRepresentation.RangeType rangeType2;
        SpectralRangeRepresentation spectralRangeRepresentation;
        SpectralRangeRepresentation spectralRangeRepresentation2;
        double d = baseBand.getCenterFrequencySky().getContentInGHz();
        double d2 = baseBand.getBandwidth().getContentInGHz() / 2.0;
        double d3 = d - d2;
        double d4 = d + d2;
        SpectralRangeRepresentation spectralRangeRepresentation3 = new SpectralRangeRepresentation(d3, d4, sideBandUse, SpectralRangeRepresentation.RangeType.Primary);
        double d5 = ((Frequency)((Frequency)frequency.multiply(2.0)).minus((AbstractDoubleWithUnit)baseBand.getCenterFrequencySky())).getContentInGHz();
        SpectralRangeRepresentation spectralRangeRepresentation4 = new SpectralRangeRepresentation(d5 - d2, d5 + d2, sideBandUse.switchSideBand(), SpectralRangeRepresentation.RangeType.Secondary);
        spectralRangeRepresentation3.setMirror(spectralRangeRepresentation4);
        spectralRangeRepresentation3.setHighlight(baseBand.getBaseBandIndex() == this.getSelectedBBC());
        spectralRangeRepresentation4.setHighlight(baseBand.getBaseBandIndex() == this.getSelectedBBC());
        spectralRangeRepresentation3.setDepth(3);
        spectralRangeRepresentation4.setDepth(3);
        map.get(baseBand).add(spectralRangeRepresentation3);
        map.get(baseBand).add(spectralRangeRepresentation4);
        switch (sideBandUse) {
            case SIDEBANDUSE_LSB: {
                spectralRangeRepresentation2 = spectralRangeRepresentation3;
                spectralRangeRepresentation = spectralRangeRepresentation4;
                rangeType2 = SpectralRangeRepresentation.RangeType.Primary;
                rangeType = SpectralRangeRepresentation.RangeType.Secondary;
                break;
            }
            case SIDEBANDUSE_USB: {
                spectralRangeRepresentation2 = spectralRangeRepresentation4;
                spectralRangeRepresentation = spectralRangeRepresentation3;
                rangeType2 = SpectralRangeRepresentation.RangeType.Secondary;
                rangeType = SpectralRangeRepresentation.RangeType.Primary;
                break;
            }
            default: {
                Log.logger((Object)this).warning(String.format("Unexpected sideband use (%s) in baseband %s", new Object[]{sideBandUse, baseBand.getBaseBandName()}));
                return;
            }
        }
        spectralRangeRepresentation2.setLabel(String.format("%s(L)", baseBand.getBaseBandName()));
        spectralRangeRepresentation.setLabel(String.format("%s(U)", baseBand.getBaseBandName()));
        for (SpectralWindowI spectralWindowI : baseBand.getSpectralWindow()) {
            SpectralRangeRepresentation spectralRangeRepresentation5 = null;
            SpectralRangeRepresentation spectralRangeRepresentation6 = null;
            spectralRangeRepresentation5 = this.addSWtoBBC(spectralRangeRepresentation2, spectralWindowI.getLSB(), SideBandUse.SIDEBANDUSE_LSB, rangeType2, map);
            spectralRangeRepresentation6 = this.addSWtoBBC(spectralRangeRepresentation, spectralWindowI.getUSB(), SideBandUse.SIDEBANDUSE_USB, rangeType, map);
            if (spectralRangeRepresentation5 == null || spectralRangeRepresentation6 == null) continue;
            spectralRangeRepresentation5.setMirror(spectralRangeRepresentation6);
        }
    }

    private void addMultipleSidebandRanges(BaseBand baseBand, SideBandUse sideBandUse, Frequency frequency, SpectralRangeRepresentation.DSBType dSBType, Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map) {
        SpectralRangeRepresentation.RangeType rangeType;
        SpectralRangeRepresentation.RangeType rangeType2;
        SpectralRangeRepresentation spectralRangeRepresentation;
        SpectralRangeRepresentation spectralRangeRepresentation2;
        double d = baseBand.getCenterFrequencySky().getContentInGHz();
        double d2 = baseBand.getBandwidth().getContentInGHz() / 2.0;
        double d3 = d - d2;
        double d4 = d + d2;
        SpectralRangeRepresentation spectralRangeRepresentation3 = new SpectralRangeRepresentation(d3, d4, sideBandUse, SpectralRangeRepresentation.RangeType.Primary);
        double d5 = ((Frequency)((Frequency)frequency.multiply(2.0)).minus((AbstractDoubleWithUnit)baseBand.getCenterFrequencySky())).getContentInGHz();
        SpectralRangeRepresentation spectralRangeRepresentation4 = new SpectralRangeRepresentation(d5 - d2, d5 + d2, sideBandUse.switchSideBand(), SpectralRangeRepresentation.RangeType.Secondary);
        spectralRangeRepresentation3.setMirror(spectralRangeRepresentation4);
        spectralRangeRepresentation3.setHighlight(baseBand.getBaseBandIndex() == this.getSelectedBBC());
        spectralRangeRepresentation4.setHighlight(baseBand.getBaseBandIndex() == this.getSelectedBBC());
        spectralRangeRepresentation3.setDepth(3);
        spectralRangeRepresentation4.setDepth(3);
        map.get(baseBand).add(spectralRangeRepresentation3);
        map.get(baseBand).add(spectralRangeRepresentation4);
        switch (sideBandUse) {
            case SIDEBANDUSE_LSB: {
                spectralRangeRepresentation2 = spectralRangeRepresentation3;
                spectralRangeRepresentation = spectralRangeRepresentation4;
                rangeType2 = SpectralRangeRepresentation.RangeType.Primary;
                rangeType = SpectralRangeRepresentation.RangeType.Secondary;
                break;
            }
            case SIDEBANDUSE_USB: {
                spectralRangeRepresentation2 = spectralRangeRepresentation4;
                spectralRangeRepresentation = spectralRangeRepresentation3;
                rangeType2 = SpectralRangeRepresentation.RangeType.Secondary;
                rangeType = SpectralRangeRepresentation.RangeType.Primary;
                break;
            }
            default: {
                Log.logger((Object)this).warning(String.format("Unexpected sideband use (%s) in baseband %s", new Object[]{sideBandUse, baseBand.getBaseBandName()}));
                return;
            }
        }
        spectralRangeRepresentation2.setLabel(String.format("%s(L)", baseBand.getBaseBandName()));
        spectralRangeRepresentation.setLabel(String.format("%s(U)", baseBand.getBaseBandName()));
        for (SpectralWindowI spectralWindowI : baseBand.getSpectralWindow()) {
            boolean bl = true;
            boolean bl2 = true;
            if (dSBType == SpectralRangeRepresentation.DSBType.Separation) {
                switch (spectralWindowI.getSideBandUse()) {
                    case SIDEBANDUSE_BOTH: {
                        break;
                    }
                    case SIDEBANDUSE_LSB: {
                        bl2 = false;
                        break;
                    }
                    case SIDEBANDUSE_USB: {
                        bl = false;
                        break;
                    }
                    default: {
                        bl = false;
                        bl2 = false;
                        Log.logger((Object)this).warning(String.format("Unexpected SpectralWindow sideband use (%s) in baseband %s", new Object[]{spectralWindowI.getSideBandUse(), baseBand.getBaseBandName()}));
                    }
                }
            }
            SpectralRangeRepresentation spectralRangeRepresentation5 = null;
            SpectralRangeRepresentation spectralRangeRepresentation6 = null;
            spectralRangeRepresentation5 = this.addSWtoBBC(spectralRangeRepresentation2, spectralWindowI.getLSB(), SideBandUse.SIDEBANDUSE_LSB, bl ? rangeType2 : SpectralRangeRepresentation.RangeType.Suppressed, map);
            spectralRangeRepresentation6 = this.addSWtoBBC(spectralRangeRepresentation, spectralWindowI.getUSB(), SideBandUse.SIDEBANDUSE_USB, bl2 ? rangeType : SpectralRangeRepresentation.RangeType.Suppressed, map);
            if (spectralRangeRepresentation5 == null || spectralRangeRepresentation6 == null) continue;
            spectralRangeRepresentation5.setMirror(spectralRangeRepresentation6);
        }
    }

    private Map<IBusinessObject, Collection<SpectralRangeRepresentation>> buildRanges(SpectralSpec spectralSpec) {
        HashMap<IBusinessObject, Collection<SpectralRangeRepresentation>> hashMap = new HashMap<IBusinessObject, Collection<SpectralRangeRepresentation>>();
        ReceiverBand receiverBand = spectralSpec.getReceiverBand();
        String string = receiverBand.getType();
        Frequency frequency = spectralSpec.getLO1Frequency();
        for (BaseBand baseBand : spectralSpec.getBaseBandHolder().getBaseBand()) {
            hashMap.put((IBusinessObject)baseBand, new HashSet());
            for (AbstractSpectralWindow abstractSpectralWindow : baseBand.getSingleSpectralWindow()) {
                hashMap.put((IBusinessObject)abstractSpectralWindow, new HashSet());
                for (ChannelAverageRegion channelAverageRegion : abstractSpectralWindow.getChannelAverageRegion()) {
                    hashMap.put((IBusinessObject)channelAverageRegion, new HashSet());
                }
            }
            this.addRanges(baseBand, string, frequency, hashMap);
        }
        return hashMap;
    }

    private void paintSpectralSpec(Graphics graphics, SpectralSpec spectralSpec) {
        Map<IBusinessObject, Collection<SpectralRangeRepresentation>> map = this.buildRanges(spectralSpec);
        this.paintBackground(graphics);
        if (this.getDrawOtherLines()) {
            this.paintKnownSpectralLinesLines(graphics, this.minTF, this.maxTF);
        }
        BBCLevelManager bBCLevelManager = new BBCLevelManager(spectralSpec.getBaseBandHolder(), map, this.isFoldBasebands(), this.isFoldSpectralWindows(), 3);
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        formatter.format("%s@%h.paintSpectralSpec(%s @ %h)%n", this.getClass().getSimpleName(), this.hashCode(), spectralSpec.getClass().getSimpleName(), spectralSpec.hashCode());
        spectralSpec.getBaseBandHolder().format(formatter, "\t");
        stringBuilder = new StringBuilder();
        formatter = new Formatter(stringBuilder);
        formatter.format("SpectralRangeRepresentations:%n", new Object[0]);
        for (BaseBand baseBand : spectralSpec.getBaseBandHolder().getBaseBand()) {
            formatter.format("\tBBC %s (#%d)%n", baseBand.getBaseBandName(), baseBand.getBaseBandIndex() + 1);
            for (SpectralRangeRepresentation spectralRangeRepresentation : map.get(baseBand)) {
                formatter.format("\t\t@%8h %7.3f - %7.3f GHz level:%2d %3s %10s %8h%n", new Object[]{spectralRangeRepresentation.hashCode(), spectralRangeRepresentation.getMinFrequencyGHz(), spectralRangeRepresentation.getMaxFrequencyGHz(), spectralRangeRepresentation.getLevel(), spectralRangeRepresentation.getSideband(), spectralRangeRepresentation.getType(), spectralRangeRepresentation.getMirror() == null ? 0 : spectralRangeRepresentation.getMirror().hashCode()});
            }
            for (AbstractSpectralWindow abstractSpectralWindow : baseBand.getSingleSpectralWindow()) {
                formatter.format("\t\t\tSW %h%n", abstractSpectralWindow.hashCode());
                for (SpectralRangeRepresentation spectralRangeRepresentation : map.get(abstractSpectralWindow)) {
                    formatter.format("\t\t\t\t@%8h %7.3f - %7.3f GHz level:%2d %3s %10s %8h%n", new Object[]{spectralRangeRepresentation.hashCode(), spectralRangeRepresentation.getMinFrequencyGHz(), spectralRangeRepresentation.getMaxFrequencyGHz(), spectralRangeRepresentation.getLevel(), spectralRangeRepresentation.getSideband(), spectralRangeRepresentation.getType(), spectralRangeRepresentation.getMirror() == null ? 0 : spectralRangeRepresentation.getMirror().hashCode()});
                }
                for (ChannelAverageRegion channelAverageRegion : abstractSpectralWindow.getChannelAverageRegion()) {
                    formatter.format("\t\t\t\tCAR %h%n", channelAverageRegion.hashCode());
                    for (SpectralRangeRepresentation spectralRangeRepresentation : map.get(channelAverageRegion)) {
                        formatter.format("\t\t\t\t\t@%8h %7.3f - %7.3f GHz level:%2d %3s %10s %8h%n", new Object[]{spectralRangeRepresentation.hashCode(), spectralRangeRepresentation.getMinFrequencyGHz(), spectralRangeRepresentation.getMaxFrequencyGHz(), spectralRangeRepresentation.getLevel(), spectralRangeRepresentation.getSideband(), spectralRangeRepresentation.getType(), spectralRangeRepresentation.getMirror() == null ? 0 : spectralRangeRepresentation.getMirror().hashCode()});
                    }
                }
            }
        }
        formatter.close();
        if (bBCLevelManager != null) {
            this.paintBasebands(graphics, spectralSpec, map, bBCLevelManager);
        }
        if (this.isDrawSideBand()) {
            this.paintSideBands(graphics, spectralSpec);
        }
        if (this.isDrawReceiverBand()) {
            this.paintReceiverBand(graphics, spectralSpec);
        }
    }

    @Override
    public void corePaintComponent(Graphics graphics) {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec != null) {
            this.paintSpectralSpec(graphics, spectralSpec);
        } else {
            this.resetFrequencyRange();
            this.paintNoSpectralSpec(graphics);
        }
    }

    private int yBaseBandHeight() {
        return this.textHeight / 2;
    }

    @Override
    protected int yRxBandHeight() {
        return 2 * this.yBaseBandHeight();
    }

    @Override
    protected int yClearTarget() {
        return this.yTargetAxis();
    }

    @Override
    protected int yClearObserved() {
        int n = this.yObservedAxis() + this.yBaseBandHeight();
        if (this.isDrawReceiverBand()) {
            n += this.yRxBandHeight();
        }
        return n;
    }

    private int yHeight(BBCLevelManager bBCLevelManager, BusinessObject businessObject) {
        return this.yClearObserved() + this.yClearHeight() * bBCLevelManager.levelFor(businessObject) / bBCLevelManager.numLevels();
    }

    private int yHeight(BBCLevelManager bBCLevelManager, int n) {
        return this.yClearObserved() + this.yClearHeight() * n / bBCLevelManager.numLevels();
    }

    private int yDepth(BBCLevelManager bBCLevelManager, int n) {
        return this.yClearHeight() * n / bBCLevelManager.numLevels();
    }

    private int yDepth(BBCLevelManager bBCLevelManager, BusinessObject businessObject) {
        return this.yClearHeight() * bBCLevelManager.depthFor(businessObject) / bBCLevelManager.numLevels();
    }

    private int observedLabelBase() {
        return this.yObservedAxis() + this.yRxBandHeight() + this.yLOBandHeight() + this.textHeight;
    }

    @Override
    protected int observedLabelHeight(int n) {
        return this.observedLabelBase() + n * this.textHeight;
    }

    @Override
    public void abandon(DNDDescriptor dNDDescriptor) {
    }

    @Override
    public DNDDescriptor createDescriptor(MousePoint mousePoint) {
        return null;
    }

    @Override
    public void destroyDescriptor(DNDDescriptor dNDDescriptor) {
    }

    @Override
    public void drag(DNDDescriptor dNDDescriptor, MousePoint mousePoint) {
    }

    @Override
    public void drop(DNDDescriptor dNDDescriptor, MousePoint mousePoint) {
    }

    public void setTrackBasebandSelection(boolean bl) {
        this.trackSelection = bl;
    }

    public boolean isTrackBasebandSelection() {
        return this.trackSelection;
    }

    public boolean isDrawSideBand() {
        return this.drawSideBand;
    }

    public void setDrawSideBand(boolean bl) {
        this.drawSideBand = bl;
    }

    public boolean isDrawReceiverBand() {
        return this.drawReceiverBand;
    }

    public void setDrawReceiverBand(boolean bl) {
        this.drawReceiverBand = bl;
    }

    public boolean isFoldBasebands() {
        return this.foldBasebands;
    }

    public void setFoldBasebands(boolean bl) {
        this.foldBasebands = bl;
    }

    public boolean isFoldSpectralWindows() {
        return this.foldSpectralWindows;
    }

    public void setFoldSpectralWindows(boolean bl) {
        this.foldSpectralWindows = bl;
    }

    public boolean isACA() {
        return this.aca;
    }

    public boolean isBL() {
        return !this.isACA();
    }

    public void setACA(boolean bl) {
        this.aca = bl;
    }

    public int getSelectedBBC() {
        return this.selectedBBC;
    }

    public void setSelectedBBC(int n) {
        this.selectedBBC = n;
        if (this.isTrackBasebandSelection()) {
            this.zoomToSelectedBaseband();
        }
        this.repaint();
    }

    public void zoomToReceiverBand() {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec == null) {
            return;
        }
        ReceiverBand receiverBand = spectralSpec.getReceiverBand();
        this.setFrequencyRange(receiverBand.getRFMin(), receiverBand.getRFMax());
    }

    public void zoomToSelectedBaseband() {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec == null) {
            return;
        }
        int n = this.getSelectedBBC();
        if (n < 0) {
            return;
        }
        BaseBandHolder baseBandHolder = spectralSpec.getBaseBandHolder();
        if (n >= baseBandHolder.getBaseBandCount()) {
            return;
        }
        BaseBand baseBand = baseBandHolder.getBaseBand(n);
        double d = baseBand.getCenterFrequencySky().getContentInGHz();
        double d2 = baseBand.getBandwidth().getContentInGHz() / 2.0;
        this.setFrequencyRange(d - d2, d + d2);
    }

    public boolean canZoomToMirror() {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec == null) {
            return false;
        }
        double d = spectralSpec.getLO1Frequency().getContentInGHz();
        double d2 = 2.0 * d - this.maxOF;
        double d3 = 2.0 * d - this.minOF;
        return this.absoluteMinOF <= d2 && d3 <= this.absoluteMaxOF;
    }

    public void zoomToMirror() {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec == null) {
            return;
        }
        double d = spectralSpec.getLO1Frequency().getContentInGHz();
        double d2 = 2.0 * d - this.maxOF;
        double d3 = 2.0 * d - this.minOF;
        this.setFrequencyRangeNoRound(d2, d3);
    }

    @Override
    public void publish() {
    }

    @Override
    protected SpectralSpecDocument getContext() {
        SpectralSpecDocument spectralSpecDocument = null;
        if (this.model != null) {
            SpectralSpecModel spectralSpecModel = (SpectralSpecModel)this.model;
            spectralSpecDocument = spectralSpecModel.getContext();
        }
        return spectralSpecDocument;
    }

    @Override
    protected Velocity getSourceVelocity() {
        Velocity velocity = Velocity.createVelocity();
        if (this.model != null) {
            SpectralSpecModel spectralSpecModel = (SpectralSpecModel)this.model;
            velocity = spectralSpecModel.getSourceVelocity();
        }
        return velocity;
    }
}

