/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spectralvisual;

import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.GuiApi;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.editors.spectralvisual.ScienceViewSpectralPanel;
import alma.obsprep.ot.editors.spectralvisual.ZoomObservable;
import alma.obsprep.ot.editors.spectralvisual.ZoomObserver;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import alma.obsprep.ot.gui.toplevel.ReadonlyHandler;
import alma.obsprep.ot.models.sciencegoals.SfiScanSetupModel;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.services.etc.AtmosphereTable;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.spectralline.DialogSpectralLineChooser;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.SpectralLinePublisher;
import alma.obsprep.services.sfi.SingleFieldScienceGoalEditor;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class ScienceViewSpectralVisualEditor
extends EditorWithGridBagLayout
implements ZoomObserver {
    private ScienceViewSpectralPanel spectralPanel;
    public static final FieldID OVERLAY_LINES_SELECTED_FID = new FieldID("scienceViewVisualSpectralSelectOtherLinesFID");
    public static final FieldID OVERLAY_LINES_UPDATE_FID = new FieldID("scienceViewVisualSpectralSelectOtherLinesUpdatedFID");
    private static final FieldID resetScaleFID = new FieldID("scienceViewVisualSpectralResetScaleFID");
    private static final FieldID zoomInFID = new FieldID("scienceViewVisualSpectralZoomInFID");
    private static final FieldID zoomOutFID = new FieldID("scienceViewVisualSpectralZoomOutFID");
    private static final FieldID panLeftFID = new FieldID("scienceViewVisualSpectralPanLeftFID");
    private static final FieldID panRightFID = new FieldID("scienceViewVisualSpectralPanRightFID");
    private static final FieldID panLineFID = new FieldID("scienceViewVisualSpectralPanLineFID");
    private static final FieldID zoomBandFID = new FieldID("scienceViewVisualSpectralZoomBandFID");
    private static final FieldID drawReceiverBandsFID = new FieldID("scienceViewVisualSpectralDrawReceiverBandsFID");
    private static final FieldID drawOtherLinesFID = new FieldID("scienceViewVisualSpectralDrawOtherLinesFID");
    private static final FieldID drawTransmissionFID = new FieldID("scienceViewVisualSpectralDrawTransmissionFID");
    private static final FieldID waterVapourIndexFID = new FieldID("scienceViewVisualSpectralWaterVapourIndexFID");
    private static final FieldID waterVapourChoiceTypeFID = new FieldID("scienceViewVisualSpectralWaterVapourChoiceTypeFID");
    private static final FieldID drawDSBImageWindowFID = new FieldID("scienceViewVisualSpectralDisplayDSBImageFID");
    private static final FieldID drawFirstTuningFID = new FieldID("scienceViewVisualSpectralDrawFirstSpectralScanTuningFID");
    private static final FieldID drawSecondTuningFID = new FieldID("scienceViewVisualSpectralDrawSecondSpectralScanTuningFID");
    private static final FieldID drawThirdTuningFID = new FieldID("scienceViewVisualSpectralDrawThirdSpectralScanTuningFID");
    private static final FieldID drawFourthTuningFID = new FieldID("scienceViewVisualSpectralDrawFourthSpectralScanTuningFID");
    private static final FieldID drawFifthTuningFID = new FieldID("scienceViewVisualSpectralDrawFifthSpectralScanTuningFID");
    private static final FieldID showFullSpectralRangeFID = new FieldID("scienceViewVisualSpectralShowFullRangeFID");
    private static final FieldID selectSpectralTypeFID = new FieldID("scienceViewVisualSpectralSelectSpectralTypeFID");
    public static final FieldID FID_VISUALPANEL = new FieldID("ScienceViewSpectralVisual.visualPanel");
    Object currentScienceGoalDocument = null;
    private final JButton panButton = this.makeButton(panLineFID, "Pan to Spectral Window", "Centre the display on the continuum frequency or the selected spectral window");
    private final JButton bandButton = this.makeButton(zoomBandFID, "Zoom to Band", "Zoom to the current receiver band");
    private JButton otherTransitionsButton;
    private JTable targetsTable;
    private JCheckBox otherLinesCheckbox;
    private JComboBox waterVapourCombo;
    private EditorWithGridBagLayout.ComponentCollection spectralScanOverlayJComponents;
    private SfiSpectralSetupEditor spectralSetupEditor;
    private ImmutableList<Editor> editorlist = null;

    @Override
    public void finalizeUserEdits() {
        assert (this.editorlist != null);
        this.editorlist.forEach(editor -> editor.finalizeUserEdits());
    }

    public SfiSpectralSetupEditor getSpectralSetupEditor() {
        return this.spectralSetupEditor;
    }

    public ScienceViewSpectralVisualEditor(Model model2) {
        this.setModel(model2);
        if (model2 instanceof SingleFieldScienceGoalModel) {
            SingleFieldScienceGoalModel singleFieldScienceGoalModel = (SingleFieldScienceGoalModel)model2;
            SpectralSetupParametersModel spectralSetupParametersModel = singleFieldScienceGoalModel.getSpectralSetupParametersModel();
            singleFieldScienceGoalModel.subscribe((model, fieldID, object) -> {
                if (fieldID.equals(SingleFieldScienceGoalModel.EDITOR_SUBVIEW_FID)) {
                    this.spectralSetupEditor.configureEditorForView((SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews)((Object)((Object)object)));
                }
            });
            spectralSetupParametersModel.subscribe((model, fieldID, object) -> {
                if (fieldID.equals(SfiSpectralSetupEditor.FID_SPECTRALTYPE)) {
                    SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice = (SpectralSetupParameters.SpectralSetupTypeChoice)((Object)((Object)object));
                    if (spectralSetupTypeChoice.equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALSCAN)) {
                        this.bandButton.setEnabled(true);
                        this.setSpectralScanVisualiserControls(true, (SfiScanSetupModel)spectralSetupParametersModel.getScanSetupModel());
                    } else {
                        this.setSpectralScanVisualiserControls(false, (SfiScanSetupModel)spectralSetupParametersModel.getScanSetupModel());
                    }
                }
            });
            SfiScanSetupModel sfiScanSetupModel = spectralSetupParametersModel.getSpectralScanModel();
            sfiScanSetupModel.subscribe((model, fieldID, object) -> {
                if (spectralSetupParametersModel.getSpectralSetupParameters().isSpectralScan() && (fieldID.equals(SfiScanSetupModel.SPECSCAN_BANDWIDTH) || fieldID.equals(SfiScanSetupModel.SPECSCAN_ENDFREQ_VALUE_VUP) || fieldID.equals(SfiScanSetupModel.SPECSCAN_STARTFREQ_VALUE_VUP))) {
                    this.setSpectralScanVisualiserControls(true, (SfiScanSetupModel)spectralSetupParametersModel.getScanSetupModel());
                    if (this.isWaterVapourTransmissionAuto()) {
                        this.refreshWaterVapourTransmission();
                    }
                }
            });
        }
        this.build();
        model2.publish();
        this.editorlist = ImmutableList.of((Object)this.spectralSetupEditor);
    }

    @Override
    public SingleFieldScienceGoalModel getModel() {
        return (SingleFieldScienceGoalModel)super.getModel();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        super.modelChanged(model, fieldID, object);
        if (this.currentScienceGoalDocument != this.getModel().getDocument()) {
            this.spectralPanel.clearSpatialSelection();
            this.targetsTable.setRowSelectionInterval(0, 0);
            this.spectralPanel.resetFrequencyRange();
            this.setWaterVaporTransmissionAuto();
            this.currentScienceGoalDocument = this.getModel().getDocument();
        }
        if (this.targetsTable != null && this.targetsTable.getRowCount() > 0 && this.targetsTable.getSelectedRow() == -1) {
            this.targetsTable.setRowSelectionInterval(0, 0);
        }
        this.spectralPanel.notifyObservers();
    }

    private void addSpectralVisualiserPanelGroup(SingleFieldScienceGoalModel singleFieldScienceGoalModel) {
        AbstractButton abstractButton;
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        if (AlmaCapabilities.getInstance().getMaxNumberSw() == 4) {
            this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel("<html>In the table below, it is possible to define up to four spectral windows, one per baseband.<P><BR>Each baseband is 2GHz wide and can be separately configured i.e. each spectral window can have a different bandwidth and resolution.<P><BR>Note that for bands 3 to 8, it is not possible to put 3 basebands in one sideband and the fourth one in the other.</html>"));
        } else {
            this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel("<html>In the table below, it is possible to define up to 16 spectral windows, 4 per baseband as long as the total Fraction per baseband is no more than 1.<P>Each baseband is 2GHz wide and can be separately configured i.e. each spectral window can have a different bandwidth and resolution.<P>Note that for bands 3 to 8, it is not possible to put 3 basebands in one sideband and the fourth one in the other.</html>"));
        }
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.makeLabel("<html><P><BR>Left/right click to zoom in/out, grab sliding bar to pan<P>Note: Moving LO1 here is for experimentation only - actual setup determined by the windows<BR></html>"));
        this.spectralPanel = new ScienceViewSpectralPanel(this.getGuiApi().getColorPalette());
        this.spectralPanel.setModel(singleFieldScienceGoalModel);
        this.spectralPanel.addObserver(this);
        this.spectralPanel.putClientProperty("readonly-handler", new ReadonlyHandler(){

            @Override
            public void handleReadOnly(Component component) {
                ScienceViewSpectralVisualEditor.this.spectralPanel.setAllowDragLO(false);
            }

            @Override
            public void handleNotReadOnly(Component component) {
                ScienceViewSpectralVisualEditor.this.spectralPanel.setAllowDragLO(true);
            }
        });
        this.configureWaterVaporTransmissionUpdater();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.addComponent(0, jPanel, gridBagLayout, gridBagConstraints, this.spectralPanel);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.addComponent(0, jPanel, gridBagLayout, gridBagConstraints, this.heightSpacer());
        ++gridBagConstraints.gridy;
        JPanel jPanel2 = this.createNewGroup();
        GridBagLayout gridBagLayout2 = this.createNewLayout(jPanel2);
        GridBagConstraints gridBagConstraints2 = this.createNewConstraints();
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        JLabel jLabel = this.makeLabel("Overlays:");
        componentCollection.remember(jLabel);
        JCheckBox jCheckBox = this.makeCheckBox(drawReceiverBandsFID, "Receiver Bands", this.spectralPanel.getDrawReceiverBands(), "Toggle receiver bands overlay");
        componentCollection.remember(jCheckBox);
        JCheckBox jCheckBox2 = this.makeCheckBox(drawTransmissionFID, "Transmission", this.spectralPanel.getDrawTransmission(), "Toggle atmospheric transmission overlay");
        componentCollection.remember(jCheckBox2);
        JCheckBox jCheckBox3 = this.makeCheckBox(drawDSBImageWindowFID, "DSB Image", this.spectralPanel.getDrawDSBImageWindow(), "Toggle display of the DSB image");
        componentCollection.remember(jCheckBox3);
        JComponent[] jComponentArray = new JComponent[1];
        this.otherLinesCheckbox = this.makeCheckBox(drawOtherLinesFID, "Spectral Lines", this.spectralPanel.getDrawOtherLines(), "Toggle overlay of other spectral lines");
        jComponentArray[0] = this.otherLinesCheckbox;
        componentCollection.remember(jComponentArray);
        this.otherTransitionsButton = new JButton("Select Lines to Overlay");
        this.otherTransitionsButton.setName("ScienceViewSpectralVisual.otherTransitionsBtn");
        this.otherTransitionsButton.setToolTipText("Bring up the spectral line picker to overlay lines for visualisation purposes");
        this.otherTransitionsButton.addActionListener(actionEvent -> {
            Velocity velocity;
            this.otherTransitionsButton.setEnabled(false);
            SpectralSetupParameters spectralSetupParameters = this.getModel().getSpectralSetupParametersModel().getSpectralSetupParameters();
            ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
            Frequency frequency = null;
            if (spectralSetupParameters != null) {
                int n = this.targetsTable.getSelectionModel().getMaxSelectionIndex();
                if (n == -1) {
                    n = 0;
                }
                TargetParameters targetParameters = this.getModel().getSgFieldSetupModel().getTargetParameters(n);
                Frequency frequency2 = spectralSetupParameters.getLO1Frequency();
                boolean bl = spectralSetupParameters.getLOSolutionFound();
                velocity = targetParameters.getSourceVelocity();
                if (frequency2 != null && !frequency2.isZero() && bl) {
                    frequency = frequency2.deepCopy();
                }
            } else {
                velocity = Velocity.createVelocity();
            }
            SpectralLinePublisher spectralLinePublisher = DialogSpectralLineChooser.getInstance().createPublisher(this, OVERLAY_LINES_SELECTED_FID, this.otherTransitionsButton);
            arrayList.addAll(this.spectralPanel.getLinesToDisplay());
            DialogSpectralLineChooser.getInstance().chooseMultipleLinesForOverlay(spectralLinePublisher, velocity, arrayList, frequency, Optional.of(spectralSetupParameters));
        });
        componentCollection.remember((JComponent)this.otherTransitionsButton, 3);
        int n = gridBagConstraints2.fill;
        gridBagConstraints2.fill = 0;
        this.addComponentArray((JComponent)jPanel2, gridBagLayout2, gridBagConstraints2, componentCollection, false);
        gridBagConstraints2.fill = n;
        this.spectralScanOverlayJComponents = new EditorWithGridBagLayout.ComponentCollection();
        JLabel jLabel2 = this.makeLabel("Spectral Scan:");
        this.spectralScanOverlayJComponents.remember(jLabel2);
        JCheckBox jCheckBox4 = this.makeCheckBox(showFullSpectralRangeFID, "Requested Scan", true, "Display the full range of the spectral scan");
        this.spectralScanOverlayJComponents.remember(jCheckBox4);
        JCheckBox jCheckBox5 = this.makeCheckBox(drawFirstTuningFID, "Tuning 1", true, "Toggle display of the 1st spectral scan tuning");
        this.spectralScanOverlayJComponents.remember(jCheckBox5);
        JCheckBox jCheckBox6 = this.makeCheckBox(drawSecondTuningFID, "Tuning 2", true, "Toggle display of the 2nd spectral scan tuning");
        this.spectralScanOverlayJComponents.remember(jCheckBox6);
        JCheckBox jCheckBox7 = this.makeCheckBox(drawThirdTuningFID, "Tuning 3", true, "Toggle display of the 3rd spectral scan tuning");
        this.spectralScanOverlayJComponents.remember(jCheckBox7);
        JCheckBox jCheckBox8 = this.makeCheckBox(drawFourthTuningFID, "Tuning 4", true, "Toggle display of the 4th spectral scan tuning");
        this.spectralScanOverlayJComponents.remember(jCheckBox8);
        JCheckBox jCheckBox9 = this.makeCheckBox(drawFifthTuningFID, "Tuning 5", true, "Toggle display of the 5th spectral scan tuning");
        this.spectralScanOverlayJComponents.remember(jCheckBox9);
        gridBagConstraints2.ipadx = 25;
        this.addComponentArray(jPanel2, gridBagLayout2, gridBagConstraints2, this.spectralScanOverlayJComponents);
        gridBagConstraints2.ipadx = 0;
        JPanel jPanel3 = this.createLineContainer();
        this.waterVapourCombo = new JComboBox<String>(AtmosphereTable.WV_MAP);
        this.initEvents(this.waterVapourCombo, waterVapourIndexFID);
        String[] stringArray = new String[]{"Automatic Choice", "Manual Choice"};
        OTButtonGroup oTButtonGroup = new OTButtonGroup(stringArray);
        this.initEvents(oTButtonGroup, waterVapourChoiceTypeFID);
        oTButtonGroup.setSelectedItem("Automatic Choice");
        this.waterVapourCombo.setEnabled(false);
        oTButtonGroup.setToolTipText("<html>Automatic displays what will be used in time estimates, manual<br>selection is for illustration and will not be used in time estimates</html>");
        jPanel3.add(oTButtonGroup);
        this.waterVapourCombo.setToolTipText("<html>Automatic displays what will be used in time estimates, manual<br>selection is for illustration and will not be used in time estimates</html>");
        jPanel3.add(this.waterVapourCombo);
        JLabel jLabel3 = this.addLabeledComponent((JComponent)jPanel2, gridBagLayout2, gridBagConstraints2, "Water Vapour Column Density:", (JComponent)jPanel3);
        componentCollection = new EditorWithGridBagLayout.ComponentCollection();
        JButton jButton = this.makeButton(resetScaleFID, "Reset", "Set the display to its default view.");
        JLabel jLabel4 = this.makeLabel("Viewport:");
        componentCollection.remember(jLabel4, this.panButton, this.bandButton, jButton);
        this.addComponentArray(jPanel2, gridBagLayout2, gridBagConstraints2, componentCollection);
        this.addComponent(0, jPanel, gridBagLayout, gridBagConstraints, jPanel2);
        this.addComponent(0, jPanel, gridBagLayout, gridBagConstraints, this.heightSpacer());
        JComponent jComponent2 = this.addNonCollapsingGroup(jPanel, "Visualisation");
        this.add(jComponent2);
        this.panButton.setEnabled(false);
        this.bandButton.setEnabled(false);
        Enumeration<AbstractButton> enumeration = oTButtonGroup.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            abstractButton = enumeration.nextElement();
            abstractButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        }
        abstractButton = ImmutableList.of((Object)jCheckBox, (Object)jCheckBox2, (Object)jCheckBox3, (Object)this.otherLinesCheckbox, (Object)this.otherTransitionsButton, (Object)jCheckBox4, (Object)jCheckBox5, (Object)jCheckBox6, (Object)jCheckBox7, (Object)jCheckBox8, (Object)jCheckBox9, (Object)this.panButton, (Object[])new JComponent[]{this.bandButton, jButton, this.waterVapourCombo, oTButtonGroup, jLabel2, jLabel4, jLabel, jLabel3});
        abstractButton.stream().forEach(jComponent -> jComponent.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly));
    }

    private SfiSpectralSetupEditor addSpectralElementsGroup(SingleFieldScienceGoalModel singleFieldScienceGoalModel) {
        this.spectralSetupEditor = new SfiSpectralSetupEditor(singleFieldScienceGoalModel.getSpectralSetupParametersModel());
        this.registerSubView(this.spectralSetupEditor);
        this.spectralSetupEditor.addScienceSpectralWindowSelectionListener(abstractScienceSpectralWindow -> {
            this.spectralPanel.setSelectedLine(abstractScienceSpectralWindow);
            this.bandButton.setEnabled(abstractScienceSpectralWindow != null);
        });
        this.spectralSetupEditor.getSpectralLineEditor().addTableModelListener(tableModelEvent -> {
            this.spectralPanel.repaint();
            if (this.isWaterVapourTransmissionAuto()) {
                this.updateWaterVapourTransmission(null);
            }
        });
        this.spectralSetupEditor.getSpectralContinuumLineEditor().addTableModelListener(tableModelEvent -> {
            this.spectralPanel.repaint();
            if (this.isWaterVapourTransmissionAuto()) {
                this.updateWaterVapourTransmission(null);
            }
        });
        this.add(this.spectralSetupEditor);
        return this.spectralSetupEditor;
    }

    void setSpectralScanVisualiserControls(Boolean bl, SfiScanSetupModel sfiScanSetupModel) {
        Integer n = 0;
        if (bl.booleanValue()) {
            try {
                n = sfiScanSetupModel.getTunings().getNumberOfTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                bl = false;
            }
        }
        Integer n2 = -2;
        for (JComponent jComponent : this.spectralScanOverlayJComponents.getComponents()) {
            if (bl.booleanValue()) {
                if (n2 < n) {
                    jComponent.setVisible(bl);
                    Integer n3 = n2;
                    Integer n4 = n2 = Integer.valueOf(n2 + 1);
                    continue;
                }
                jComponent.setVisible(false);
                continue;
            }
            jComponent.setVisible(bl);
        }
    }

    @Override
    protected void addComponents(String string) {
        SingleFieldScienceGoalModel singleFieldScienceGoalModel = this.getModel();
        this.setLayout(new BoxLayout(this, 3));
        this.addSpectralVisualiserPanelGroup(singleFieldScienceGoalModel);
        SfiSpectralSetupEditor sfiSpectralSetupEditor = this.addSpectralElementsGroup(singleFieldScienceGoalModel);
        this.targetsTable = sfiSpectralSetupEditor.getTargetsTable();
        this.spectralPanel.addSpatialListener(this.targetsTable);
    }

    @Override
    protected void build() {
        super.build("Spectral Setup");
    }

    private JComponent heightSpacer() {
        JButton jButton = new JButton("");
        JPanel jPanel = new JPanel();
        jPanel.add(Box.createRigidArea(new Dimension(0, 2 * jButton.getSize().height / 3)));
        return jPanel;
    }

    private void setWaterVaporTransmissionAuto() {
        OTButtonGroup oTButtonGroup = (OTButtonGroup)this.retrieve(waterVapourChoiceTypeFID);
        oTButtonGroup.setSelectedItem("Automatic Choice");
        this.refreshWaterVapourTransmission();
    }

    private String getWaterVaporTransmissionChoice() {
        OTButtonGroup oTButtonGroup = (OTButtonGroup)this.retrieve(waterVapourChoiceTypeFID);
        return oTButtonGroup.getSelectedItem();
    }

    private boolean isWaterVapourTransmissionAuto() {
        return "Automatic Choice".equals(this.getWaterVaporTransmissionChoice());
    }

    public void refreshWaterVapourTransmission() {
        boolean bl = this.isWaterVapourTransmissionAuto();
        if (bl) {
            this.updateWaterVapourTransmission(null);
        } else {
            this.updateWaterVapourTransmission(this.getWaterVaporTransmissionChoice());
        }
        this.waterVapourCombo.setEnabled(!bl);
    }

    private void configureWaterVaporTransmissionUpdater() {
    }

    private void updateWaterVapourTransmission(String string) {
        int n = WaterVaporColumns.wvindexSelector(string);
        if (n == -1) {
            SingleFieldScienceGoalModel singleFieldScienceGoalModel = this.getModel();
            SpectralSetupParametersModel spectralSetupParametersModel = singleFieldScienceGoalModel.getSpectralSetupParametersModel();
            SpectralSetupParameters spectralSetupParameters = spectralSetupParametersModel.getSpectralSetupParameters();
            if (spectralSetupParameters == null) {
                return;
            }
            String string2 = spectralSetupParameters.getType();
            try {
                spectralSetupParameters.getScienceGoal().getTargetParameters(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (string2.equals("full") || string2.equals("scan")) {
                try {
                    this.spectralPanel.setWaterVapourIndex(spectralSetupParameters.getScienceGoal().getRecommendedWVCIndex());
                }
                catch (NullPointerException nullPointerException) {}
            } else if (string2.equals("continuum")) {
                try {
                    this.spectralPanel.setWaterVapourIndex(spectralSetupParameters.getScienceGoal().getRecommendedWVCIndex());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            Object e = this.waterVapourCombo.getItemAt(this.spectralPanel.getWaterVapourIndex());
            this.set2(this.waterVapourCombo, e);
        } else {
            this.spectralPanel.setWaterVapourIndex(n);
        }
        this.spectralPanel.resetTransmissionData();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (this.spectralPanel == null) {
            return;
        }
        if (fieldID == resetScaleFID) {
            this.spectralPanel.resetFrequencyRange();
        } else if (fieldID == zoomInFID) {
            this.spectralPanel.zoomIn(2.0);
        } else if (fieldID == zoomOutFID) {
            this.spectralPanel.zoomOut(2.0);
        } else if (fieldID == panLeftFID) {
            this.spectralPanel.panLeft(0.5);
        } else if (fieldID == panRightFID) {
            this.spectralPanel.panRight(0.5);
        } else if (fieldID == panLineFID) {
            this.spectralPanel.panToLine();
        } else if (fieldID == zoomBandFID) {
            this.spectralPanel.zoomToBand();
        } else if (fieldID == drawReceiverBandsFID) {
            Boolean bl = (Boolean)object;
            this.spectralPanel.setDrawReceiverBands(bl);
        } else if (fieldID == drawOtherLinesFID) {
            Boolean bl = (Boolean)object;
            this.spectralPanel.setDrawOtherLines(bl);
        } else if (fieldID == OVERLAY_LINES_SELECTED_FID) {
            if (object instanceof List) {
                List list = (List)object;
                this.spectralPanel.setLinesToDisplay(list);
                this.spectralPanel.repaint();
                if (list.size() > 0 && !this.otherLinesCheckbox.isSelected()) {
                    this.otherLinesCheckbox.doClick();
                }
            }
        } else if (fieldID == drawTransmissionFID) {
            Boolean bl = (Boolean)object;
            this.spectralPanel.setDrawTransmission(bl);
        } else if (fieldID == drawDSBImageWindowFID) {
            Boolean bl = (Boolean)object;
            this.spectralPanel.setDrawDSBImageWindow(bl);
        } else if (fieldID == waterVapourIndexFID) {
            this.updateWaterVapourTransmission(object.toString());
        } else if (fieldID == waterVapourChoiceTypeFID) {
            OTButtonGroup oTButtonGroup = (OTButtonGroup)this.retrieve(waterVapourChoiceTypeFID);
            boolean bl = "Automatic Choice".equals(oTButtonGroup.getSelectedItem());
            if (bl) {
                this.updateWaterVapourTransmission(null);
            }
            this.waterVapourCombo.setEnabled(!bl);
        } else if (fieldID == showFullSpectralRangeFID) {
            this.spectralPanel.setShowFullSpectralScan((Boolean)object);
        } else if (fieldID == drawFirstTuningFID) {
            this.spectralPanel.setSpectralScanTuningVisibility(0, (boolean)((Boolean)object));
        } else if (fieldID == drawSecondTuningFID) {
            this.spectralPanel.setSpectralScanTuningVisibility(1, (boolean)((Boolean)object));
        } else if (fieldID == drawThirdTuningFID) {
            this.spectralPanel.setSpectralScanTuningVisibility(2, (boolean)((Boolean)object));
        } else if (fieldID == drawFourthTuningFID) {
            this.spectralPanel.setSpectralScanTuningVisibility(3, (boolean)((Boolean)object));
        } else if (fieldID == drawFifthTuningFID) {
            this.spectralPanel.setSpectralScanTuningVisibility(4, (boolean)((Boolean)object));
        } else {
            super.update(fieldID, object);
        }
        this.spectralPanel.repaint();
    }

    @Override
    public void setGuiApi(GuiApi guiApi) {
        this.spectralPanel.setPalette(guiApi.getColorPalette());
        super.setGuiApi(guiApi);
    }

    @Override
    public void update(ZoomObservable zoomObservable, boolean bl) {
        this.panButton.setEnabled(bl && this.bandButton.isEnabled());
    }
}

