/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spectralvisual;

import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.schedblock.Range;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.List;

public class SpectralRangeRepresentation {
    private Range frequenciesGHz;
    private int level;
    private int depth;
    private SideBandUse sideband;
    private RangeType type;
    private SpectralRangeRepresentation mirror;
    private SpectralRangeRepresentation parent;
    private List<SpectralRangeRepresentation> children;
    private boolean error;
    private boolean highlight;
    private String label;

    public SpectralRangeRepresentation(Frequency frequency, Frequency frequency2, SideBandUse sideBandUse, RangeType rangeType) {
        this(frequency.getContentInGHz(), frequency2.getContentInGHz(), sideBandUse, rangeType);
    }

    public SpectralRangeRepresentation(double d, double d2, SideBandUse sideBandUse, RangeType rangeType) {
        this.frequenciesGHz = new Range(d, d2);
        this.sideband = sideBandUse;
        this.type = rangeType;
        this.level = 0;
        this.depth = 0;
        this.mirror = null;
        this.error = false;
        this.highlight = false;
        this.label = null;
        this.parent = null;
        this.children = new ArrayList<SpectralRangeRepresentation>();
    }

    public Range getFrequenciesGHz() {
        return this.frequenciesGHz;
    }

    public Frequency getMinFrequency() {
        return Frequency.createFrequencyGHZ(this.frequenciesGHz.min());
    }

    public Frequency getMaxFrequency() {
        return Frequency.createFrequencyGHZ(this.frequenciesGHz.max());
    }

    public double getMinFrequencyGHz() {
        return this.frequenciesGHz.min();
    }

    public double getMaxFrequencyGHz() {
        return this.frequenciesGHz.max();
    }

    public void setMinFrequency(Frequency frequency) {
        this.setMinFrequency(frequency.getContentInGHz());
    }

    public void setMaxFrequency(Frequency frequency) {
        this.setMaxFrequency(frequency.getContentInGHz());
    }

    public void setRange(Frequency frequency, Frequency frequency2) {
        this.setRange(frequency.getContentInGHz(), frequency2.getContentInGHz());
    }

    public void setMinFrequency(double d) {
        this.frequenciesGHz = new Range(d, this.getMaxFrequencyGHz());
    }

    public void setMaxFrequency(double d) {
        this.frequenciesGHz = new Range(this.getMinFrequencyGHz(), d);
    }

    public void setRange(double d, double d2) {
        this.frequenciesGHz = new Range(d, d2);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public SideBandUse getSideband() {
        return this.sideband;
    }

    public void setSideband(SideBandUse sideBandUse) {
        this.sideband = sideBandUse;
    }

    public RangeType getType() {
        return this.type;
    }

    public void setType(RangeType rangeType) {
        this.type = rangeType;
    }

    public SpectralRangeRepresentation getMirror() {
        return this.mirror;
    }

    public void setMirror(SpectralRangeRepresentation spectralRangeRepresentation) {
        if (this.mirror != null) {
            this.mirror.mirror = null;
        }
        this.mirror = spectralRangeRepresentation;
        if (spectralRangeRepresentation != null) {
            spectralRangeRepresentation.mirror = this;
        }
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean bl) {
        this.error = bl;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean bl) {
        this.highlight = bl;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setParent(SpectralRangeRepresentation spectralRangeRepresentation) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = spectralRangeRepresentation;
        if (spectralRangeRepresentation != null) {
            spectralRangeRepresentation.addChild(this);
        }
        this.setError(!spectralRangeRepresentation.frequenciesGHz.contains(this.frequenciesGHz));
    }

    public SpectralRangeRepresentation getParent() {
        return this.parent;
    }

    public List<SpectralRangeRepresentation> getChildren() {
        return this.children;
    }

    private void addChild(SpectralRangeRepresentation spectralRangeRepresentation) {
        if (!this.children.contains(spectralRangeRepresentation)) {
            this.children.add(spectralRangeRepresentation);
        }
    }

    private void removeChild(SpectralRangeRepresentation spectralRangeRepresentation) {
        this.children.remove(spectralRangeRepresentation);
    }

    private boolean completelyContains(SpectralRangeRepresentation spectralRangeRepresentation) {
        return this.frequenciesGHz.inRange(spectralRangeRepresentation.frequenciesGHz.min()) && this.frequenciesGHz.inRange(spectralRangeRepresentation.frequenciesGHz.max());
    }

    protected static enum DSBType {
        Rejection,
        Separation,
        Both;

    }

    protected static enum RangeType {
        Primary,
        Secondary,
        Suppressed;

    }
}

