/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spectralvisual;

import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.Range;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.boEditors.PanelUtilities;
import alma.obsprep.ot.editors.spectralvisual.ObservedAndTargetPanel;
import alma.obsprep.ot.gui.dnd.ConstrainedXDNDDescriptor;
import alma.obsprep.ot.gui.dnd.DNDDescriptor;
import alma.obsprep.ot.gui.dnd.DefaultDNDDescriptor;
import alma.obsprep.ot.gui.dnd.DomainPoint;
import alma.obsprep.ot.gui.dnd.MousePoint;
import alma.obsprep.ot.gui.resources.ColorPalette;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class SpectralSpecPanel
extends ObservedAndTargetPanel {
    private boolean drawReceiverBands;
    private boolean drawCentreFrequencies;
    private boolean drawBasebands;
    private boolean drawSideBands;
    private static final int DRAG_NOTHING = 0;
    private static final int DRAG_LINE = 1;
    private static final int DRAG_RANGE = 2;
    private static final int DRAG_LO = 3;
    private boolean draggingLo = false;

    @Override
    public DNDDescriptor createDescriptor(MousePoint mousePoint) {
        DefaultDNDDescriptor defaultDNDDescriptor = null;
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        double d = this.unscaleObservedFrequency(mousePoint.getX());
        double d2 = -1000.0;
        int n = -1000;
        double d3 = -1000.0;
        int n2 = -1000;
        if (spectralSpec != null) {
            d2 = spectralSpec.getFrequencySetup().getRestFrequency().getContentInGHz();
            n = this.scaleRestFrequency(d2);
            if (this.drawSideBands) {
                d3 = spectralSpec.getLO1Frequency().getContentInGHz();
                n2 = this.scaleOF(d3);
            }
        }
        if (mousePoint.getY() <= this.yObservedAxis() || mousePoint.getY() >= this.yTargetAxis()) {
            DomainPoint domainPoint = new DomainPoint(d, 0.0);
            defaultDNDDescriptor = new DefaultDNDDescriptor(2, mousePoint, domainPoint);
        } else if (spectralSpec != null) {
            if ((double)Math.abs(mousePoint.getX() - n2) < 10.0) {
                MousePoint mousePoint2 = new MousePoint(n2, mousePoint.getY());
                DomainPoint domainPoint = new DomainPoint(d3, 0.0);
                ReceiverBand receiverBand = spectralSpec.getReceiverBand();
                defaultDNDDescriptor = new ConstrainedXDNDDescriptor(3, mousePoint2, domainPoint, new Range(receiverBand.getLOMin(), receiverBand.getLOMax()));
            } else if ((double)Math.abs(mousePoint.getX() - n) < 10.0) {
                MousePoint mousePoint3 = new MousePoint(n, mousePoint.getY());
                DomainPoint domainPoint = new DomainPoint(d2, 0.0);
                ReceiverBand receiverBand = spectralSpec.getReceiverBand();
                defaultDNDDescriptor = new ConstrainedXDNDDescriptor(1, mousePoint3, domainPoint, new Range(this.getAbsoluteMin(), this.getAbsoluteMax()));
            }
        }
        this.setDragging(defaultDNDDescriptor != null);
        return defaultDNDDescriptor;
    }

    @Override
    public void drag(DNDDescriptor dNDDescriptor, MousePoint mousePoint) {
        double d;
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        DomainPoint domainPoint = new DomainPoint(this.unscaleObservedFrequency(mousePoint.getX()), 0.0);
        if (mousePoint.getX() <= 0) {
            d = -1.0 * (double)mousePoint.getX() / (double)this.getWidth();
            this.panLeft(d);
        } else if (mousePoint.getX() > this.getWidth()) {
            d = 1.0 * (double)(mousePoint.getX() - this.getWidth()) / (double)this.getWidth();
            this.panRight(d);
        }
        domainPoint = dNDDescriptor.getConstrained(domainPoint);
        switch (dNDDescriptor.getType()) {
            case 2: {
                d = 0.0;
                break;
            }
            case 1: {
                domainPoint = new DomainPoint(this.unscaleRestFrequency(mousePoint.getX()), 0.0);
                domainPoint = dNDDescriptor.getConstrained(domainPoint);
                Frequency frequency = spectralSpec.getFrequencySetup().getRestFrequency();
                String string = frequency.getUnit();
                frequency.setContentInGHz(domainPoint.getX());
                frequency.convertToUnit(string);
                break;
            }
            case 3: {
                Frequency frequency = spectralSpec.getLO1Frequency();
                String string = frequency.getUnit();
                frequency.setContentInGHz(domainPoint.getX());
                frequency.convertToUnit(string);
                break;
            }
        }
    }

    @Override
    public void abandon(DNDDescriptor dNDDescriptor) {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        DomainPoint domainPoint = dNDDescriptor.getOriginalDomainPosition();
        switch (dNDDescriptor.getType()) {
            case 2: {
                break;
            }
            case 1: {
                Frequency frequency = spectralSpec.getFrequencySetup().getRestFrequency();
                String string = frequency.getUnit();
                frequency.setContentInGHz(domainPoint.getX());
                frequency.convertToUnit(string);
                break;
            }
            case 3: {
                Frequency frequency = spectralSpec.getLO1Frequency();
                String string = frequency.getUnit();
                frequency.setContentInGHz(domainPoint.getX());
                frequency.convertToUnit(string);
                break;
            }
        }
        this.setDragging(false);
    }

    @Override
    public void drop(DNDDescriptor dNDDescriptor, MousePoint mousePoint) {
        this.setDragging(false);
    }

    @Override
    public void destroyDescriptor(DNDDescriptor dNDDescriptor) {
        this.setDragging(false);
    }

    @Override
    public void publish() {
        this.model.publish();
    }

    public void setModel(SpectralSpecModel spectralSpecModel) {
        ObservedAndTargetPanel.LocalDNDAdapter localDNDAdapter = new ObservedAndTargetPanel.LocalDNDAdapter(this);
        this.addMouseListener(localDNDAdapter);
        this.addMouseMotionListener(localDNDAdapter);
        super.setModel(spectralSpecModel);
    }

    public SpectralSpecPanel(ColorPalette colorPalette, double d, double d2) {
        super(d, d2);
        this.palette = colorPalette;
        this.helper = new PanelUtilities(this);
        this.drawReceiverBands = true;
        this.drawCentreFrequencies = false;
        this.drawBasebands = true;
        this.drawSideBands = true;
        this.setDrawOtherLines(false);
        this.setDrawTransmission(true);
        this.setInitialFrequencyRange();
    }

    public SpectralSpecPanel(ColorPalette colorPalette) {
        this(colorPalette, 1.0, 1.0);
    }

    @Override
    public void resetFrequencyRange() {
        this.minOF = this.absoluteMinOF;
        this.maxOF = this.absoluteMaxOF;
        this.setFrequencyRangeNoRound(this.minOF, this.maxOF);
    }

    public void panToLine() {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec == null) {
            return;
        }
        Velocity velocity = spectralSpec.getSourceVelocity();
        Frequency frequency = spectralSpec.getFrequencySetup().getRestFrequency().dopplerShifted(velocity);
        this.panTo(frequency.getContentInGHz());
    }

    public void zoomToBand() {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec == null) {
            return;
        }
        ReceiverBand receiverBand = spectralSpec.getReceiverBand();
        if (receiverBand != null) {
            this.setFrequencyRange(receiverBand.getRFMin(), receiverBand.getRFMax());
        }
    }

    @Override
    protected int yClearTarget() {
        return this.yTargetAxis();
    }

    @Override
    protected int yClearObserved() {
        return this.yObservedAxis() + 2 * this.textHeight;
    }

    private int observedLabelBase() {
        return this.yObservedAxis() + this.yRxBandHeight() + this.yLOBandHeight() + this.textHeight;
    }

    @Override
    protected int observedLabelHeight(int n) {
        return this.observedLabelBase() + n * this.textHeight;
    }

    private int spectraltop() {
        return 0;
    }

    public void paintObservedAxisAndBands(Graphics graphics) {
        this.paintSkyAxis(graphics);
        boolean bl = true;
        if (this.getDrawReceiverBands()) {
            Color color;
            Color color2 = color = COLOUR_BANDLINES;
            for (int i = 0; i < this.names.length; ++i) {
                ReceiverBand receiverBand = ReceiverBand.getReceiverBand(this.names[i]);
                if (bl) {
                    this.paintBand(graphics, receiverBand, color, bl);
                } else {
                    this.paintBand(graphics, receiverBand, color2, bl);
                }
                bl = !bl;
            }
        }
    }

    private void paintSideBands(Graphics graphics, SpectralSpec spectralSpec) {
        Range range;
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(spectralSpec.getFrequencySetup().getReceiverBand());
        double d = spectralSpec.getLO1Frequency().getContentInGHz();
        Color color = Colors.transparentColor(this.palette.getSidebandsColor());
        if (receiverBand.hasLower()) {
            range = new Range(d - receiverBand.getIFMax(), d - receiverBand.getIFMin());
            this.paintSideBand(graphics, range, color, false);
        }
        if (receiverBand.hasUpper()) {
            range = new Range(d + receiverBand.getIFMin(), d + receiverBand.getIFMax());
            this.paintSideBand(graphics, range, color, false);
        }
        this.paintObservedSpectralLine(graphics, d, "LO1", this.palette.getSidebandsColor(), 1, false);
    }

    private void paintBBCLines(Graphics graphics, SpectralSpec spectralSpec) {
        Color color = this.palette.getCentreFrequencyColor();
        Color color2 = color.darker();
        double d = spectralSpec.getLO1Frequency().getContentInGHz();
        boolean bl = true;
        String string = spectralSpec.getReceiverBand().getType();
        boolean bl2 = false;
        if (string.equals(SpectralSpec.RECEIVERTYPE_DSB)) {
            bl2 = true;
        }
        for (int i = 0; i < spectralSpec.getBaseBandCount(); ++i) {
            BaseBandSpecification baseBandSpecification = spectralSpec.getBaseBandSpecification(i);
            double d2 = baseBandSpecification.getCenterFrequencySky().getContentInGHz();
            double d3 = 2.0 * d - d2;
            String string2 = baseBandSpecification.getBaseBandName();
            if (this.getDrawCentreFrequencies()) {
                this.paintObservedSpectralLine(graphics, d2, string2, color, i, true);
                if (bl2) {
                    this.paintObservedSpectralLine(graphics, d3, null, color2, i, true);
                }
            }
            if (!this.getDrawBasebands()) continue;
            Frequency frequency = baseBandSpecification.getBandwidth();
            double d4 = frequency.getContentInGHz() / 2.0;
            int n = this.observedLabelHeight(i);
            int n2 = this.scaleOF(d2 + d4);
            int n3 = this.scaleOF(d2 - d4);
            int n4 = this.scaleOF(d2);
            this.drawBasebandLine(graphics, string2, color, n, n2, n3, n4);
            if (!bl2) continue;
            n2 = this.scaleOF(d3 + d4);
            n3 = this.scaleOF(d3 - d4);
            n4 = this.scaleOF(d3);
            this.drawBasebandLine(graphics, null, color2, n, n2, n3, n4);
        }
    }

    private void drawBasebandLine(Graphics graphics, String string, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.drawLine(n3, n, n2, n);
        graphics.drawLine(n3, n - 5, n3, n + 5);
        graphics.drawLine(n2, n - 5, n2, n + 5);
        if (string != null) {
            if (this.drawCentreFrequencies) {
                graphics.fillOval(n4 - 2, n - 2, 4, 4);
            } else {
                this.helper.labelCentre(graphics, n4, n, string);
            }
        }
    }

    private void paintRestFrequency(Graphics graphics, SpectralSpec spectralSpec) {
        Frequency frequency = spectralSpec.getFrequencySetup().getRestFrequency();
        this.paintTargetSpectralLine(graphics, frequency.getContentInGHz(), spectralSpec.getFrequencySetup().getTransitionName(), this.palette.getRestFrequencyColor(), 0);
        String string = spectralSpec.getFrequencySetup().getReceiverBand();
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(string);
        this.paintBand(graphics, receiverBand, this.palette.getRestFrequencyColor());
    }

    public void paintNoSpectralSpec(Graphics graphics) {
        this.textHeight = this.helper.calculateTextHeight(graphics);
        this.paintBackground(graphics);
        if (this.getDrawOtherLines()) {
            this.paintKnownSpectralLinesLines(graphics, this.minTF, this.maxTF);
        }
    }

    private void paintSpectralSpec(Graphics graphics, SpectralSpec spectralSpec) {
        this.logger.startWatch();
        this.paintNoSpectralSpec(graphics);
        this.logger.stopWatch("paintNoSpectralSpec(Graphics)");
        if (this.drawSideBands) {
            this.paintSideBands(graphics, spectralSpec);
            this.logger.stopWatch("paintSideBands(Graphics, SpectralSpec)");
        }
        if (this.getDrawOtherLines()) {
            this.paintKnownSpectralLinesLines(graphics, this.minTF, this.maxTF);
            this.logger.stopWatch("paintKnownLines(Graphics, double, double)");
        }
        if (this.getDrawCentreFrequencies() || this.getDrawBasebands()) {
            this.paintBBCLines(graphics, spectralSpec);
            this.logger.stopWatch("paintBBCLines(Graphics, SpectralSpec)");
        }
        if (this.getDrawTransmission()) {
            // empty if block
        }
        this.paintRestFrequency(graphics, spectralSpec);
        this.logger.stopWatch("paintRestFrequency(Graphics, SpectralSpec)");
    }

    @Override
    public void corePaintComponent(Graphics graphics) {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        if (spectralSpec != null) {
            this.paintSpectralSpec(graphics, spectralSpec);
        } else {
            this.resetFrequencyRange();
            this.paintNoSpectralSpec(graphics);
        }
    }

    private void paintBackground(Graphics graphics) {
        this.paintObservedAxisAndBands(graphics);
        this.paintRestAxis(graphics);
    }

    public static void main(String[] stringArray) {
        double d;
        UnitMapConfigurator.configureUnitMaps();
        Velocity velocity = Velocity.createVelocity();
        Speed speed = Speed.createSpeed();
        Frequency[] frequencyArray = new Frequency[10];
        Frequency[] frequencyArray2 = new Frequency[frequencyArray.length];
        speed.setContent(2.8E8);
        speed.setUnit(Speed.UNIT_M_S);
        velocity.setCenterVelocity(speed);
        System.out.println("Before\t\tShifted\t\t\tChangeT\tChangeO\n");
        for (int i = 0; i < frequencyArray.length; ++i) {
            frequencyArray[i] = Frequency.createFrequencyGHZ(i * 100);
            frequencyArray2[i] = velocity.dopplerShift(frequencyArray[i]);
            System.out.print((Object)((Object)frequencyArray[i]) + "\t" + (Object)((Object)frequencyArray2[i]));
            if (i > 0) {
                double d2 = frequencyArray[i].getContentInGHz() - frequencyArray[i - 1].getContentInGHz();
                d = frequencyArray2[i].getContentInGHz() - frequencyArray2[i - 1].getContentInGHz();
                System.out.print("\t" + d2 + '\t' + d);
            }
            System.out.println();
        }
        Frequency frequency = Frequency.createFrequencyGHZ(230.53799);
        d = 0.0;
        double d3 = 2.0E8;
        Velocity velocity2 = Velocity.createVelocity();
        Velocity velocity3 = Velocity.createVelocity();
        Velocity velocity4 = Velocity.createVelocity();
        Speed speed2 = Speed.createSpeed();
        Speed speed3 = Speed.createSpeed();
        Speed speed4 = Speed.createSpeed();
        velocity2.setCenterVelocity(speed2);
        velocity3.setCenterVelocity(speed3);
        velocity4.setCenterVelocity(speed4);
        speed2.setUnit(Speed.UNIT_M_S);
        speed3.setUnit(Speed.UNIT_M_S);
        speed4.setUnit(Speed.UNIT_M_S);
        speed2.setContent(d);
        speed4.setContent(d3);
        Frequency frequency2 = velocity4.dopplerShift(frequency);
        Frequency frequency3 = velocity2.dopplerShift(frequency);
        do {
            double d4 = (d + d3) / 2.0;
            speed3.setContent(d4);
            Frequency frequency4 = velocity3.dopplerShift(frequency);
            System.out.println("v: (" + (Object)((Object)speed2) + ":" + (Object)((Object)speed3) + ":" + (Object)((Object)speed4) + ") => f: (" + (Object)((Object)frequency2) + ":" + (Object)((Object)frequency4) + ":" + (Object)((Object)frequency3) + ")");
            double d5 = frequency4.getContentInGHz();
            if (d5 < 229.42) {
                d3 = d4;
                speed4.setContent(speed3.getContent());
                frequency3.setContent(frequency4.getContent());
                continue;
            }
            d = d4;
            speed2.setContent(speed3.getContent());
            frequency2.setContent(frequency4.getContent());
        } while (d3 - d > 1.0);
    }

    public void setDrawReceiverBands(boolean bl) {
        this.drawReceiverBands = bl;
    }

    public void setDrawCentreFrequencies(boolean bl) {
        this.drawCentreFrequencies = bl;
    }

    public void setDrawBasebands(boolean bl) {
        this.drawBasebands = bl;
    }

    public void setDrawSideBands(boolean bl) {
        this.drawSideBands = bl;
    }

    public boolean getDrawReceiverBands() {
        return this.drawReceiverBands;
    }

    public boolean getDrawCentreFrequencies() {
        return this.drawCentreFrequencies;
    }

    public boolean getDrawBasebands() {
        return this.drawBasebands;
    }

    public boolean getDrawSideBands() {
        return this.drawSideBands;
    }

    @Override
    protected SpectralSpecDocument getContext() {
        SpectralSpecDocument spectralSpecDocument = null;
        if (this.model != null) {
            SpectralSpecModel spectralSpecModel = (SpectralSpecModel)this.model;
            spectralSpecDocument = spectralSpecModel.getContext();
        }
        return spectralSpecDocument;
    }

    @Override
    protected Velocity getSourceVelocity() {
        Velocity velocity = Velocity.createVelocity();
        if (this.model != null) {
            SpectralSpecModel spectralSpecModel = (SpectralSpecModel)this.model;
            velocity = spectralSpecModel.getSourceVelocity();
        }
        return velocity;
    }

    public boolean mouseOnLo(MouseEvent mouseEvent) {
        SpectralSpec spectralSpec = (SpectralSpec)this.model.getDocument();
        double d = -1000.0;
        int n = -1000;
        if (spectralSpec != null && this.drawSideBands) {
            d = spectralSpec.getLO1Frequency().getContentInGHz();
            n = this.scaleOF(d);
        }
        return (double)Math.abs(mouseEvent.getX() - n) < 10.0;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.pressedX = mouseEvent.getX();
        this.draggingLocally = this.mouseOnAxes(mouseEvent);
        this.draggingLo = this.mouseOnLo(mouseEvent);
        this.pressedMinOF = this.minOF;
        this.pressedMaxOF = this.maxOF;
        if (this.draggingLocally || this.draggingLo) {
            this.setCursor(this.moveCursor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.draggingLocally && !this.draggingLo) {
            if (mouseEvent.getButton() == 1) {
                this.zoomInAtCursor(3.0);
            } else if (mouseEvent.getButton() == 3) {
                this.zoomOutAtCursor(3.0);
            }
            this.repaint();
        }
        if (this.pressedX != mouseEvent.getX()) {
            return;
        }
        this.draggingLocally = false;
        this.draggingLo = false;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.mouseOnAxes(mouseEvent) || this.mouseOnLo(mouseEvent)) {
            this.setCursor(this.handCursor);
        } else {
            this.setCursor(this.zoomCursor);
        }
        this.repaint();
    }
}

