/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.valuetypes;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.obsprep.bo.BOUtilities;
import alma.obsprep.bo.DefaultObservingFrequency;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.FrequencyVerifier;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.valuetypes.ObservingFrequencyModel;
import alma.obsprep.services.sfi.SingleFieldScienceGoalEditor;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class ObservingFrequencyEditor
extends Editor {
    private CorrPolarization previousPolarisationSetting;
    public static final FieldID SINGLE_CONT_CENTRAL_FREQUENCY_FID = new FieldID("ObservingFrequencyEditor.singleContCentralFrequencyFID");
    public static FieldID INPUT_FREQUENCY_VUP = new FieldID("ObservingFrequencyEditor.inputFrequencyVUP");
    private JComboBox standardFrequencyBandJComboBox;
    private ValueUnitPairEditor singleContinuumFrequencyVUPE;
    private JButton resetToStandardButton;

    public ObservingFrequencyEditor(Model model) {
        this.setModel(model);
        this.build();
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (fieldID.equals(SfiSpectralSetupEditor.FID_POLARIZATION)) {
                    CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization((String)object);
                    ObservingFrequencyEditor.this.setupPolarizationSpecificStandardFrequencies(corrPolarization);
                }
            }
        };
        model.getParentModel().subscribe(modelChangeSubscriber);
        model.publish();
    }

    @Override
    public ObservingFrequencyModel getModel() {
        return (ObservingFrequencyModel)super.getModel();
    }

    @Override
    protected void build() {
        JLabel jLabel = new JLabel("Input Frequency Type");
        OTButtonGroup oTButtonGroup = new OTButtonGroup(ObservingFrequency.FrequencyType.getLabels());
        this.initEvents(oTButtonGroup, ObservingFrequencyModel.FREQUENCY_TYPE_FID);
        jLabel = new JLabel("Receiver Band");
        this.standardFrequencyBandJComboBox = new JComboBox();
        this.standardFrequencyBandJComboBox.setName("observingFrequencyEditor.standardFrequencyBandJComboBox");
        this.standardFrequencyBandJComboBox.setToolTipText("<html>List of bands available with the selected polarization.</html>");
        this.standardFrequencyBandJComboBox.setRenderer(new StandardFrequencyComboBoxRenderer());
        this.initEvents(this.standardFrequencyBandJComboBox, ObservingFrequencyModel.BAND_SELECTED_FID);
        this.addLabeledWidget(jLabel, this.standardFrequencyBandJComboBox);
        jLabel = new JLabel();
        this.register(jLabel, ObservingFrequencyModel.EDITOR_LABEL_FID);
        this.resetToStandardButton = new JButton("Reset to Standard Frequency");
        this.resetToStandardButton.setToolTipText("Reset the single continuum central frequency to the band default");
        this.resetToStandardButton.setName("observingFrequencyEditor.resetToStandardButton");
        this.initEvents(this.resetToStandardButton, ObservingFrequencyModel.RESET_TO_STANDARD_FREQ_FID);
        this.addLabeledWidget(new JLabel(""), this.resetToStandardButton);
        this.singleContinuumFrequencyVUPE = new ValueUnitPairEditor(this.getModel().getFrequencyModel());
        this.singleContinuumFrequencyVUPE.setToolTipText("<html>The continuum central frequency in the sky frame.</HTML>");
        this.register(this.singleContinuumFrequencyVUPE, INPUT_FREQUENCY_VUP);
        this.registerSubView(this.singleContinuumFrequencyVUPE);
        this.singleContinuumFrequencyVUPE.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(this.singleContinuumFrequencyVUPE, false));
        this.addLabeledWidget(jLabel, this.singleContinuumFrequencyVUPE);
        UserEditRestrictionController.getInstance().registerUserChangeRestrictionAffectedComponents((List<JComponent>)ImmutableList.of((Object)this.resetToStandardButton, (Object)jLabel, (Object)this.singleContinuumFrequencyVUPE.getInput()));
        jLabel = new JLabel();
        this.register(jLabel, ObservingFrequencyModel.FEEDBACK_LABEL_FID);
        JTextField jTextField = new JTextField();
        jTextField.setToolTipText("Single continuum central frequency in the rest frame");
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        this.register(jTextField, ObservingFrequencyModel.FEEDBACK_AREA_FID);
        this.addLabeledWidget(jLabel, jTextField);
        this.setInsetAboveComponent(5);
        this.setInsetBelowComponent(5);
        this.layoutLabeledWidgets();
    }

    @Override
    public void configureEditorForView(SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews scienceGoalEditorSubviews) {
        if (SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews.VLBI.equals((Object)scienceGoalEditorSubviews)) {
            this.configureEditorForVLBIView();
        } else if (SingleFieldScienceGoalEditor.ScienceGoalEditorSubviews.SOLAR.equals((Object)scienceGoalEditorSubviews)) {
            this.configureEditorForSolarView();
        } else {
            this.configureEditorForStandardView();
        }
    }

    private void configureEditorForStandardView() {
        JComponent jComponent = this.retrieve(ObservingFrequencyModel.RESET_TO_STANDARD_FREQ_FID);
        assert (jComponent != null);
        jComponent.setEnabled(true);
        this.setupPolarizationSpecificStandardFrequencies();
        this.singleContinuumFrequencyVUPE.setEnabled(true);
        UserEditRestrictionController.getInstance().registerUserChangeRestrictionAffectedComponents((List<JComponent>)ImmutableList.of((Object)this.resetToStandardButton, (Object)this.singleContinuumFrequencyVUPE.getInput()));
    }

    private void configureEditorForSolarView() {
        JComponent jComponent = this.retrieve(ObservingFrequencyModel.RESET_TO_STANDARD_FREQ_FID);
        assert (jComponent != null);
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        this.singleContinuumFrequencyVUPE.setEnabled(false);
        this.configureStandardFrequenciesComboBox(OTConfigurationHelper.getFrequencyListAsStr(almaCapabilities.getSolarFrequencies(), Frequency.UNIT_GHZ), false);
        jComponent.setEnabled(false);
        UserEditRestrictionController.getInstance().removeUserChangeRestrictionAffectedComponents((List<JComponent>)ImmutableList.of((Object)this.resetToStandardButton, (Object)this.singleContinuumFrequencyVUPE.getInput()));
    }

    private void configureEditorForVLBIView() {
        JComponent jComponent = this.retrieve(ObservingFrequencyModel.RESET_TO_STANDARD_FREQ_FID);
        assert (jComponent != null);
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        this.singleContinuumFrequencyVUPE.setEnabled(false);
        String[] stringArray = OTConfigurationHelper.getFrequencyListAsStr(almaCapabilities.getVLBIFrequencies(), Frequency.UNIT_GHZ);
        this.configureStandardFrequenciesComboBox(stringArray, false);
        jComponent.setEnabled(false);
        UserEditRestrictionController.getInstance().removeUserChangeRestrictionAffectedComponents((List<JComponent>)ImmutableList.of((Object)this.resetToStandardButton, (Object)this.singleContinuumFrequencyVUPE.getInput()));
    }

    private void setupPolarizationSpecificStandardFrequencies() {
        if (this.previousPolarisationSetting == null) {
            return;
        }
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        String[] stringArray = this.previousPolarisationSetting.equals((Object)CorrPolarization.FULL) ? OTConfigurationHelper.getFrequencyListAsStr(almaCapabilities.getPolarizationFrequencies(), Frequency.UNIT_GHZ) : OTConfigurationHelper.getFrequencyListAsStr(almaCapabilities.getContinuumFrequencies(), Frequency.UNIT_GHZ);
        this.configureStandardFrequenciesComboBox(stringArray, true);
    }

    public void setupPolarizationSpecificStandardFrequencies(CorrPolarization corrPolarization) {
        ObsProposal obsProposal;
        String[] stringArray;
        Object object;
        BusinessObject businessObject;
        if (this.previousPolarisationSetting != null && this.previousPolarisationSetting.equals((Object)corrPolarization)) {
            return;
        }
        if (this.previousPolarisationSetting != null && (this.previousPolarisationSetting.equals((Object)CorrPolarization.DOUBLE) && corrPolarization.equals((Object)CorrPolarization.SINGLE_X) || this.previousPolarisationSetting.equals((Object)CorrPolarization.SINGLE_X) && corrPolarization.equals((Object)CorrPolarization.DOUBLE))) {
            this.previousPolarisationSetting = corrPolarization;
            return;
        }
        Object object2 = this.getModel().getDocument();
        boolean bl = false;
        boolean bl2 = false;
        if (object2 != null && (businessObject = BOUtilities.findTreeRoot((BusinessObject)(object = (stringArray = (String[])object2).getSpectralSetupParameters()))) instanceof ObsProposal && !(bl = (obsProposal = (ObsProposal)businessObject).isVLBI())) {
            try {
                bl2 = ((SpectralSetupParameters)((Object)object)).getScienceGoal().isSolarScienceGoal();
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
        assert (!(bl2 && bl));
        object = AlmaCapabilities.getInstance();
        stringArray = bl ? OTConfigurationHelper.getFrequencyListAsStr(((AlmaCapabilities)object).getVLBIFrequencies(), Frequency.UNIT_GHZ) : (bl2 ? OTConfigurationHelper.getFrequencyListAsStr(((AlmaCapabilities)object).getSolarFrequencies(), Frequency.UNIT_GHZ) : (corrPolarization.equals((Object)CorrPolarization.FULL) ? OTConfigurationHelper.getFrequencyListAsStr(((AlmaCapabilities)object).getPolarizationFrequencies(), Frequency.UNIT_GHZ) : OTConfigurationHelper.getFrequencyListAsStr(((AlmaCapabilities)object).getContinuumFrequencies(), Frequency.UNIT_GHZ)));
        assert (stringArray.length > 0);
        this.configureStandardFrequenciesComboBox(stringArray, false);
        this.previousPolarisationSetting = corrPolarization;
    }

    private void configureStandardFrequenciesComboBox(String[] stringArray, boolean bl) {
        Integer n = (Integer)this.standardFrequencyBandJComboBox.getSelectedItem();
        DefaultComboBoxModel<Integer> defaultComboBoxModel = new DefaultComboBoxModel<Integer>();
        Integer n2 = null;
        for (String string : stringArray) {
            ReceiverBand receiverBand = ReceiverBand.getReceiverBand(Frequency.createFrequencyGHZ(new Double(string)));
            if (n2 == null) {
                n2 = receiverBand.getNumber();
            }
            defaultComboBoxModel.addElement(receiverBand.getNumber());
            if (n == null || !n.equals(receiverBand.getNumber())) continue;
            defaultComboBoxModel.setSelectedItem(n);
            n2 = n;
        }
        this.standardFrequencyBandJComboBox.setModel(defaultComboBoxModel);
        SpectralSetupParametersModel spectralSetupParametersModel = (SpectralSetupParametersModel)this.getModel().getParentModel();
        if (!spectralSetupParametersModel.isConfiguring()) {
            if (!bl) {
                this.getModel().update(null, ObservingFrequencyModel.BAND_SELECTED_FID, n2.toString());
            } else {
                this.singleContinuumFrequencyVUPE.getModel().publish();
            }
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == ObservingFrequencyModel.FREQUENCY_TYPE_FID) {
            String string = (String)object;
            super.update(fieldID, string);
            this.updateLabels(ObservingFrequency.FrequencyType.getFrequencyType(string));
            return;
        }
        if (fieldID == ObservingFrequencyModel.FEEDBACK_AREA_FID) {
            Frequency frequency = (Frequency)((Object)object);
            super.update(fieldID, TextUtils.format(frequency));
            return;
        }
        if (fieldID.equals(ObservingFrequencyModel.BAND_SELECTED_FID)) {
            if (object instanceof Integer) {
                this.set2(this.standardFrequencyBandJComboBox, (Object)((Integer)object));
            }
            return;
        }
        super.update(fieldID, object);
    }

    protected void updateLabels(ObservingFrequency.FrequencyType frequencyType) {
        super.update(ObservingFrequencyModel.EDITOR_LABEL_FID, (Object)frequencyType);
        if (frequencyType == ObservingFrequency.FrequencyType.SKY_FREQUENCY) {
            super.update(ObservingFrequencyModel.FEEDBACK_LABEL_FID, ObservingFrequency.FrequencyType.REST_FREQUENCY.toString());
        } else {
            super.update(ObservingFrequencyModel.FEEDBACK_LABEL_FID, ObservingFrequency.FrequencyType.SKY_FREQUENCY.toString());
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        Frequency frequency = Frequency.createFrequencyGHZ(230.0);
        Velocity velocity = Velocity.createVelocity();
        velocity.setCenterVelocity(Speed.createSpeed((double)100000.0, (String)Speed.UNIT_KM_S));
        DefaultObservingFrequency defaultObservingFrequency = new DefaultObservingFrequency(frequency, velocity);
        final ObservingFrequencyModel observingFrequencyModel = new ObservingFrequencyModel(null);
        ObservingFrequencyEditor observingFrequencyEditor = new ObservingFrequencyEditor(observingFrequencyModel);
        observingFrequencyModel.setDocument(defaultObservingFrequency);
        JButton jButton = new JButton("Print RestFrequency");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("RestFrequency = " + (Object)((Object)observingFrequencyModel.getObservingFrequency().getRestFrequency()));
            }
        });
        JFrame jFrame = new JFrame("ObservingFrequencyEditor Test");
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.setLayout(new BoxLayout(container, 3));
        container.add(observingFrequencyEditor);
        container.add(jButton);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class StandardFrequencyComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public StandardFrequencyComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ReceiverBand receiverBand = ReceiverBand.getReceiverBand((Integer)object);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setText(receiverBand.getNumber() + " [" + receiverBand.getRFMin() + "-" + receiverBand.getRFMax() + " GHz]");
            return this;
        }
    }
}

