/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.bott;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.BOInfo;
import alma.obsprep.bo.BOIntrospector;
import alma.obsprep.bo.BOPropertyDescriptor;
import alma.obsprep.ot.gui.bott.AbstractTreeTableModel;
import alma.obsprep.ot.gui.bott.BOTreeNode;
import alma.obsprep.ot.gui.bott.TreeTableModel;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class BOLargeTTModel
extends AbstractTreeTableModel {
    private String[] columns;

    public BOLargeTTModel(BusinessObject businessObject) throws IntrospectionException {
        super(new BOTreeNode(businessObject));
        this.init((BOTreeNode)this.root);
    }

    private void addChildBO(BOTreeNode bOTreeNode, BusinessObject businessObject, HashMap hashMap) throws IntrospectionException {
        BOTreeNode bOTreeNode2 = new BOTreeNode(businessObject);
        bOTreeNode.add(bOTreeNode2);
        this.computeChildren(bOTreeNode2, hashMap);
    }

    private void collectFieldNames(Class clazz, HashMap hashMap, HashMap hashMap2) throws IntrospectionException {
        if (hashMap2.get(clazz) != null) {
            return;
        }
        hashMap2.put(clazz, clazz);
        BOInfo bOInfo = BOIntrospector.getBOInfo(clazz);
        String[] stringArray = bOInfo.getSimplePropertyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Integer n = (Integer)hashMap.get(string);
            n = n == null ? new Integer(1) : new Integer(n + 1);
            hashMap.put(string, n);
        }
        Class<?>[] classArray = bOInfo.getChildClasses();
        for (int i = 0; i < classArray.length; ++i) {
            this.collectFieldNames(classArray[i], hashMap, hashMap2);
        }
    }

    protected void computeChildren(BOTreeNode bOTreeNode) throws IntrospectionException {
        this.computeChildren(bOTreeNode, new HashMap());
    }

    private void computeChildren(BOTreeNode bOTreeNode, HashMap hashMap) throws IntrospectionException {
        if (bOTreeNode == null) {
            return;
        }
        hashMap.put(bOTreeNode.getBusinessObject(), bOTreeNode);
        BusinessObject businessObject = bOTreeNode.getBusinessObject();
        BOInfo bOInfo = BOIntrospector.getBOInfo(businessObject.getClass());
        BOPropertyDescriptor[] bOPropertyDescriptorArray = bOInfo.getProperties();
        for (int i = 0; i < bOPropertyDescriptorArray.length; ++i) {
            BOPropertyDescriptor bOPropertyDescriptor = bOPropertyDescriptorArray[i];
            if (!bOPropertyDescriptor.isBusinessObject()) continue;
            try {
                BusinessObject[] businessObjectArray;
                Method method = bOPropertyDescriptor.getReadMethod();
                Object object = method.invoke((Object)businessObject, (Object[])null);
                if (object == null || hashMap.get(object) != null) continue;
                if (object.getClass().isArray()) {
                    businessObjectArray = (BusinessObject[])object;
                    for (int j = 0; j < businessObjectArray.length; ++j) {
                        BusinessObject businessObject2 = businessObjectArray[j];
                        this.addChildBO(bOTreeNode, businessObject2, hashMap);
                    }
                    continue;
                }
                businessObjectArray = (BusinessObject[])object;
                this.addChildBO(bOTreeNode, (BusinessObject)businessObjectArray, hashMap);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                boolean bl = false;
            }
        }
    }

    @Override
    public Object getChild(Object object, int n) {
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        BOTreeNode bOTreeNode2 = (BOTreeNode)bOTreeNode.getChildAt(n);
        return bOTreeNode2;
    }

    @Override
    public int getChildCount(Object object) {
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        int n = bOTreeNode.getChildCount();
        return n;
    }

    @Override
    public Class getColumnClass(int n) {
        if (n == 0) {
            return TreeTableModel.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length + 1;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "";
        }
        return this.columns[n - 1];
    }

    public BOTreeNode[] computePathToRoot(BOTreeNode bOTreeNode) {
        Stack stack = new Stack();
        this.recurseToRoot(bOTreeNode, stack);
        BOTreeNode[] bOTreeNodeArray = stack.toArray(new BOTreeNode[stack.size()]);
        return bOTreeNodeArray;
    }

    private void recurseToRoot(BOTreeNode bOTreeNode, Stack stack) {
        if (bOTreeNode == null) {
            return;
        }
        stack.add(0, bOTreeNode);
        this.recurseToRoot((BOTreeNode)bOTreeNode.getParent(), stack);
    }

    @Override
    public Object getValueAt(Object object, int n) {
        if (n == 0) {
            return null;
        }
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        String string = this.getColumnName(n);
        Object object2 = bOTreeNode.getFieldValue(string);
        return object2;
    }

    private void init(BOTreeNode bOTreeNode) throws IntrospectionException {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.collectFieldNames(bOTreeNode.getBusinessObject().getClass(), hashMap, hashMap2);
        this.columns = this.sort(hashMap);
        this.computeChildren(bOTreeNode);
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        if (n == 0) {
            return true;
        }
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        String string = this.getColumnName(n);
        return bOTreeNode.hasProperty(string);
    }

    @Override
    public boolean isLeaf(Object object) {
        BOTreeNode bOTreeNode = (BOTreeNode)object;
        boolean bl = bOTreeNode.isLeaf();
        return bl;
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
    }

    private String[] sort(HashMap hashMap) {
        Object object;
        ColumnName[] columnNameArray = new ColumnName[hashMap.size()];
        Iterator iterator = hashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            int n2 = (Integer)hashMap.get(object);
            columnNameArray[n++] = new ColumnName((String)object, n2);
        }
        object = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                ColumnName columnName = (ColumnName)object;
                ColumnName columnName2 = (ColumnName)object2;
                int n2 = columnName.getFrequency();
                if (n2 != (n = columnName2.getFrequency())) {
                    return n - n2;
                }
                return columnName.getName().compareTo(columnName2.getName());
            }
        };
        Arrays.sort(columnNameArray, object);
        String[] stringArray = new String[columnNameArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = columnNameArray[i].getName();
        }
        return stringArray;
    }

    private class ColumnName {
        private int freq;
        private String name;

        ColumnName(String string, int n) {
            this.name = string;
            this.freq = n;
        }

        int getFrequency() {
            return this.freq;
        }

        String getName() {
            return this.name;
        }
    }
}

