/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.factory;

import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.project.ProjectTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jdesktop.swingx.MultiSplitLayout;
import org.jdesktop.swingx.MultiSplitPane;

public class TreePile
extends JPanel
implements Serializable {
    static int cnt;
    protected MyMultiSplitPane multiSplitPane = new MyMultiSplitPane();
    protected Border normBorder;
    protected LineBorder emphBorder;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        final TreePile treePile = new TreePile(null);
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(treePile);
        jSplitPane.setRightComponent(new JTextArea("sadfsadfsadfsadf", 20, 20));
        JSplitPane jSplitPane2 = new JSplitPane(0);
        jSplitPane2.setTopComponent(jSplitPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        final AbstractAction abstractAction = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComponent jComponent = (JComponent)actionEvent.getSource();
                treePile.remove(jComponent);
            }
        };
        jPanel.add((Component)new JButton(new AbstractAction("add at bottom"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                treePile.addAtBottom("This is the " + cnt++ + ". project", new JScrollPane(new JTree()), abstractAction);
            }
        }), "North");
        jPanel.add((Component)new JTextArea("qqqqqqqqqqqq", 5, 20), "Center");
        jSplitPane2.setBottomComponent(jPanel);
        jFrame.add(jSplitPane2);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public TreePile(GuiFactory guiFactory) {
        super(new BorderLayout());
        this.add((Component)((Object)this.multiSplitPane), "Center");
    }

    public synchronized void addAtBottom(JComponent jComponent, Action action) {
        this.addAtBottom(" ", jComponent, action);
    }

    public synchronized void addAtBottom(String string, JComponent jComponent, Action action) {
        ProjectTree projectTree;
        Entry entry = new Entry(string, jComponent, action);
        this.multiSplitPane.add(entry);
        this.setHighlighted(jComponent, null);
        if (jComponent instanceof ProjectTree && (projectTree = (ProjectTree)jComponent).isDndReadonly()) {
            projectTree.getTree().setBackground(entry.titlebox.getBackground());
        }
    }

    public synchronized void remove(JComponent jComponent) {
        Entry entry = this.getEntryForWidget(jComponent);
        this.multiSplitPane.remove(entry);
    }

    private Entry getEntryForWidget(JComponent jComponent) {
        for (JComponent jComponent2 : this.multiSplitPane.widgets) {
            Entry entry = (Entry)jComponent2;
            if (entry.widget != jComponent) continue;
            return entry;
        }
        return null;
    }

    public void setTitle(ProjectTree projectTree, String string, Color color) {
        Entry entry = this.getEntryForWidget(projectTree);
        if (projectTree.isDndReadonly()) {
            string = string + "  (read-only)";
        }
        entry.setTitle(string, color);
    }

    public void setHighlighted(JComponent jComponent, Color color) {
        Entry entry = this.getEntryForWidget(jComponent);
        if (this.normBorder == null) {
            this.normBorder = new EmptyBorder(2, 2, 2, 2);
        }
        if (this.emphBorder == null || this.emphBorder.getLineColor() != color) {
            this.emphBorder = new LineBorder(color, 2);
        }
        if (color == null) {
            jComponent.setBorder(this.normBorder);
            entry.titlebox.setBackground(null);
        } else {
            jComponent.setBorder(this.emphBorder);
            entry.titlebox.setBackground(color);
        }
    }

    protected static class MyMultiSplitPane
    extends MultiSplitPane {
        protected MultiSplitLayout.Node modelRoot;
        protected ArrayList<JComponent> widgets = new ArrayList();

        protected MyMultiSplitPane() {
            this.setDividerSize(9);
            this.setDividerPainter(new MyDividerPainter());
        }

        public void add(JComponent jComponent) {
            this.widgets.add(jComponent);
            this.sync();
        }

        public void remove(JComponent jComponent) {
            this.widgets.remove(jComponent);
            this.sync();
        }

        private void sync() {
            this.removeAll();
            if (this.widgets.size() == 0) {
                this.modelRoot = new MultiSplitLayout.Leaf("default");
            } else {
                JComponent jComponent = this.widgets.get(0);
                String string = "Widget" + System.identityHashCode(jComponent);
                if (this.widgets.size() == 1) {
                    this.modelRoot = new MultiSplitLayout.Leaf(string);
                    this.add(jComponent, string);
                } else {
                    MultiSplitLayout.Split split = new MultiSplitLayout.Split();
                    split.setRowLayout(false);
                    this.modelRoot = split;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    this.add(jComponent, string);
                    arrayList.add(new MultiSplitLayout.Leaf(string));
                    for (int i = 1; i < this.widgets.size(); ++i) {
                        JComponent jComponent2 = this.widgets.get(i);
                        String string2 = "Widget" + System.identityHashCode(jComponent2);
                        arrayList.add(new MultiSplitLayout.Divider());
                        arrayList.add(new MultiSplitLayout.Leaf(string2));
                        this.add(jComponent2, string2);
                    }
                    split.setChildren(arrayList);
                }
            }
            this.getMultiSplitLayout().setFloatingDividers(true);
            this.getMultiSplitLayout().setModel(this.modelRoot);
            this.revalidate();
            if (this.widgets.size() == 0) {
                this.repaint();
            }
        }

        protected static class MyDividerPainter
        extends MultiSplitPane.DividerPainter {
            protected MyDividerPainter() {
            }

            public void paint(Graphics graphics, MultiSplitLayout.Divider divider) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Rectangle rectangle = divider.getBounds();
                graphics2D.setColor(Color.lightGray);
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                graphics2D.setColor(Color.darkGray);
                int n = rectangle.x + rectangle.width / 2;
                int n2 = rectangle.y + rectangle.height / 2;
                graphics2D.drawLine(n - 10, n2 - 1, n + 10, n2 - 1);
                graphics2D.drawLine(n - 5, n2 + 1, n + 5, n2 + 1);
            }
        }
    }

    protected class Entry
    extends JPanel {
        JComponent widget;
        Box titlebox;
        JLabel lblText;
        JButton btnClose;

        Entry(String string, JComponent jComponent, final Action action) {
            this.widget = jComponent;
            this.titlebox = new Box(0);
            this.titlebox.setOpaque(true);
            this.lblText = new JLabel(string);
            Dimension dimension = this.lblText.getMinimumSize();
            dimension.width = 25;
            this.lblText.setMinimumSize(dimension);
            this.titlebox.setBorder(new EmptyBorder(2, 0, 0, 0));
            this.titlebox.add(this.lblText);
            this.titlebox.add(Box.createHorizontalGlue());
            if (action != null) {
                Icon icon = Icons.closeView;
                this.btnClose = new JButton(icon);
                this.btnClose.setToolTipText("Close");
                this.btnClose.setPreferredSize(new Dimension(icon.getIconWidth() + 3, icon.getIconHeight()));
                this.btnClose.setMargin(new Insets(0, 2, 0, 1));
                this.btnClose.setContentAreaFilled(false);
                this.btnClose.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        actionEvent.setSource(Entry.this.widget);
                        action.actionPerformed(actionEvent);
                    }
                });
                this.titlebox.add(Box.createHorizontalStrut(2));
                this.titlebox.add(this.btnClose);
                this.titlebox.add(Box.createHorizontalStrut(2));
            }
            this.setLayout(new BorderLayout());
            this.add((Component)this.titlebox, "North");
            this.add((Component)this.widget, "Center");
        }

        void setTitle(String string, Color color) {
            this.lblText.setText(string);
            this.lblText.setForeground(color);
        }
    }
}

