/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.obstooluserprefs.FavoriteDirectory;
import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.OTActions;
import alma.obsprep.ot.actions.RejuvenateProject;
import alma.obsprep.ot.actions.SetPerspective;
import alma.obsprep.ot.actions.WizardInteractor;
import alma.obsprep.ot.actions.WizardPerformer;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.gui.bott.BOTTModel;
import alma.obsprep.ot.gui.bott.BOTreeTable;
import alma.obsprep.ot.gui.factory.ScrollPane;
import alma.obsprep.ot.gui.factory.SplitPane;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.factory.TreePile;
import alma.obsprep.ot.gui.feedback.ProblemTableModel;
import alma.obsprep.ot.gui.feedback.ProblemTableSelectionModel;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.PreferencesListener;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import alma.obsprep.ot.gui.toplevel.SplashScreen;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreePanels;
import alma.obsprep.ot.valdef.ProblemListEvent;
import alma.obsprep.ot.valdef.ProblemListListener;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.ValidatorSet;
import alma.obsprep.ot.valdef.others.TestBoCanFindProjectValidator;
import alma.obsprep.ot.valdef.others.TestBoParentValidator;
import alma.obsprep.ot.valdef.others.TestEntityKnowsProjectValidator;
import alma.obsprep.ot.valdef.others.TestEntityRefsNotBrokenValidator;
import alma.obsprep.ot.valdef.others.TestObjectStatusValidator;
import alma.obsprep.ot.valdef.others.TestObsUnitKnowsProjectValidator;
import alma.obsprep.ot.valdef.others.TestTargetAttachmentsValidator;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.util.Convert;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.LoggingSetup;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.WidgetDetective;
import alma.obsprep.util.debug.ModelDebugger;
import alma.obsprep.util.job.ObsprepThreadGroup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IntrospectionException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.help.CSH;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class GuiFactory
implements PreferencesReadWrite {
    private static final int MAX_FILES_IN__FILE_HISTORY = 20;
    private static GuiFactory instance = null;
    private static final String SPLASH_IMAGE_NAME = "ALMASplashImage.png";
    public static final Color COLOR_TEXT_BACKGROUND = UIManager.getColor("text");
    public static final Color COLOR_TEXT_BACKGROUND_SELECTED = UIManager.getColor("textHighlight");
    public static final Color COLOR_TREE_BACKGROUND_SELECTED = UIManager.getColor("Tree.selectionBackground");
    public static final Color COLOR_HEADLINE_BACKGROUND = new Color(138, 226, 52);
    Border insetBorder1 = new EmptyBorder(0, 2, 0, 2);
    ArrayList<Window> windows = new ArrayList();
    private static JFrame defaultOwner;
    private java.util.Map<String, String> fileChoosersFavoriteDirs = new HashMap<String, String>();
    private java.util.Map<Object, JFileChooser> fileChoosers = Collections.synchronizedMap(new HashMap());
    private java.util.Map<Object, RecentFileList> recentFileLists = new HashMap<Object, RecentFileList>();
    private OTActions.ApplicationWide appActions;

    public static Color COLOR_TREE_BACKGROUND_SELECTED_NOFOCUS() {
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color == null) {
            return Color.lightGray;
        }
        return color.brighter();
    }

    public static GuiFactory getFactory() {
        if (instance == null) {
            instance = new GuiFactory();
        }
        return instance;
    }

    private GuiFactory() {
    }

    void dispose() {
        for (Window window : this.windows) {
            window.dispose();
        }
    }

    @Override
    public void readPreferences(ObsToolUserPrefs obsToolUserPrefs) {
        for (FavoriteDirectory favoriteDirectory : obsToolUserPrefs.getFavoriteDirectory()) {
            this.fileChoosersFavoriteDirs.put(favoriteDirectory.getKey(), favoriteDirectory.getDir());
        }
    }

    @Override
    public void writePreferences(ObsToolUserPrefs obsToolUserPrefs) {
        Object object;
        for (Map.Entry<Object, JFileChooser> entry : this.fileChoosers.entrySet()) {
            File file;
            object = entry.getKey();
            if (!(object instanceof String) || (file = entry.getValue().getSelectedFile()) == null) continue;
            File file2 = file.isDirectory() ? file : file.getParentFile();
            this.fileChoosersFavoriteDirs.put((String)object, file2.getAbsolutePath());
        }
        obsToolUserPrefs.clearFavoriteDirectory();
        for (Map.Entry<Object, Object> entry : this.fileChoosersFavoriteDirs.entrySet()) {
            object = new FavoriteDirectory();
            object.setKey((String)entry.getKey());
            object.setDir((String)entry.getValue());
            obsToolUserPrefs.addFavoriteDirectory((FavoriteDirectory)object);
        }
    }

    public JComponent giveNotYetImplementedView(String string) {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("(View \"" + string + "\")"));
        return jPanel;
    }

    protected void addKeyBinding(JComponent jComponent, int n, Action action) {
        InputMap inputMap = jComponent.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(n, 0), action.getValue("Name"));
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.put(action.getValue("Name"), action);
    }

    public JPanel giveLabeledPanel(JLabel jLabel, JComponent jComponent) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    public JLabel givePerspectiveLabel(ObservingToolController observingToolController) {
        final JLabel jLabel = new JLabel();
        jLabel.setToolTipText("Your currently active Perspective");
        jLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        PreferencesListener preferencesListener = new PreferencesListener(){

            @Override
            public void handlePreferencesChanged(ObsToolUserPrefs obsToolUserPrefs) {
                jLabel.setText("Perspective " + obsToolUserPrefs.getPerspective());
            }
        };
        if (observingToolController != null) {
            observingToolController.addPreferencesListener(preferencesListener);
        }
        return jLabel;
    }

    public JFrame giveFrame() {
        if (this.appActions.quit == null) {
            throw new RuntimeException("bug: setApplicationWideActions() has not been called");
        }
        final Action action = this.appActions.quit;
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                action.actionPerformed(null);
            }
        };
        JFrame jFrame = this.giveFrame("");
        jFrame.setIconImage(Icons.otIcon.getImage());
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(windowAdapter);
        return jFrame;
    }

    public JFrame giveFrame(String string) {
        JFrame jFrame = new JFrame(string);
        this.windows.add(jFrame);
        return jFrame;
    }

    static void setParentWindow(JFrame jFrame) {
        defaultOwner = jFrame;
    }

    public JFrame getParentWindow() {
        return defaultOwner;
    }

    public JScrollPane giveScrollPane(JComponent jComponent) {
        return new ScrollPane(jComponent);
    }

    public JLabel giveHeadline(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        jLabel.setOpaque(true);
        jLabel.setBorder(this.insetBorder1);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setBackground(COLOR_HEADLINE_BACKGROUND);
        return jLabel;
    }

    public JList<String> givePerspectivesList() {
        JList<String> jList = new JList<String>();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        jList.setModel(defaultListModel);
        jList.setSelectionMode(0);
        jList.setVisibleRowCount(4);
        defaultListModel.addElement("1");
        defaultListModel.addElement("2");
        return jList;
    }

    public LookAndFeel giveLookAndFeel(String string) {
        if (string.equals("Mac OS X") || string.equals("CDE/Motif")) {
            return null;
        }
        LookAndFeel lookAndFeel = null;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            if (!string.equals(lookAndFeelInfo.getName())) continue;
            try {
                lookAndFeel = (LookAndFeel)Class.forName(lookAndFeelInfo.getClassName()).newInstance();
            }
            catch (Exception exception) {
                Log.logger((Object)this).info("Could not instantiate look and feel: " + exception);
            }
        }
        if (lookAndFeel != null && !lookAndFeel.isSupportedLookAndFeel()) {
            lookAndFeel = null;
        }
        return lookAndFeel;
    }

    public JList<String> giveLookAndFeelList() {
        JList<String> jList = new JList<String>();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        jList.setModel(defaultListModel);
        jList.setSelectionMode(0);
        jList.setVisibleRowCount(4);
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            defaultListModel.addElement(lookAndFeelInfo.getName());
        }
        defaultListModel.removeElement("Mac OS X");
        defaultListModel.removeElement("CDE/Motif");
        return jList;
    }

    public SplashScreen giveSplashScreen(String string) {
        return this.giveSplashScreen(string, null);
    }

    public SplashScreen giveSplashScreen(String string, String string2) {
        SplashScreen splashScreen = new SplashScreen(SPLASH_IMAGE_NAME, string, string2);
        return splashScreen;
    }

    public JSplitPane giveSplitPane(int n) {
        SplitPane splitPane = new SplitPane(n);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerSize(12);
        return splitPane;
    }

    public ProjectTreePanels giveTreePanels(ObservingToolGui observingToolGui, boolean bl) {
        return new ProjectTreePanels(observingToolGui, bl);
    }

    public JScrollPane giveTreeTable(BusinessObject businessObject) throws IntrospectionException {
        BOTTModel bOTTModel = new BOTTModel(businessObject);
        BOTreeTable bOTreeTable = new BOTreeTable(bOTTModel);
        bOTreeTable.setAutoResizeMode(0);
        JScrollPane jScrollPane = new JScrollPane(bOTreeTable);
        jScrollPane.setPreferredSize(new Dimension(750, 200));
        bOTreeTable.doLayout();
        jScrollPane.getViewport().setBackground(Color.white);
        return jScrollPane;
    }

    public JPanel giveCombinedEditorsPanel() {
        CombinedEditorsPanel combinedEditorsPanel = new CombinedEditorsPanel();
        combinedEditorsPanel.setLayout(new BoxLayout(combinedEditorsPanel, 0));
        return combinedEditorsPanel;
    }

    public TreePile giveTreePile() {
        return new TreePile(this);
    }

    JPanel giveSpatialFormPanel() {
        return this.giveGridLayoutPanel();
    }

    JPanel giveSpatialVisualPanel() {
        return this.giveGridLayoutPanel();
    }

    JPanel giveSpectralVisualPanel() {
        return this.giveGridLayoutPanel();
    }

    JComponent giveLogging() {
        LoggingPanel loggingPanel = new LoggingPanel();
        loggingPanel.setName("Logging");
        return loggingPanel;
    }

    JComponent giveProblems() {
        Problems problems = new Problems();
        problems.setName("Problems");
        return problems;
    }

    ProblemPrinter giveProblemPrinter(ObservingToolGui observingToolGui) {
        return new ProblemPrinter(observingToolGui);
    }

    JComponent giveInformation() {
        Information information = new Information();
        information.setName("Information Panel");
        return information;
    }

    private JPanel giveGridLayoutPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<JFileChooser> getFileChoosers() {
        java.util.Map<Object, JFileChooser> map = this.fileChoosers;
        synchronized (map) {
            ArrayList<JFileChooser> arrayList = new ArrayList<JFileChooser>(this.fileChoosers.values());
            return arrayList.iterator();
        }
    }

    public JFileChooser giveFileChooser(Object object) {
        return this.giveFileChooser(object, null);
    }

    public JFileChooser giveFileChooser(Object object, String string) {
        JFileChooser jFileChooser = this.fileChoosers.get(object);
        if (jFileChooser == null) {
            if (object instanceof String && string == null) {
                string = this.fileChoosersFavoriteDirs.get(object);
            }
            final String string2 = object instanceof String ? String.format("RecentFileList-%s.fileList", object) : String.format("RecentFileList-%s.fileList", object.getClass().getName());
            jFileChooser = new JFileChooser(string);
            if (string2 != null) {
                RecentFileList recentFileList = new RecentFileList(jFileChooser);
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                String string3 = preferences.get(string2, null);
                if (string3 != null) {
                    RecentFileList.FileListModel fileListModel = recentFileList.getListModel();
                    String[] stringArray = string3.split(File.pathSeparator);
                    for (int i = stringArray.length - 1; i >= 0; --i) {
                        String string4 = stringArray[i];
                        File file = new File(string4);
                        if (!file.exists()) continue;
                        fileListModel.add(file);
                    }
                }
                this.recentFileLists.put(jFileChooser, recentFileList);
                jFileChooser.setAccessory(recentFileList);
                jFileChooser.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                            if (!(actionEvent.getSource() instanceof JFileChooser)) {
                                return;
                            }
                            JFileChooser jFileChooser = (JFileChooser)actionEvent.getSource();
                            RecentFileList recentFileList = (RecentFileList)GuiFactory.this.recentFileLists.get(jFileChooser);
                            if (recentFileList == null) {
                                return;
                            }
                            File file = jFileChooser.getSelectedFile();
                            recentFileList.add(jFileChooser.getSelectedFile());
                            jFileChooser.setSelectedFile(file);
                            StringBuilder stringBuilder = new StringBuilder(300);
                            HashSet<File> hashSet = new HashSet<File>();
                            for (int i = 0; i < recentFileList.getListModel().getSize(); ++i) {
                                File file2 = recentFileList.getListModel().getElementAt(i);
                                if (hashSet.contains(file2) || i >= 20) continue;
                                if (stringBuilder.length() > 0) {
                                    stringBuilder.append(File.pathSeparator);
                                }
                                hashSet.add(file2);
                                stringBuilder.append(file2.getPath());
                            }
                            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                            preferences.put(string2, stringBuilder.toString());
                            try {
                                preferences.flush();
                            }
                            catch (BackingStoreException backingStoreException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
            this.fileChoosers.put(object, jFileChooser);
        }
        return jFileChooser;
    }

    void setApplicationWideActions(OTActions.ApplicationWide applicationWide) {
        this.appActions = applicationWide;
    }

    private void menuAdd(JMenu jMenu, Action action, String string) {
        boolean bl = action.getValue("SwingSelectedKey") != null;
        JMenuItem jMenuItem = bl ? new JCheckBoxMenuItem(action) : new JMenuItem(action);
        jMenu.add(jMenuItem);
        if (action instanceof OTAction) {
            ((OTAction)action).addComponent(jMenuItem);
        }
        jMenuItem.setName(string);
    }

    public JMenu giveHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        jMenu.setName("HelpMenu");
        jMenu.setMnemonic(72);
        this.menuAdd(jMenu, this.appActions.helpUserManual, "Menu.UserManual");
        this.menuAdd(jMenu, this.appActions.helpReferenceManual, "Menu.ReferenceManual");
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.about, "Menu.About");
        this.menuAdd(jMenu, this.appActions.releasenotes, "Menu.ReleaseNotes");
        return jMenu;
    }

    public JMenu giveSearchMenu() {
        JMenu jMenu = new JMenu("Search");
        jMenu.setName("SearchMenu");
        jMenu.setMnemonic(83);
        this.menuAdd(jMenu, this.appActions.seePreviousProblem, "Menu.PrevProb");
        this.menuAdd(jMenu, this.appActions.seeNextProblem, "Menu.NextProb");
        return jMenu;
    }

    public Action[] giveToolBarActions(OTActions.ProjectTied projectTied) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(projectTied.newProposal);
        arrayList.add(projectTied.newDDTProposal);
        arrayList.add(projectTied.newProject);
        arrayList.add(projectTied.newCommissioningProject);
        arrayList.add(null);
        arrayList.add(projectTied.open);
        arrayList.add(projectTied.retrieve);
        arrayList.add(projectTied.save);
        arrayList.add(null);
        arrayList.add(projectTied.addPhaseIScienceGoal);
        arrayList.add(projectTied.addPhase2ScienceGoal);
        arrayList.add(projectTied.generateSBs);
        arrayList.add(projectTied.runPhaseIIGeneratorBatch);
        arrayList.add(projectTied.addObsUnitSet);
        arrayList.add(projectTied.addSchedblock);
        arrayList.add(null);
        arrayList.add(this.appActions.importStdLibrary);
        arrayList.add(this.appActions.expTimeCalc);
        arrayList.add(projectTied.runProjectSummaryDisplay);
        arrayList.add(null);
        arrayList.add(projectTied.validate);
        arrayList.add(this.appActions.seePreviousProblem);
        arrayList.add(this.appActions.seeNextProblem);
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public JMenu giveDebugMenu(final ObservingToolController observingToolController) {
        final ObservingToolController observingToolController2 = observingToolController;
        JMenu jMenu = new JMenu("Debug");
        jMenu.setMnemonic(68);
        OTActions.ActionProperties actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Activate Perspective 1";
        actionProperties.accelKey = 49;
        jMenu.add(OTActions.createAction(new SetPerspective(observingToolController, "1"), actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Activate Perspective 2";
        actionProperties.accelKey = 50;
        jMenu.add(OTActions.createAction(new SetPerspective(observingToolController, "2"), actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Load Prefs";
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                observingToolController2.jobLoadPreferences().go();
                observingToolController2.jobInitialApplyConnectionPreferences().go();
                observingToolController2.jobInitialApplyGuiPreferences().go();
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Clear JCS Cache";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MiscUtils.resetJCSCache();
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Save Prefs";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                observingToolController2.jobCollectAndSavePreferences().go();
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        JMenu jMenu2 = new JMenu("Change local Loglevel");
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "INFO";
        class ChangeLevel
        extends AbstractAction {
            String level;
            boolean stacktraces;

            ChangeLevel(String string, boolean bl) {
                this.level = string;
                this.stacktraces = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<String> arrayList = InitServices.loggerProvider.loggerNames();
                LoggingSetup.configureDebugging(arrayList, this.level, this.stacktraces);
            }
        }
        abstractAction = new ChangeLevel("INFO", false);
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "FINEST (plus stacktraces)";
        abstractAction = new ChangeLevel("FINEST", true);
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "FINE (plus stacktraces)";
        abstractAction = new ChangeLevel("FINE", true);
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "DEBUG (plus stacktraces)";
        abstractAction = new ChangeLevel("DEBUG", true);
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "TRACE (plus stacktraces)";
        abstractAction = new ChangeLevel("TRACE", true);
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        jMenu.add(jMenu2);
        jMenu2 = new JMenu("Experimental Features");
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Rejuvenate project (ICT-4534)";
        abstractAction = new RejuvenateProject.Action(observingToolController.getGui());
        jMenu2.add(OTActions.createAction(abstractAction, actionProperties));
        jMenu2.add(new AbstractAction("Generate Phase1 SBs"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    final ObsProposal obsProposal = observingToolController.getGui().getPrimaryProject().getObsProposal();
                    WizardInteractor wizardInteractor = new WizardInteractor(){

                        @Override
                        public boolean confirmOverwrite() {
                            return true;
                        }

                        @Override
                        public boolean requestConfirmation(String string) {
                            return true;
                        }

                        @Override
                        public boolean shouldScienceGoalKnowItGotGenerated() {
                            return false;
                        }

                        @Override
                        public AbstractScienceGoal[] getScienceGoals() {
                            return obsProposal.getAbstractScienceGoalScienceGoal();
                        }

                        @Override
                        public void error(String string, Exception exception) {
                            GUIUtilities.warning(null, "Failure while running generator: " + string, exception);
                        }

                        @Override
                        public void busy(boolean bl) {
                        }
                    };
                    WizardPerformer wizardPerformer = new WizardPerformer(wizardInteractor);
                    wizardPerformer.perform();
                }
                catch (UnknownEntityException unknownEntityException) {
                    unknownEntityException.printStackTrace();
                }
            }
        });
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Dbg-Validate active Project";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ValidatorSet validatorSet = new ValidatorSet();
                    validatorSet.registerValidator(new TestBoParentValidator());
                    validatorSet.registerValidator(new TestTargetAttachmentsValidator());
                    validatorSet.registerValidator(new TestEntityKnowsProjectValidator());
                    validatorSet.registerValidator(new TestEntityRefsNotBrokenValidator());
                    validatorSet.registerValidator(new TestObsUnitKnowsProjectValidator());
                    validatorSet.registerValidator(new TestBoCanFindProjectValidator());
                    validatorSet.registerValidator(new TestObjectStatusValidator());
                    ObsProject obsProject = observingToolController.getGui().getActiveProject();
                    ProblemTableModel problemTableModel = observingToolController.getGui().getProblemModel(obsProject);
                    validatorSet.validate((BusinessObject)obsProject, problemTableModel);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Dbg-Render active trees on/off";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ProjectTree projectTree = observingToolController.getGui().activeProjectCompartment().getProjectTreePanels().getPhase1Tree();
                    projectTree.getTree().toggleDebugRendering();
                    projectTree = observingToolController.getGui().activeProjectCompartment().getProjectTreePanels().getPhase2Tree();
                    projectTree.getTree().toggleDebugRendering();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Dump active Project to Text Window";
        abstractAction = new AbstractAction(){
            StringBuilder text = new StringBuilder();

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JFrame jFrame = new JFrame();
                    jFrame.setDefaultCloseOperation(2);
                    JTextArea jTextArea = new JTextArea();
                    jFrame.add(new JScrollPane(jTextArea));
                    this.text.setLength(0);
                    ObsProject obsProject = observingToolController.getGui().activeProjectCompartment().getProjectTreePanels().getObsProject();
                    Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decompose(obsProject);
                    this.print("ObsProject", (BusinessObject)boBundle.boProject);
                    this.print("ObsProposal", (BusinessObject)boBundle.boProposal);
                    this.print("ObsAttachment", (BusinessObject)boBundle.boDocuments);
                    this.print("ObsReview", (BusinessObject)boBundle.boReview);
                    for (SchedBlock schedBlock : boBundle.boSchedblocks) {
                        this.print("SchedBlock", (BusinessObject)schedBlock);
                    }
                    jTextArea.setText(this.text.toString());
                    this.text.setLength(0);
                    jFrame.setSize(650, 800);
                    jFrame.setTitle(new Date() + "   " + obsProject.getProjectName());
                    jFrame.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            void print(String string, BusinessObject businessObject) {
                this.text.append("--- ").append(string).append(" ---\n");
                this.text.append(businessObject != null ? businessObject.toXml() : "none.\n");
                this.text.append("\n");
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Inspect active Project in Model Debugger";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ObsProject obsProject = observingToolController.getGui().activeProjectCompartment().getProjectTreePanels().getObsProject();
                    Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decompose(obsProject);
                    ModelDebugger modelDebugger = new ModelDebugger(boBundle);
                    modelDebugger.showFrame();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Show concurrent Threads";
        abstractAction = new AbstractAction(){
            JDialog d;
            Table ta;
            Timer timer;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.d = new JDialog(observingToolController.getGui().frame, "OT Threads", false);
                this.d.setDefaultCloseOperation(2);
                this.ta = new Table();
                this.d.add(new JScrollPane(this.ta));
                final JButton jButton = new JButton(new AbstractAction("Refresh"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ObsprepThreadGroup obsprepThreadGroup = ObsprepThreadGroup.getInstance();
                        Thread[] threadArray = new Thread[obsprepThreadGroup.activeCount()];
                        obsprepThreadGroup.enumerate(threadArray);
                        final Object[][] objectArray = new Object[threadArray.length][3];
                        for (int i = 0; i < threadArray.length; ++i) {
                            Thread thread = threadArray[i];
                            objectArray[i][0] = thread.getName() + (thread.isDaemon() ? "  [daemon]" : "");
                            int n = thread.getPriority();
                            objectArray[i][1] = (n <= 3 ? "low" : (n >= 8 ? "high" : "normal")) + " (" + n + ")";
                            objectArray[i][2] = thread.getState();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((DefaultTableModel)ta.getModel()).setDataVector(objectArray, new Object[]{"name", "priority", "state"});
                                ColumnResizer.adjustColumnPreferredWidths(ta);
                            }
                        });
                    }
                });
                final JCheckBox jCheckBox = new JCheckBox("Auto-Refresh");
                jCheckBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (((JCheckBox)itemEvent.getSource()).isSelected()) {
                            timer = new Timer(true);
                            timer.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    jButton.doClick();
                                }
                            }, 0L, 2000L);
                        } else {
                            if (timer != null) {
                                timer.cancel();
                            }
                            timer = null;
                        }
                    }
                });
                this.d.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        jCheckBox.setSelected(false);
                    }
                });
                JPanel jPanel = new JPanel();
                jPanel.add(jCheckBox);
                jPanel.add(jButton);
                this.d.add((Component)jPanel, "South");
                jButton.doClick();
                this.d.pack();
                this.d.setVisible(true);
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Run the Widget Detective";
        abstractAction = new AbstractAction(){
            WidgetDetective det;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.det == null) {
                    this.det = new WidgetDetective(observingToolController.heap.getGui().frame);
                }
                this.det.on();
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Check Help IDs";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<Component> arrayList = new ArrayList<Component>();
                Collection<Editor> collection = observingToolController2.getGui().getEditors().getAllEditors();
                for (Editor editor : collection) {
                    arrayList.addAll(this.findGroupPanels(editor));
                }
                this.printRefManMapIDs(arrayList);
                this.printBadRefManMapIDs(arrayList);
            }

            String getParentEditorName(Component component) {
                String string = component.getClass().getSimpleName();
                if (string.equals("GroupPanel")) {
                    string = this.getParentEditorName(component.getParent());
                }
                return string;
            }

            ArrayList<Component> findGroupPanels(Component component) {
                ArrayList<Component> arrayList = new ArrayList<Component>();
                if (component instanceof EditorWithGridBagLayout.GroupPanel) {
                    arrayList.add(component);
                }
                if (component instanceof Container) {
                    for (Component component2 : ((Container)component).getComponents()) {
                        arrayList.addAll(this.findGroupPanels(component2));
                    }
                }
                return arrayList;
            }

            void printRefManMapIDs(ArrayList<Component> arrayList) {
                System.out.println("Component Reference Manual ID Mappings");
                System.out.println("--------------------------------------");
                for (Component component : arrayList) {
                    String string = CSH.getHelpIDString((Component)component);
                    System.out.println(this.getParentEditorName(component) + " --> " + string);
                }
            }

            void printBadRefManMapIDs(ArrayList<Component> arrayList) {
                HelpSet helpSet = observingToolController2.heap.getReferenceManualHS();
                Map map = observingToolController2.heap.getReferenceManualHS().getCombinedMap();
                System.out.println("\nBad Component Reference Manual ID Mappings");
                System.out.println("------------------------------------------");
                for (Component component : arrayList) {
                    String string = CSH.getHelpIDString((Component)component);
                    if (map.isValidID(string, helpSet)) continue;
                    System.out.println(this.getParentEditorName(component) + " --> " + string);
                }
            }

            void printMapIDsOnly() {
                Object object;
                Enumeration enumeration = observingToolController2.heap.getReferenceManualHS().getCombinedMap().getAllIDs();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    String string = object.toString();
                    string = string.substring(4);
                    string = string.split(",")[0];
                    arrayList.add(string);
                }
                Collections.sort(arrayList);
                System.out.println("Complete List Of Reference Manual Mapping IDs");
                System.out.println("---------------------------------------------");
                object = arrayList.iterator();
                while (object.hasNext()) {
                    System.out.println((String)object.next());
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Print Help IDs";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Enumeration enumeration = observingToolController2.heap.getReferenceManualHS().getCombinedMap().getAllIDs();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    String string = object.toString();
                    string = string.substring(4);
                    string = string.split(",")[0];
                    arrayList.add(string);
                }
                Collections.sort(arrayList);
                System.out.println("Complete List Of Reference Manual Mapping IDs");
                System.out.println("---------------------------------------------");
                object = arrayList.iterator();
                while (object.hasNext()) {
                    System.out.println((String)object.next());
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        jMenu.addSeparator();
        actionProperties = new OTActions.ActionProperties();
        actionProperties.name = "Exit without saving preferences";
        abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (GUIUtilities.confirm(null, "Exit without saving preferences?")) {
                        System.exit(0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        jMenu.add(OTActions.createAction(abstractAction, actionProperties));
        return jMenu;
    }

    public JMenu giveEditMenu(OTActions.ProjectTied projectTied) {
        JMenu jMenu = new JMenu("Edit");
        jMenu.setName("EditMenu");
        jMenu.setMnemonic(69);
        this.menuAdd(jMenu, projectTied.cut, "Menu.Cut");
        this.menuAdd(jMenu, projectTied.copy, "Menu.Copy");
        this.menuAdd(jMenu, projectTied.paste, "Menu.Paste");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTied.rename, "Menu.Rename");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTied.addPhaseIScienceGoal, "Menu.AddPh1SG");
        this.menuAdd(jMenu, projectTied.addPhase2ScienceGoal, "Menu.AddSFSG");
        JMenu jMenu2 = new JMenu("Add Observatory Setup");
        this.menuAdd(jMenu2, projectTied.addHolographySetup, "Menu.AddHolSetup");
        this.menuAdd(jMenu2, projectTied.addOpticalPointingScienceGoal, "Menu.AddOPTSG");
        this.menuAdd(jMenu2, projectTied.addRadiometricPointing, "Menu.AddRadioPoint");
        this.menuAdd(jMenu2, projectTied.addBaselineCalibrationGoal, "Menu.AddBaseCalG");
        this.menuAdd(jMenu2, projectTied.addCalibratorSurveyGoal, "Menu.AddCalSurG");
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTied.addObsUnitSet, "Menu.AddOUS");
        this.menuAdd(jMenu, projectTied.addSchedblock, "Menu.AddSB");
        this.menuAdd(jMenu, projectTied.addObservingGroup, "Menu.AddObsGrp");
        this.menuAdd(jMenu, projectTied.addTarget, "Menu.AddTrg");
        this.menuAdd(jMenu, projectTied.addFieldSource, "Menu.AddFS");
        this.menuAdd(jMenu, projectTied.addBLSpectralSpec, "Menu.AddBLSS");
        this.menuAdd(jMenu, projectTied.addACASpectralSpec, "Menu.AddACSSS");
        this.menuAdd(jMenu, projectTied.addSquareLawSpectralSpec, "Menu.AddSqLSS");
        this.menuAdd(jMenu, projectTied.addScienceParameters, "Menu.AddScPar");
        this.menuAdd(jMenu, projectTied.addPhaseCalParameters, "Menu.AddPhCal");
        this.menuAdd(jMenu, projectTied.addPointingCalParameters, "Menu.AddPoiCal");
        this.menuAdd(jMenu, projectTied.addAmplitudeCalParameters, "Menu.AddAmpCal");
        this.menuAdd(jMenu, projectTied.addPolarizationCalParameters, "Menu.AddPolCal");
        this.menuAdd(jMenu, projectTied.addFocusCalParameters, "Menu.AddFocCal");
        this.menuAdd(jMenu, projectTied.addAtmosphericCalParameters, "Menu.AddAtmCal");
        this.menuAdd(jMenu, projectTied.addDelayCalParameters, "Menu.AddDelayCal");
        this.menuAdd(jMenu, projectTied.addCheckSourceCalParameters, "Menu.AddCheckSourceCal");
        this.menuAdd(jMenu, projectTied.addSidebandRatioCalParameters, "Menu.AddSidebandRatioCal");
        this.menuAdd(jMenu, projectTied.addBandpassCalParameters, "Menu.AddBndpsCal");
        this.menuAdd(jMenu, projectTied.addOpticalPointingParameters, "Menu.AddOptPoi");
        this.menuAdd(jMenu, projectTied.addRadiometricPointingParameters, "Menu.AddRadPoi");
        this.menuAdd(jMenu, projectTied.addHolographyParameters, "Menu.AddHolPar");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTied.attachComponents, "Menu.AttachComps");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTied.delete, "Menu.Delete");
        this.menuAdd(jMenu, projectTied.csvSuspend, "Menu.Suspend");
        this.menuAdd(jMenu, projectTied.csvResume, "Menu.Resume");
        this.menuAdd(jMenu, projectTied.repair, "Menu.Repair");
        this.menuAdd(jMenu, projectTied.terminate, "Menu.Terminate");
        return jMenu;
    }

    public JMenu giveToolMenu(OTActions.ProjectTied projectTied) {
        JMenu jMenu = new JMenu("Tool");
        jMenu.setName("ToolMenu");
        jMenu.setMnemonic(84);
        this.menuAdd(jMenu, projectTied.calTool, "Menu.CalTool");
        this.menuAdd(jMenu, projectTied.loTool, "Menu.LoTool");
        this.menuAdd(jMenu, this.appActions.expTimeCalc, "Menu.ETC");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTied.generateSBs, "Menu.Ph2Gen");
        this.menuAdd(jMenu, projectTied.runProjectSummaryDisplay, "Menu.ProjectTimeSummaryDisplay");
        this.menuAdd(jMenu, projectTied.runPhaseIGeneratorBatch, "Menu.Ph1GenBatch");
        this.menuAdd(jMenu, projectTied.runPhaseIIGeneratorBatch, "Menu.Ph2GenBatch");
        this.menuAdd(jMenu, projectTied.exportSB, "Menu.ExportSB");
        this.menuAdd(jMenu, projectTied.scienceGoalFeedback, "Menu.SGFeedback");
        this.menuAdd(jMenu, projectTied.generateWholePDF, "Menu.GenWholePDF");
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.disableOusCompProtect, "Menu.DisableProtect");
        return jMenu;
    }

    public JMenu giveViewMenu(OTActions.ProjectTied projectTied) {
        JMenu jMenu = new JMenu("View");
        jMenu.setName("ViewMenu");
        jMenu.setMnemonic(86);
        this.menuAdd(jMenu, this.appActions.viewFeedback, "Menu.ViewFeedback");
        this.menuAdd(jMenu, this.appActions.viewOverview, "Menu.ViewOverview");
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTied.expandNodes, "Menu.Expand");
        this.menuAdd(jMenu, projectTied.findPreviousSimilarNodeInProjectTree, "Menu.FindPreviousSimilarNode");
        this.menuAdd(jMenu, projectTied.findNextSimilarNodeInProjectTree, "Menu.FindNextSimilarNode");
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.importStdLibrary, "Menu.ViewStdLib");
        return jMenu;
    }

    public JMenu giveFileMenu(OTActions.ProjectTied projectTied) {
        JMenu jMenu = new JMenu("File");
        jMenu.setName("FileMenu");
        jMenu.setMnemonic(70);
        this.menuAdd(jMenu, projectTied.newProposal, "Menu.NewProp");
        this.menuAdd(jMenu, projectTied.newDDTProposal, "Menu.NewDDTProp");
        this.menuAdd(jMenu, projectTied.newProject, "Menu.NewProj");
        this.menuAdd(jMenu, projectTied.newCommissioningProject, "Menu.NewCommProj");
        this.menuAdd(jMenu, projectTied.newVLBIProject, "Menu.NewVLBIProj");
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Open Project");
        jMenu2.setName("OpenProjectMenu");
        this.menuAdd(jMenu2, projectTied.open, "Menu.Open");
        this.menuAdd(jMenu2, projectTied.openfind, "Menu.OpenFind");
        this.menuAdd(jMenu2, projectTied.retrieve, "Menu.Retrieve");
        jMenu.add(jMenu2);
        jMenu2 = new JMenu("Open Project as New Proposal");
        jMenu2.setName("OpenProjectAsNew.Menu");
        this.menuAdd(jMenu2, projectTied.retrieveAsNewProposal, "Menu.RetrieveAsNew");
        this.menuAdd(jMenu2, projectTied.retrieveAsNewDDTProposal, "Menu.RetrieveAsNew");
        jMenu.add(jMenu2);
        this.menuAdd(jMenu, projectTied.save, "Menu.Save");
        this.menuAdd(jMenu, projectTied.saveAs, "Menu.SaveAs");
        if (MiscUtils.isDeveloperUIFeaturesEnabled()) {
            this.menuAdd(jMenu, projectTied.revertProjectFromDisk, "Menu.RevertProjectFromDisk");
        }
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.importStdLibrary, "Menu.ImpStdLib");
        jMenu2 = new JMenu("Use Project as Template");
        jMenu2.setName("UseTemplateMenu");
        this.menuAdd(jMenu2, this.appActions.importLibrary, "Menu.ImpLib");
        this.menuAdd(jMenu2, this.appActions.retrieveLibrary, "Menu.RetrieveLib");
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        this.menuAdd(jMenu, projectTied.validate, "Menu.Validate");
        this.menuAdd(jMenu, projectTied.submit, "Menu.Submit");
        this.menuAdd(jMenu, projectTied.submitAsNew, "Menu.SubmitAsNew");
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.preferencesDialog, "Menu.ShowPrefs");
        this.menuAdd(jMenu, this.appActions.savePreferences, "Menu.SavePrefs");
        jMenu.addSeparator();
        this.menuAdd(jMenu, this.appActions.quit, "Menu.Quit");
        return jMenu;
    }

    protected ArrayList<Action> givePhase2TreePopupMenuItemList(OTActions.ProjectTied projectTied) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(projectTied.cut);
        arrayList.add(projectTied.copy);
        arrayList.add(projectTied.paste);
        arrayList.add(null);
        arrayList.add(projectTied.addPhase2ScienceGoal);
        arrayList.add(projectTied.runPhaseIIGeneratorBatch);
        arrayList.add(null);
        arrayList.add(projectTied.addOpticalPointingScienceGoal);
        arrayList.add(projectTied.addRadiometricPointing);
        arrayList.add(projectTied.addBaselineCalibrationGoal);
        arrayList.add(projectTied.addCalibratorSurveyGoal);
        arrayList.add(projectTied.addHolographySetup);
        arrayList.add(projectTied.generateSBs);
        arrayList.add(projectTied.rename);
        arrayList.add(projectTied.addObsUnitSet);
        arrayList.add(projectTied.addSchedblock);
        arrayList.add(null);
        arrayList.add(projectTied.addObservingGroup);
        arrayList.add(projectTied.addTarget);
        arrayList.add(projectTied.addFieldSource);
        arrayList.add(projectTied.addBLSpectralSpec);
        arrayList.add(projectTied.addACASpectralSpec);
        arrayList.add(projectTied.addSquareLawSpectralSpec);
        arrayList.add(projectTied.addOpticalCameraSpec);
        arrayList.add(projectTied.addScienceParameters);
        arrayList.add(projectTied.addPhaseCalParameters);
        arrayList.add(projectTied.addPointingCalParameters);
        arrayList.add(projectTied.addAmplitudeCalParameters);
        arrayList.add(projectTied.addPolarizationCalParameters);
        arrayList.add(projectTied.addFocusCalParameters);
        arrayList.add(projectTied.addAtmosphericCalParameters);
        arrayList.add(projectTied.addDelayCalParameters);
        arrayList.add(projectTied.addCheckSourceCalParameters);
        arrayList.add(projectTied.addSidebandRatioCalParameters);
        arrayList.add(projectTied.addBandpassCalParameters);
        arrayList.add(projectTied.addOpticalPointingParameters);
        arrayList.add(projectTied.addRadiometricPointingParameters);
        arrayList.add(projectTied.addHolographyParameters);
        arrayList.add(null);
        arrayList.add(projectTied.attachComponents);
        arrayList.add(projectTied.setRepresentativeTarget);
        arrayList.add(null);
        arrayList.add(projectTied.expandNodes);
        arrayList.add(projectTied.collapseNodes);
        arrayList.add(projectTied.findPreviousSimilarNodeInProjectTree);
        arrayList.add(projectTied.findNextSimilarNodeInProjectTree);
        arrayList.add(null);
        arrayList.add(projectTied.delete);
        arrayList.add(projectTied.csvSuspend);
        arrayList.add(projectTied.csvResume);
        arrayList.add(projectTied.repair);
        arrayList.add(projectTied.terminate);
        return arrayList;
    }

    protected ArrayList<Action> givePhase1TreePopupMenuItemList(OTActions.ProjectTied projectTied) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(projectTied.cut);
        arrayList.add(projectTied.copy);
        arrayList.add(projectTied.paste);
        arrayList.add(null);
        arrayList.add(projectTied.addPhaseIScienceGoal);
        arrayList.add(projectTied.scienceGoalFeedback);
        arrayList.add(projectTied.generateWholePDF);
        arrayList.add(projectTied.runProjectSummaryDisplay);
        arrayList.add(projectTied.rename);
        arrayList.add(null);
        arrayList.add(projectTied.expandNodes);
        arrayList.add(projectTied.collapseNodes);
        arrayList.add(projectTied.findPreviousSimilarNodeInProjectTree);
        arrayList.add(projectTied.findNextSimilarNodeInProjectTree);
        arrayList.add(null);
        arrayList.add(projectTied.delete);
        return arrayList;
    }

    public class RecentFileList
    extends JPanel {
        private final JList<File> list;
        private final FileListModel listModel;
        private final JFileChooser fileChooser;

        public FileListModel getListModel() {
            return this.listModel;
        }

        public RecentFileList(JFileChooser jFileChooser) {
            this.fileChooser = jFileChooser;
            this.listModel = new FileListModel();
            this.list = new JList<File>(this.listModel);
            this.list.setSelectionMode(0);
            this.list.setCellRenderer(new FileListCellRenderer());
            this.setLayout(new BorderLayout());
            this.add(new JScrollPane(this.list));
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    File file = null;
                    try {
                        file = (File)RecentFileList.this.list.getSelectedValue();
                        if (file.exists()) {
                            RecentFileList.this.fileChooser.setSelectedFile(file);
                            if (mouseEvent.getClickCount() == 2) {
                                RecentFileList.this.fileChooser.approveSelection();
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            };
            this.list.addMouseListener(mouseAdapter);
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        try {
                            File file = (File)RecentFileList.this.list.getSelectedValue();
                            if (file.exists()) {
                                RecentFileList.this.fileChooser.setSelectedFile(file);
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }
            });
        }

        public void clearList() {
            this.listModel.clear();
        }

        public void add(File file) {
            this.listModel.add(file);
            this.list.setSelectedIndex(0);
        }

        public class FileListCellRenderer
        extends DefaultListCellRenderer {
            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object instanceof File) {
                    File file = (File)object;
                    Icon icon = FileSystemView.getFileSystemView().getSystemIcon(file);
                    this.setIcon(icon);
                    this.setToolTipText(file.getParent());
                    this.setText(file.getName());
                }
                return this;
            }
        }

        public class FileListModel
        extends AbstractListModel<File> {
            private List<File> files = new ArrayList<File>();

            public void add(File file) {
                if (this.files.contains(file)) {
                    this.files.remove(file);
                }
                if (this.files.isEmpty()) {
                    this.files.add(file);
                } else {
                    this.files.add(0, file);
                }
                this.fireIntervalAdded(this, 0, 0);
            }

            public void clear() {
                int n = this.files.size() - 1;
                if (n >= 0) {
                    this.files.clear();
                    this.fireIntervalRemoved(this, 0, n);
                }
            }

            @Override
            public int getSize() {
                return this.files.size();
            }

            @Override
            public File getElementAt(int n) {
                return this.files.get(n);
            }
        }
    }

    class CombinedEditorsPanel
    extends JPanel
    implements Scrollable {
        public CombinedEditorsPanel() {
        }

        public CombinedEditorsPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 100;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 15;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }
    }

    class SpatialVisualEditor
    extends JPanel {
        SpatialVisualEditor() {
            this.setLayout(new BorderLayout());
            this.add(new JLabel(Icons.getIcon("SpatialVisualEditor")));
        }
    }

    class FoldTextPane
    extends JEditorPane
    implements HyperlinkListener {
        protected String collapseHandle;
        protected String expandHandle;
        protected String messageDescription;
        protected String messageTitle;

        public FoldTextPane(String string, String string2) {
            this.messageTitle = string;
            this.messageDescription = string2;
            this.expandHandle = "<a href='file://expand'><em>(click for details)</em></a>";
            this.collapseHandle = "<a href='file://collapse'><em>(hide details)</em></a>";
            this.setEditable(false);
            this.setContentType("text/html");
            this.addHyperlinkListener(this);
            this.showShortDescription();
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String string = hyperlinkEvent.getURL().toString().substring(7);
            if ("expand".equals(string)) {
                this.showLongDescription();
            }
            if ("collapse".equals(string)) {
                this.showShortDescription();
            }
        }

        public void showLongDescription() {
            this.setText(this.messageTitle + "&nbsp;&nbsp;" + this.collapseHandle + "<br>" + this.messageDescription);
        }

        public void showShortDescription() {
            this.setText(this.messageTitle + "&nbsp;&nbsp;" + this.expandHandle);
        }
    }

    class Information
    extends JPanel {
        Box box;

        Information() {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.setBackground(new JEditorPane().getBackground());
            this.box = new Box(1);
            this.add((Component)this.box, "North");
        }

        public void addMessage(String string, String string2) {
            this.box.add(new FoldTextPane(string, string2));
            this.validate();
        }
    }

    class ProblemPrinter
    implements ProblemListListener {
        private ProblemListModel model;
        private ObservingToolGui gui;

        ProblemPrinter(ObservingToolGui observingToolGui) {
            this.gui = observingToolGui;
        }

        void setModel(ProblemListModel problemListModel) {
            if (this.model != null) {
                this.model.removeProblemListListener(this);
            }
            this.model = problemListModel;
            this.model.addProblemListListener(this);
        }

        @Override
        public void problemListChanged(ProblemListEvent problemListEvent) {
            if (problemListEvent.getType() == 1062) {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                this.compileResults(stringBuffer, stringBuffer2);
                String string = stringBuffer.toString();
                String string2 = stringBuffer2.toString();
                this.gui.addInformationMessage(string, string2);
            }
        }

        private void compileResults(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            int n = 0;
            int n2 = 0;
            stringBuffer2.append("<table>");
            for (int i = 0; i < this.model.getSize(); ++i) {
                Problem problem = this.model.getProblemAt(i);
                if (problem.isError()) {
                    ++n2;
                } else if (problem.isWarning()) {
                    ++n;
                }
                stringBuffer2.append("<tr><td rowspan=1 valign=top>");
                stringBuffer2.append(problem.getSeverity());
                stringBuffer2.append(" in ");
                String string = problem.getResource().toString();
                if (problem.getResource() instanceof BusinessObject) {
                    string = ((BusinessObject)problem.getResource()).getNameOrDefault();
                }
                stringBuffer2.append(string);
                stringBuffer2.append("</td></tr>");
                stringBuffer2.append("<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                stringBuffer2.append(problem.getDescription());
                stringBuffer2.append("</td></tr>");
                stringBuffer2.append("<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                stringBuffer2.append(problem.getSuggestion());
                stringBuffer2.append("</td></tr>");
            }
            stringBuffer2.append("</table>");
            stringBuffer.append(Convert.convertToDateTime(new Date()));
            stringBuffer.append("&nbsp; Project ");
            if (n2 > 0) {
                stringBuffer.append("FAILED");
            } else {
                stringBuffer.append("PASSED");
            }
            stringBuffer.append(" validation with ");
            stringBuffer.append(n2);
            stringBuffer.append(" error");
            if (n2 != 1) {
                stringBuffer.append('s');
            }
            stringBuffer.append(" and ");
            stringBuffer.append(n);
            stringBuffer.append(" warning");
            if (n != 1) {
                stringBuffer.append('s');
            }
        }
    }

    class Problems
    extends JPanel {
        private ProblemTableModel model;
        private ProblemTableSelectionModel selectionModel;
        private Table table;
        private JLabel lblStatus;
        private ProblemListListener titleMaker = new ProblemListListener(){

            @Override
            public void problemListChanged(ProblemListEvent problemListEvent) {
                if (problemListEvent.getType() == 1064 || problemListEvent.getType() == 1065) {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = 0;
                    int n2 = 0;
                    for (int i = 0; i < Problems.this.model.getSize(); ++i) {
                        Problem problem = Problems.this.model.getProblemAt(i);
                        if (problem.isError()) {
                            ++n;
                            continue;
                        }
                        if (!problem.isWarning()) continue;
                        ++n2;
                    }
                    stringBuilder.append(n);
                    stringBuilder.append(" error");
                    if (n != 1) {
                        stringBuilder.append('s');
                    }
                    stringBuilder.append(", ");
                    stringBuilder.append(n2);
                    stringBuilder.append(" warning");
                    if (n2 != 1) {
                        stringBuilder.append('s');
                    }
                    if (n2 > 0 || n > 0) {
                        stringBuilder.append(" : double-click on each row to be taken to the problem");
                    }
                    Problems.this.setStatusText(stringBuilder.toString());
                }
            }
        };
        TableCellRenderer plainRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                ((JComponent)component).setToolTipText(String.valueOf(object));
                return component;
            }
        };
        TableCellRenderer htmlRenderer = new DefaultTableCellRenderer(){
            StringBuilder buffy = new StringBuilder(2048);

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.buffy.setLength(0);
                this.buffy.append("<html>");
                this.buffy.append(String.valueOf(object));
                this.buffy.append("</html>");
                String string = this.buffy.toString();
                Component component = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
                ((JComponent)component).setToolTipText(string);
                return component;
            }
        };
        TableCellRenderer severityRenderer = new DefaultTableCellRenderer(){
            final String errorCaption = DefaultProblem.createError(null, null, null).getSeverity();
            final String warningCaption = DefaultProblem.createWarning(null, null, null).getSeverity();
            final String successCaption = DefaultProblem.createSuccess(null, null, null).getSeverity();
            final String infoCaption = DefaultProblem.createInfo(null, null, null).getSeverity();

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Icon icon = null;
                String string = String.valueOf(object);
                icon = string.equals(this.errorCaption) ? Icons.error : (string.equals(this.warningCaption) ? Icons.warning : (string.equals(this.infoCaption) ? Icons.info : (string.equals(this.successCaption) ? Icons.okay : null)));
                super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
                this.setIcon(icon);
                this.setToolTipText(string);
                return this;
            }
        };

        Problems() {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.setBackground(new JEditorPane().getBackground());
            this.lblStatus = new JLabel(" ");
            this.add((Component)this.lblStatus, "North");
            this.model = new ProblemTableModel();
            this.table = new Table(this.model);
            this.table.getTableHeader().setReorderingAllowed(false);
            JScrollPane jScrollPane = GuiFactory.this.giveScrollPane(this.table);
            this.add((Component)jScrollPane, "Center");
        }

        void addExamples() {
            SchedBlock schedBlock = SchedBlock.createSchedBlock();
            String string = "Reduce the number of target areas in the scheduling block - perhaps creating a new scheduling block for some of them.";
            this.model.add(DefaultProblem.createWarning("Too many target areas.", string, schedBlock));
            this.model.add(DefaultProblem.createError("Parameter warp is out of range.", "Decrease parameter to avoid warp core implosion", null));
            this.model.add(DefaultProblem.createWarning("Too many target areas.", string, schedBlock));
            this.model.add(DefaultProblem.createError("Parameter <em>warp</em> is out of range.", "Decrease parameter to avoid <font color=red>warp core implosion!</font>", null));
            this.model.add(DefaultProblem.createWarning("Too many target areas.", string, schedBlock));
            this.model.add(DefaultProblem.createError("Parameter warp is out of range.", "Decrease parameter to avoid warp core implosion", null));
            this.model.add(DefaultProblem.createWarning("Too many target areas.", string, schedBlock));
            this.model.add(DefaultProblem.createError("Parameter warp is out of range.", "Decrease parameter to avoid warp core implosion", null));
        }

        void setModel(ProblemTableModel problemTableModel) {
            if (this.model != null) {
                this.model.removeProblemListListener(this.titleMaker);
            }
            this.model = problemTableModel;
            this.table.setModel(this.model);
            this.table.setRowSorter(new TableRowSorter<ProblemTableModel>(this.model));
            this.selectionModel = new ProblemTableSelectionModel(this.model);
            this.table.setSelectionModel(this.selectionModel);
            this.model.addProblemListListener(this.titleMaker);
            this.setStatusText(" ");
            this.table.setDefaultRenderer(String.class, this.htmlRenderer);
            this.table.getColumn(" ").setCellRenderer(this.severityRenderer);
            this.table.getColumn(" ").setMaxWidth(25);
            this.table.getColumn("Description").setPreferredWidth(90);
            this.table.getColumn("Suggestion").setPreferredWidth(190);
        }

        public void setStatusText(String string) {
            this.lblStatus.setText(string);
        }

        public Problem get(int n) {
            int n2 = this.table.convertRowIndexToModel(n);
            return this.model.getProblemAt(n2);
        }

        public void addTableActionListener(ActionListener actionListener) {
            this.table.addActionListener(actionListener);
        }

        public void removeTableActionListener(ActionListener actionListener) {
            this.table.removeActionListener(actionListener);
        }

        public int nextIndexInCycle(boolean bl) {
            return this.selectionModel.nextIndexInCycle(bl);
        }

        public void setSelectedIndex(int n) {
            this.selectionModel.setSelectionInterval(n, n);
        }

        public void doAction(int n) {
            this.table.doAction(n);
        }

        public void scrollTo(int n) {
            Rectangle rectangle = this.table.getCellRect(n, 0, true);
            this.table.scrollRectToVisible(rectangle);
        }
    }

    class LoggingPanel
    extends JPanel {
        JLabel label;
        JTextArea text;

        LoggingPanel() {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.setBackground(new JEditorPane().getBackground());
            this.label = new JLabel("This window shows application warnings and errors. The full log is in file 'ot.log'");
            this.text = new JTextArea();
            this.add((Component)this.label, "North");
            this.add((Component)this.text, "Center");
        }

        public void addMessage(String string) {
            this.text.append(string);
            this.validate();
        }
    }

    public static class Dialog
    extends JDialog {
        public void setDefaultButton(JButton jButton) {
            this.getRootPane().setDefaultButton(jButton);
        }

        public Dialog() {
            super(defaultOwner);
            GuiFactory.getFactory().windows.add(this);
            InputMap inputMap = this.getRootPane().getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "esc");
            AbstractAction abstractAction = new AbstractAction(this){
                final /* synthetic */ Dialog this$0;
                {
                    this.this$0 = dialog;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.setVisible(false);
                }
            };
            this.getRootPane().getActionMap().put("esc", abstractAction);
        }

        public Dialog(Frame frame) {
            super(frame != null ? frame : defaultOwner);
            GuiFactory.getFactory().windows.add(this);
            InputMap inputMap = this.getRootPane().getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "esc");
            AbstractAction abstractAction = new /* invalid duplicate definition of identical inner class */;
            this.getRootPane().getActionMap().put("esc", abstractAction);
        }

        @Override
        public void setVisible(boolean bl) {
            if (bl) {
                this.centreOnMonitor();
            }
            EventQueue.invokeLater(() -> {
                this.toFront();
                this.repaint();
            });
            super.setVisible(bl);
        }

        public void rescaleToMonitor(double d) {
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            this.handleControlDisplay(rectangle);
            int n = (int)((double)rectangle.width * d);
            int n2 = (int)((double)rectangle.height * d);
            int n3 = rectangle.x + (rectangle.width - n) / 2;
            int n4 = rectangle.y + (rectangle.height - n2) / 2;
            this.setSize(n, n2);
            this.setLocation(n3, n4);
        }

        public void centreOnMonitor() {
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            Dimension dimension = this.getSize();
            this.handleControlDisplay(rectangle);
            int n = dimension.width;
            int n2 = dimension.height;
            int n3 = rectangle.x + rectangle.width / 2 - n / 2;
            int n4 = rectangle.y + rectangle.height / 2 - n2 / 2;
            this.setLocation(n3, n4);
        }

        private void handleControlDisplay(Rectangle rectangle) {
            double d = 1.0 * (double)rectangle.width / (double)rectangle.height;
            if (d > 2.7) {
                rectangle.width /= 2;
                Rectangle rectangle2 = defaultOwner.getGraphicsConfiguration().getBounds();
                if (rectangle2.getCenterX() > (double)rectangle.width) {
                    rectangle.x += rectangle.width;
                }
            }
        }
    }
}

