/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.bo.EntityIDFactory;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.EntityIdFactoryImpl;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.util.LogLoggerProviderImpl;
import alma.obsprep.util.LoggingSetup;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.PropertyHandler;
import alma.obsprep.util.UnitMapConfigurator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;

public class InitServices {
    public static final File ALMAOT_FOLDER = new File(System.getProperty("user.home"), ".almaot");
    public static final File ALMAOT_BACKUP_FOLDER = new File(ALMAOT_FOLDER, "backups");
    private static final String VERSION_PROPERTIES_FILE = "version.properties";
    private static final String VERSION_USER = "version.user";
    private static final String VERSION_ALMA = "version.alma";
    private static final String VERSION_PATCH = "version.patch";
    private static String userVersion = "";
    private static String almaVersion = "";
    private static String patchVersion = "";
    private static PropertyHandler propertyHandler = new PropertyHandler(ALMAOT_FOLDER);
    static LogLoggerProviderImpl loggerProvider;
    private static AtomicBoolean init;
    private static AtomicBoolean initModelSupportClasses;

    private static void loadVersionProperties(String string) {
        try {
            File file = new File("config");
            URL uRL = MiscUtils.findResource(file, string);
            InputStream inputStream = uRL.openStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            userVersion = properties.getProperty(VERSION_USER, "");
            almaVersion = properties.getProperty(VERSION_ALMA, "");
            patchVersion = properties.getProperty(VERSION_PATCH, "");
            System.setProperty(VERSION_USER, userVersion);
            System.setProperty(VERSION_ALMA, almaVersion);
            System.setProperty(VERSION_PATCH, patchVersion);
        }
        catch (Throwable throwable) {
            System.setProperty(VERSION_USER, "");
            System.setProperty(VERSION_ALMA, "");
            System.setProperty(VERSION_PATCH, "");
        }
    }

    public static String getUserVersion() {
        return System.getProperty(VERSION_USER);
    }

    public static String getAlmaVersion() {
        return System.getProperty(VERSION_ALMA);
    }

    public static String getPatchVersion() {
        return System.getProperty(VERSION_PATCH);
    }

    public static String getFullAlmaVersion() {
        return InitServices.getAlmaVersion() + InitServices.getPatchVersion();
    }

    public static PropertyHandler getPropertyHandler() {
        return propertyHandler;
    }

    private static void init(boolean bl) throws IOException {
        if (!init.getAndSet(true)) {
            loggerProvider = new LogLoggerProviderImpl();
            Log.setRuntimeImplementation((Log.LoggerProvider)loggerProvider);
            EntityIdFactoryImpl entityIdFactoryImpl = new EntityIdFactoryImpl();
            ImpexFactory.addProjectImportListener(entityIdFactoryImpl);
            EntityIDFactory.setRuntimeImplementation((EntityIDFactory)entityIdFactoryImpl);
            UnitMapConfigurator.configureUnitMaps();
            String string = InitServices.getPropertyHandler().getProperty("alma.obsprep.versionproperties");
            if (string == null) {
                string = VERSION_PROPERTIES_FILE;
            }
            InitServices.loadVersionProperties(string);
            propertyHandler.loadSystemProperties();
            InitServices.initialiseJCSCache();
            if (bl) {
                LoggingSetup.configureBasicSetup();
                LoggingSetup.configureLoggers(loggerProvider.loggerNames());
            }
            Log.logger(InitServices.class).config("Running with version.properties file : " + string);
            Log.logger(InitServices.class).config("Running with these Java System Properties:\n" + InitServices.propertyHandler.REPORT);
        }
    }

    public static void initS() throws IOException {
        InitServices.init(false);
    }

    public static void init() throws IOException {
        InitServices.init(true);
    }

    public static void initModelSupportClasses() {
        if (!init.get() && !initModelSupportClasses.getAndSet(true)) {
            loggerProvider = new LogLoggerProviderImpl();
            Log.setRuntimeImplementation((Log.LoggerProvider)loggerProvider);
            EntityIdFactoryImpl entityIdFactoryImpl = new EntityIdFactoryImpl();
            ImpexFactory.addProjectImportListener(entityIdFactoryImpl);
            EntityIDFactory.setRuntimeImplementation((EntityIDFactory)entityIdFactoryImpl);
            UnitMapConfigurator.configureUnitMaps();
        }
    }

    private static void initialiseJCSCache() {
        CompositeCacheManager compositeCacheManager = CompositeCacheManager.getUnconfiguredInstance();
        try {
            File file = new File("config");
            URL uRL = MiscUtils.findResource(file, "jcscache.properties");
            InputStream inputStream = uRL.openStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            compositeCacheManager.configure(properties);
        }
        catch (Throwable throwable) {
            Log.logger(InitServices.class).info("Fatal: Unable to configure JCS cache -" + throwable.getMessage());
            System.exit(-2);
        }
    }

    static {
        init = new AtomicBoolean();
        initModelSupportClasses = new AtomicBoolean();
    }
}

