/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.EntityIdFactoryImpl;
import alma.obsprep.bo.MultipartBOComponent;
import alma.obsprep.bo.annotations.AttachableToTarget;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnit;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.ObsUnitData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.GuiApi;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.MultipageView;
import alma.obsprep.guiutil.mvc.MultipageViewException;
import alma.obsprep.guiutil.mvc.View;
import alma.obsprep.guiutil.mvc.widgets.IndeterminateProgressMonitor;
import alma.obsprep.guiutil.perspectives.BadLookAndFeelException;
import alma.obsprep.guiutil.perspectives.PerspectivePane;
import alma.obsprep.guiutil.perspectives.UndefinedPerspectiveException;
import alma.obsprep.guiutil.perspectives.ViewPane;
import alma.obsprep.obstooluserprefs.DialogSettings;
import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.obstooluserprefs.types.DefaultEditorTypeType;
import alma.obsprep.obstooluserprefs.types.TabPlacementType;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.OTActions;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.misc.SummaryTableEditor;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.editors.obsproject.ObsProjectEditor;
import alma.obsprep.ot.editors.obsproject.ObsProposalEditor;
import alma.obsprep.ot.editors.schedblock.ObservingGroupEditor;
import alma.obsprep.ot.editors.schedblock.SchedBlockEditor;
import alma.obsprep.ot.editors.schedblock.SpectralSpecFormEditor;
import alma.obsprep.ot.editors.schedblock.SpectralSpecVisualEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.ObservingParameterEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.ObservingParameterTabEditor;
import alma.obsprep.ot.gui.factory.TableActionEvent;
import alma.obsprep.ot.gui.factory.TreePile;
import alma.obsprep.ot.gui.feedback.ProblemTableModel;
import alma.obsprep.ot.gui.resources.ColorPalette;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.AboutDialog;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import alma.obsprep.ot.gui.toplevel.EditorManager;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGuiProjectCompartment;
import alma.obsprep.ot.gui.toplevel.Overview;
import alma.obsprep.ot.gui.toplevel.PreferencesDialog;
import alma.obsprep.ot.gui.toplevel.PreferencesListener;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import alma.obsprep.ot.persistence.ProjectRepositoryHttp;
import alma.obsprep.ot.project.OTTree;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.ObjectFilter;
import alma.obsprep.util.job.AbstractJob;
import alma.obsprep.util.job.JobUtility;
import com.google.common.base.Stopwatch;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javafx.application.Platform;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ObservingToolGui
implements ModelChangeSubscriber,
EventReceiver,
PreferencesReadWrite,
PreferencesListener,
GuiApi,
ChangeListener {
    private Log.Logger logger = Log.logger((Object)this);
    private static final int PROJSTRUCT_PROPOSAL_TAB = 0;
    private static final int PROJSTRUCT_PROGRAM_TAB = 1;
    final ObservingToolController controller;
    PerspectivePane perspectPane;
    DefaultHelpBroker quickStartGuideHB;
    DefaultHelpBroker userManualHB;
    DefaultHelpBroker referenceManualHB;
    DefaultHelpBroker cookbookHB;
    private ProjectTreeNode currentNode = null;
    private EditorManager editorManager;
    private Colors palette;
    GuiFactory guiFactory;
    JFrame frame;
    private JTabbedPane tabContainerTree = new JTabbedPane();
    private JTabbedPane tabContainerEditor = new JTabbedPane();
    private JTabbedPane tabContainerFeedback = new JTabbedPane();
    GuiFactory.LoggingPanel logging;
    GuiFactory.Information information;
    GuiFactory.Problems problems;
    GuiFactory.ProblemPrinter problemPrinter;
    JPanel panelTree;
    JPanel panelEditor;
    JPanel panelOverview;
    JPanel panelFeedback;
    JPanel spatialFormPanel;
    private JPanel spatialVisualPanel;
    private JPanel spectralVisualPanel;
    private EditorManager.EditorType editPreference;
    private Map<EditorManager.EditorType, Integer> editorTypeToTabInPanelMap = new HashMap<EditorManager.EditorType, Integer>();
    private EditorManager.EditorType[] tab2EditorType = new EditorManager.EditorType[4];
    PreferencesDialog dlgPreferences;
    private JMenuBar menubar;
    private JMenu menDebug;
    private JMenu menHelp;
    private JLabel lblAreaA;
    private JLabel lblAreaB;
    private JLabel lblAreaC;
    private JLabel lblAreaD;
    private JToolBar toolbar;
    private JLabel lblProgress;
    private TreePile phase2Pile;
    private TreePile phase1Pile;
    private OTActions.ApplicationWide appWideActions;
    JPanel overviewPanel = new JPanel(new FlowLayout(1, 10, 10));
    private static List<String> phase1stati = Arrays.asList(ObsProject.STATUS_NEWPHASE1, ObsProject.STATUS_PHASE1SUBMITTED, ObsProject.STATUS_REJECTED);
    private HashMap<String, IndeterminateProgressMonitor> progressMons = new HashMap();
    private AbstractJob latestProgress;
    private Vector<ObservingToolGuiProjectCompartment> projectCompartments = new Vector();
    private ObservingToolGuiProjectCompartment activeProjectCompartment;
    private Optional<Editor> previousEditor = Optional.empty();
    private EditorManager.EditorType phase2InstrumentSetUpEditorType = EditorManager.EditorType.FORM;
    private boolean isPhase2InstrumentSetupEditorSelected = false;
    private ObjectFilter<ProjectTreeNode> leavesOnly = new ObjectFilter<ProjectTreeNode>(){

        @Override
        public boolean accept(ProjectTreeNode projectTreeNode) {
            return projectTreeNode.getChildCount() == 0;
        }
    };
    private String currLafName;
    private int currFontSize;
    private EditorDisablerController componentDisabler;

    ObservingToolGui(ObservingToolController observingToolController) {
        this.controller = observingToolController;
        this.guiFactory = GuiFactory.getFactory();
        this.editorManager = new EditorManager(this, observingToolController);
        Platform.setImplicitExit((boolean)false);
    }

    protected AbstractJob jobBuildGui() {
        return new AbstractJob("build gui", true){

            @Override
            public void job() throws Exception {
                ObservingToolGui.this.buildGui_initLookAndFeel();
                ObservingToolGui.this.buildGui_initEditors();
                ObservingToolGui.this.buildGui_initListeners();
                ObservingToolGui.this.buildGui_initFrontend();
                ObservingToolGui.this.buildGui_initHelpAndDiagnostics();
            }
        };
    }

    public static List<String> getPhase1stati() {
        return Collections.unmodifiableList(phase1stati);
    }

    private void buildGui_initLookAndFeel() {
        try {
            OceanTheme oceanTheme = new OceanTheme();
            MetalLookAndFeel.setCurrentTheme(oceanTheme);
            UIManager.put("swing.boldMetal", Boolean.FALSE);
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            Object object = UIManager.get("Label.foreground");
            UIManager.put("TextField.inactiveForeground", object);
            UIManager.put("TextArea.inactiveForeground", object);
            UIManager.put("ComboBox.disabledForeground", object);
            UIManager.put("ComboBox.disabledBackground", UIManager.get("Panel.background"));
            UIManager.put("TextField.inactiveBackground", UIManager.get("Panel.background"));
            UIManager.put("Obsprep.disabledBackground", UIManager.get("ComboBox.disabledBackground"));
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            this.logger.info("Metal Look and Feel not supported on this platform");
        }
    }

    private void makeFrameAccent(boolean bl) {
        Color color;
        int n;
        boolean bl2;
        boolean bl3;
        if (this.projectCompartments.isEmpty()) {
            return;
        }
        final ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = this.primaryProjectCompartment();
        boolean bl4 = observingToolGuiProjectCompartment.getObsProject().getIsCommissioning();
        String string = observingToolGuiProjectCompartment.getObsProject().getStatus();
        boolean bl5 = observingToolGuiProjectCompartment.getObsProject().getIsDDT();
        try {
            bl3 = observingToolGuiProjectCompartment.getObsProject().getObsProposal().isVLBI();
        }
        catch (UnknownEntityException unknownEntityException) {
            bl3 = false;
        }
        if (bl4) {
            bl2 = true;
            n = 1;
            color = this.getPalette().getCommissionColor();
        } else if (phase1stati.contains(string)) {
            bl2 = false;
            n = 0;
            color = !bl5 ? this.getPalette().getPhase1Color() : this.getPalette().getDDTColor();
        } else {
            bl2 = true;
            n = 1;
            color = bl3 ? this.getPalette().getVLBIColor() : this.getPalette().getPhase2Color();
        }
        this.lblAreaA.setBackground(color);
        this.lblAreaB.setBackground(color);
        this.lblAreaC.setBackground(color);
        this.lblAreaD.setBackground(color);
        observingToolGuiProjectCompartment.getProjectTreePanels().getOverview().refreshColors();
        if (bl) {
            final int n2 = n;
            this.tabContainerTree.setSelectedIndex(n);
            new AbstractJob("select root", false, JobUtility.swing){

                @Override
                public void job() throws Exception {
                    ProjectTree projectTree = n2 == 0 ? observingToolGuiProjectCompartment.getPhase1Tree() : observingToolGuiProjectCompartment.getPhase2Tree();
                    projectTree.select(new TreePath(projectTree.getTop().getPath()));
                }
            }.go();
        }
        this.tabContainerTree.setEnabledAt(1, bl2);
    }

    private void buildGui_initEditors() {
        this.createPalette();
        this.editorManager.init();
    }

    private void buildGui_initListeners() {
        this.listenUp(this.editorManager);
        this.controller.addPreferencesListener(this);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
    }

    private int addTab(JTabbedPane jTabbedPane, String string, JComponent jComponent, String string2, boolean bl, String string3) {
        jTabbedPane.addTab(string, jComponent);
        int n = jTabbedPane.getTabCount() - 1;
        jTabbedPane.setToolTipTextAt(n, "<html>" + string2 + "</html>");
        jTabbedPane.setEnabledAt(n, bl);
        jTabbedPane.getComponentAt(n).setName(string3);
        return n;
    }

    private void buildGui_initFrontend() {
        this.componentDisabler = new EditorDisablerController(this.tabContainerEditor);
        UIManager.put("MultiSplitPane.minimizeIcon", Icons.minimizeView);
        UIManager.put("MultiSplitPane.restoreIcon", Icons.restoreView);
        UIManager.put("MultiSplitPane.closeIcon", Icons.closeView);
        this.phase2Pile = this.guiFactory.giveTreePile();
        this.phase1Pile = this.guiFactory.giveTreePile();
        this.lblAreaA = this.guiFactory.giveHeadline("Project Structure");
        this.lblAreaB = this.guiFactory.giveHeadline("Editors");
        this.lblAreaC = this.guiFactory.giveHeadline("Overview");
        this.lblAreaD = this.guiFactory.giveHeadline("Feedback");
        this.addTab(this.tabContainerTree, "Proposal", this.getPhase1TreePile(), "Your Observing Proposal (Phase I)", true, "Proposal");
        int n = this.addTab(this.tabContainerTree, "Program", this.getPhase2TreePile(), "Your Observing Programme (Phase II)", true, "Program");
        this.tabContainerTree.setSelectedIndex(n);
        this.tabContainerTree.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ObservingToolGui.this.activeProjectCompartment != null) {
                    int n = ObservingToolGui.this.tabContainerTree.getSelectedIndex();
                    boolean bl = n == 0;
                    ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = ObservingToolGui.this.activeProjectCompartment();
                    ProjectTree projectTree = bl ? observingToolGuiProjectCompartment.getPhase1Tree() : observingToolGuiProjectCompartment.getPhase2Tree();
                    OTTree oTTree = projectTree.getTree();
                    TreePath[] treePathArray = oTTree.getSelectionPaths();
                    oTTree.getSelectionModel().clearSelection();
                    oTTree.setSelectionPaths(treePathArray);
                    oTTree.requestFocusInWindow();
                }
            }
        });
        this.tabContainerTree.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ObservingToolGui.this.projectCompartments.size() > 0) {
                    int n = ObservingToolGui.this.tabContainerTree.getSelectedIndex();
                    boolean bl = n == 0;
                    ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = ObservingToolGui.this.primaryProjectCompartment();
                    Overview.Phase phase = bl ? Overview.Phase.PHASE1 : Overview.Phase.PHASE2;
                    observingToolGuiProjectCompartment.getProjectTreePanels().overview.setProjectPhase(phase);
                }
            }
        });
        JPanel jPanel = this.guiFactory.giveCombinedEditorsPanel();
        jPanel.setName("form");
        this.spatialFormPanel = this.guiFactory.giveSpatialFormPanel();
        this.spatialFormPanel.setName("spatialFormPanel");
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("leftPanel");
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.spatialFormPanel, "North");
        jPanel.add(jPanel2);
        this.spatialVisualPanel = this.guiFactory.giveSpatialVisualPanel();
        this.spatialVisualPanel.setName("spatialVisualPanel");
        this.spectralVisualPanel = this.guiFactory.giveSpectralVisualPanel();
        this.spectralVisualPanel.setName("spectralVisualPanel");
        n = this.addTab(this.tabContainerEditor, DefaultEditorTypeType.SPECTRAL.toString(), this.guiFactory.giveScrollPane(this.spectralVisualPanel), "Graphical visualisation of spectral<br>facets of the observation program", true, "Spectral");
        this.editorTypeToTabInPanelMap.put(EditorManager.EditorType.VISUAL_SPECTRAL, n);
        this.tab2EditorType[n] = EditorManager.EditorType.VISUAL_SPECTRAL;
        n = this.addTab(this.tabContainerEditor, DefaultEditorTypeType.SPATIAL.toString(), this.guiFactory.giveScrollPane(this.spatialVisualPanel), "Graphical visualisation of spatial<br>facets of the observation program", true, "Spatial");
        this.editorTypeToTabInPanelMap.put(EditorManager.EditorType.VISUAL_SPATIAL, n);
        this.tab2EditorType[n] = EditorManager.EditorType.VISUAL_SPATIAL;
        n = this.addTab(this.tabContainerEditor, DefaultEditorTypeType.FORMS.toString(), this.guiFactory.giveScrollPane(jPanel), "Textual entry of the observation program", true, "Forms");
        this.editorTypeToTabInPanelMap.put(EditorManager.EditorType.FORM, n);
        this.tab2EditorType[n] = EditorManager.EditorType.FORM;
        this.tabContainerEditor.addChangeListener(this);
        this.tabContainerEditor.setSelectedIndex(n);
        this.problems = (GuiFactory.Problems)this.guiFactory.giveProblems();
        this.information = (GuiFactory.Information)this.guiFactory.giveInformation();
        this.logging = (GuiFactory.LoggingPanel)this.guiFactory.giveLogging();
        this.problemPrinter = this.guiFactory.giveProblemPrinter(this);
        JScrollPane jScrollPane = this.guiFactory.giveScrollPane(this.information);
        JScrollPane jScrollPane2 = this.guiFactory.giveScrollPane(this.logging);
        this.tabContainerFeedback.addTab("Validation", this.problems);
        this.tabContainerFeedback.addTab("Validation History", jScrollPane);
        this.tabContainerFeedback.addTab("Log", jScrollPane2);
        this.tabContainerFeedback.setSelectedIndex(0);
        ((Logger)Log.logger((Object)this.controller)).addHandler(new ObservingToolController.LogToFeedbackConnect(this.controller));
        this.panelTree = this.guiFactory.giveLabeledPanel(this.lblAreaA, this.tabContainerTree);
        CSH.setHelpIDString((Component)this.panelTree, (String)"TOC-Overview of the Observing Tool-Panes-Project Structure");
        this.panelEditor = this.guiFactory.giveLabeledPanel(this.lblAreaB, this.tabContainerEditor);
        CSH.setHelpIDString((Component)this.panelEditor, (String)"TOC-Overview of the Observing Tool-Panes-Editors");
        this.panelOverview = this.guiFactory.giveLabeledPanel(this.lblAreaC, this.overviewPanel);
        CSH.setHelpIDString((Component)this.panelOverview, (String)"TOC-Overview of the Observing Tool-Panes-Overview");
        this.panelFeedback = this.guiFactory.giveLabeledPanel(this.lblAreaD, this.tabContainerFeedback);
        CSH.setHelpIDString((Component)this.panelFeedback, (String)"TOC-Overview of the Observing Tool-Panes-Feedback");
        this.panelEditor.setMinimumSize(new Dimension(100, 100));
        this.panelFeedback.setMinimumSize(new Dimension(0, 0));
        this.panelTree.setMinimumSize(new Dimension(100, 0));
        this.panelOverview.setMinimumSize(new Dimension(0, 0));
        this.panelEditor.setPreferredSize(new Dimension(100, 100));
        this.panelFeedback.setPreferredSize(new Dimension(0, 0));
        this.panelTree.setPreferredSize(new Dimension(180, 100));
        this.panelOverview.setPreferredSize(new Dimension(100, 220));
        this.perspectPane = new PerspectivePane();
        this.perspectPane.registerView(this.panelTree, "tree");
        this.perspectPane.registerView(this.panelEditor, "spatial");
        this.perspectPane.registerView(this.panelOverview, "spectral");
        this.perspectPane.registerView(this.panelFeedback, "feedback");
        this.perspectPane.setRepository(this.controller.getPerspectiveRepository());
        JLabel jLabel = this.guiFactory.givePerspectiveLabel(this.controller);
        this.lblProgress = new JLabel("");
        this.lblProgress.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.appWideActions = new OTActions.ApplicationWide();
        ProjectRepositoryHttp projectRepositoryHttp = this.controller.heap.getProjectRepository();
        this.appWideActions.initialize(this.controller, this, projectRepositoryHttp);
        this.guiFactory.setApplicationWideActions(this.appWideActions);
        this.menDebug = this.guiFactory.giveDebugMenu(this.controller);
        this.menHelp = this.guiFactory.giveHelpMenu();
        this.menubar = new JMenuBar();
        CSH.setHelpIDString((Component)this.menubar, (String)"TOC-Overview of the Observing Tool-Menu Bar");
        this.toolbar = new JToolBar("Main Tools");
        CSH.setHelpIDString((Component)this.toolbar, (String)"TOC-Overview of the Observing Tool-Tool Bar");
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.lblProgress);
        jMenuBar.add(new JSeparator(1));
        jMenuBar.add(jLabel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jMenuBar, "East");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.menubar, "Center");
        jPanel4.add((Component)jPanel3, "East");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)this.toolbar, "South");
        this.frame = this.guiFactory.giveFrame();
        this.frame.setName("ObservingToolGui.mainFrame");
        this.frame.getContentPane().add((Component)jPanel5, "North");
        this.frame.getContentPane().add((Component)this.perspectPane, "Center");
        GUIUtilities.setParentWindow(this.frame);
        GuiFactory.setParentWindow(this.frame);
        this.dlgPreferences = new PreferencesDialog(this.controller, this);
        RoleDirectoryService.addUserAuthenticatesListener(UserEditRestrictionController.getInstance());
        RoleDirectoryService.addUserAuthenticatesListener(this.dlgPreferences);
        this.tabContainerEditor.setName("EditorTabs");
        this.tabContainerFeedback.setName("FeedbackTabs");
        this.tabContainerTree.setName("TreeTabs");
        this.overviewPanel.setName("overviewPanel");
    }

    private void buildGui_initHelpAndDiagnostics() {
        this.cookbookHB = (DefaultHelpBroker)this.controller.getCookbookHS().createHelpBroker();
        this.referenceManualHB = (DefaultHelpBroker)this.controller.getReferenceManualHS().createHelpBroker();
        this.userManualHB = (DefaultHelpBroker)this.controller.getUserManualHS().createHelpBroker();
        this.quickStartGuideHB = (DefaultHelpBroker)this.controller.getQuickStartGuideHS().createHelpBroker();
        this.applyHelpIDs(this.tabContainerFeedback);
        this.problems.addTableActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n = ((TableActionEvent)actionEvent).getRowIndex();
                Problem problem = ObservingToolGui.this.problems.get(n);
                if (ObservingToolGui.this.logger.finest()) {
                    ObservingToolGui.this.logger.finest("table action on " + problem);
                }
                if ((object = problem.getResource()) instanceof BusinessObject) {
                    ObservingToolGui.this.jumpToBO((BusinessObject)object);
                }
            }
        });
    }

    protected void applyHelpIDs(JComponent jComponent) {
        block5: {
            String string = jComponent.getName();
            if (string != null && !"".equals(string)) {
                this.userManualHB.enableHelp((Component)jComponent, string, null);
                if (this.logger.finest()) {
                    this.logger.finest("registered helpID for widget '" + string + "'");
                }
            }
            try {
                Component[] componentArray = jComponent.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    if (!(componentArray[i] instanceof JComponent)) continue;
                    this.applyHelpIDs((JComponent)componentArray[i]);
                }
            }
            catch (Exception exception) {
                if (!this.logger.finest()) break block5;
                this.logger.fine("probably concurrent modification in jcomponent tree of " + jComponent + ": " + exception);
            }
        }
    }

    protected AbstractJob jobStart() {
        return new AbstractJob("start gui", true){

            @Override
            public void job() {
                ObservingToolGui.this.frame.setVisible(true);
            }
        };
    }

    protected AbstractJob jobStop() {
        return new AbstractJob("stop gui", false){

            @Override
            public void job() {
                ObservingToolGui.this.guiFactory.dispose();
            }
        };
    }

    @Override
    public void readPreferences(ObsToolUserPrefs obsToolUserPrefs) {
        if (this.frame != null) {
            int n = obsToolUserPrefs.getFrameWidth();
            int n2 = obsToolUserPrefs.getFrameHeight();
            int n3 = obsToolUserPrefs.getFrameX();
            int n4 = obsToolUserPrefs.getFrameY();
            Log.logger(ObservingToolGui.class).finest("Stored x,y,w,h from preferences: " + n3 + ", " + n4 + ", " + n + ", " + n2);
            this.frame.setBounds(n3, n4, n, n2);
            Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            double d = rectangle.getWidth();
            double d2 = rectangle.getHeight();
            Log.logger(ObservingToolGui.class).finest("availableWidth = " + d + " availableHeight = " + d2);
            double d3 = rectangle.getLocation().getX();
            double d4 = rectangle.getLocation().getY();
            int n5 = n;
            int n6 = n2;
            String string = "none";
            if (d <= (double)n) {
                Log.logger(ObservingToolGui.class).finest("Maximising width");
                n5 = (int)d;
                string = "width";
            }
            if ((double)n3 < d3) {
                Log.logger(ObservingToolGui.class).finest("Overriding x position");
                n3 = (int)d3;
            }
            if (d2 <= (double)n2) {
                Log.logger(ObservingToolGui.class).finest("Maximising height");
                n6 = (int)d2;
                switch (string) {
                    case "width": {
                        string = "both";
                        break;
                    }
                    case "none": {
                        string = "height";
                        break;
                    }
                }
            }
            if ((double)n4 < d4) {
                Log.logger(ObservingToolGui.class).finest("Overriding y position");
                n4 = (int)d4;
            }
            switch (string) {
                case "width": {
                    this.frame.setExtendedState(2);
                    break;
                }
                case "height": {
                    this.frame.setExtendedState(4);
                    break;
                }
                case "both": {
                    this.frame.setExtendedState(6);
                    break;
                }
                default: {
                    this.frame.setBounds(n3, n4, n5, n6);
                }
            }
        }
        this.guiFactory.readPreferences(obsToolUserPrefs);
    }

    @Override
    public void handlePreferencesChanged(ObsToolUserPrefs obsToolUserPrefs) {
        Comparable<DialogId> comparable;
        DialogSettings dialogSettings2;
        GUIUtilities.clearAutomatisedDialogs();
        for (DialogSettings dialogSettings2 : obsToolUserPrefs.getDialogSettings()) {
            comparable = new DialogId(dialogSettings2.getDialogId(), dialogSettings2.getDescription());
            GUIUtilities.automatiseDialog((DialogId)comparable, dialogSettings2.getAutoanswer());
        }
        this.activatePerspective(obsToolUserPrefs.getPerspective());
        this.activateLookAndFeel(obsToolUserPrefs.getLookAndFeel(), obsToolUserPrefs.getFontSize());
        Colors colors = this.getPalette();
        colors.setColor("Foreground", new Color((int)Long.parseLong(obsToolUserPrefs.getColorForeground(), 16)));
        colors.setColor("Clipboard", new Color((int)Long.parseLong(obsToolUserPrefs.getColorClipboard(), 16)));
        colors.setColor("Error", new Color((int)Long.parseLong(obsToolUserPrefs.getColorError(), 16)));
        colors.setColor("Phase1", new Color((int)Long.parseLong(obsToolUserPrefs.getColorPhase1(), 16)));
        colors.setColor("Phase2", new Color((int)Long.parseLong(obsToolUserPrefs.getColorPhase2(), 16)));
        colors.setColor("Catalog Lines", new Color((int)Long.parseLong(obsToolUserPrefs.getColorCatalogueLines(), 16)));
        colors.setColor("Centre Frequency", new Color((int)Long.parseLong(obsToolUserPrefs.getColorCentreFrequency(), 16)));
        colors.setColor("Rest Frequency", new Color((int)Long.parseLong(obsToolUserPrefs.getColorRestFrequency(), 16)));
        colors.setColor("Sidebands", new Color((int)Long.parseLong(obsToolUserPrefs.getColorSidebands(), 16)));
        colors.setColor("Warning", new Color((int)Long.parseLong(obsToolUserPrefs.getColorWarning(), 16)));
        colors.setColor("Zoom Box", new Color((int)Long.parseLong(obsToolUserPrefs.getColorZoomBox(), 16)));
        colors.setColor("DDT", new Color((int)Long.parseLong(obsToolUserPrefs.getColorDDT(), 16)));
        colors.setColor("FOV", new Color((int)Long.parseLong(obsToolUserPrefs.getColorFOV(), 16)));
        colors.setColor("FOV 1/3 HPBW", new Color((int)Long.parseLong(obsToolUserPrefs.getColorFOVMainFluxHPBW(), 16)));
        DefaultEditorTypeType defaultEditorTypeType = obsToolUserPrefs.getDefaultEditorType();
        if (defaultEditorTypeType == DefaultEditorTypeType.FORMS) {
            this.editPreference = EditorManager.EditorType.FORM;
        } else if (defaultEditorTypeType == DefaultEditorTypeType.SPECTRAL) {
            this.editPreference = EditorManager.EditorType.VISUAL_SPECTRAL;
        } else if (defaultEditorTypeType == DefaultEditorTypeType.SPATIAL) {
            this.editPreference = EditorManager.EditorType.VISUAL_SPATIAL;
        }
        if (obsToolUserPrefs.getTabPlacement().equals(TabPlacementType.TOP)) {
            this.tabContainerTree.setTabPlacement(1);
            this.tabContainerEditor.setTabPlacement(1);
            this.tabContainerFeedback.setTabPlacement(1);
        } else {
            this.tabContainerTree.setTabPlacement(3);
            this.tabContainerEditor.setTabPlacement(3);
            this.tabContainerFeedback.setTabPlacement(3);
        }
        int n = obsToolUserPrefs.getTooltipDismissDelay();
        n = n < 0 ? 4 : n;
        ToolTipManager.sharedInstance().setDismissDelay(n * 1000);
        dialogSettings2 = obsToolUserPrefs.getBLCorrelator();
        if (dialogSettings2 != null) {
            System.setProperty("BLCorrelator", dialogSettings2.toString());
        }
        if ((comparable = Boolean.valueOf(obsToolUserPrefs.getUseBlCorrForAca())) != null) {
            System.setProperty("UseBLCorrForAca", ((Boolean)comparable).toString());
        }
        this.makeFrameAccent(false);
        this.controller.advancedOptionsReassess();
        this.readAdvancedOptions();
    }

    @Override
    public void writePreferences(ObsToolUserPrefs obsToolUserPrefs) {
        Rectangle rectangle = this.frame.getBounds();
        obsToolUserPrefs.setFrameX(rectangle.x);
        obsToolUserPrefs.setFrameY(rectangle.y);
        obsToolUserPrefs.setFrameWidth(rectangle.width);
        obsToolUserPrefs.setFrameHeight(rectangle.height);
        this.guiFactory.writePreferences(obsToolUserPrefs);
        this.dlgPreferences.writePreferences("Dialogs");
    }

    @Override
    public boolean isFieldReplace() {
        return !this.controller.getPreferences().getFieldInsert();
    }

    @Override
    public boolean usesWorkbookSummary() {
        return this.controller.getPreferences().getShowsAllWorkbookPagesAsSummary();
    }

    protected void setupDefaultPerspective1() {
        if (this.logger.finest()) {
            this.logger.fine("setting up default perspective 1");
        }
        JSplitPane jSplitPane = this.guiFactory.giveSplitPane(0);
        JSplitPane jSplitPane2 = this.guiFactory.giveSplitPane(1);
        JSplitPane jSplitPane3 = this.guiFactory.giveSplitPane(0);
        jSplitPane.setName("MainWindow.split10-vertical");
        jSplitPane2.setName("MainWindow.split11-horizontal");
        jSplitPane3.setName("MainWindow.split12-vertical");
        jSplitPane3.setTopComponent(new ViewPane(this.panelEditor));
        jSplitPane3.setBottomComponent(new ViewPane(this.panelFeedback));
        jSplitPane2.setLeftComponent(new ViewPane(this.panelTree));
        jSplitPane2.setRightComponent(jSplitPane3);
        jSplitPane.setTopComponent(jSplitPane2);
        jSplitPane.setBottomComponent(new ViewPane(this.panelOverview));
        this.perspectPane.setChild(jSplitPane);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane3.setResizeWeight(1.0);
    }

    protected void setupDefaultPerspective2() {
        if (this.logger.finest()) {
            this.logger.fine("setting up default perspective 2");
        }
        JSplitPane jSplitPane = this.guiFactory.giveSplitPane(0);
        JSplitPane jSplitPane2 = this.guiFactory.giveSplitPane(1);
        JSplitPane jSplitPane3 = this.guiFactory.giveSplitPane(0);
        jSplitPane.setName("MainWindow.split20-vertical");
        jSplitPane2.setName("MainWindow.split21-horizontal");
        jSplitPane3.setName("MainWindow.split22-vertical");
        jSplitPane3.setTopComponent(new ViewPane(this.panelTree));
        jSplitPane3.setBottomComponent(new ViewPane(this.panelFeedback));
        jSplitPane2.setLeftComponent(jSplitPane3);
        jSplitPane2.setRightComponent(new ViewPane(this.panelEditor));
        jSplitPane.setTopComponent(jSplitPane2);
        jSplitPane.setBottomComponent(new ViewPane(this.panelOverview));
        this.perspectPane.setChild(jSplitPane);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane3.setResizeWeight(1.0);
    }

    public OTActions.ApplicationWide getApplicationWideActions() {
        return this.appWideActions;
    }

    public GuiFactory getFactory() {
        return this.guiFactory;
    }

    private void setupMacOSBindings() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"TextField.focusInputMap", "PasswordField.focusInputMap", "TextArea.focusInputMap", "TextPane.focusInputMap", "EditorPane.focusInputMap", "FormattedTextField.focusInputMap", "List.focusInputMap", "Table.ancestorInputMap", "Tree.focusInputMap"}) {
            InputMapUIResource inputMapUIResource = (InputMapUIResource)UIManager.get(string);
            inputMapUIResource.put(KeyStroke.getKeyStroke(67, 256), "copy-to-clipboard");
            inputMapUIResource.put(KeyStroke.getKeyStroke(86, 256), "paste-from-clipboard");
            inputMapUIResource.put(KeyStroke.getKeyStroke(65, 256), "select-all");
            inputMapUIResource.put(KeyStroke.getKeyStroke(88, 256), "cut-to-clipboard");
        }
    }

    protected void makeFrameTitle() {
        String string;
        SiteCharacteristics siteCharacteristics = SiteCharacteristics.getInstance();
        String string2 = System.getProperty("alma.obsprep.developmentversion") != null ? String.format("%s (%s)", System.getProperty("alma.obsprep.developmentversion"), InitServices.getUserVersion()) : String.format("%s Observing Tool (%s)", siteCharacteristics.getObsName(), InitServices.getUserVersion());
        try {
            string = this.activeProjectCompartment().getObsProject().toTreeString(1, true, false);
            string2 = string2 + " - " + string + " ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = this.activeProjectCompartment().getObsProject().getCode();
            if (string != null && !string.equalsIgnoreCase("None Assigned")) {
                String string3;
                ObsProject obsProject = this.activeProjectCompartment().getObsProject();
                ObsProposal obsProposal = obsProject.getObsProposal();
                String string4 = string3 = obsProject.getIsDDT() ? " [DDT] " : " ";
                if (null != obsProposal) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String string5 = simpleDateFormat.format(obsProposal.getDateReceived());
                    string2 = string2 + "(" + string + string3 + "last submitted " + string5 + ")";
                } else {
                    String string6 = obsProject.getTimeOfCreation();
                    string2 = string2 + "(" + string + string3 + "created " + string6 + ")";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.frame != null) {
            this.frame.setTitle(string2);
        }
    }

    protected void makeTreeTitle(ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment) {
        ObsProject obsProject = observingToolGuiProjectCompartment.getObsProject();
        String string = obsProject.getProjectName();
        if (string.equals("")) {
            string = "(unnamed project)";
        }
        String string2 = string;
        this.getPhase1TreePile().setTitle(observingToolGuiProjectCompartment.getPhase1Tree(), string2, null);
        this.getPhase2TreePile().setTitle(observingToolGuiProjectCompartment.getPhase2Tree(), string2, null);
        if (observingToolGuiProjectCompartment == this.primaryProjectCompartment()) {
            boolean bl = EntityIdFactoryImpl.isOnTheFlyId(obsProject.getEntityID());
            Color color = bl ? null : Color.RED;
            String string3 = bl ? "Unsubmitted Proposal" : "SUBMITTED";
            this.getPhase1TreePile().setTitle(observingToolGuiProjectCompartment.getPhase1Tree(), string3, color);
            if (obsProject.getStatus().equals(ObsProject.STATUS_PHASE2SUBMITTED)) {
                this.getPhase2TreePile().setTitle(observingToolGuiProjectCompartment.getPhase2Tree(), "SUBMITTED", Color.RED);
            }
        }
    }

    protected void showHelpCookbook() {
        this.showHelpCookbook("intro");
    }

    protected void showHelpCookbook(String string) {
        this.cookbookHB.setCurrentID(string);
        this.cookbookHB.setDisplayed(true);
    }

    protected void showHelpReferenceManual() {
        this.showHelpReferenceManual("intro");
    }

    protected void showHelpReferenceManual(String string) {
        this.referenceManualHB.setCurrentID(string);
        this.referenceManualHB.setDisplayed(true);
    }

    protected void showHelpUserManual() {
        this.showHelpUserManual("intro");
    }

    protected void showHelpUserManual(String string) {
        this.userManualHB.setCurrentID(string);
        this.userManualHB.setDisplayed(true);
    }

    protected void showHelpQuickStartGuide() {
        this.showHelpQuickStartGuide("intro");
    }

    protected void showHelpQuickStartGuide(String string) {
        this.quickStartGuideHB.setCurrentID(string);
        this.quickStartGuideHB.setDisplayed(true);
    }

    protected void showAboutBox() {
        AboutDialog aboutDialog = new AboutDialog(InitServices.getUserVersion(), InitServices.getAlmaVersion(), InitServices.getPatchVersion());
        aboutDialog.showDialog();
    }

    protected void showReleaseNotes() {
        AboutDialog aboutDialog = new AboutDialog(InitServices.getUserVersion(), InitServices.getAlmaVersion(), InitServices.getPatchVersion());
        aboutDialog.showReleaseNotes();
    }

    public void showAsBusy(boolean bl) {
        if (this.frame != null) {
            this.frame.setCursor(bl ? Cursor.getPredefinedCursor(3) : null);
            for (ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment : this.projectCompartments) {
                observingToolGuiProjectCompartment.getProjectTreePanels().getPhase1Tree().setBusyCursor(bl);
                observingToolGuiProjectCompartment.getProjectTreePanels().getPhase2Tree().setBusyCursor(bl);
            }
        }
    }

    public void monitorJob(AbstractJob abstractJob) {
        new IndeterminateProgressMonitor(this.frame, abstractJob);
    }

    public IndeterminateProgressMonitor showProgressMonitor(boolean bl, String string) {
        if (bl) {
            IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor(this.frame, string, " ");
            this.progressMons.put(string, indeterminateProgressMonitor);
            indeterminateProgressMonitor.setMillisToPopup(0);
            indeterminateProgressMonitor.propertyChange(new PropertyChangeEvent(this, "state", null, (Object)SwingWorker.StateValue.STARTED));
            return indeterminateProgressMonitor;
        }
        IndeterminateProgressMonitor indeterminateProgressMonitor = this.progressMons.remove(string);
        if (indeterminateProgressMonitor != null) {
            indeterminateProgressMonitor.propertyChange(new PropertyChangeEvent(this, "state", null, (Object)SwingWorker.StateValue.DONE));
        }
        return indeterminateProgressMonitor;
    }

    public void setProgressText(final String string) {
        new AbstractJob("set progress text", false, JobUtility.swing){

            @Override
            public void job() {
                ObservingToolGui.this.lblProgress.setText(string);
            }
        }.go();
        this.latestProgress = new AbstractJob("", false, JobUtility.fiveSecondsLater){

            @Override
            public void job() {
                if (ObservingToolGui.this.latestProgress != this) {
                    return;
                }
                new AbstractJob("unset progress text", false, JobUtility.swing){

                    @Override
                    public void job() {
                        ObservingToolGui.this.lblProgress.setText(null);
                    }
                }.go();
            }
        }.go();
    }

    protected void addLoggingMessage(String string) {
        if (this.logging != null) {
            this.logging.addMessage(string);
        }
    }

    public void addInformationMessage(String string, String string2) {
        if (this.information != null) {
            this.information.addMessage(string, string2);
        }
    }

    public void addInformationMessage(FeedbackInfo feedbackInfo) {
        this.addInformationMessage(feedbackInfo.summary, feedbackInfo.details);
    }

    public void setProblemStatusText(String string) {
        this.problems.setStatusText(string);
    }

    public void seeNextProblem(boolean bl) {
        int n;
        if (this.problems != null && (n = this.problems.nextIndexInCycle(bl)) > -1) {
            this.problems.setSelectedIndex(n);
            this.problems.scrollTo(n);
            this.problems.doAction(n);
        }
    }

    public void setPrimaryProject(ObsProject obsProject, File file, boolean bl) {
        if (this.projectCompartments.isEmpty()) {
            ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = this.openCompartment(false);
            this.setObsProject(observingToolGuiProjectCompartment, obsProject, file);
            this.switchToProject(obsProject);
        } else {
            this.performIsMosaicConsistencyCheck(obsProject);
            ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = this.primaryProjectCompartment();
            this.setObsProject(observingToolGuiProjectCompartment, obsProject, file);
            if (this.activeProjectCompartment != observingToolGuiProjectCompartment) {
                this.switchToProject(obsProject);
            }
        }
    }

    private void performIsMosaicConsistencyCheck(ObsProject obsProject) {
        try {
            Object object;
            ObsProposal obsProposal = obsProject.getObsProposal();
            if (obsProposal != null) {
                object = obsProposal.getAbstractScienceGoalScienceGoal();
                int n = ((ScienceGoal[])object).length;
                for (int i = 0; i < n; ++i) {
                    ScienceGoal scienceGoal = object[i];
                    for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                        if (1 != targetParameters.getFieldSinglePointCount()) continue;
                        targetParameters.setIsMosaic(false);
                    }
                }
            }
            if ((object = obsProject.getObsProgram()) != null) {
                for (ScienceGoal scienceGoal : object.getAbstractScienceGoalScienceGoal()) {
                    for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                        if (1 != targetParameters.getFieldSinglePointCount()) continue;
                        targetParameters.setIsMosaic(false);
                    }
                }
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    public ObsProject getPrimaryProject() {
        return this.primaryProjectCompartment().getProjectTreePanels().getObsProject();
    }

    public ObservingToolGuiProjectCompartment addSecondaryProject(ObsProject obsProject, File file, boolean bl) {
        ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = this.openCompartment(bl);
        this.setObsProject(observingToolGuiProjectCompartment, obsProject, file);
        return observingToolGuiProjectCompartment;
    }

    public ObsProject getActiveProject() {
        return this.activeProjectCompartment().getObsProject();
    }

    public boolean isProjectModified(ObsProject obsProject) {
        ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = this.compartment4proj(obsProject);
        if (observingToolGuiProjectCompartment.isReadonly()) {
            return false;
        }
        return observingToolGuiProjectCompartment.obsProjectModified();
    }

    @Override
    public ProblemTableModel getProblemModel(ObsProject obsProject) {
        ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = this.compartment4proj(obsProject);
        return observingToolGuiProjectCompartment.getProblemModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservingToolGuiProjectCompartment[] allProjectCompartments() {
        Vector<ObservingToolGuiProjectCompartment> vector = this.projectCompartments;
        synchronized (vector) {
            ObservingToolGuiProjectCompartment[] observingToolGuiProjectCompartmentArray = new ObservingToolGuiProjectCompartment[this.projectCompartments.size()];
            this.projectCompartments.toArray(observingToolGuiProjectCompartmentArray);
            return observingToolGuiProjectCompartmentArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObservingToolGuiProjectCompartment compartment4proj(ObsProject obsProject) {
        Vector<ObservingToolGuiProjectCompartment> vector = this.projectCompartments;
        synchronized (vector) {
            int n = this.projectCompartments.size();
            for (int i = 0; i < n; ++i) {
                ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = this.projectCompartments.get(i);
                ObsProject obsProject2 = observingToolGuiProjectCompartment.getObsProject();
                if (obsProject2 != obsProject) continue;
                return observingToolGuiProjectCompartment;
            }
        }
        return null;
    }

    public ObservingToolGuiProjectCompartment activeProjectCompartment() {
        if (this.activeProjectCompartment == null) {
            throw new AssertionError((Object)"no project is active! this won't work");
        }
        return this.activeProjectCompartment;
    }

    public ObservingToolGuiProjectCompartment primaryProjectCompartment() {
        if (this.projectCompartments.size() == 0 || this.projectCompartments.get(0) == null) {
            return null;
        }
        return this.projectCompartments.get(0);
    }

    private void setObsProject(ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment, ObsProject obsProject, File file) {
        observingToolGuiProjectCompartment.getProblemModel().clear();
        observingToolGuiProjectCompartment.getProjectTreePanels().setObsProject(obsProject);
        observingToolGuiProjectCompartment.resetInitialObsProject(obsProject);
        observingToolGuiProjectCompartment.fileLocation = file;
        this.makeTreeTitle(observingToolGuiProjectCompartment);
        if (observingToolGuiProjectCompartment == this.activeProjectCompartment) {
            this.problems.setModel(observingToolGuiProjectCompartment.getProblemModel());
            this.problemPrinter.setModel(observingToolGuiProjectCompartment.getProblemModel());
            this.makeFrameTitle();
        }
        if (observingToolGuiProjectCompartment == this.primaryProjectCompartment()) {
            this.overviewPanel.removeAll();
            this.overviewPanel.add(observingToolGuiProjectCompartment.getProjectTreePanels().overview);
            this.makeFrameAccent(true);
        }
    }

    private void switchToProject(ObsProject obsProject) {
        if (obsProject == null) {
            throw new AssertionError((Object)"Who passed in 'null' as the obsProject to switch to?");
        }
        ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = null;
        observingToolGuiProjectCompartment = this.compartment4proj(obsProject);
        if (observingToolGuiProjectCompartment == null) {
            throw new AssertionError((Object)("Where does this obsProject instance come from? It was not opened through openObsProject(): " + obsProject));
        }
        this.menubar.removeAll();
        for (JMenu object : observingToolGuiProjectCompartment.getMenus()) {
            this.menubar.add(object);
        }
        this.menubar.add(this.menDebug);
        this.menubar.add(this.menHelp);
        this.toolbar.removeAll();
        for (Action action : observingToolGuiProjectCompartment.toolbarActions) {
            if (action == null) {
                this.toolbar.addSeparator();
                continue;
            }
            boolean bl = action.getValue("SwingSelectedKey") != null;
            AbstractButton abstractButton = bl ? new JToggleButton(action) : new JButton(action);
            abstractButton.setHideActionText(true);
            this.toolbar.add(abstractButton);
            if (!(action instanceof OTAction)) continue;
            ((OTAction)action).addComponent(abstractButton);
        }
        this.toolbar.addSeparator();
        JButton jButton = new JButton(Icons.help);
        jButton.setToolTipText("Contextual Help");
        jButton.addActionListener((ActionListener)new CSH.DisplayHelpAfterTracking(this.controller.getReferenceManualHS(), "javax.help.MainWindow", null));
        this.toolbar.add(jButton);
        this.toolbar.repaint();
        if (this.activeProjectCompartment != null) {
            this.getPhase2TreePile().setHighlighted(this.activeProjectCompartment.getPhase2Tree(), null);
            this.getPhase1TreePile().setHighlighted(this.activeProjectCompartment.getPhase1Tree(), null);
        }
        this.getPhase2TreePile().setHighlighted(observingToolGuiProjectCompartment.getPhase2Tree(), GuiFactory.COLOR_TREE_BACKGROUND_SELECTED);
        this.getPhase1TreePile().setHighlighted(observingToolGuiProjectCompartment.getPhase1Tree(), GuiFactory.COLOR_TREE_BACKGROUND_SELECTED);
        this.problems.setModel(observingToolGuiProjectCompartment.getProblemModel());
        this.problemPrinter.setModel(observingToolGuiProjectCompartment.getProblemModel());
        if (this.showingTree(observingToolGuiProjectCompartment.getPhase1Tree())) {
            observingToolGuiProjectCompartment.getPhase1Tree().getTree().requestFocusInWindow();
        } else if (this.showingTree(observingToolGuiProjectCompartment.getPhase2Tree())) {
            observingToolGuiProjectCompartment.getPhase2Tree().getTree().requestFocusInWindow();
        }
        this.activeProjectCompartment = observingToolGuiProjectCompartment;
        this.makeFrameTitle();
        this.readAdvancedOptions();
        EventManager.publish(new Event(EventTypes.PROJECT_ACTIVATED, this, observingToolGuiProjectCompartment));
    }

    private ObservingToolGuiProjectCompartment openCompartment(boolean bl) {
        boolean bl2 = bl;
        final ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = new ObservingToolGuiProjectCompartment(bl);
        observingToolGuiProjectCompartment.buildGui(this, this.guiFactory);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ObservingToolGui.this.activeProjectCompartment != observingToolGuiProjectCompartment) {
                    ObservingToolGui.this.switchToProject(observingToolGuiProjectCompartment.getObsProject());
                    JTree jTree = (JTree)mouseEvent.getComponent();
                    TreePath[] treePathArray = jTree.getSelectionPaths();
                    jTree.getSelectionModel().clearSelection();
                    jTree.setSelectionPaths(treePathArray);
                }
            }
        };
        observingToolGuiProjectCompartment.getPhase2Tree().getTree().addMouseListener(mouseAdapter);
        observingToolGuiProjectCompartment.getPhase1Tree().getTree().addMouseListener(mouseAdapter);
        ProjectRepositoryHttp projectRepositoryHttp = this.controller.heap.getProjectRepository();
        observingToolGuiProjectCompartment.buildActions(this.guiFactory, this.controller, this, projectRepositoryHttp);
        observingToolGuiProjectCompartment.buildData();
        this.projectCompartments.add(observingToolGuiProjectCompartment);
        Action action = bl2 ? observingToolGuiProjectCompartment.projectTiedActions.close : null;
        this.getPhase1TreePile().addAtBottom(observingToolGuiProjectCompartment.getPhase1Tree(), action);
        this.getPhase2TreePile().addAtBottom(observingToolGuiProjectCompartment.getPhase2Tree(), action);
        this.readAdvancedOptions();
        return observingToolGuiProjectCompartment;
    }

    public void closeCompartment(ObsProject obsProject) {
        if (obsProject == null) {
            throw new AssertionError((Object)"need to change this method's impl if you want to use 'null' as project");
        }
        ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = this.compartment4proj(obsProject);
        if (observingToolGuiProjectCompartment == null) {
            return;
        }
        if (observingToolGuiProjectCompartment == this.activeProjectCompartment) {
            this.clearEditorArea();
            if (!this.projectCompartments.isEmpty()) {
                this.switchToProject(this.getPrimaryProject());
            }
        }
        this.getPhase2TreePile().remove(observingToolGuiProjectCompartment.getPhase2Tree());
        this.getPhase1TreePile().remove(observingToolGuiProjectCompartment.getPhase1Tree());
        this.projectCompartments.remove(observingToolGuiProjectCompartment);
    }

    public void bringToFront(ObsProject obsProject) {
        if (obsProject != this.getActiveProject()) {
            this.switchToProject(obsProject);
        }
    }

    ProjectTree getProjectTree() {
        return this.activeProjectCompartment().getPhase2Tree();
    }

    ProjectTree getOusTree() {
        return this.activeProjectCompartment().getPhase1Tree();
    }

    void showNode(ProjectTree projectTree, ProjectTreeNode projectTreeNode) {
        this.showTree(projectTree);
        TreePath treePath = new TreePath(projectTreeNode.getPath());
        projectTree.select(treePath);
        projectTree.scrollTo(treePath);
    }

    private void showTree(ProjectTree projectTree) {
        JTabbedPane jTabbedPane;
        Container container;
        Container container2 = projectTree;
        for (container = projectTree.getParent(); container != null && !(container instanceof JTabbedPane); container = container.getParent()) {
            container2 = container;
        }
        if (container != null && (jTabbedPane = (JTabbedPane)container).indexOfComponent(container2) > -1) {
            jTabbedPane.setSelectedComponent(container2);
            return;
        }
        throw new IllegalArgumentException("tree not known to exist in any tabbedpane");
    }

    private boolean showingTree(ProjectTree projectTree) {
        Component component = this.tabContainerTree.getSelectedComponent();
        return SwingUtilities.isDescendingFrom(projectTree, component);
    }

    public void jumpToBO(BusinessObject businessObject) {
        ProjectTree projectTree = null;
        ProjectTree projectTree2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment : this.allProjectCompartments()) {
            ProjectTree projectTree3 = observingToolGuiProjectCompartment.getPhase1Tree();
            ProjectTree projectTree4 = observingToolGuiProjectCompartment.getPhase2Tree();
            ProjectTreeNode projectTreeNode = projectTree3.findNodeRepresentingBo(businessObject);
            ProjectTreeNode projectTreeNode2 = projectTree4.findNodeRepresentingBo(businessObject);
            if (projectTreeNode == null && projectTreeNode2 == null) continue;
            if (this.showingTree(projectTree3)) {
                projectTree = projectTree3;
                defaultMutableTreeNode = projectTreeNode;
                projectTree2 = projectTree4;
                defaultMutableTreeNode2 = projectTreeNode2;
                break;
            }
            projectTree = projectTree4;
            defaultMutableTreeNode = projectTreeNode2;
            projectTree2 = projectTree3;
            defaultMutableTreeNode2 = projectTreeNode;
            break;
        }
        if (defaultMutableTreeNode == null && defaultMutableTreeNode2 == null) {
            return;
        }
        ObservingToolGuiProjectCompartment[] observingToolGuiProjectCompartmentArray = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        int n = 0;
        while (n == 0) {
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() == businessObject) {
                observingToolGuiProjectCompartmentArray = projectTree;
                defaultMutableTreeNode3 = defaultMutableTreeNode;
                break;
            }
            if (defaultMutableTreeNode2 != null && defaultMutableTreeNode2.getUserObject() == businessObject) {
                observingToolGuiProjectCompartmentArray = projectTree2;
                defaultMutableTreeNode3 = defaultMutableTreeNode2;
                break;
            }
            if (defaultMutableTreeNode != null) {
                observingToolGuiProjectCompartmentArray = projectTree;
                defaultMutableTreeNode3 = defaultMutableTreeNode;
                break;
            }
            if (defaultMutableTreeNode2 != null) {
                observingToolGuiProjectCompartmentArray = projectTree2;
                defaultMutableTreeNode3 = defaultMutableTreeNode2;
                break;
            }
            n = 1;
        }
        this.showNode((ProjectTree)observingToolGuiProjectCompartmentArray, (ProjectTreeNode)defaultMutableTreeNode3);
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID.equals(FieldIDs.projectNameFID) || fieldID.equals(FieldIDs.versionFID)) {
            this.makeTreeTitle(this.activeProjectCompartment);
            this.makeFrameTitle();
        }
        if (fieldID.equals(FieldIDs.isCommissioningFID)) {
            this.makeFrameAccent(false);
        }
        for (ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment : this.allProjectCompartments()) {
            observingToolGuiProjectCompartment.getPhase2Tree().getTree().repaintMaybeNeeded();
            observingToolGuiProjectCompartment.getPhase1Tree().getTree().repaintMaybeNeeded();
        }
    }

    private void listenUpSubViews(View view) {
        if (!view.isSubViewsEmpty()) {
            for (View view2 : view.getSubViews()) {
                this.listenUpSubViews(view2);
            }
        }
        if (view instanceof Editor) {
            view.getController().subscribe(this);
        }
    }

    private void listenUp(EditorManager editorManager) {
        for (Editor editor : editorManager.getAllFormEditors()) {
            this.listenUpSubViews(editor);
        }
    }

    private void clearEditorArea() {
        JPanel[] jPanelArray;
        for (JPanel jPanel : jPanelArray = new JPanel[]{this.spatialFormPanel, this.spatialVisualPanel, this.spectralVisualPanel}) {
            try {
                this.updatePanel(jPanel, null);
                this.updateEditor(null, null);
            }
            catch (MultipageViewException multipageViewException) {
                this.logger.finer("problem clearing the editor area: " + multipageViewException);
            }
        }
    }

    private void updateEditor(BusinessObject businessObject, Editor editor) throws MultipageViewException {
        if (editor != null) {
            Model model = editor.getModel();
            if (editor.isMultipage()) {
                if (businessObject instanceof MultipartBOComponent) {
                    ((MultipageView)((Object)editor)).showAllPageInOneView(false);
                    model.setDocument(businessObject.getParent());
                    MultipageView multipageView = (MultipageView)((Object)editor);
                    if (multipageView.hasPageNumbers()) {
                        MultipartBOComponent multipartBOComponent = (MultipartBOComponent)businessObject;
                        multipageView.displayPageNumber(multipartBOComponent.getComponentNumber());
                    } else {
                        multipageView.displayPageFor(businessObject);
                    }
                } else {
                    model.setDocument(businessObject);
                    ((MultipageView)((Object)editor)).showAllPageInOneView(true);
                }
            } else {
                model.setDocument(businessObject);
            }
        }
    }

    private void saveCurrentComponent(JComponent jComponent) {
        FieldID fieldID = (FieldID)jComponent.getClientProperty("fieldId");
        Editor editor = (Editor)jComponent.getClientProperty("editor");
        if (fieldID == null || editor == null) {
            return;
        }
        if (jComponent instanceof JTextField) {
            editor.getController().widgetUpdated(editor, fieldID, ((JTextField)jComponent).getText());
        } else if (jComponent instanceof JTextArea) {
            editor.getController().widgetUpdated(editor, fieldID, ((JTextArea)jComponent).getText());
        }
    }

    private void updateEditor(ProjectTreeNode projectTreeNode, boolean bl) throws MultipageViewException {
        ProjectTreeNode projectTreeNode2;
        ObsProject obsProject;
        ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment;
        Stopwatch stopwatch = Stopwatch.createStarted();
        BusinessObject businessObject = (BusinessObject)projectTreeNode.getUserObject();
        BusinessObject businessObject2 = projectTreeNode.spatialBO();
        BusinessObject businessObject3 = projectTreeNode.spectralBO();
        Editor editor2 = null;
        Editor editor3 = null;
        Editor editor4 = null;
        if (!bl) {
            this.refreshCrossHighlight(projectTreeNode);
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component instanceof JComponent) {
                this.saveCurrentComponent((JComponent)component);
            }
            this.previousEditor.ifPresent(editor -> editor.finalizeUserEdits());
            editor2 = this.editorManager.editorFor(EditorManager.EditorType.FORM, businessObject);
            this.previousEditor = Optional.ofNullable(editor2);
            editor3 = this.editorManager.editorFor(EditorManager.EditorType.VISUAL_SPATIAL, businessObject2);
            editor4 = this.editorManager.editorFor(EditorManager.EditorType.VISUAL_SPECTRAL, businessObject3);
            if (businessObject instanceof SchedBlock || businessObject instanceof ObsUnitSet || businessObject instanceof ObservingGroup) {
                editor4 = null;
            }
            this.updatePanel(this.spatialFormPanel, editor2);
            this.updatePanel(this.spatialVisualPanel, editor3);
            this.updatePanel(this.spectralVisualPanel, editor4);
        }
        boolean bl2 = (observingToolGuiProjectCompartment = this.compartment4proj(obsProject = (ObsProject)(projectTreeNode2 = (ProjectTreeNode)projectTreeNode.getRoot()).getUserObject())) != null && observingToolGuiProjectCompartment.isReadonly();
        bl2 |= RoleDirectoryServiceHelper.isContactScientist(obsProject) && !RoleDirectoryServiceHelper.isUserP2G();
        bl2 |= this.isOUSReadOnly(projectTreeNode);
        bl2 |= this.isScienceGoalReadOnly(projectTreeNode, obsProject);
        boolean bl3 = this.isPhase2ProjectAndPhase1Node(projectTreeNode, obsProject, observingToolGuiProjectCompartment);
        bl2 |= bl3;
        boolean bl4 = RoleDirectoryServiceHelper.isUserP2G();
        bl2 |= !bl4 && this.isPhase2ProjectAndOUSNode(projectTreeNode, obsProject);
        bl2 |= this.isPhase2ProjectAndOUSNodeCancelled(projectTreeNode, obsProject);
        ScienceGoal scienceGoal = this.getPhase2ScienceGoal(projectTreeNode, obsProject);
        bl2 |= !bl4 && scienceGoal != null;
        bl2 |= this.isProjectNodeReadOnly(bl4, projectTreeNode, obsProject);
        if (!bl) {
            this.updateEditor(businessObject, editor2);
            this.updateEditor(businessObject2, editor3);
            this.updateEditor(businessObject3, editor4);
            boolean bl5 = phase1stati.contains(obsProject.getStatus());
            this.makePreferredEditorVisible(editor2, editor3, editor4);
            this.tabContainerEditor.setTitleAt(this.editorTypeToTabInPanelMap.get((Object)EditorManager.EditorType.FORM), businessObject.toTreeString(bl5 ? 1 : 2, true, false));
        }
        this.setReadonly(bl2);
        if (scienceGoal != null && !bl3) {
            UserEditRestrictionController.getInstance().setComponentVisibility(scienceGoal);
        } else {
            UserEditRestrictionController.getInstance().resetColourMapping();
        }
        if (Log.logger((Object)this).finest()) {
            String string = String.format("updateEditor takes %d[sec] for %s", stopwatch.elapsed(TimeUnit.MILLISECONDS), businessObject.toString());
            Log.logger((Object)this).finest(string);
        }
    }

    private boolean isProjectNodeReadOnly(boolean bl, ProjectTreeNode projectTreeNode, ObsProject obsProject) {
        if (ObsProject.STATUS_REJECTED.equals(obsProject.getStatus())) {
            return true;
        }
        if (!(projectTreeNode.getUserObject() instanceof ObsProject)) {
            return false;
        }
        if (bl) {
            return false;
        }
        return !phase1stati.contains(obsProject.getStatus());
    }

    private ScienceGoal getPhase2ScienceGoal(ProjectTreeNode projectTreeNode, ObsProject obsProject) {
        if (!phase1stati.contains(obsProject.getStatus())) {
            List<Object> list = Arrays.asList(projectTreeNode.getUserObjectPath());
            for (Object object : list) {
                ScienceGoal scienceGoal;
                BusinessObject businessObject;
                if (!(object instanceof ScienceGoal) || (businessObject = (scienceGoal = (ScienceGoal)object).getParent()) == null || !(businessObject instanceof ObsProgram)) continue;
                return scienceGoal;
            }
        }
        return null;
    }

    private boolean isPhase2ProjectAndOUSNode(ProjectTreeNode projectTreeNode, ObsProject obsProject) {
        if (!phase1stati.contains(obsProject.getStatus())) {
            List<Object> list = Arrays.asList(projectTreeNode.getUserObjectPath());
            for (Object object : list) {
                if (!(object instanceof ObsUnitSet)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPhase2ProjectAndOUSNodeCancelled(ProjectTreeNode projectTreeNode, ObsProject obsProject) {
        if (!phase1stati.contains(obsProject.getStatus())) {
            for (Object object : Arrays.asList(projectTreeNode.getUserObjectPath())) {
                ObsUnit obsUnit;
                if (!ObsUnit.class.isAssignableFrom(object.getClass()) || !(obsUnit = (ObsUnit)object).getStatus().equals(ObsUnitData.STATUS_CANCELED)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPhase2ProjectAndPhase1Node(ProjectTreeNode projectTreeNode, ObsProject obsProject, ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment) {
        if (!phase1stati.contains(obsProject.getStatus())) {
            Object object;
            TreeNode treeNode = projectTreeNode.getRoot();
            return treeNode == (object = observingToolGuiProjectCompartment.getPhase1Tree().getTree().getModel().getRoot());
        }
        return false;
    }

    private void setReadonly(boolean bl) {
        this.componentDisabler.setReadonly(bl);
    }

    private void updatePanel(JPanel jPanel, Editor editor) {
        jPanel.removeAll();
        if (editor != null) {
            editor.setAlignmentY(0.0f);
            jPanel.add(editor);
        }
        jPanel.revalidate();
        jPanel.repaint();
    }

    private boolean isOUSReadOnly(ProjectTreeNode projectTreeNode) {
        return projectTreeNode.getUserObject() instanceof ObsUnitSetComponent && this.editorManager.isOusCompProtected();
    }

    private boolean isScienceGoalReadOnly(ProjectTreeNode projectTreeNode, ObsProject obsProject) {
        if (!(projectTreeNode.getParent() instanceof ProjectTreeNode) || !(((ProjectTreeNode)projectTreeNode.getParent()).getUserObject() instanceof ScienceGoal)) {
            return false;
        }
        String string = obsProject.getStatus();
        if (string.equals(ObsProject.STATUS_NEWPHASE1) || string.equals(ObsProject.STATUS_PHASE1SUBMITTED)) {
            return false;
        }
        return false;
    }

    private void makePreferredEditorVisible(Editor editor, Editor editor2, Editor editor3) {
        boolean bl;
        HashSet<EditorManager.EditorType> hashSet = new HashSet<EditorManager.EditorType>();
        EditorManager.EditorType editorType = this.getEditorPreference();
        boolean bl2 = bl = editor != null && editor2 != null && editor3 != null;
        if (bl) {
            editorType = EditorManager.EditorType.FORM;
        }
        boolean bl3 = this.isPhase2InstrumentSetupEditorSelected = editor instanceof SpectralSpecFormEditor && editor3 instanceof SpectralSpecVisualEditor;
        if (this.isPhase2InstrumentSetupEditorSelected) {
            editorType = this.phase2InstrumentSetUpEditorType;
        }
        if (editor != null) {
            hashSet.add(EditorManager.EditorType.FORM);
        }
        if (editor2 != null) {
            hashSet.add(EditorManager.EditorType.VISUAL_SPATIAL);
        }
        if (editor3 != null) {
            hashSet.add(EditorManager.EditorType.VISUAL_SPECTRAL);
        }
        if (hashSet.isEmpty()) {
            return;
        }
        if (bl) {
            editorType = EditorManager.EditorType.FORM;
        }
        switch (editorType) {
            case FORM: {
                editorType = this.selectAvailableEditor(hashSet, EditorManager.EditorType.FORM, EditorManager.EditorType.VISUAL_SPATIAL, EditorManager.EditorType.VISUAL_SPECTRAL);
                break;
            }
            case VISUAL_SPATIAL: {
                editorType = this.selectAvailableEditor(hashSet, EditorManager.EditorType.VISUAL_SPATIAL, EditorManager.EditorType.VISUAL_SPECTRAL, EditorManager.EditorType.FORM);
                break;
            }
            case VISUAL_SPECTRAL: {
                editorType = this.selectAvailableEditor(hashSet, EditorManager.EditorType.VISUAL_SPECTRAL, EditorManager.EditorType.VISUAL_SPATIAL, EditorManager.EditorType.FORM);
            }
        }
        this.updateCurrentEditorType(editorType);
        if (editorType != null) {
            this.tabContainerEditor.setSelectedIndex(this.editorTypeToTabInPanelMap.get((Object)editorType));
        }
        this.enableEditors(hashSet);
        this.enableEditorsForScienceGoalSummaryTable(editor);
    }

    private void enableEditorsForScienceGoalSummaryTable(Editor editor) {
        Model model;
        if (editor instanceof SummaryTableEditor && (model = editor.getModel()).getDocument() instanceof ScienceGoal) {
            int n = this.editorTypeToTabInPanelMap.get((Object)EditorManager.EditorType.VISUAL_SPECTRAL);
            int n2 = this.editorTypeToTabInPanelMap.get((Object)EditorManager.EditorType.VISUAL_SPATIAL);
            this.tabContainerEditor.setEnabledAt(n, false);
            this.tabContainerEditor.setEnabledAt(n2, false);
            this.tabContainerEditor.setSelectedIndex(this.editorTypeToTabInPanelMap.get((Object)EditorManager.EditorType.FORM));
        }
    }

    private void enableEditors(Set<EditorManager.EditorType> set) {
        int n = this.editorTypeToTabInPanelMap.get((Object)EditorManager.EditorType.FORM);
        if (set.contains((Object)EditorManager.EditorType.FORM)) {
            this.tabContainerEditor.setEnabledAt(n, true);
        } else {
            this.tabContainerEditor.setEnabledAt(n, false);
        }
        n = this.editorTypeToTabInPanelMap.get((Object)EditorManager.EditorType.VISUAL_SPECTRAL);
        if (set.contains((Object)EditorManager.EditorType.VISUAL_SPECTRAL)) {
            this.tabContainerEditor.setEnabledAt(n, true);
        } else {
            this.tabContainerEditor.setEnabledAt(n, false);
        }
        n = this.editorTypeToTabInPanelMap.get((Object)EditorManager.EditorType.VISUAL_SPATIAL);
        if (set.contains((Object)EditorManager.EditorType.VISUAL_SPATIAL)) {
            this.tabContainerEditor.setEnabledAt(n, true);
        } else {
            this.tabContainerEditor.setEnabledAt(n, false);
        }
    }

    private EditorManager.EditorType selectAvailableEditor(Set<EditorManager.EditorType> set, EditorManager.EditorType ... editorTypeArray) {
        for (EditorManager.EditorType editorType : editorTypeArray) {
            if (!set.contains((Object)editorType)) continue;
            return editorType;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tabContainerEditor) {
            try {
                EditorManager.EditorType editorType = this.tab2EditorType[this.tabContainerEditor.getSelectedIndex()];
                this.updateCurrentEditorType(editorType);
                if (this.isPhase2InstrumentSetupEditorSelected) {
                    this.phase2InstrumentSetUpEditorType = editorType;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.updateCurrentEditorType(null);
            }
        }
    }

    private EditorManager.EditorType getEditorPreference() {
        return this.editPreference;
    }

    private void updateCurrentEditorType(EditorManager.EditorType editorType) {
        Class clazz = null;
        switch (editorType) {
            case FORM: {
                Object object;
                if (this.currentNode == null || (object = this.currentNode.getUserObject()) == null) break;
                clazz = object.getClass();
                break;
            }
            case VISUAL_SPATIAL: 
            case VISUAL_SPECTRAL: {
                clazz = ScienceGoal.class;
                break;
            }
            default: {
                Log.logger(ObservingToolGui.class).warning("Unable to determine editor type in tab");
            }
        }
        if (clazz == null) {
            return;
        }
        this.previousEditor.ifPresent(editor -> editor.finalizeUserEdits());
        this.previousEditor = Optional.ofNullable(this.editorManager.editorFor(editorType, ScienceGoal.class));
    }

    public void updateEditor() throws MultipageViewException {
        this.updateEditor(this.currentNode, false);
    }

    public void updateEditor(boolean bl) throws MultipageViewException {
        this.updateEditor(this.currentNode, bl);
    }

    public void refreshCrossHighlight() {
        this.refreshCrossHighlight(this.currentNode);
    }

    private void refreshCrossHighlight(ProjectTreeNode projectTreeNode) {
        ProjectTree projectTree = this.getProjectTree();
        if (projectTree == null) {
            return;
        }
        ArrayList<ProjectTreeNode> arrayList = projectTree.findNodesBelow(projectTree.getTop(), this.leavesOnly);
        for (ProjectTreeNode object : arrayList) {
            object.setHighlight(false);
        }
        BusinessObject businessObject = (BusinessObject)projectTreeNode.getUserObject();
        if (businessObject instanceof Target) {
            for (AttachableToTarget attachableToTarget : ((Target)businessObject).attachedObjects()) {
                ProjectTreeNode projectTreeNode2 = projectTree.findNode(attachableToTarget);
                if (projectTreeNode2 == null) continue;
                projectTreeNode2.setHighlight(true);
            }
        } else if (businessObject instanceof AttachableToTarget) {
            for (Target target : ((AttachableToTarget)businessObject).getTargetList()) {
                ProjectTreeNode projectTreeNode3 = projectTree.findNode(target);
                if (projectTreeNode3 == null) continue;
                projectTreeNode3.setHighlight(true);
            }
        } else if (businessObject instanceof ObservingGroup) {
            Editor editor = this.editorManager.editorFor(EditorManager.EditorType.FORM, businessObject);
            ObservingGroupEditor observingGroupEditor = (ObservingGroupEditor)editor;
            Target[] targetArray = observingGroupEditor.getHighlightedTargets();
            if (targetArray.length > 0) {
                for (Target target : targetArray) {
                    ProjectTreeNode projectTreeNode4 = projectTree.findNode(target);
                    if (projectTreeNode4 != null) {
                        projectTreeNode4.setHighlight(true);
                    }
                    for (AttachableToTarget attachableToTarget : target.attachedObjects()) {
                        projectTreeNode4 = projectTree.findNode(attachableToTarget);
                        if (projectTreeNode4 == null) continue;
                        projectTreeNode4.setHighlight(true);
                    }
                }
            } else {
                for (OrderedTarget orderedTarget : ((ObservingGroup)businessObject).getOrderedTarget()) {
                    Target target = orderedTarget.getTarget();
                    ProjectTreeNode projectTreeNode5 = projectTree.findNode(target);
                    if (projectTreeNode5 == null) continue;
                    projectTreeNode5.setHighlight(true);
                }
            }
        }
        projectTree.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveEvent(Event event) {
        ProjectTreeNode projectTreeNode;
        BusinessObject businessObject = (BusinessObject)event.getData();
        this.currentNode = projectTreeNode = (ProjectTreeNode)event.getSource();
        try {
            this.showAsBusy(true);
            this.updateEditor(projectTreeNode, false);
        }
        catch (MultipageViewException multipageViewException) {
            this.logger.warning("Cannot display component part " + businessObject.getNameOrDefault() + " - " + multipageViewException.getLocalizedMessage());
        }
        finally {
            this.showAsBusy(false);
        }
    }

    @Override
    public EditorManager getEditors() {
        return this.editorManager;
    }

    private TreePile getPhase2TreePile() {
        return this.phase2Pile;
    }

    private TreePile getPhase1TreePile() {
        return this.phase1Pile;
    }

    private void createPalette() {
        this.palette = new Colors();
    }

    public Colors getPalette() {
        return this.palette;
    }

    protected AbstractJob jobSaveCurrentPerspective() {
        return new AbstractJob("save current perspective", false){

            @Override
            public void job() throws Exception {
                try {
                    ObservingToolGui.this.perspectPane.saveCurrent();
                }
                catch (BadLookAndFeelException badLookAndFeelException) {
                    GUIUtilities.info(null, "Your current Look-and-Feel caused a problem.\nThe current perspective will not be restorable.");
                }
            }
        };
    }

    public boolean isOverviewPanelVisible() {
        int n;
        JSplitPane jSplitPane = (JSplitPane)this.perspectPane.getChild();
        int n2 = jSplitPane.getHeight();
        return n2 - (n = jSplitPane.getDividerLocation()) >= 30;
    }

    public boolean isFeedbackPanelVisible() {
        int n;
        String string = this.perspectPane.getPerspectiveName();
        JSplitPane jSplitPane = (JSplitPane)this.perspectPane.getChild();
        JSplitPane jSplitPane2 = (JSplitPane)jSplitPane.getTopComponent();
        JSplitPane jSplitPane3 = string.equals("1") ? (JSplitPane)jSplitPane2.getRightComponent() : (JSplitPane)jSplitPane2.getLeftComponent();
        int n2 = jSplitPane3.getHeight();
        return n2 - (n = jSplitPane3.getDividerLocation()) >= 30;
    }

    public void setOverviewPanelVisible(boolean bl) {
        JSplitPane jSplitPane = (JSplitPane)this.perspectPane.getChild();
        if (bl) {
            jSplitPane.setDividerLocation(jSplitPane.getSize().height - jSplitPane.getInsets().top - jSplitPane.getDividerSize() - 220);
        } else {
            jSplitPane.setDividerLocation(1.0);
        }
    }

    public void setFeedbackPanelVisible(boolean bl) {
        String string = this.perspectPane.getPerspectiveName();
        JSplitPane jSplitPane = (JSplitPane)this.perspectPane.getChild();
        JSplitPane jSplitPane2 = (JSplitPane)jSplitPane.getTopComponent();
        JSplitPane jSplitPane3 = string.equals("1") ? (JSplitPane)jSplitPane2.getRightComponent() : (JSplitPane)jSplitPane2.getLeftComponent();
        if (bl) {
            jSplitPane3.setDividerLocation(0.7);
        } else {
            jSplitPane3.setDividerLocation(1.0);
        }
    }

    public void toggleOverviewPanel() {
        this.setOverviewPanelVisible(!this.isOverviewPanelVisible());
        this.setFeedbackPanelVisible(this.isFeedbackPanelVisible());
    }

    public void viewOverviewPanel() {
        if (!this.isOverviewPanelVisible()) {
            this.setOverviewPanelVisible(true);
            this.setFeedbackPanelVisible(this.isFeedbackPanelVisible());
        }
    }

    public void toggleFeedbackPanel() {
        this.setFeedbackPanelVisible(!this.isFeedbackPanelVisible());
    }

    public void viewFeedbackPanel() {
        if (!this.isFeedbackPanelVisible()) {
            this.setFeedbackPanelVisible(true);
        }
    }

    protected void activatePerspective(String string) {
        block5: {
            try {
                try {
                    this.perspectPane.activatePerspective(string);
                }
                catch (UndefinedPerspectiveException undefinedPerspectiveException) {
                    this.logger.fine("couldn't activate perspective: " + undefinedPerspectiveException);
                    if (string.equals("1")) {
                        this.setupDefaultPerspective1();
                        this.perspectPane.snapshotPerspective("1");
                        break block5;
                    }
                    this.setupDefaultPerspective2();
                    this.perspectPane.snapshotPerspective("2");
                }
            }
            catch (BadLookAndFeelException badLookAndFeelException) {
                this.logger.fine("perspective exception: " + badLookAndFeelException);
                GUIUtilities.info(null, "Your current Look-and-Feel caused a problem. Please choose another Look-and-Feel");
            }
        }
    }

    public void setEnabledOverride(Component component, boolean bl) {
        if (bl && this.componentDisabler != null) {
            this.componentDisabler.disableAutoDisable(component);
        }
        component.setEnabled(bl);
    }

    protected void activateLookAndFeel(String string, int n) {
        if (string.equals(this.currLafName) && n == this.currFontSize) {
            return;
        }
        LookAndFeel lookAndFeel = this.guiFactory.giveLookAndFeel(string);
        if (lookAndFeel == null) {
            this.logger.warning("Could not switch to Look and Feel '" + string + "'; ignoring.");
            return;
        }
        try {
            Serializable serializable;
            Object object2;
            UIDefaults uIDefaults = UIManager.getDefaults();
            Object object3 = uIDefaults.keys();
            while (object3.hasMoreElements()) {
                Object k = object3.nextElement();
                if (!(k instanceof String) || !((String)(object2 = (String)k)).endsWith(".font") && !((String)object2).endsWith(".titleFont") && !((String)object2).endsWith(".acceleratorFont") || !(uIDefaults.get(object2) instanceof FontUIResource)) continue;
                FontUIResource object4 = (FontUIResource)uIDefaults.get(object2);
                serializable = new FontUIResource(object4.deriveFont((float)n));
                UIManager.put(object2, serializable);
            }
            UIManager.setLookAndFeel(lookAndFeel);
            object3 = System.getProperty("os.name").toLowerCase();
            boolean bl = ((String)object3).startsWith("mac os x");
            if (bl) {
                this.setupMacOSBindings();
            }
            for (Window window : this.guiFactory.windows) {
                SwingUtilities.updateComponentTreeUI(window);
            }
            SwingUtilities.updateComponentTreeUI(this.dlgPreferences);
            for (Editor editor : this.getEditors().getAllEditors()) {
                SwingUtilities.updateComponentTreeUI(editor);
            }
            object2 = this.userManualHB.getWindowPresentation().getHelpWindow();
            if (object2 != null) {
                SwingUtilities.updateComponentTreeUI((Component)object2);
            }
            Iterator<JFileChooser> iterator = this.guiFactory.getFileChoosers();
            serializable = null;
            FileFilter fileFilter = null;
            while (iterator.hasNext()) {
                serializable = iterator.next();
                fileFilter = ((JFileChooser)serializable).getFileFilter();
                SwingUtilities.updateComponentTreeUI((Component)serializable);
                ((JFileChooser)serializable).setFileFilter(fileFilter);
            }
            for (ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment : this.allProjectCompartments()) {
                for (JMenu jMenu : observingToolGuiProjectCompartment.getMenus()) {
                    SwingUtilities.updateComponentTreeUI(jMenu);
                }
            }
            SwingUtilities.updateComponentTreeUI(this.menDebug);
            SwingUtilities.updateComponentTreeUI(this.menHelp);
        }
        catch (Exception exception) {
            GUIUtilities.error(null, "Failure activating Look-and-Feel.", exception);
        }
        this.currLafName = string;
        this.currFontSize = n;
    }

    @Override
    public ColorPalette getColorPalette() {
        return this.getPalette();
    }

    public void flagStatus(ObsProject obsProject) {
        Iterable<SchedBlock> iterable;
        ArrayList<Problem> arrayList = new ArrayList<Problem>();
        try {
            iterable = obsProject.gettrueObsProgram().gettrueObsPlan().findSchedBlocks();
            for (SchedBlock object : iterable) {
                if (object.getStatus().equals(SchedBlock.STATUS_BROKEN)) {
                    arrayList.add(DefaultProblem.createError("SchedBlock is marked Broken", "Either terminate the SB or fix the SB and mark it as repaired", object));
                    continue;
                }
                if (!object.getStatus().equals(SchedBlock.STATUS_CSVSUSPENDED)) continue;
                arrayList.add(DefaultProblem.createWarning("Observations of this SchedBlock are suspended", "Use the 'Resume' option if you wish to resume observations of this SchedBlock", object));
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            GUIUtilities.error(null, unknownEntityException.toString());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (arrayList.size() > 0) {
            iterable = this.getProblemModel(obsProject);
            iterable.start();
            for (Problem problem : arrayList) {
                iterable.add(problem);
            }
            iterable.finish();
        }
    }

    public boolean shouldShowStaffActions() {
        return this.controller.advancedOptions().isShowStaffActions();
    }

    private void readAdvancedOptions() {
        ObservingToolController.AdvancedOptions advancedOptions = this.controller.advancedOptions();
        boolean bl = advancedOptions.isShowStaffActions();
        boolean bl2 = advancedOptions.isShowNewProject();
        boolean bl3 = advancedOptions.isShowCreateGoal();
        boolean bl4 = advancedOptions.isShowDebugMenu();
        this.menDebug.setVisible(bl4);
        this.adjustActions(bl, bl2, bl3);
        this.adjustEditors(bl, bl2, bl3);
    }

    private void adjustActions(boolean bl, boolean bl2, boolean bl3) {
        for (ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment : this.allProjectCompartments()) {
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().newCommissioningProject, bl2);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().newVLBIProject, bl2);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().newProject, bl);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().submitAsNew, bl);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().runPhaseIGenerator, bl);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().runPhaseIGeneratorBatch, bl);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().exportSB, bl);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().addCalibratorSurveyGoal, bl3);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().addRadiometricPointing, bl3);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().addBaselineCalibrationGoal, bl3);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().addOpticalPointingScienceGoal, bl3);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().addCalibratorSurveyScienceGoal, bl3);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().addHolographySetup, bl3);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().addOpticalPointingParameters, bl3);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().addRadiometricPointingParameters, bl3);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().addOpticalCameraSpec, bl3);
            this.setOTActionVisible(observingToolGuiProjectCompartment.getProjectTiedActions().addHolographyParameters, bl3);
        }
    }

    private void setOTActionVisible(Action action, boolean bl) {
        if (action != null && action instanceof OTAction) {
            ((OTAction)action).setVisible(bl);
        }
    }

    private void adjustEditors(boolean bl, boolean bl2, boolean bl3) {
        Object object;
        ObservingParameterTabEditor observingParameterTabEditor;
        SpectralSpecFormEditor spectralSpecFormEditor;
        SchedBlockEditor schedBlockEditor;
        EditorManager editorManager = this.getEditors();
        ObsProjectEditor obsProjectEditor = (ObsProjectEditor)editorManager.editorFor(EditorManager.EditorType.FORM, ObsProject.class);
        if (obsProjectEditor != null) {
            obsProjectEditor.setAdvancedOptionsVisible(bl);
        }
        if ((schedBlockEditor = (SchedBlockEditor)editorManager.editorFor(EditorManager.EditorType.FORM, SchedBlock.class)) != null) {
            schedBlockEditor.setAdvancedParametersVisible(bl);
            schedBlockEditor.setScriptEditingVisible(bl);
        }
        if ((spectralSpecFormEditor = (SpectralSpecFormEditor)editorManager.editorFor(EditorManager.EditorType.FORM, SpectralSpec.class)) != null) {
            spectralSpecFormEditor.setAdvancedEngineeringVisible(bl);
        }
        if ((observingParameterTabEditor = (ObservingParameterTabEditor)editorManager.editorFor(EditorManager.EditorType.FORM, ObservingParameters.class)) != null) {
            object = observingParameterTabEditor.getAllEditors();
            while (object.hasNext()) {
                Object e = object.next();
                if (!(e instanceof ObservingParameterEditor)) continue;
                ((ObservingParameterEditor)e).setAdvancedParametersVisible(bl);
            }
        }
        if ((object = (ObsProposalEditor)editorManager.editorFor(EditorManager.EditorType.FORM, ObsProposal.class)) != null) {
            ((ObsProposalEditor)object).setAdvancedProposalsVisible(bl);
        }
        CalibratorExpert.SourceCatalog.setEnableOfflineCatalogAccess(bl2);
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }

    public static class FeedbackInfo {
        private String summary;
        private String details;

        public FeedbackInfo(String string, String string2) {
            this.summary = string;
            this.details = string2;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getDetails() {
            return this.details;
        }
    }
}

