/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.misc;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.BOCollection;
import alma.obsprep.bo.FieldSourceCollection;
import alma.obsprep.bo.InstrumentSpecCollection;
import alma.obsprep.bo.ObservingParametersCollection;
import alma.obsprep.bo.PhaseISciencePlanCollection;
import alma.obsprep.bo.TargetCollection;
import alma.obsprep.bo.annotations.SummaryTable;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.misc.ScienceGoalSummaryTableLoader;
import alma.obsprep.ot.editors.misc.SummaryTableEditor;
import alma.obsprep.ot.editors.misc.SummaryTableRowsLoader;
import alma.obsprep.ot.gui.toplevel.EditorManager;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SummaryTableModel<E extends SummaryTableRow>
extends Model
implements TableModel {
    protected final ObservingToolController otc;
    static HashMap<Class<?>, SummaryTableRowsLoader> loaders = new HashMap();
    private Vector<E> rows;
    private E sample = null;
    protected EventListenerList listenerList = new EventListenerList();

    public SummaryTableModel(Object object, ObservingToolController observingToolController) {
        super(object);
        this.otc = observingToolController;
        this.rows = new Vector();
    }

    public void clear() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public boolean add(E e) {
        int n = this.rows.size();
        boolean bl = this.rows.add(e);
        if (bl) {
            this.fireTableRowsInserted(n, n);
        }
        return bl;
    }

    public void add(SummaryTable<E> summaryTable) {
        this.add(summaryTable, true);
    }

    public void add(SummaryTable<E> summaryTable, boolean bl) {
        if (summaryTable instanceof SummaryTableRow) {
            this.add((SummaryTableRow)((Object)summaryTable));
        }
        for (SummaryTableRow summaryTableRow : summaryTable) {
            try {
                SummaryTable summaryTable2 = (SummaryTable)((Object)summaryTableRow);
                this.add(summaryTable2, bl);
            }
            catch (ClassCastException classCastException) {
                if (!bl) continue;
                this.add(summaryTableRow);
            }
        }
    }

    public void addChildrenElements(SummaryTable<E> summaryTable, boolean bl) {
        for (SummaryTableRow summaryTableRow : summaryTable) {
            try {
                SummaryTable summaryTable2 = (SummaryTable)((Object)summaryTableRow);
                this.add(summaryTable2, bl);
            }
            catch (ClassCastException classCastException) {
                if (!bl) continue;
                this.add(summaryTableRow);
            }
        }
    }

    public void add(int n, E e) {
        this.rows.add(n, e);
        this.fireTableRowsInserted(n, n);
    }

    public boolean addAll(Collection<? extends E> collection) {
        int n = this.rows.size();
        boolean bl = this.rows.addAll(collection);
        if (bl) {
            this.fireTableRowsInserted(n, n + collection.size());
        }
        return bl;
    }

    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = this.rows.addAll(n, collection);
        if (bl) {
            this.fireTableRowsInserted(n, n + collection.size());
        }
        return bl;
    }

    public E remove(int n) {
        SummaryTableRow summaryTableRow = (SummaryTableRow)this.rows.remove(n);
        if (summaryTableRow != null) {
            this.fireTableRowsDeleted(n, n);
        }
        return (E)summaryTableRow;
    }

    public boolean remove(Object object) {
        boolean bl = this.rows.remove(object);
        if (bl) {
            this.fireTableDataChanged();
        }
        return bl;
    }

    public boolean removeAll(Collection<?> collection) {
        boolean bl = this.rows.removeAll(collection);
        if (bl) {
            this.fireTableDataChanged();
        }
        return bl;
    }

    public boolean retainAll(Collection<?> collection) {
        boolean bl = this.rows.retainAll(collection);
        if (bl) {
            this.fireTableDataChanged();
        }
        return bl;
    }

    public E set(int n, E e) {
        SummaryTableRow summaryTableRow = (SummaryTableRow)this.rows.set(n, e);
        this.fireTableRowsUpdated(n, n);
        return (E)summaryTableRow;
    }

    public E get(int n) {
        return (E)((SummaryTableRow)this.rows.get(n));
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        int n = 0;
        if (this.getRowCount() > 0) {
            return ((SummaryTableRow)this.rows.get(0)).getSummaryTableColumns().getSummaryColumnCount();
        }
        if (this.sample != null) {
            return this.sample.getSummaryTableColumns().getSummaryColumnCount();
        }
        return n;
    }

    @Override
    public String getColumnName(int n) {
        String string = "";
        if (this.getRowCount() > 0) {
            return ((SummaryTableRow)this.rows.get(0)).getSummaryTableColumns().getSummaryColumnName(n);
        }
        if (this.sample != null) {
            return this.sample.getSummaryTableColumns().getSummaryColumnName(n);
        }
        return string;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (this.getRowCount() > 0) {
            return ((SummaryTableRow)this.rows.get(0)).getSummaryTableColumns().getSummaryColumnClass(n);
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        try {
            SummaryTable summaryTable = (SummaryTable)this.getDocument();
            return summaryTable.isSummaryTableEditable() && ((SummaryTableRow)this.rows.get(n)).getSummaryTableColumns().isSummaryCellEditable(n2);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return ((SummaryTableRow)this.rows.get(n)).getSummaryTableColumns().getSummaryValueAt(n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ((SummaryTableRow)this.rows.get(n)).getSummaryTableColumns().setSummaryValueAt(object, n2);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.add(TableModelListener.class, tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.remove(TableModelListener.class, tableModelListener);
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 1));
    }

    public void fireTableRowsUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 0));
    }

    public void fireTableRowsDeleted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, -1));
    }

    public void fireTableCellUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n, n2));
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableModelListener.class) continue;
            ((TableModelListener)objectArray[i + 1]).tableChanged(tableModelEvent);
        }
    }

    public void addnew() {
        try {
            BOCollection bOCollection = (BOCollection)this.getDocument();
            bOCollection.addnew();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void addToParent(List<E> list) {
        try {
            BOCollection bOCollection = (BOCollection)this.getDocument();
            bOCollection.add(list);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void deleteSelected(int[] nArray) {
        try {
            BOCollection bOCollection = (BOCollection)this.getDocument();
            BusinessObject[] businessObjectArray = bOCollection.getCollection();
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                bOCollection.remove(businessObjectArray[n]);
                this.remove(businessObjectArray[n]);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void loadFromFile(File file) {
        SummaryTableRowsLoader summaryTableRowsLoader = loaders.get(this.getDocument().getClass());
        if (summaryTableRowsLoader == null) {
            return;
        }
        try {
            summaryTableRowsLoader.loadList(file, ",");
        }
        catch (IOException iOException) {
            return;
        }
        this.addToParent(summaryTableRowsLoader.getList());
    }

    public Object[] getSummaryColumnItemList(int n) {
        if (this.getRowCount() == 0) {
            return null;
        }
        return ((SummaryTableRow)this.rows.get(0)).getSummaryTableColumns().getSummaryColumnKnownItemList(n);
    }

    public Object[] getLongValues() {
        return this.sample != null ? this.sample.getSummaryTableColumns().getLongValues() : new Object[]{};
    }

    public void updateRows() {
        if (this.rows.size() > 0) {
            this.fireTableRowsUpdated(0, this.rows.size() - 1);
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return null;
    }

    @Override
    public void publish() {
        this.fireTableStructureChanged();
        this.publish(SummaryTableEditor.FID_TABLE, null);
    }

    @Override
    public void setDocument(Object object) {
        Object object2;
        SummaryTable<SummaryTableRow> summaryTable;
        this.clear();
        EditorManager editorManager = this.otc.getGui().getEditors();
        SummaryTableEditor summaryTableEditor = (SummaryTableEditor)editorManager.getSummaryFormEditor();
        if (object instanceof PhaseISciencePlanCollection) {
            summaryTableEditor.setMessage("Table of the science goals. Double click on table to select science goal in project tree.");
        } else if (object instanceof ScienceGoal) {
            summaryTable = (ScienceGoal)object;
            if (summaryTable.getTargetParametersCount() > 0) {
                object2 = summaryTable.getName();
                String string = ((ScienceGoal)summaryTable).getRepresentativeFrequency().toString();
                if (summaryTable.getName().equals("Science Goal")) {
                    summaryTableEditor.setMessage("Table of the field sources for the science goal. Representative frequency is " + string);
                } else {
                    summaryTableEditor.setMessage("<html>Table of the field sources for the <em>" + (String)object2 + "</em> science goal. Representative frequency is " + string + "</html>");
                }
            }
        } else if (object instanceof TargetCollection) {
            summaryTableEditor.setMessage("Table of the targets");
        } else if (object instanceof FieldSourceCollection) {
            summaryTableEditor.setMessage("Table of the field sources");
        } else if (object instanceof InstrumentSpecCollection) {
            summaryTableEditor.setMessage("Table of the instrument specifications");
        } else if (object instanceof ObservingParametersCollection) {
            summaryTableEditor.setMessage("Table of the observing parameters");
        }
        try {
            summaryTable = (SummaryTable)object;
            if (object instanceof ScienceGoal) {
                this.addChildrenElements(summaryTable, summaryTable.expandsRow());
            } else {
                this.add(summaryTable, summaryTable.expandsRow());
            }
            if (this.rows.size() > 0) {
                this.sample = (SummaryTableRow)this.rows.get(0);
            }
        }
        catch (ClassCastException classCastException) {
            try {
                object2 = (SummaryTableRow)object;
                this.clear();
                this.add(object2);
            }
            catch (ClassCastException classCastException2) {
                // empty catch block
            }
        }
        super.setDocument(object);
    }

    static {
        loaders.put(PhaseISciencePlanCollection.class, new ScienceGoalSummaryTableLoader());
    }
}

