/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.obsproject.CalibratedAbstractScienceGoal;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.GoalTargetParameters;
import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.obsproject.CalibrationSetupParametersEditor;
import alma.obsprep.ot.editors.obsproject.CalibratorTableElement;
import alma.obsprep.ot.models.obsproject.CalibrationTargetParametersModel;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CalibrationSetupParametersModel
extends Model {
    public static final FieldID CALIBRATOR_TABLE_ELEMENTS = new FieldID("CalibrationSetupParametersModel query sources FID");
    private final CalibratorExpertModel queryModel = new CalibratorExpertModel(null);
    private final CalibrationTargetParametersModel targetModel = new CalibrationTargetParametersModel(null);
    private GoalTargetParameters firstTarget;

    public CalibrationSetupParametersModel(CalibrationSetupParameters calibrationSetupParameters) {
        super((Object)calibrationSetupParameters);
        this.queryModel.subscribe(new CalibratorExpertController());
        this.setDocument((Object)calibrationSetupParameters);
    }

    private void setDefaultCalibratorIntents() {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters == null) {
            return;
        }
        this.clearCalibrations();
        for (String string : this.getDefaultIntents()) {
            this.addQuerySource(string);
        }
    }

    public void addCalibration(QuerySource querySource) {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null && querySource != null) {
            calibrationSetupParameters.addQuerySource(querySource);
        }
    }

    public void addCalibration(CalibrationTargetParameters calibrationTargetParameters) {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null && calibrationTargetParameters != null) {
            calibrationSetupParameters.addCalibrationTargetParameters(calibrationTargetParameters);
        }
    }

    public void clearCalibrations() {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null) {
            calibrationSetupParameters.clearQuerySource();
            calibrationSetupParameters.clearCalibrationTargetParameters();
        }
        this.publish();
    }

    private Collection<String> getDefaultIntents() {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters == null) {
            return new ArrayList<String>();
        }
        BusinessObject businessObject = calibrationSetupParameters.getParent();
        if (businessObject instanceof CalibratedAbstractScienceGoal) {
            CalibratedAbstractScienceGoal calibratedAbstractScienceGoal = (CalibratedAbstractScienceGoal)businessObject;
            List<String> list = ObservingModeExpert.getDefaultCalibratorIntents(calibratedAbstractScienceGoal);
            list.remove(QuerySource.INTENDEDUSE_ATMOSPHERIC);
            list.remove(QuerySource.INTENDEDUSE_BANDPASS);
            return list;
        }
        throw new AssertionError((Object)"Parent entity does not implement CalibratedAbstractScienceGoal");
    }

    public Collection<String> getCalibrationIntents() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (QuerySource targetWithIntent : this.getQuerySources()) {
            arrayList.add(targetWithIntent.getIntendedUse());
        }
        for (CalibrationTargetParameters calibrationTargetParameters : this.getCalibrationTargetParameters()) {
            arrayList.add(calibrationTargetParameters.getIntendedUse());
        }
        return arrayList;
    }

    private CalibrationSetupParameters getCalibrationSetupParameters() {
        CalibrationSetupParameters calibrationSetupParameters = (CalibrationSetupParameters)((Object)this.getDocument());
        return calibrationSetupParameters;
    }

    public CalibratorExpertModel getCalibratorExpertModel() {
        return this.queryModel;
    }

    public CalibrationTargetParametersModel getCalibrationTargetParametersModel() {
        return this.targetModel;
    }

    public Collection<QuerySource> getQuerySources() {
        ArrayList<QuerySource> arrayList = new ArrayList<QuerySource>();
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null) {
            for (QuerySource querySource : calibrationSetupParameters.getQuerySource()) {
                arrayList.add(querySource);
            }
        }
        return arrayList;
    }

    public Collection<CalibrationTargetParameters> getCalibrationTargetParameters() {
        ArrayList<CalibrationTargetParameters> arrayList = new ArrayList<CalibrationTargetParameters>();
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null) {
            for (CalibrationTargetParameters calibrationTargetParameters : calibrationSetupParameters.getCalibrationTargetParameters()) {
                arrayList.add(calibrationTargetParameters);
            }
        }
        return arrayList;
    }

    @Override
    public void publish() {
        CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
        if (calibrationSetupParameters != null) {
            this.publish(CALIBRATOR_TABLE_ELEMENTS, this.getCalibratorTableElements());
            if (CalibrationSetupParameters.SELECTION_SYSTEM.equals(calibrationSetupParameters.getSelection())) {
                this.publish(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_STANDARD, null);
            } else if (CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE.equals(calibrationSetupParameters.getSelection())) {
                this.publish(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_AMPLITUDE, null);
            } else {
                this.publish(CalibrationSetupParametersEditor.MANUAL_CALIBRATORS, null);
            }
        }
    }

    public QuerySource addQuerySource(String string) {
        Object object;
        QuerySource querySource = QuerySource.createQuerySource(string);
        if (this.firstTarget != null) {
            object = this.firstTarget.getSourceCoordinates().deepCopy();
            querySource.setQueryCenter((SkyCoordinates)object);
            querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
        }
        if ((object = this.getCalibrationSetupParameters()) != null) {
            object.addQuerySource(querySource);
        }
        return querySource;
    }

    public CalibrationTargetParameters addCalibrationTargetParameters(String string) {
        Object object;
        CalibrationTargetParameters calibrationTargetParameters = CalibrationTargetParameters.createCalibrationTargetParameters(string);
        if (this.firstTarget != null) {
            object = this.firstTarget.getSourceCoordinates().deepCopy();
            calibrationTargetParameters.setSourceCoordinates((SkyCoordinates)object);
        }
        if ((object = this.getCalibrationSetupParameters()) != null) {
            object.addCalibrationTargetParameters(calibrationTargetParameters);
        }
        return calibrationTargetParameters;
    }

    public void removeCalibrator(QuerySource querySource) {
        if (querySource != null) {
            CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
            calibrationSetupParameters.removeQuerySource(querySource);
        }
    }

    public void removeCalibrator(CalibrationTargetParameters calibrationTargetParameters) {
        if (calibrationTargetParameters != null) {
            CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
            calibrationSetupParameters.removeCalibrationTargetParameters(calibrationTargetParameters);
        }
    }

    @Override
    public void setDocument(Object object) {
        if (object != null && object instanceof CalibrationSetupParameters) {
            this.queryModel.setDocument(null);
            this.targetModel.setDocument(null);
        }
        super.setDocument(object);
    }

    private List<CalibratorTableElement> getCalibratorTableElements() {
        ArrayList<CalibratorTableElement> arrayList = new ArrayList<CalibratorTableElement>();
        for (QuerySource targetWithIntent : this.getQuerySources()) {
            arrayList.add(new CalibratorTableElement(targetWithIntent));
        }
        for (CalibrationTargetParameters calibrationTargetParameters : this.getCalibrationTargetParameters()) {
            arrayList.add(new CalibratorTableElement(calibrationTargetParameters));
        }
        return arrayList;
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (CalibrationSetupParametersEditor.ADD_CALIBRATOR_QUERY.equals(fieldID)) {
            if (object instanceof String) {
                String string = (String)object;
                QuerySource querySource = null;
                if (!string.isEmpty()) {
                    querySource = this.addQuerySource(string);
                }
                this.publish(CALIBRATOR_TABLE_ELEMENTS, this.getCalibratorTableElements());
                return querySource;
            }
        } else if (CalibrationSetupParametersEditor.ADD_FIXED_CALIBRATOR.equals(fieldID)) {
            if (object instanceof String) {
                String string = (String)object;
                CalibrationTargetParameters calibrationTargetParameters = null;
                if (!string.isEmpty()) {
                    calibrationTargetParameters = this.addCalibrationTargetParameters(string);
                }
                this.publish(CALIBRATOR_TABLE_ELEMENTS, this.getCalibratorTableElements());
                return calibrationTargetParameters;
            }
        } else {
            if (CalibrationSetupParametersEditor.DELETE_CALIBRATOR_QUERY.equals(fieldID)) {
                if (object instanceof QuerySource) {
                    QuerySource querySource = (QuerySource)object;
                    this.removeCalibrator(querySource);
                    this.publish(CALIBRATOR_TABLE_ELEMENTS, this.getCalibratorTableElements());
                    return object;
                }
                if (object instanceof CalibrationTargetParameters) {
                    CalibrationTargetParameters calibrationTargetParameters = (CalibrationTargetParameters)object;
                    this.removeCalibrator(calibrationTargetParameters);
                    this.publish(CALIBRATOR_TABLE_ELEMENTS, this.getCalibratorTableElements());
                    return object;
                }
                throw new AssertionError((Object)"Non-string intent published");
            }
            if (fieldID.equals(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_STANDARD)) {
                CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
                if (calibrationSetupParameters != null) {
                    calibrationSetupParameters.setSelection(CalibrationSetupParameters.SELECTION_SYSTEM);
                }
                this.publish(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_STANDARD, null);
                return object;
            }
            if (fieldID.equals(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_AMPLITUDE)) {
                CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
                if (calibrationSetupParameters != null) {
                    calibrationSetupParameters.setSelection(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE);
                }
                this.publish(CalibrationSetupParametersEditor.SYSTEM_CALIBRATORS_AMPLITUDE, null);
                return object;
            }
            if (fieldID.equals(CalibrationSetupParametersEditor.MANUAL_CALIBRATORS)) {
                CalibrationSetupParameters calibrationSetupParameters = this.getCalibrationSetupParameters();
                if (calibrationSetupParameters != null) {
                    calibrationSetupParameters.setSelection(CalibrationSetupParameters.SELECTION_USER);
                    if (calibrationSetupParameters.getQuerySource().length == 0) {
                        this.setDefaultCalibratorIntents();
                        this.publish(CALIBRATOR_TABLE_ELEMENTS, this.getCalibratorTableElements());
                    }
                }
                this.publish(CalibrationSetupParametersEditor.MANUAL_CALIBRATORS, null);
                return object;
            }
            if (fieldID.equals(CalibrationSetupParametersEditor.EDIT_CALIBRATOR_QUERY)) {
                this.publish();
                return object;
            }
        }
        return object;
    }

    public void setDefaultSearchPosition(GoalTargetParameters goalTargetParameters) {
        this.firstTarget = goalTargetParameters;
    }

    public void setDefaultSearchPosition(TargetParameters targetParameters) {
        SkyCoordinates skyCoordinates = targetParameters.getFieldCenterCoordinates();
        this.firstTarget = ObservatoryGoalTargetParameters.createObservatoryGoalTargetParameters();
        this.firstTarget.setSourceCoordinates(skyCoordinates);
    }
}

