/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.Source;
import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.obsprep.bo.obsproject.GoalTargetParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.schedblock.NameResolver;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.ot.models.valuetypes.VelocityModel;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.util.astro.Resolver;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class GoalTargetParametersModel
extends Model {
    public static FieldID ADD_PROPERTY = new FieldID("GoalTargetParametersModel add property FID");
    public static FieldID CALIBRATION_TARGET_PROPERTIES = new FieldID("GoalTargetParametersModel calibration target properties FID");
    public static FieldID REMOVE_PROPERTY = new FieldID("GoalTargetParametersModel remove property FID");
    public static FieldID RESOLVE_SOURCE = new FieldID("GoalTargetParametersModel Resolve source button FID");
    public static FieldID SOURCE_NAME = new FieldID("GoalTargetParametersModel Source name FID");
    public static FieldID VELOCITY_VALUE = new FieldID("GoalTargetParametersModel velocity value FID");
    public static FieldID VELOCITY_UNITS = new FieldID("GoalTargetParametersModel velocity units FID");
    public static FieldID VELOCITY_REDSHIFT = new FieldID("GoalTargetParametersModel velocity redshift FID");
    public static FieldID VELOCITY_DOPPLER = new FieldID("GoalTargetParametersModel velocity doppler FID");
    public static FieldID VELOCITY_SYSTEM = new FieldID("GoalTargetParametersModel velocity system FID");
    private final NameResolver nameResolver = new NameResolver();
    private final SkyCoordsModel skyCoordsModel = new SkyCoordsModel(null);
    private final VelocityModel velocityModel = new VelocityModel(null, VELOCITY_VALUE, VELOCITY_UNITS, VELOCITY_SYSTEM, VELOCITY_DOPPLER, VELOCITY_REDSHIFT);

    public GoalTargetParametersModel(GoalTargetParameters goalTargetParameters) {
        super(goalTargetParameters);
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                GoalTargetParametersModel.this.getController().modelChanged(fieldID, object);
            }
        };
        this.skyCoordsModel.subscribe(modelChangeSubscriber);
        this.velocityModel.subscribe(modelChangeSubscriber);
        this.registerSubModel(this.skyCoordsModel);
        this.registerSubModel(this.velocityModel);
        this.setDocument(goalTargetParameters);
    }

    @Override
    public void setDocument(Object object) {
        if (object instanceof GoalTargetParameters) {
            GoalTargetParameters goalTargetParameters = (GoalTargetParameters)object;
            this.velocityModel.setDocument((Object)goalTargetParameters.getSourceVelocity());
            this.skyCoordsModel.setDocument(goalTargetParameters.getSourceCoordinates());
            super.setDocument(object);
        }
    }

    @Override
    public void publish() {
        GoalTargetParameters goalTargetParameters = this.getGoalTargetParameters();
        if (goalTargetParameters == null) {
            return;
        }
        this.publish(CALIBRATION_TARGET_PROPERTIES, goalTargetParameters.getCalibrationTargetProperties());
        this.publish(SOURCE_NAME, goalTargetParameters.getSourceName());
        for (Model model : this.getSubModels()) {
            model.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (RESOLVE_SOURCE.equals(fieldID)) {
            this.resolveName();
            return object;
        }
        if (SOURCE_NAME.equals(fieldID)) {
            GoalTargetParameters goalTargetParameters = this.getGoalTargetParameters();
            if (goalTargetParameters != null) {
                if (object instanceof String) {
                    goalTargetParameters.setSourceName((String)object);
                } else {
                    throw new IllegalArgumentException("Non-String published for source name");
                }
            }
            return object;
        }
        if (ADD_PROPERTY.equals(fieldID)) {
            this.addCalibrationTargetProperties(CalibrationTargetProperties.createCalibrationTargetProperties());
            return object;
        }
        if (REMOVE_PROPERTY.equals(fieldID)) {
            if (!(object instanceof Collection)) {
                throw new IllegalArgumentException("Non-Collection published for target property");
            }
            Collection collection = (Collection)object;
            this.removeCalibrationTargetProperties(collection);
            return object;
        }
        for (Model model : this.getSubModels()) {
            object = model.update(editor, fieldID, object);
        }
        return object;
    }

    public VelocityModel getVelocityModel() {
        return this.velocityModel;
    }

    public SkyCoordsModel getSkyCoordsModel() {
        return this.skyCoordsModel;
    }

    private GoalTargetParameters getGoalTargetParameters() {
        return (GoalTargetParameters)this.getDocument();
    }

    private void resolveName() {
        Object object;
        GoalTargetParameters goalTargetParameters = this.getGoalTargetParameters();
        if (goalTargetParameters == null) {
            return;
        }
        String string = goalTargetParameters.getSourceName();
        if (string.length() > 0 && (object = this.nameResolver.resolve(goalTargetParameters)) != null && object instanceof Resolver) {
            goalTargetParameters.clearCalibrationTargetProperties();
            this.publish();
            this.skyCoordsModel.publish(SkyCoordsModel.FID_RESOLVEDBY, ((Resolver)object).getNameServer());
        }
    }

    public void setTargetFromSource(Source source) {
        GoalTargetParameters goalTargetParameters = this.getGoalTargetParameters();
        if (goalTargetParameters != null && source != null) {
            goalTargetParameters.setSourceName(CalibratorExpert.findJ2000NameOrDefault(source.getNames()));
            Iterator iterator = source.getMeasurements().iterator();
            if (iterator.hasNext()) {
                Measurement measurement = (Measurement)iterator.next();
                goalTargetParameters.getSourceCoordinates().setAbsoluteCoordinatesInDegInSystem(measurement.getRa(), measurement.getDec(), SkyCoordinates.SYSTEM_ICRS);
            }
            goalTargetParameters.getSourceVelocity().setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
            goalTargetParameters.clearCalibrationTargetProperties();
            for (Measurement measurement : source.getMeasurements()) {
                CalibrationTargetProperties calibrationTargetProperties = CalibrationTargetProperties.createCalibrationTargetProperties(measurement);
                goalTargetParameters.addCalibrationTargetProperties(calibrationTargetProperties);
            }
            this.publish();
        }
    }

    public void setTargetFromMeasurement(Measurement measurement) {
        Integer n = measurement.getSourceId();
        Source source = null;
        if (n != null) {
            source = CalibratorExpert.getInstance().getSource(n);
        }
        if (source != null) {
            this.setTargetFromSource(source);
            GoalTargetParameters goalTargetParameters = this.getGoalTargetParameters();
            if (goalTargetParameters != null && measurement != null) {
                goalTargetParameters.getSourceCoordinates().setAbsoluteCoordinatesInDegInSystem(measurement.getRa(), measurement.getDec(), SkyCoordinates.SYSTEM_ICRS);
                this.publish();
            }
        } else {
            GoalTargetParameters goalTargetParameters = this.getGoalTargetParameters();
            if (goalTargetParameters != null && measurement != null) {
                goalTargetParameters.setSourceName(measurement.getFormattedName());
                goalTargetParameters.getSourceCoordinates().setAbsoluteCoordinatesInDegInSystem(measurement.getRa(), measurement.getDec(), SkyCoordinates.SYSTEM_ICRS);
                goalTargetParameters.getSourceVelocity().setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
                CalibrationTargetProperties calibrationTargetProperties = CalibrationTargetProperties.createCalibrationTargetProperties(measurement);
                goalTargetParameters.clearCalibrationTargetProperties();
                goalTargetParameters.addCalibrationTargetProperties(calibrationTargetProperties);
                this.publish();
            }
        }
    }

    public void addCalibrationTargetProperties(CalibrationTargetProperties calibrationTargetProperties) {
        GoalTargetParameters goalTargetParameters = this.getGoalTargetParameters();
        if (goalTargetParameters != null && calibrationTargetProperties != null) {
            goalTargetParameters.addCalibrationTargetProperties(calibrationTargetProperties);
            this.publish(CALIBRATION_TARGET_PROPERTIES, goalTargetParameters.getCalibrationTargetProperties());
        }
    }

    public void setCalibrationTargetProperties(CalibrationTargetProperties calibrationTargetProperties, int n) {
        GoalTargetParameters goalTargetParameters = this.getGoalTargetParameters();
        if (goalTargetParameters != null && calibrationTargetProperties != null) {
            CalibrationTargetProperties[] calibrationTargetPropertiesArray = goalTargetParameters.getCalibrationTargetProperties();
            calibrationTargetPropertiesArray[n] = calibrationTargetProperties;
            goalTargetParameters.setCalibrationTargetProperties(calibrationTargetPropertiesArray);
            this.publish(CALIBRATION_TARGET_PROPERTIES, goalTargetParameters.getCalibrationTargetProperties());
        }
    }

    public Collection<CalibrationTargetProperties> getCalibrationTargetProperties() {
        ArrayList<CalibrationTargetProperties> arrayList = new ArrayList<CalibrationTargetProperties>();
        GoalTargetParameters goalTargetParameters = this.getGoalTargetParameters();
        if (goalTargetParameters != null) {
            for (CalibrationTargetProperties calibrationTargetProperties : goalTargetParameters.getCalibrationTargetProperties()) {
                arrayList.add(calibrationTargetProperties);
            }
        }
        return arrayList;
    }

    public boolean removeCalibrationTargetProperties(CalibrationTargetProperties calibrationTargetProperties) {
        GoalTargetParameters goalTargetParameters;
        if (calibrationTargetProperties != null && (goalTargetParameters = this.getGoalTargetParameters()) != null) {
            return goalTargetParameters.removeCalibrationTargetProperties(calibrationTargetProperties);
        }
        return false;
    }

    public void removeCalibrationTargetProperties(Collection<CalibrationTargetProperties> collection) {
        GoalTargetParameters goalTargetParameters;
        if (collection != null && (goalTargetParameters = this.getGoalTargetParameters()) != null) {
            for (CalibrationTargetProperties calibrationTargetProperties : collection) {
                goalTargetParameters.removeCalibrationTargetProperties(calibrationTargetProperties);
            }
            this.publish(CALIBRATION_TARGET_PROPERTIES, goalTargetParameters.getCalibrationTargetProperties());
        }
    }
}

