/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsattachment.DocumentLink;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.investigator.TableInvestigator;
import alma.obsprep.ot.editors.obsproject.ObsProposalEditor;
import alma.obsprep.services.userlookup.User;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JList;

public class ObsProposalModel
extends Model {
    public static final String VLBI = "VLBI";
    private static AlmaPolicies apol = AlmaPolicies.getInstance();
    private int[] oldKeywords = new int[0];
    private int previousKeyword = -1;
    private int currentKeyword = -1;

    public ObsProposalModel(Object object) {
        super(object);
    }

    public ObsProposal getObsProposal() {
        ObsProposal obsProposal = this.getTrueObsProposal();
        if (obsProposal == null) {
            obsProposal = ObsProposal.createObsProposal();
            this.setDocument((Object)obsProposal);
        }
        return obsProposal;
    }

    public boolean isDDT() {
        ObsProject obsProject;
        ObsProposal obsProposal = this.getTrueObsProposal();
        if (obsProposal == null) {
            return false;
        }
        try {
            obsProject = obsProposal.getObsProject();
        }
        catch (UnknownEntityException unknownEntityException) {
            return false;
        }
        return obsProject != null ? obsProject.getIsDDT() : false;
    }

    private ObsProposal getTrueObsProposal() {
        return (ObsProposal)((Object)this.getDocument());
    }

    public ObsAttachment gettrueAttachments() throws UnknownEntityException {
        ObsAttachment obsAttachment = null;
        obsAttachment = this.getObsProposal().gettrueDocuments();
        return obsAttachment;
    }

    public ObsAttachment getAttachments() throws UnknownEntityException {
        ObsAttachment obsAttachment = this.gettrueAttachments();
        if (obsAttachment == null) {
            obsAttachment = ObsAttachment.createObsAttachment();
            this.getObsProposal().setDocuments(obsAttachment);
        }
        return obsAttachment;
    }

    @Override
    public void publish() {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal == null) {
            return;
        }
        this.publish(ObsProposalEditor.THIS_FID, (Object)obsProposal);
        this.publish(ObsProposalEditor.CATEGORY_FID, obsProposal.getScientificCategoryString());
        this.publish(ObsProposalEditor.KEYWORDS_FID, obsProposal.getKeyword());
        this.publish(ObsProposalEditor.ABSTRACT_FID, obsProposal.getAbstract());
        this.publish(ObsProposalEditor.PROPOSALTYPE_FID, obsProposal.getProposalTypeString());
        this.publish(ObsProposalEditor.ADVANCEDPROPOSALTYPE_FID, obsProposal.getProposalTypeString());
        this.publish(ObsProposalEditor.RELATEDPROPS_FID, obsProposal.getRelatedProposals());
        this.publish(ObsProposalEditor.DUPLICATE_OBSERVATION_FID, obsProposal.getDuplicateObservationsJustification());
        this.publish(ObsProposalEditor.PREVIOUSPROPS_FID, obsProposal.getPreviousProposals());
        this.publish(ObsProposalEditor.DATERECEIVED_FID, obsProposal.getDateReceived());
        this.publish(ObsProposalEditor.CYCLE_FID, obsProposal.getCycle());
        this.publish(ObsProposalEditor.STUDENT_FID, obsProposal.getStudentProject());
        this.publishDocumentFilename(DocumentLink.DOCUMENTCLASS_SCIENCE_CASE);
        this.publishDocumentFilename(DocumentLink.DOCUMENTCLASS_FIGURES);
        this.publishDocumentFilename(DocumentLink.DOCUMENTCLASS_TECHNICAL_CASE);
        this.publishDocumentFilename(DocumentLink.DOCUMENTCLASS_TABLES);
        this.publish(FieldIDs.investigatorClearAllFID, null);
        this.publish(FieldIDs.investigatorSetPiFID, (Object)obsProposal.getPrincipalInvestigator());
        List<Investigator> list = Arrays.asList(obsProposal.getCoPrincipalInvestigator());
        this.publish(FieldIDs.investigatorAddCoPiFID, list);
        List<Investigator> list2 = Arrays.asList(obsProposal.getCoInvestigator());
        this.publish(FieldIDs.investigatorAddCoiFID, list2);
    }

    @Override
    public void setDocument(Object object) {
        BusinessObject businessObject;
        ObsProject obsProject;
        super.setDocument(object);
        Model model = this.getParentModel();
        if ((model != null || object instanceof ObsProposal) && (obsProject = (businessObject = (BusinessObject)object).findProject()) != null) {
            if (!model.getDocument().equals(obsProject)) {
                model.setDocument(obsProject);
            }
            this.publish(FieldIDs.projectNameFID, obsProject.getProjectName());
        }
    }

    public void publishProposalType() {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal == null) {
            return;
        }
        this.publish(ObsProposalEditor.PROPOSALTYPE_FID, obsProposal.getProposalTypeString());
    }

    private synchronized void checkKeywordsInRange(Editor editor, JList jList) {
        int[] nArray = jList.getSelectedIndices();
        Arrays.sort(this.oldKeywords);
        for (int n : nArray) {
            if (Arrays.binarySearch(this.oldKeywords, n) >= 0) continue;
            this.currentKeyword = n;
            break;
        }
        if (this.currentKeyword == this.previousKeyword) {
            return;
        }
        if (nArray.length > 2) {
            editor.suspendEvents(jList);
            int[] nArray2 = new int[]{this.previousKeyword, this.currentKeyword};
            jList.setSelectedIndices(nArray2);
            this.oldKeywords = nArray2;
            editor.resumeEvents(jList);
        } else {
            this.oldKeywords = nArray;
        }
        this.previousKeyword = this.currentKeyword;
    }

    public void debugKeywords(String string, int[] nArray) {
        System.out.printf(string, new Object[0]);
        for (int n : nArray) {
            System.out.printf("%d ", n);
        }
        System.out.printf("\n", new Object[0]);
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(FieldIDs.investigatorSetPiFID)) {
            if (object instanceof Investigator) {
                this.setPrincipalInvestigator((Investigator)((Object)object));
            }
            return object;
        }
        ObsProposal obsProposal = this.getObsProposal();
        if (fieldID.equals(FieldIDs.investigatorAddCoiFID)) {
            if (object instanceof List) {
                for (Investigator investigator : (List)object) {
                    this.addCoInvestigator(investigator);
                }
            }
            return object;
        }
        if (fieldID.equals(FieldIDs.investigatorRemoveCoiFID)) {
            if (object instanceof List) {
                for (TableInvestigator tableInvestigator : (List)object) {
                    this.deleteCoI(tableInvestigator.getInvestigator());
                }
            }
            return object;
        }
        if (fieldID.equals(FieldIDs.investigatorAddCoPiFID)) {
            if (object instanceof List) {
                for (Investigator investigator : (List)object) {
                    this.addCoPrincipalInvestigator(investigator);
                }
            }
            return object;
        }
        if (fieldID.equals(FieldIDs.investigatorRemoveCoPiFID)) {
            if (object instanceof List) {
                for (TableInvestigator tableInvestigator : (List)object) {
                    this.deleteCoPrincipalInvestigator(tableInvestigator.getInvestigator());
                }
            }
            return object;
        }
        if (fieldID == ObsProposalEditor.KEYWORDS_FID) {
            JList jList = (JList)editor.retrieve(ObsProposalEditor.KEYWORDS_FID);
            this.checkKeywordsInRange(editor, jList);
            Object[] objectArray = jList.getSelectedValues();
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = objectArray[i].toString();
            }
            obsProposal.setKeyword(stringArray);
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = apol.getScienceKeywordCode(stringArray[i]);
            }
            obsProposal.setKeywordCode(stringArray2);
            return stringArray;
        }
        String string = object.toString();
        if (fieldID == ObsProposalEditor.CATEGORY_FID) {
            AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
            String string2 = almaPolicies.getScienceCodeForCategory(string);
            obsProposal.setScientificCategoryCode(string2);
            obsProposal.setScientificCategoryString(string);
            String[] stringArray = almaPolicies.getScienceKeywords(string2);
            JList jList = (JList)editor.retrieve(ObsProposalEditor.KEYWORDS_FID);
            jList.setListData(stringArray);
        } else if (fieldID == ObsProposalEditor.ABSTRACT_FID) {
            obsProposal.setAbstract(string);
        } else if (fieldID == ObsProposalEditor.DUPLICATE_OBSERVATION_FID) {
            obsProposal.setDuplicateObservationsJustification(string);
        } else if (fieldID == ObsProposalEditor.PROPOSALTYPE_FID) {
            AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
            String string3 = almaPolicies.getCodeForProposalType(string);
            obsProposal.setProposalTypeCode(string3);
            obsProposal.setProposalTypeString(string);
            this.scheduleACAInAllScienceGoals();
        } else if (fieldID == ObsProposalEditor.ADVANCEDPROPOSALTYPE_FID) {
            AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
            String string4 = almaPolicies.getCodeForProposalType(string);
            if (string4.equals("?")) {
                string4 = almaPolicies.getCodeForObservatoryType(string);
            }
            obsProposal.setProposalTypeCode(string4);
            obsProposal.setProposalTypeString(string);
        } else if (fieldID == ObsProposalEditor.RELATEDPROPS_FID) {
            obsProposal.setRelatedProposals(string);
        } else if (fieldID == ObsProposalEditor.PREVIOUSPROPS_FID) {
            obsProposal.setPreviousProposals(string);
        } else if (fieldID != ObsProposalEditor.DATERECEIVED_FID) {
            if (fieldID == ObsProposalEditor.CYCLE_FID) {
                obsProposal.setCycle(string);
            } else if (fieldID == ObsProposalEditor.STUDENT_FID) {
                obsProposal.setStudentProject((Boolean)object);
            }
        }
        return string;
    }

    private void scheduleACAInAllScienceGoals() {
        for (AbstractScienceGoal abstractScienceGoal : this.getObsProposal().getAbstractScienceGoal()) {
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            ScienceGoal.determineACAScheduling(scienceGoal);
        }
    }

    public void resetProposalType() {
        ObsProposal obsProposal = this.getObsProposal();
        obsProposal.setProposalTypeCode(null);
        obsProposal.setProposalTypeString(null);
    }

    void publishDocumentFilename(String string) {
        ObsAttachment obsAttachment;
        try {
            obsAttachment = this.gettrueAttachments();
        }
        catch (UnknownEntityException unknownEntityException) {
            obsAttachment = null;
        }
        if (obsAttachment == null) {
            this.publish(ObsProposalEditor.SCIDOCUMENT_FID, null);
            this.publish(ObsProposalEditor.FIGURES_FID, null);
            this.publish(ObsProposalEditor.TECHDOCUMENT_FID, null);
            this.publish(ObsProposalEditor.TABLES_FID, null);
            return;
        }
        if (string.equals(DocumentLink.DOCUMENTCLASS_SCIENCE_CASE)) {
            this.publish(ObsProposalEditor.SCIDOCUMENT_FID, (Object)obsAttachment.gettrueDocumentLink(string));
        } else if (string.equals(DocumentLink.DOCUMENTCLASS_TECHNICAL_CASE)) {
            this.publish(ObsProposalEditor.TECHDOCUMENT_FID, (Object)obsAttachment.gettrueDocumentLink(string));
        } else if (string.equals(DocumentLink.DOCUMENTCLASS_FIGURES)) {
            this.publish(ObsProposalEditor.FIGURES_FID, (Object)obsAttachment.gettrueDocumentLink(string));
        } else if (string.equals(DocumentLink.DOCUMENTCLASS_TABLES)) {
            this.publish(ObsProposalEditor.TABLES_FID, (Object)obsAttachment.gettrueDocumentLink(string));
        }
    }

    public void attachDocument(File file, String string) throws UnknownEntityException {
        this.getAttachments().attachDocument(file, string);
        this.publishDocumentFilename(string);
    }

    public void detachDocument(String string) throws UnknownEntityException {
        this.getAttachments().detachDocument(string);
        this.publishDocumentFilename(string);
        if (this.getAttachments().getDocumentLinkCount() == 0) {
            this.getObsProposal().setDocuments(null);
        }
    }

    public Investigator getPrincipalInvestigator() {
        Investigator investigator = this.getTruePrincipalInvestigator();
        if (investigator == null) {
            investigator = Investigator.createInvestigator();
            this.getObsProposal().setPrincipalInvestigator(investigator);
        }
        return investigator;
    }

    private Investigator getTruePrincipalInvestigator() {
        ObsProposal obsProposal = this.getTrueObsProposal();
        if (obsProposal == null) {
            return null;
        }
        return obsProposal.getPrincipalInvestigator();
    }

    public void setPrincipalInvestigator(Investigator investigator) {
        if (investigator != null) {
            this.getObsProposal().setPrincipalInvestigator(investigator);
        }
    }

    public int addCoInvestigator(Investigator investigator) {
        if (!this.getCoInvestigators().contains((Object)investigator)) {
            this.getObsProposal().addCoInvestigator(investigator);
        }
        return this.getCoInvestigators().indexOf((Object)investigator);
    }

    public int addCoPrincipalInvestigator(Investigator investigator) {
        if (!this.getCoInvestigators().contains((Object)investigator)) {
            this.getObsProposal().addCoPrincipalInvestigator(investigator);
        }
        return this.getCoPrincipalInvestigators().indexOf((Object)investigator);
    }

    public void addCoInvestigators(Collection<Investigator> collection) {
        if (collection != null) {
            for (Investigator investigator : collection) {
                this.addCoInvestigator(investigator);
            }
        }
    }

    public void addCoInvestigators(Investigator[] investigatorArray) {
        if (investigatorArray != null) {
            for (Investigator investigator : investigatorArray) {
                this.addCoInvestigator(investigator);
            }
        }
    }

    public void addCoPrincipalInvestigators(Investigator[] investigatorArray) {
        if (investigatorArray != null) {
            for (Investigator investigator : investigatorArray) {
                this.addCoPrincipalInvestigator(investigator);
            }
        }
    }

    public int addCoInvestigator(User user) {
        Investigator investigator = Investigator.createInvestigator(user);
        this.getObsProposal().addCoInvestigator(investigator);
        return this.getCoInvestigators().indexOf((Object)investigator);
    }

    public int addCoPrincipalInvestigator(User user) {
        Investigator investigator = Investigator.createInvestigator(user);
        this.getObsProposal().addCoPrincipalInvestigator(investigator);
        return this.getCoPrincipalInvestigators().indexOf((Object)investigator);
    }

    public void deleteCoInvestigator(int n) {
        Investigator investigator = this.getCoInvestigator(n);
        this.deleteCoI(investigator);
    }

    public void deleteCoPrincipalInvestigator(int n) {
        Investigator investigator = this.getCoPrincipalInvestigator(n);
        this.deleteCoPrincipalInvestigator(investigator);
    }

    public void deleteCoI(Investigator investigator) {
        this.getObsProposal().removeCoInvestigator(investigator);
    }

    public void deleteCoPrincipalInvestigator(Investigator investigator) {
        this.getObsProposal().removeCoPrincipalInvestigator(investigator);
    }

    public Investigator getCoInvestigator(int n) {
        Investigator[] investigatorArray = this.getObsProposal().getCoInvestigator();
        if (n > investigatorArray.length - 1) {
            return null;
        }
        return investigatorArray[n];
    }

    public Investigator getCoPrincipalInvestigator(int n) {
        Investigator[] investigatorArray = this.getObsProposal().getCoPrincipalInvestigator();
        if (n > investigatorArray.length - 1) {
            return null;
        }
        return investigatorArray[n];
    }

    public List<Investigator> getCoInvestigators() {
        List<Investigator> list = this.getTrueCoInvestigators();
        if (list == null) {
            list = new ArrayList<Investigator>();
            Investigator[] investigatorArray = list.toArray(new Investigator[list.size()]);
            this.getObsProposal().setCoInvestigator(investigatorArray);
        }
        return list;
    }

    public List<Investigator> getCoPrincipalInvestigators() {
        List<Investigator> list = this.getTrueCoPrincipalInvestigators();
        if (list == null) {
            list = new ArrayList<Investigator>();
            Investigator[] investigatorArray = list.toArray(new Investigator[list.size()]);
            this.getObsProposal().setCoPrincipalInvestigator(investigatorArray);
        }
        return list;
    }

    private List<Investigator> getTrueCoInvestigators() {
        ObsProposal obsProposal = this.getTrueObsProposal();
        if (obsProposal == null) {
            return null;
        }
        return Arrays.asList(obsProposal.getCoInvestigator());
    }

    private List<Investigator> getTrueCoPrincipalInvestigators() {
        ObsProposal obsProposal = this.getTrueObsProposal();
        if (obsProposal == null) {
            return null;
        }
        return Arrays.asList(obsProposal.getCoPrincipalInvestigator());
    }

    public void clearCoInvestigators() {
        ObsProposal obsProposal = this.getTrueObsProposal();
        if (obsProposal != null) {
            obsProposal.clearCoInvestigator();
        }
    }

    public void setCoInvestigator(Investigator investigator) {
        if (investigator != null) {
            List<Investigator> list = this.getCoInvestigators();
            int n = 0;
            for (Investigator investigator2 : list) {
                if (investigator2.getUserId().equals(investigator.getUserId())) {
                    list.set(n, investigator);
                    break;
                }
                ++n;
            }
            list.set(n, investigator);
            this.getObsProposal().setCoInvestigator(list.toArray(new Investigator[list.size()]));
        }
    }

    public void setCoPrincipalInvestigator(Investigator investigator) {
        if (investigator != null) {
            List<Investigator> list = this.getCoPrincipalInvestigators();
            int n = 0;
            for (Investigator investigator2 : list) {
                if (investigator2.getUserId().equals(investigator.getUserId())) {
                    list.set(n, investigator);
                    break;
                }
                ++n;
            }
            this.getObsProposal().setCoPrincipalInvestigator(list.toArray(new Investigator[list.size()]));
        }
    }

    private String convertPreviousProposalToString(PreviousProposalInfo previousProposalInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(previousProposalInfo.code);
        stringBuffer.append(",");
        stringBuffer.append(previousProposalInfo.title);
        stringBuffer.append(",");
        stringBuffer.append(previousProposalInfo.pi);
        stringBuffer.append(",");
        stringBuffer.append(previousProposalInfo.name);
        stringBuffer.append(",");
        stringBuffer.append(previousProposalInfo.publicationStatus);
        stringBuffer.append(",");
        return stringBuffer.toString();
    }

    private PreviousProposalInfo convertStringToPreviousProposal(String string) {
        String[] stringArray = string.split(",");
        PreviousProposalInfo previousProposalInfo = new PreviousProposalInfo();
        int n = 0;
        previousProposalInfo.code = stringArray[n++];
        previousProposalInfo.title = stringArray[n++];
        previousProposalInfo.name = stringArray[n++];
        previousProposalInfo.publicationStatus = stringArray[n++];
        return previousProposalInfo;
    }

    protected static class PreviousProposalInfo {
        protected String code;
        protected String title;
        protected String pi;
        protected String name;
        protected String publicationStatus;
    }
}

