/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.CalibrationRequirements;
import alma.obsprep.bo.obsproject.ObsUnit;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.Time;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

public class ObsUnitModel
extends Model {
    private ValueUnitPairModel maximumTimeModel = new ValueUnitPairModel(null, FieldIDs.maximumTimeValueFID, FieldIDs.maximumTimeUnitsFID);
    private ValueUnitPairModel estimatedTimeModel = new ValueUnitPairModel(null, FieldIDs.estimatedTimeValueFID, FieldIDs.estimatedTimeUnitsFID);
    private ValueUnitPairModel pointingAccuracyModel = new ValueUnitPairModel(null, FieldIDs.pointingAccuracyValueFID, FieldIDs.pointingAccuracyUnitsFID);
    private ValueUnitPairModel unitDepDelayModel = new ValueUnitPairModel(null, FieldIDs.unitDepDelayValueFID, FieldIDs.unitDepDelayUnitsFID);
    private ValueUnitPairModel unitDepMarginModel = new ValueUnitPairModel(null, FieldIDs.unitDepMarginValueFID, FieldIDs.unitDepMarginUnitsFID);

    public ObsUnitModel(ObsUnit obsUnit) {
        super(obsUnit);
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        this.maximumTimeModel.setNumberFormat(decimalFormat);
        this.estimatedTimeModel.setNumberFormat(decimalFormat);
    }

    private ObsUnit getObsUnit() {
        return (ObsUnit)this.getDocument();
    }

    public ValueUnitPairModel getMaximumTimeModel() {
        return this.maximumTimeModel;
    }

    public ValueUnitPairModel getEstimatedTimeModel() {
        return this.estimatedTimeModel;
    }

    public ValueUnitPairModel getPointingAccuracyModel() {
        return this.pointingAccuracyModel;
    }

    public ValueUnitPairModel getUnitDepDelayModel() {
        return this.unitDepDelayModel;
    }

    public ValueUnitPairModel getUnitDepMarginModel() {
        return this.unitDepMarginModel;
    }

    @Override
    public void publish() {
        ObsUnit obsUnit = this.getObsUnit();
        if (obsUnit == null) {
            return;
        }
        ObsUnitControl obsUnitControl = obsUnit.getObsUnitControl();
        if (obsUnitControl == null) {
            Log.logger(ObsUnitModel.class).warning("No ObsUnitControl in ObsUnit");
            return;
        }
        CalibrationRequirements calibrationRequirements = obsUnitControl.getCalibrationRequirements();
        if (calibrationRequirements == null) {
            Log.logger(ObsUnitModel.class).warning("No CalibrationRequirements in ObsUnit.ObsUnitControl");
            return;
        }
        this.publish(FieldIDs.nameFID, obsUnit.getName());
        this.publish(FieldIDs.statusFID, obsUnit.getStatus());
        this.publish(FieldIDs.noteFID, obsUnit.getNote());
        this.publish(FieldIDs.unitDepExecCountFID, new Integer(obsUnit.getUnitDependencies().getExecutionCount()));
        this.publish(FieldIDs.unitDepExprFID, obsUnit.getUnitDependencies().getExpression());
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = obsUnit.getUnitDependencies().getDependencyList();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        this.publish(FieldIDs.unitDepListFID, stringBuffer.toString());
        this.publish(FieldIDs.arrayRequestedFID, String.valueOf(obsUnitControl.getArrayRequested()));
        this.publish(FieldIDs.userPriorityFID, String.valueOf(obsUnitControl.getUserPriority()));
        this.publish(FieldIDs.tacPriorityFID, String.valueOf(obsUnitControl.getTacPriority()));
        this.publish(FieldIDs.polarizationAccuracyFID, new Double(obsUnitControl.getCalibrationRequirements().getPolarizationAccuracy()));
        this.publish(FieldIDs.bandpassAccuracyFID, new Double(obsUnitControl.getCalibrationRequirements().getBandpassAccuracy()));
        this.getMaximumTimeModel().publish();
        this.getEstimatedTimeModel().publish();
        this.getPointingAccuracyModel().publish();
        this.getUnitDepDelayModel().publish();
        this.getUnitDepMarginModel().publish();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        String string = object.toString();
        ObsUnit obsUnit = this.getObsUnit();
        ObsUnitControl obsUnitControl = obsUnit.getObsUnitControl();
        CalibrationRequirements calibrationRequirements = obsUnitControl.getCalibrationRequirements();
        if (fieldID.equals(FieldIDs.nameFID)) {
            obsUnit.setName(string);
        } else if (fieldID.equals(FieldIDs.statusFID)) {
            obsUnit.setStatus(string);
        } else if (fieldID.equals(FieldIDs.noteFID)) {
            obsUnit.setNote(string);
        } else if (fieldID.equals(FieldIDs.unitDepExecCountFID)) {
            obsUnit.getUnitDependencies().setExecutionCount(Integer.parseInt(string));
        } else if (fieldID.equals(FieldIDs.unitDepExprFID)) {
            obsUnit.getUnitDependencies().setExpression(string);
        } else if (fieldID.equals(FieldIDs.unitDepListFID)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            obsUnit.getUnitDependencies().setDependencyList(stringArray);
        } else if (fieldID.equals(FieldIDs.arrayRequestedFID)) {
            obsUnitControl.setArrayRequested(string);
        } else if (fieldID.equals(FieldIDs.userPriorityFID)) {
            obsUnitControl.setUserPriority(Integer.parseInt(string));
        } else if (!fieldID.equals(FieldIDs.tacPriorityFID)) {
            if (fieldID.equals(FieldIDs.bandpassAccuracyFID)) {
                calibrationRequirements.setBandpassAccuracy(Double.parseDouble(string));
            } else if (fieldID.equals(FieldIDs.polarizationAccuracyFID)) {
                calibrationRequirements.setPolarizationAccuracy(Double.parseDouble(string));
            }
        }
        return string;
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        ObsUnit obsUnit = this.getObsUnit();
        Time time = obsUnit.getObsUnitControl().getMaximumTime();
        this.getMaximumTimeModel().setDocument(time);
        time = obsUnit.getObsUnitControl().getEstimatedExecutionTime();
        this.getEstimatedTimeModel().setDocument(time);
        this.getPointingAccuracyModel().setDocument((Object)obsUnit.getObsUnitControl().getCalibrationRequirements().getPointingAccuracy());
        time = obsUnit.getUnitDependencies().getDelay();
        this.getUnitDepDelayModel().setDocument(time);
        time = obsUnit.getUnitDependencies().getMargin();
        this.getUnitDepMarginModel().setDocument(time);
    }
}

