/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.spectralvisual.ScienceViewSpectralVisualEditor;
import alma.obsprep.ot.models.obsproject.CalibratedGoalModel;
import alma.obsprep.ot.models.obsproject.CalibrationSetupParametersModel;
import alma.obsprep.ot.models.obsproject.ObservatoryGoalTargetsModel;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;

public class ObservatoryGoalModel
extends Model
implements CalibratedGoalModel {
    private final ObservatoryGoalTargetsModel targetModel = new ObservatoryGoalTargetsModel(null);
    private final CalibrationSetupParametersModel calibratorsModel = new CalibrationSetupParametersModel(null);
    private final SpectralSetupParametersModel spectralSetupModel = new SpectralSetupParametersModel(null);
    private final ValueUnitPairModel integrationTimeModel = new ValueUnitPairModel(null, ObservatoryGoalTargetsEditor.INTEGRATION_TIME_VALUE_FID, ObservatoryGoalTargetsEditor.INTEGRATION_TIME_UNITS_FID);

    public ObservatoryGoalModel(Object object) {
        super(object);
        this.registerSubModel(this.targetModel);
        this.registerSubModel(this.calibratorsModel);
        this.registerSubModel(this.spectralSetupModel);
        this.registerSubModel(this.integrationTimeModel);
        this.spectralSetupModel.subscribe(new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (fieldID == ScienceViewSpectralVisualEditor.FID_VISUALPANEL) {
                    ObservatoryGoalModel.this.publish(fieldID, null);
                }
            }
        });
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                ObservatoryGoalTargetParameters[] observatoryGoalTargetParametersArray;
                if (ObservatoryGoalTargetsModel.CALIBRATOR_SURVEY_TARGET_CALIBRATORS_FID.equals(fieldID) && object instanceof ObservatoryGoalTargetParameters[] && (observatoryGoalTargetParametersArray = (ObservatoryGoalTargetParameters[])object).length > 0) {
                    ObservatoryGoalModel.this.calibratorsModel.setDefaultSearchPosition(observatoryGoalTargetParametersArray[0]);
                }
            }
        };
        this.targetModel.subscribe(modelChangeSubscriber);
        this.setDocument(object);
    }

    private ObservatoryGoal getObservatoryGoal() {
        return (ObservatoryGoal)this.getDocument();
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        if (object != null && object instanceof ObservatoryGoal) {
            ObservatoryGoal observatoryGoal = (ObservatoryGoal)object;
            this.targetModel.setDocument(observatoryGoal);
            this.calibratorsModel.setDocument((Object)observatoryGoal.getCalibrationSetupParameters());
            this.spectralSetupModel.setDocument((Object)observatoryGoal.getSpectralSetupParameters());
            this.integrationTimeModel.setDocument(observatoryGoal.getIntegrationTime());
        }
    }

    @Override
    public void publish() {
        for (Model model : this.getSubModels()) {
            model.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        for (Model model : this.getSubModels()) {
            object = model.update(editor, fieldID, object);
        }
        return object;
    }

    public ObservatoryGoalTargetsModel getTargetModel() {
        return this.targetModel;
    }

    public SpectralSetupParametersModel getSpectralSetupModel() {
        return this.spectralSetupModel;
    }

    @Override
    public CalibrationSetupParametersModel getCalibrationSetupParametersModel() {
        return this.calibratorsModel;
    }

    public ValueUnitPairModel getIntegrationTimeModel() {
        return this.integrationTimeModel;
    }
}

