/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.common.sourcecatalog.Measurement;
import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.models.obsproject.ObservatoryGoalTargetParametersModel;
import alma.obsprep.ot.models.obsproject.ObservatoryGoalTargetTableLoader;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ObservatoryGoalTargetsModel
extends Model {
    public static final FieldID CALIBRATOR_SURVEY_TARGET_CALIBRATORS_FID = new FieldID("calibrator survey calibrators FID");
    private final CalibratorExpertModel queryModel = new CalibratorExpertModel(null);
    private final ObservatoryGoalTargetParametersModel targetModel = new ObservatoryGoalTargetParametersModel(null);

    public ObservatoryGoalTargetsModel(ObservatoryGoal observatoryGoal) {
        super(observatoryGoal);
        this.queryModel.subscribe(new CalibratorExpertController());
        this.setDocument(observatoryGoal);
    }

    public void addAllCalibrators(List<Measurement> list) {
        List<ObservatoryGoalTargetParameters> list2 = this.convertToTargets(list);
        this.addAllTargets(list2);
    }

    public void addAllTargets(List<ObservatoryGoalTargetParameters> list) {
        ObservatoryGoal observatoryGoal = (ObservatoryGoal)this.getDocument();
        observatoryGoal.addAllTargets(list);
        this.publish(CALIBRATOR_SURVEY_TARGET_CALIBRATORS_FID, this.getTargets());
    }

    private ObservatoryGoalTargetParameters convertToTarget(Measurement measurement) {
        Object object;
        Object object2;
        Object object3;
        ObservatoryGoalTargetParameters observatoryGoalTargetParameters = ObservatoryGoalTargetParameters.createObservatoryGoalTargetParameters();
        String string = CalibratorExpert.findJ2000NameOrDefault(measurement.getNames());
        observatoryGoalTargetParameters.setSourceName(string);
        Double d = measurement.getRa();
        Double d2 = measurement.getDec();
        if (d != null && d2 != null) {
            object3 = SkyCoordinates.createSkyCoordinates();
            object2 = Longitude.createLongitude((double)d, (String)Longitude.UNIT_DEG);
            object = Latitude.createLatitude((double)d2, (String)Latitude.UNIT_DEG);
            object3.setLongitude((Longitude)((Object)object2));
            object3.setLatitude((Latitude)((Object)object));
            object3.setSystem(SkyCoordinates.SYSTEM_J2000);
            observatoryGoalTargetParameters.setSourceCoordinates((SkyCoordinates)object3);
            object3.setFieldName(string);
        }
        object3 = measurement.getFrequency();
        object2 = measurement.getFlux();
        object = CalibrationTargetProperties.createCalibrationTargetProperties();
        if (object2 != null) {
            object.setFlux(Flux.createFlux((double)((Double)object2), (String)Flux.UNIT_JY));
        }
        if (object3 != null) {
            object.setFrequency(Frequency.createFrequency((double)((Double)object3), (String)Frequency.UNIT_HZ));
            object.getFrequency().convertToFriendlyUnit();
        }
        observatoryGoalTargetParameters.addCalibrationTargetProperties((CalibrationTargetProperties)((Object)object));
        return observatoryGoalTargetParameters;
    }

    private List<ObservatoryGoalTargetParameters> convertToTargets(List<Measurement> list) {
        ArrayList<ObservatoryGoalTargetParameters> arrayList = new ArrayList<ObservatoryGoalTargetParameters>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (Measurement measurement : list) {
            Integer n = measurement.getSourceId();
            if (arrayList2.contains(n)) continue;
            ObservatoryGoalTargetParameters observatoryGoalTargetParameters = this.convertToTarget(measurement);
            arrayList.add(observatoryGoalTargetParameters);
            arrayList2.add(n);
        }
        return arrayList;
    }

    public CalibratorExpertModel getCalibratorExpertModel() {
        return this.queryModel;
    }

    public ObservatoryGoalTargetParametersModel getObservatoryGoalTargetParametersModel() {
        return this.targetModel;
    }

    private ObservatoryGoal getObservatoryGoal() {
        return (ObservatoryGoal)this.getDocument();
    }

    private IQuerySource getQuerySourceForFID(FieldID fieldID) {
        if (ObservatoryGoalTargetsEditor.EDIT_TARGET_LIST_QUERY.equals(fieldID)) {
            ObservatoryGoal observatoryGoal = (ObservatoryGoal)this.getDocument();
            return observatoryGoal.getObservatoryGoalQueryParameters();
        }
        throw new AssertionError((Object)"Unhandled 'edit query source' FID published");
    }

    public ObservatoryGoalTargetParameters[] getTargets() {
        ObservatoryGoal observatoryGoal = (ObservatoryGoal)this.getDocument();
        if (observatoryGoal == null) {
            return null;
        }
        ObservatoryGoalTargetParameters[] observatoryGoalTargetParametersArray = observatoryGoal.getObservatoryGoalTargetParameters();
        return observatoryGoalTargetParametersArray;
    }

    public void moveDown(ObservatoryGoalTargetParameters observatoryGoalTargetParameters) {
        List<ObservatoryGoalTargetParameters> list = Arrays.asList(this.getTargets());
        int n = list.indexOf(observatoryGoalTargetParameters);
        if (n != -1 && n < list.size() - 1) {
            ObservatoryGoalTargetParameters observatoryGoalTargetParameters2 = list.get(n + 1);
            list.set(n, observatoryGoalTargetParameters2);
            list.set(n + 1, observatoryGoalTargetParameters);
        }
        this.setTargets(list);
    }

    public void moveUp(ObservatoryGoalTargetParameters observatoryGoalTargetParameters) {
        List<ObservatoryGoalTargetParameters> list = Arrays.asList(this.getTargets());
        int n = list.indexOf(observatoryGoalTargetParameters);
        if (n > 0) {
            ObservatoryGoalTargetParameters observatoryGoalTargetParameters2 = list.get(n - 1);
            list.set(n, observatoryGoalTargetParameters2);
            list.set(n - 1, observatoryGoalTargetParameters);
        }
        this.setTargets(list);
    }

    @Override
    public void publish() {
        this.publish(CALIBRATOR_SURVEY_TARGET_CALIBRATORS_FID, this.getTargets());
        ObservatoryGoal observatoryGoal = (ObservatoryGoal)this.getDocument();
        if (observatoryGoal != null) {
            this.publish(ObservatoryGoalTargetsEditor.OBSERVATORY_GOAL_PURPOSE_FID, observatoryGoal.getPurpose());
            if (observatoryGoal.getUseQuery()) {
                this.publish(ObservatoryGoalTargetsEditor.AUTO_TARGET_LIST_QUERY, null);
            } else {
                this.publish(ObservatoryGoalTargetsEditor.MANUAL_TARGET_LIST_QUERY, null);
            }
        }
        for (Model model : this.getSubModels()) {
            model.publish();
        }
    }

    public void removeAllTargets(List<ObservatoryGoalTargetParameters> list) {
        ObservatoryGoal observatoryGoal = (ObservatoryGoal)this.getDocument();
        observatoryGoal.removeAllTargets(list);
        this.publish(CALIBRATOR_SURVEY_TARGET_CALIBRATORS_FID, this.getTargets());
    }

    public void removeTarget(ObservatoryGoalTargetParameters observatoryGoalTargetParameters) {
        ObservatoryGoal observatoryGoal = (ObservatoryGoal)this.getDocument();
        observatoryGoal.removeObservatoryGoalTargetParameters(observatoryGoalTargetParameters);
        this.publish(CALIBRATOR_SURVEY_TARGET_CALIBRATORS_FID, this.getTargets());
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        if (object instanceof ObservatoryGoal) {
            this.queryModel.setDocument(null);
        }
        this.publish();
    }

    public void setTargets(List<ObservatoryGoalTargetParameters> list) {
        ObservatoryGoal observatoryGoal = (ObservatoryGoal)this.getDocument();
        observatoryGoal.setTargets(list);
        this.publish(CALIBRATOR_SURVEY_TARGET_CALIBRATORS_FID, this.getTargets());
    }

    private void setUseTargetQuery(boolean bl) {
        ObservatoryGoal observatoryGoal = (ObservatoryGoal)this.getDocument();
        if (observatoryGoal != null) {
            observatoryGoal.setUseQuery(bl);
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        Object object2;
        Object object3 = this.getSubModels().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            ((Model)object2).update(editor, fieldID, object);
        }
        if (ObservatoryGoalTargetsEditor.AUTO_TARGET_LIST_QUERY.equals(fieldID)) {
            this.setUseTargetQuery(true);
        } else if (ObservatoryGoalTargetsEditor.MANUAL_TARGET_LIST_QUERY.equals(fieldID)) {
            this.setUseTargetQuery(false);
        } else {
            if (ObservatoryGoalTargetsEditor.EDIT_TARGET_LIST_QUERY.equals(fieldID)) {
                object3 = this.getQuerySourceForFID(fieldID);
                object2 = new QuerySourceAdapter((IQuerySource)object3);
                this.queryModel.setDocument(object2);
                return object;
            }
            if (ObservatoryGoalTargetsEditor.TARGET_LIST_LOAD.equals(fieldID)) {
                if (object instanceof File && ((File)(object3 = (File)object)).exists() && ((File)object3).canRead()) {
                    this.loadFromFile((File)object3);
                }
                return object;
            }
            if (ObservatoryGoalTargetsEditor.TARGET_LIST_REMOVE_ALL.equals(fieldID)) {
                this.removeAllTargets(Arrays.asList(this.getTargets()));
            }
        }
        this.updateTargets(editor, fieldID, object);
        return object;
    }

    public void loadFromFile(File file) {
        ObservatoryGoalTargetTableLoader observatoryGoalTargetTableLoader = new ObservatoryGoalTargetTableLoader();
        if (observatoryGoalTargetTableLoader == null) {
            return;
        }
        try {
            observatoryGoalTargetTableLoader.loadList(file, ",");
        }
        catch (Exception exception) {
            return;
        }
        this.addAllTargets(observatoryGoalTargetTableLoader.getTargets());
    }

    private Object updateTargets(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(ObservatoryGoalTargetsEditor.TARGET_LIST_REMOVE)) {
            if (object instanceof List) {
                List list = (List)object;
                this.removeAllTargets(list);
            }
        } else if (fieldID.equals(ObservatoryGoalTargetsEditor.TARGET_LIST_ADD_CALIBRATOR)) {
            if (object instanceof List) {
                List list = (List)object;
                this.addAllCalibrators(list);
            }
        } else if (fieldID.equals(ObservatoryGoalTargetsEditor.TARGET_LIST_ADD_TARGET)) {
            if (object instanceof ObservatoryGoalTargetParameters) {
                ObservatoryGoalTargetParameters observatoryGoalTargetParameters = (ObservatoryGoalTargetParameters)object;
                ObservatoryGoal observatoryGoal = (ObservatoryGoal)this.getDocument();
                observatoryGoal.addObservatoryGoalTargetParameters(observatoryGoalTargetParameters);
                this.publish(CALIBRATOR_SURVEY_TARGET_CALIBRATORS_FID, this.getTargets());
            }
        } else if (fieldID.equals(ObservatoryGoalTargetsEditor.TARGET_LIST_UP)) {
            if (object instanceof ObservatoryGoalTargetParameters) {
                ObservatoryGoalTargetParameters observatoryGoalTargetParameters = (ObservatoryGoalTargetParameters)object;
                this.moveUp(observatoryGoalTargetParameters);
            }
        } else if (fieldID.equals(ObservatoryGoalTargetsEditor.TARGET_LIST_DOWN) && object instanceof ObservatoryGoalTargetParameters) {
            ObservatoryGoalTargetParameters observatoryGoalTargetParameters = (ObservatoryGoalTargetParameters)object;
            this.moveDown(observatoryGoalTargetParameters);
        }
        return object;
    }
}

