/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.obsproject.RectangleEditor;
import alma.obsprep.ot.editors.sciencegoals.SfiControlParameterEditor;
import alma.obsprep.ot.editors.valuetypes.CoordsEditor;
import alma.obsprep.ot.models.obsproject.SuspendablePropertyChangeListener;
import alma.obsprep.ot.models.valuetypes.CoordsModel;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.experts.RectangleAreaExpert;

public class RectangleModel
extends Model {
    private boolean acaEnabled = true;
    private final ModelChangeSubscriber nPointingsUpdater = (model, fieldID, object) -> {
        Rectangle rectangle = this.getRectangle();
        boolean bl = false;
        if (rectangle != null) {
            RectangleAreaExpert rectangleAreaExpert = RectangleAreaExpert.getInstance(rectangle);
            BusinessObject businessObject = rectangle.getParent().getParent();
            if (businessObject != null && businessObject instanceof ScienceGoal) {
                ScienceGoal scienceGoal = (ScienceGoal)businessObject;
                bl = scienceGoal.isStandAloneACA();
            }
            this.publish(RectangleEditor.NPOINTINGS12M_FID, bl ? "" : Integer.valueOf(rectangleAreaExpert.getNumberOfPointings(Array.ARRAY_12M)));
            this.publish(RectangleEditor.NPOINTINGS7M_FID, rectangleAreaExpert.getNumberOfPointings(Array.ARRAY_7M));
        }
    };
    private final ModelChangeSubscriber updaterFor12mPointings = (model, fieldID, object) -> this.nPointingsUpdater.modelChanged(null, null, null);
    public static final FieldID LONG_VALUE = new FieldID("Rectangle.long.value");
    public static final FieldID LONG_UNIT = new FieldID("Rectangle.long.unit");
    public static final FieldID SHORT_VALUE = new FieldID("Rectangle.short.value");
    public static final FieldID SHORT_UNIT = new FieldID("Rectangle.short.unit");
    public static final FieldID PA_LONG_VALUE = new FieldID("Rectangle.paLong.value");
    public static final FieldID PA_LONG_UNIT = new FieldID("Rectangle.paLong.unit");
    public static final FieldID SPACING_VALUE = new FieldID("Rectangle.spacing.value");
    public static final FieldID SPACING_UNIT = new FieldID("Rectangle.spacing.unit");
    private final CoordsModel coordsModel = new CoordsModel(null);
    private final ValueUnitPairModel longModel = new ValueUnitPairModel(null, LONG_VALUE, LONG_UNIT);
    private final ValueUnitPairModel shortModel = new ValueUnitPairModel(null, SHORT_VALUE, SHORT_UNIT);
    private final ValueUnitPairModel paLongModel = new ValueUnitPairModel(null, PA_LONG_VALUE, PA_LONG_UNIT);
    private final UserUnitValueUnitPairModel spacingModel = new UserUnitValueUnitPairModel(null, SPACING_VALUE, SPACING_UNIT);
    private final SuspendablePropertyChangeListener boListener = new SuspendablePropertyChangeListener(this);
    private final ModelChangeSubscriber acaEnabledUpdater = new ModelChangeSubscriber(){

        @Override
        public void modelChanged(Model model, FieldID fieldID, Object object) {
            boolean bl = RectangleModel.this.acaEnabled;
            if (SfiControlParameterEditor.FID_ACAOBSERVATION.equals(fieldID) && object instanceof Boolean) {
                RectangleModel.this.acaEnabled = (Boolean)object;
                RectangleModel.this.publish(RectangleEditor.ACA_ENABLED_FID, RectangleModel.this.acaEnabled);
            }
            RectangleModel.this.nPointingsUpdater.modelChanged(null, null, null);
            if (bl != RectangleModel.this.acaEnabled && RectangleModel.this.acaEnabled) {
                RectangleModel.this.nPointingsUpdater.modelChanged(null, null, null);
            }
        }
    };

    public RectangleModel(Object object2) {
        super(object2);
        this.registerSubModel(this.coordsModel);
        this.registerSubModel(this.longModel);
        this.registerSubModel(this.shortModel);
        this.registerSubModel(this.paLongModel);
        this.registerSubModel(this.spacingModel);
        this.configureNpointingsUpdater();
        this.setDocument(object2);
    }

    private Rectangle getRectangle() {
        return (Rectangle)this.getDocument();
    }

    public ModelChangeSubscriber getAcaEnabledUpdater() {
        return this.acaEnabledUpdater;
    }

    private void configureNpointingsUpdater() {
        this.longModel.subscribe(this.nPointingsUpdater);
        this.shortModel.subscribe(this.nPointingsUpdater);
        this.spacingModel.subscribe(this.nPointingsUpdater);
    }

    public CoordsModel getCoordsModel() {
        return this.coordsModel;
    }

    public ValueUnitPairModel getLongModel() {
        return this.longModel;
    }

    public ValueUnitPairModel getShortModel() {
        return this.shortModel;
    }

    public ValueUnitPairModel getPALongModel() {
        return this.paLongModel;
    }

    public UserUnitValueUnitPairModel getSpacingModel() {
        return this.spacingModel;
    }

    @Override
    public void publish() {
        Rectangle rectangle = this.getRectangle();
        if (rectangle != null) {
            this.getCoordsModel().publish();
            this.getLongModel().publish();
            this.getShortModel().publish();
            this.getPALongModel().publish();
            this.getSpacingModel().publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID == RectangleEditor.NYQUIST_FID) {
            this.boListener.setEnabled(false);
            this.getRectangle().setSpacingToNyquist();
            this.boListener.setEnabled(true);
            this.getSpacingModel().publish();
            return null;
        }
        return null;
    }

    @Override
    public void setonlyDocument(Object object) {
        this.document = object;
        if (object != null) {
            Rectangle rectangle = this.getRectangle();
            this.getCoordsModel().setonlyDocument(rectangle);
            this.getLongModel().setonlyDocument((Object)rectangle.getLong());
            this.getShortModel().setonlyDocument((Object)rectangle.getShort());
            this.getPALongModel().setonlyDocument((Object)rectangle.getPALong());
            this.getSpacingModel().setonlyDocument(rectangle.getSpacing());
        }
    }

    @Override
    public void setDocument(Object object) {
        Rectangle rectangle = this.getRectangle();
        if (rectangle != null) {
            rectangle.removePropertyChangeListener(this.boListener);
        }
        if (object instanceof Rectangle) {
            Rectangle rectangle2 = (Rectangle)object;
            rectangle2.addPropertyChangeListener(this.boListener);
        }
        this.setonlyDocument(object);
        this.publish();
    }

    public void setIsMosaic(boolean bl) {
        Rectangle rectangle = this.getRectangle();
        if (null != rectangle) {
            this.getRectangle().setIsMosaic(bl);
        }
    }

    public boolean isMosaic() {
        Rectangle rectangle = this.getRectangle();
        return null == rectangle ? true : rectangle.isMosaic();
    }

    public ModelChangeSubscriber getUpdate12Pointings() {
        return this.updaterFor12mPointings;
    }

    public void setRectangleCoordinateSystem(String string) {
        if (string == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: coordinateSystem");
        }
        Rectangle rectangle = this.getRectangle();
        if (rectangle == null) {
            return;
        }
        this.getCoordsModel().update(null, CoordsEditor.FID_COORDS_SYSTEM, string);
    }
}

