/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.schedblock.ACABaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.BLBaseBandConfig;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.BaseBandConfigEditor;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.obsprep.ot.models.schedblock.SpectralWindowTabbedModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.util.TextUtils;

public class BaseBandConfigModel
extends Model {
    private ValueUnitPairModel desiredCenterFreqRestModel = null;
    private ValueUnitPairModel desiredImageFreqRestModel = null;
    private ValueUnitPairModel dwellTimeModel = null;
    private ValueUnitPairModel resDelayFreqModel = null;
    private SpectralWindowTabbedModel swTabbedModel = null;
    private SpectralSpecModel ssm;

    public BaseBandConfigModel(Object object) {
        super(object);
        AbstractBaseBandConfig abstractBaseBandConfig = (AbstractBaseBandConfig)object;
        this.swTabbedModel = new SpectralWindowTabbedModel(null);
        this.desiredCenterFreqRestModel = new ValueUnitPairModel(null);
        this.desiredImageFreqRestModel = new ValueUnitPairModel(null);
        this.dwellTimeModel = new ValueUnitPairModel(null);
        this.resDelayFreqModel = new ValueUnitPairModel(null);
        this.registerSubModel(this.swTabbedModel);
        this.registerSubModel(this.desiredCenterFreqRestModel);
        this.registerSubModel(this.dwellTimeModel);
        this.registerSubModel(this.resDelayFreqModel);
    }

    private SpectralSpecModel getSpectralSpecModel() {
        if (this.ssm == null) {
            for (Model model = this.getParentModel(); model != null; model = model.getParentModel()) {
                if (!(model instanceof SpectralSpecModel)) continue;
                this.ssm = (SpectralSpecModel)model;
                break;
            }
        }
        return this.ssm;
    }

    public BaseBand getBaseBand() {
        return (BaseBand)this.getDocument();
    }

    public AbstractBaseBandConfig getBaseBandConfig() {
        return this.document == null ? null : this.getBaseBand().getBaseBandConfig();
    }

    public BaseBandSpecification getBaseBandSpecification() {
        return this.document == null ? null : this.getBaseBand().getBaseBandSpecification();
    }

    private BLBaseBandConfig getBLBaseBandConfig() {
        try {
            return (BLBaseBandConfig)((Object)this.getDocument());
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private ACABaseBandConfig getACABaseBandConfig() {
        try {
            return (ACABaseBandConfig)((Object)this.getDocument());
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public ValueUnitPairModel getDesiredCenterFreqRestModel() {
        return this.desiredCenterFreqRestModel;
    }

    public ValueUnitPairModel getDesiredImageFreqRestModel() {
        return this.desiredImageFreqRestModel;
    }

    public ValueUnitPairModel getDwellTimeModel() {
        return this.dwellTimeModel;
    }

    public ValueUnitPairModel getResDelayFreqModel() {
        return this.resDelayFreqModel;
    }

    public SpectralWindowTabbedModel getSwTabbedModel() {
        return this.swTabbedModel;
    }

    public void updateSwitching() {
        if (this.getBaseBandSpecification() != null) {
            this.publish(BaseBandConfigEditor.FRQSWITCHING_FID, this.getBaseBandSpecification().getFrequencySwitching());
        }
    }

    @Override
    public void publish() {
        this.publish(BaseBandConfigEditor.DOCUMENTLABEL_FID, this.getDocument());
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        if (baseBandSpecification != null) {
            this.getDesiredCenterFreqRestModel().publish();
            this.getDesiredImageFreqRestModel().publish();
            this.publish(BaseBandConfigEditor.ACTUALCNTRFREQREST_FID, TextUtils.format(baseBandSpecification.getActualBaseBandCenterFrequencyRest(), 5));
            this.publish(BaseBandConfigEditor.ACTUALCNTRFREQSKY_FID, TextUtils.format(baseBandSpecification.getActualBaseBandCenterFrequencySky(), 5));
            this.publish(BaseBandConfigEditor.BASEBANDNAME_TF_FID, baseBandSpecification.getBaseBandName());
            this.publish(BaseBandConfigEditor.BASEBANDNAME_CB_FID, baseBandSpecification.getBaseBandName());
            this.publish(BaseBandConfigEditor.USE_12GFILTER_FID, baseBandSpecification.gettrueUse12GHzFilter());
            this.publish(BaseBandConfigEditor.USE_USB_FID, baseBandSpecification.gettrueUseUSB());
            AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
            if (abstractBaseBandConfig != null) {
                this.publish(BaseBandConfigEditor.PRODUCTS_FID, abstractBaseBandConfig.getDataProducts());
                try {
                    ACABaseBandConfig aCABaseBandConfig = (ACABaseBandConfig)((Object)abstractBaseBandConfig);
                    this.getResDelayFreqModel().publish();
                    this.publish(BaseBandConfigEditor.POLNMODE_FID, aCABaseBandConfig.getPolnProducts());
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                this.getSwTabbedModel().publish();
            }
        }
    }

    public void setFrequencySwitching() {
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        if (baseBandSpecification == null) {
            return;
        }
        SpectralSpec spectralSpec = baseBandSpecification.getSpectralSpec();
        if (spectralSpec == null) {
            return;
        }
        boolean bl = spectralSpec.getSwitchingType() == SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING;
        this.publish(BaseBandConfigEditor.SS_FRQSWITCHING_FID, bl);
        this.publish(BaseBandConfigEditor.FRQSWITCHING_FID, baseBandSpecification.getFrequencySwitching());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(BaseBandConfigEditor.BASEBANDNAME_CB_FID)) {
            BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
            if (baseBandSpecification != null) {
                baseBandSpecification.setBaseBandName((String)object);
            }
            return object;
        }
        if (fieldID.equals(BaseBandConfigEditor.FRQSWITCHING_FID)) {
            BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
            if (baseBandSpecification != null) {
                baseBandSpecification.setFrequencySwitching((Boolean)object);
            }
            return object;
        }
        if (fieldID.equals(BaseBandConfigEditor.NUMPOS_FID)) {
            return object;
        }
        if (fieldID.equals(BaseBandConfigEditor.PRODUCTS_FID)) {
            String string = (String)object;
            AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
            if (abstractBaseBandConfig != null) {
                abstractBaseBandConfig.setDataProducts(string);
            }
            return string;
        }
        if (fieldID.equals(BaseBandConfigEditor.BASEBANDNAME_TF_FID)) {
            return object;
        }
        if (fieldID.equals(BaseBandConfigEditor.POLNMODE_FID)) {
            ACABaseBandConfig aCABaseBandConfig = this.getACABaseBandConfig();
            String string = (String)object;
            if (aCABaseBandConfig != null) {
                aCABaseBandConfig.setPolnProducts(string);
                this.getSwTabbedModel().publish();
            }
            return string;
        }
        if (fieldID.equals(BaseBandConfigEditor.USE_12GFILTER_FID)) {
            BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
            if (baseBandSpecification != null) {
                baseBandSpecification.setUse12GHzFilter((Boolean)object);
            }
            return object;
        }
        if (fieldID.equals(BaseBandConfigEditor.USE_USB_FID)) {
            BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
            if (baseBandSpecification != null) {
                baseBandSpecification.setUseUSB((Boolean)object);
            }
            return object;
        }
        return null;
    }

    @Override
    public void setDocument(Object object) {
        int n;
        int n2;
        super.setDocument(object);
        BaseBandSpecification baseBandSpecification = this.getBaseBandSpecification();
        AbstractBaseBandConfig abstractBaseBandConfig = this.getBaseBandConfig();
        if (baseBandSpecification != null) {
            this.getDesiredCenterFreqRestModel().setDocument((Object)baseBandSpecification.getCenterFrequency());
            this.getDesiredImageFreqRestModel().setDocument((Object)baseBandSpecification.getImageCenterFrequency());
        }
        try {
            BLBaseBandConfig bLBaseBandConfig = (BLBaseBandConfig)((Object)abstractBaseBandConfig);
        }
        catch (ClassCastException classCastException) {
            try {
                ACABaseBandConfig aCABaseBandConfig = (ACABaseBandConfig)((Object)abstractBaseBandConfig);
                aCABaseBandConfig.syncPolnProducts();
                this.getResDelayFreqModel().setDocument((Object)aCABaseBandConfig.getCenterFreqOfResidualDelay());
            }
            catch (ClassCastException classCastException2) {
                // empty catch block
            }
        }
        if (abstractBaseBandConfig != null && abstractBaseBandConfig.isPairMode() && (n2 = abstractBaseBandConfig.getSingleSpectralWindowCount()) != (n = abstractBaseBandConfig.getSpectralWindowCount()) * 2) {
            if (n == 0) {
                abstractBaseBandConfig.refreshPairList();
            } else {
                throw new RuntimeException("Unexpected number of SpectralWindowPairs : " + n2 + " SpectralWindows, " + n + " pairs");
            }
        }
        this.getSwTabbedModel().setDocument(abstractBaseBandConfig);
    }

    public void dataRateChanged() {
        this.getSwTabbedModel().dataRateChanged();
    }
}

