/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SpectralWindowPair;
import javax.swing.table.AbstractTableModel;

public class CARTableModel
extends AbstractTableModel {
    private SpectralWindowI spectralWindow = null;
    private boolean usesInBoth = false;
    private Object[] longValues = new Object[]{"Start Channel", "Num. Channels", new Boolean(true), new Boolean(true)};

    public CARTableModel(SpectralWindowI spectralWindowI) {
        this.setSpectralWindow(spectralWindowI);
    }

    public void setSpectralWindow(SpectralWindowI spectralWindowI) {
        this.spectralWindow = spectralWindowI;
    }

    public SpectralWindowI getSpectralWindow() {
        return this.spectralWindow;
    }

    public void setUsesInBoth(boolean bl) {
        this.usesInBoth = bl;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public int getColumnCount() {
        if (this.spectralWindow != null && this.spectralWindow.isPair() && !this.usesInBoth) {
            return 4;
        }
        return 2;
    }

    public Class getColumnClass(int n) {
        Object var2_2 = null;
        switch (n) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        throw new RuntimeException("Unexpected column number : " + n);
    }

    @Override
    public String getColumnName(int n) {
        Object var2_2 = null;
        switch (n) {
            case 0: {
                return "Start Channel";
            }
            case 1: {
                return "Num. Channels";
            }
            case 2: {
                return "LSB";
            }
            case 3: {
                return "USB";
            }
        }
        throw new RuntimeException("Unexpected column number : " + n);
    }

    @Override
    public int getRowCount() {
        SpectralWindowI spectralWindowI = this.getSpectralWindow();
        if (spectralWindowI == null) {
            return 0;
        }
        return spectralWindowI.getChannelAverageRegionCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ChannelAverageRegion channelAverageRegion = this.getSpectralWindow().getChannelAverageRegion(n);
        switch (n2) {
            case 0: {
                return new Integer(channelAverageRegion.getStartChannel());
            }
            case 1: {
                return new Integer(channelAverageRegion.getNumberChannels());
            }
            case 2: {
                SpectralWindowPair spectralWindowPair = (SpectralWindowPair)this.getSpectralWindow();
                SpectralSpec.SideBand sideBand = SpectralSpec.SideBand.LSB;
                return new Boolean(spectralWindowPair.getChannelAverageRegionUse(n).usesLSB());
            }
            case 3: {
                SpectralWindowPair spectralWindowPair = (SpectralWindowPair)this.getSpectralWindow();
                SpectralSpec.SideBand sideBand = SpectralSpec.SideBand.USB;
                return new Boolean(spectralWindowPair.getChannelAverageRegionUse(n).usesUSB());
            }
        }
        throw new RuntimeException("Unexpected column number : " + n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ChannelAverageRegion channelAverageRegion = this.getSpectralWindow().getChannelAverageRegion(n);
        switch (n2) {
            case 0: {
                int n3 = (Integer)object;
                channelAverageRegion.setStartChannel(n3);
                break;
            }
            case 1: {
                int n4 = (Integer)object;
                channelAverageRegion.setNumberChannels(n4);
                break;
            }
            case 2: {
                boolean bl = (Boolean)object;
                SpectralWindowPair spectralWindowPair = (SpectralWindowPair)this.getSpectralWindow();
                SideBandUse sideBandUse = spectralWindowPair.getChannelAverageRegionUse(n);
                spectralWindowPair.setChannelAverageRegionUse(n, sideBandUse.enableLSB(bl));
                break;
            }
            case 3: {
                boolean bl = (Boolean)object;
                SpectralWindowPair spectralWindowPair = (SpectralWindowPair)this.getSpectralWindow();
                SideBandUse sideBandUse = spectralWindowPair.getChannelAverageRegionUse(n);
                spectralWindowPair.setChannelAverageRegionUse(n, sideBandUse.enableUSB(bl));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected column number : " + n2);
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void addChannelAverageRegion(int n) {
        SpectralWindowI spectralWindowI;
        ChannelAverageRegion channelAverageRegion = ChannelAverageRegion.createChannelAverageRegion();
        if (n == -1) {
            n = this.getRowCount();
        }
        if ((spectralWindowI = this.getSpectralWindow()) != null) {
            spectralWindowI.addChannelAverageRegion(n, channelAverageRegion);
            if (AbstractSpectralWindow.class.isAssignableFrom(spectralWindowI.getClass())) {
                AbstractSpectralWindow abstractSpectralWindow = (AbstractSpectralWindow)spectralWindowI;
                abstractSpectralWindow.resetSpectralAverageRegions(n, false);
            }
            this.fireTableRowsInserted(n, n);
        }
    }

    public void deleteChannelAverageRegion(int n) {
        SpectralWindowI spectralWindowI;
        if (n != -1 && (spectralWindowI = this.getSpectralWindow()) != null) {
            ChannelAverageRegion channelAverageRegion = spectralWindowI.getChannelAverageRegion(n);
            spectralWindowI.removeChannelAverageRegion(channelAverageRegion);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public Object[] getLongValues() {
        Object[] objectArray = new Object[this.getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            objectArray[i] = this.longValues[i];
        }
        return objectArray;
    }
}

