/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.schedblock.FillPattern;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.FillPatternEditor;
import alma.obsprep.ot.models.valuetypes.CoordsModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.Angle;

public class FillPatternModel
extends Model {
    private CoordsModel patternCenterCoordsModel = new CoordsModel(null);
    private ValueUnitPairModel latitudeLengthModel = new ValueUnitPairModel(null);
    private ValueUnitPairModel orthogonalStepModel = new ValueUnitPairModel(null);
    private ValueUnitPairModel longitudeLengthModel = new ValueUnitPairModel(null);
    private ValueUnitPairModel orientationModel = new ValueUnitPairModel(null);

    public FillPatternModel(Object object) {
        super(object);
        this.registerSubModel(this.patternCenterCoordsModel);
        this.registerSubModel(this.latitudeLengthModel);
        this.registerSubModel(this.orthogonalStepModel);
        this.registerSubModel(this.longitudeLengthModel);
        this.registerSubModel(this.orientationModel);
        if (object != null) {
            this.setDocument(object);
        }
    }

    public FillPattern getFillPattern() {
        return (FillPattern)((Object)this.document);
    }

    @Override
    public void publish() {
        this.getPatternCenterCoordsModel().publish();
        this.getLatitudeLengthModel().publish();
        this.samplingStepModel().publish();
        this.getLongitudeLengthModel().publish();
        this.getOrientationModel().publish();
        FillPattern fillPattern = this.getFillPattern();
        if (fillPattern != null) {
            this.publish(FillPatternEditor.FID_SCAN_COORD_SYSTEM, fillPattern.getScanningCoordinateSystem());
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        FillPattern fillPattern = this.getFillPattern();
        if (fillPattern == null) {
            return object;
        }
        if (fieldID.equals(FillPatternEditor.FID_SCAN_COORD_SYSTEM)) {
            String string = (String)object;
            fillPattern.setScanningCoordinateSystem(string);
            return string;
        }
        if (fieldID.equals(FillPatternEditor.FID_PATTERN_TYPE)) {
            String string = (String)object;
            fillPattern.setPatternType(string);
            return string;
        }
        return object;
    }

    @Override
    public void setonlyDocument(Object object) {
        this.document = object;
        FillPattern fillPattern = this.getFillPattern();
        if (fillPattern == null) {
            return;
        }
        this.getPatternCenterCoordsModel().setonlyDocument((Object)fillPattern);
        Angle angle = fillPattern.getLatitudeLength();
        this.getLatitudeLengthModel().setonlyDocument((Object)angle);
        angle = fillPattern.getSamplingLength();
        this.samplingStepModel().setonlyDocument((Object)angle);
        angle = fillPattern.getLongitudeLength();
        this.getLongitudeLengthModel().setonlyDocument((Object)angle);
        angle = fillPattern.getOrientation();
        this.getOrientationModel().setonlyDocument((Object)angle);
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    public CoordsModel getPatternCenterCoordsModel() {
        return this.patternCenterCoordsModel;
    }

    public ValueUnitPairModel getLatitudeLengthModel() {
        return this.latitudeLengthModel;
    }

    public ValueUnitPairModel samplingStepModel() {
        return this.orthogonalStepModel;
    }

    public ValueUnitPairModel getLongitudeLengthModel() {
        return this.longitudeLengthModel;
    }

    public ValueUnitPairModel getOrientationModel() {
        return this.orientationModel;
    }

    public static enum Axis {
        LONGITUDE,
        LATITUDE;

    }
}

