/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.LOSetupPreferenceEditor;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.schedblock.BaseBandConfigTabbedModel;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.valuetypes.Velocity;
import java.util.logging.Level;

public class LOSetupPreferenceModel
extends Model {
    public LOSetupPreferenceModel(Object object) {
        super(object);
    }

    public SpectralSpecModel getSpectralSpecModel() {
        BaseBandConfigTabbedModel baseBandConfigTabbedModel = (BaseBandConfigTabbedModel)this.getParentModel();
        if (baseBandConfigTabbedModel == null) {
            return null;
        }
        return baseBandConfigTabbedModel.getSpectralSpecModel();
    }

    public FrequencySetup getFrequencySetup() {
        return (FrequencySetup)this.document;
    }

    @Override
    public void publish() {
        if (this.document != null) {
            this.publishPrefs();
            this.publishWeights();
            this.publish(LOSetupPreferenceEditor.DOPPLER_FID, this.getFrequencySetup().getDopplerReference());
            SpectralSpecModel spectralSpecModel = this.getSpectralSpecModel();
            if (spectralSpecModel != null) {
                this.publish(LOSetupPreferenceEditor.VELOCITY_FID, spectralSpecModel.getVelocitySource());
            }
        }
    }

    private int getSbPrefsIndex(FieldID fieldID) {
        int n = 0;
        for (FieldID fieldID2 : LOSetupPreferenceEditor.sbchoiceFIDs) {
            if (fieldID == fieldID2) {
                FrequencySetup frequencySetup = this.getFrequencySetup();
                for (int i = 0; i < frequencySetup.getBaseBandSpecificationCount(); ++i) {
                    String string = frequencySetup.getBaseBandSpecification(i).getBaseBandName();
                    if (n != BaseBandSpecification.getBaseBandNameIndex(string)) continue;
                    return i;
                }
                String string = "Unexpected baseband index : fidIndex(0-3) = " + n;
                Log.logger((Object)this).warning(string);
                return -1;
            }
            ++n;
        }
        return -1;
    }

    private int getBaseBandIndex(FieldID fieldID) {
        int n = 0;
        for (FieldID fieldID2 : LOSetupPreferenceEditor.weightFIDs) {
            if (fieldID == fieldID2) {
                FrequencySetup frequencySetup = this.getFrequencySetup();
                for (int i = 0; i < frequencySetup.getBaseBandSpecificationCount(); ++i) {
                    String string = frequencySetup.getBaseBandSpecification(i).getBaseBandName();
                    if (n != BaseBandSpecification.getBaseBandNameIndex(string)) continue;
                    return i;
                }
                String string = "Unexpected baseband index : fidIndex(0-3) = " + n;
                Log.logger((Object)this).warning(string);
                return -1;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(LOSetupPreferenceEditor.DOPPLER_FID)) {
            FrequencySetup frequencySetup = this.getFrequencySetup();
            if (frequencySetup != null) {
                frequencySetup.setDopplerReference((String)object);
            }
        } else {
            int n = this.getBaseBandIndex(fieldID);
            if (n != -1) {
                FrequencySetup frequencySetup = this.getFrequencySetup();
                BaseBandSpecification baseBandSpecification = frequencySetup.getBaseBandSpecification(n);
                double d = new Double((String)object);
                baseBandSpecification.setWeighting(d);
            } else {
                n = this.getSbPrefsIndex(fieldID);
                if (n != -1) {
                    FrequencySetup frequencySetup = this.getFrequencySetup();
                    BaseBandSpecification baseBandSpecification = frequencySetup.getBaseBandSpecification(n);
                    baseBandSpecification.setSideBandPreference((String)object);
                }
            }
        }
        return object;
    }

    public void publishWeights() {
        if (this.document != null) {
            int n;
            FrequencySetup frequencySetup = this.getFrequencySetup();
            for (n = 0; n < SpectralSpec.maxBaseBandCount(); ++n) {
                this.publish(LOSetupPreferenceEditor.weightFIDs[n], null);
            }
            for (n = 0; n < frequencySetup.getBaseBandSpecificationCount(); ++n) {
                BaseBandSpecification baseBandSpecification = frequencySetup.getBaseBandSpecification(n);
                int n2 = baseBandSpecification.getBaseBandNameIndex();
                this.publish(LOSetupPreferenceEditor.weightFIDs[n2], baseBandSpecification.getWeighting());
            }
        }
    }

    public void publishPrefs() {
        if (this.document != null) {
            int n;
            FrequencySetup frequencySetup = this.getFrequencySetup();
            for (n = 0; n < SpectralSpec.maxBaseBandCount(); ++n) {
                this.publish(LOSetupPreferenceEditor.sbchoiceFIDs[n], null);
            }
            for (n = 0; n < frequencySetup.getBaseBandSpecificationCount(); ++n) {
                BaseBandSpecification baseBandSpecification = frequencySetup.getBaseBandSpecification(n);
                int n2 = baseBandSpecification.getBaseBandNameIndex();
                this.publish(LOSetupPreferenceEditor.sbchoiceFIDs[n2], baseBandSpecification.getSideBandPreference());
            }
        }
    }

    public boolean calculateLOs(int n) {
        Object object;
        FrequencySetup frequencySetup = this.getFrequencySetup();
        SpectralSpec spectralSpec = frequencySetup.getSpectralSpec();
        boolean bl = false;
        try {
            object = this.getSpectralSpecModel();
            Velocity velocity = null;
            if (spectralSpec.getFrequencySetup().getDopplerReference() != FrequencySetup.DOPPLERREFERENCE_REST) {
                velocity = Velocity.createVelocity();
            } else {
                Velocity velocity2 = velocity = object == null ? Velocity.createVelocity() : ((SpectralSpecModel)object).getSourceVelocity();
            }
            if (spectralSpec.getBaseBandConfigCount() == 0) {
                return bl;
            }
            bl = spectralSpec.calculateCorrelatorSetup(velocity, true, n);
            if (spectralSpec.hasCorrelatorConfiguration()) {
                spectralSpec.getCorrelatorConfiguration().updateSideband();
            }
            ((SpectralSpecModel)object).publish();
        }
        catch (RuntimeException runtimeException) {
            Log.logger((Object)this).log(Level.WARNING, runtimeException.getMessage(), (Throwable)runtimeException);
            return false;
        }
        try {
            if (spectralSpec.getFeedbackInfo() != null) {
                object = ObservingToolController.getMyInstance().getGui();
                ((ObservingToolGui)object).addInformationMessage(spectralSpec.getFeedbackInfo().getSummary(), spectralSpec.getFeedbackInfo().getDetails());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void setonlyDocument(Object object) {
        FrequencySetup frequencySetup = (FrequencySetup)object;
        super.setonlyDocument(frequencySetup);
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }
}

