/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import javax.swing.table.AbstractTableModel;

public class ObservingGroupAllTargetsTableModel
extends AbstractTableModel {
    public static final int COLUMN_SOURCE_NAME = 0;
    public static final int COLUMN_RA = 1;
    public static final int COLUMN_DEC = 2;
    public static final int COLUMN_SPECTRAL_SPEC = 3;
    public static final int COLUMN_REST_FREQUENCY = 4;
    public static final int COLUMN_PURPOSE = 5;
    public static final int LAST_COLUMN = 5;
    private SchedBlock m_schedBlock;

    public ObservingGroupAllTargetsTableModel(SchedBlock schedBlock) {
        this.m_schedBlock = schedBlock;
    }

    public void setSchedBlock(SchedBlock schedBlock) {
        this.m_schedBlock = schedBlock;
    }

    public SchedBlock getSchedBlock() {
        return this.m_schedBlock;
    }

    private int getTargetCount() {
        return this.getSchedBlock() == null ? 0 : this.getSchedBlock().getTargetCount();
    }

    private Target[] getTargets() {
        return this.getSchedBlock() == null ? null : this.getSchedBlock().getTarget();
    }

    private Target getTargetAtRow(int n) {
        if (this.getSchedBlock() == null) {
            return null;
        }
        Target[] targetArray = this.getSchedBlock().getTarget();
        return targetArray[n];
    }

    private String getPurposeString(Target target) {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = ",";
        if (target.hasScienceParameters()) {
            stringBuffer.append("Science" + string2);
        }
        if (target.hasPhaseCalParameters()) {
            stringBuffer.append("PhsCal" + string2);
        }
        if (target.hasAmplitudeCalParameters()) {
            stringBuffer.append("AmpCal" + string2);
        }
        if (target.hasPolarizationCalParameters()) {
            stringBuffer.append("PolCal" + string2);
        }
        if (target.hasPointingCalParameters()) {
            stringBuffer.append("PntCal" + string2);
        }
        if (target.hasAtmosphericCalParameters()) {
            stringBuffer.append("AtmCal" + string2);
        }
        if (target.hasDelayCalParameters()) {
            stringBuffer.append("DlyCal" + string2);
        }
        if (target.hasCheckSourceCalParameters()) {
            stringBuffer.append("ChkCal" + string2);
        }
        if (target.hasBandpassCalParameters()) {
            stringBuffer.append("BndCal" + string2);
        }
        if (target.hasFocusCalParameters()) {
            stringBuffer.append("FocCal" + string2);
        }
        if (target.hasOpticalPointingParameters()) {
            stringBuffer.append("OptPtg" + string2);
        }
        if (target.hasRadiometricPointingParameters()) {
            stringBuffer.append("RadPtg" + string2);
        }
        if ((n = (string = stringBuffer.toString()).lastIndexOf(string2)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.getSchedBlock() == null) {
            return false;
        }
        switch (n2) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 4: {
                return false;
            }
            case 3: {
                return false;
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Longitude.class;
            }
            case 2: {
                return Latitude.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Frequency.class;
            }
            case 5: {
                return String.class;
            }
        }
        throw new RuntimeException("Invalid number of columns");
    }

    @Override
    public String getColumnName(int n) {
        Object var2_2 = null;
        switch (n) {
            case 0: {
                return "<html><div align=center>Source Name</div></html>";
            }
            case 1: {
                return "<html><div align=center>RA</div></html>";
            }
            case 2: {
                return "<html><div align=center>DEC</div></html>";
            }
            case 3: {
                return "<html><div align=center>Spectral Spec</div></html>";
            }
            case 4: {
                return "<html><div align=center>Rest Freq</div></html>";
            }
            case 5: {
                return "<html><div align=center>Purpose</div></html>";
            }
        }
        return "<html><div align=center><font color=red>**ERROR**</font></div></html>";
    }

    @Override
    public int getRowCount() {
        return this.getTargetCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Target target = this.getTargetAtRow(n);
        try {
            switch (n2) {
                case 0: {
                    return target.getFieldSource().getSourceName();
                }
                case 1: {
                    return target.getFieldSource().getSourceCoordinates().getJ2000SkyCoordinates().getLongitude();
                }
                case 2: {
                    return target.getFieldSource().getSourceCoordinates().getJ2000SkyCoordinates().getLatitude();
                }
                case 3: {
                    return target.getSpectralSpec().getName();
                }
                case 4: {
                    return target.getSpectralSpec().getRestFrequency();
                }
                case 5: {
                    return this.getPurposeString(target);
                }
            }
            return "<html><font color=\"red\">Error!</font></html>";
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    public Object[] getLongValues() {
        return new Object[]{"Source Name", "+00:00:00", "+00:00:00", "Spectral Spec Name", "123.4 GHz", "Phs,Amp,Plr"};
    }
}

