/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.misc.IndividualPointingsTableLoader;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.models.schedblock.PointingPatternTableModel;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class PointingPatternModel
extends Model {
    private static DialogId DIALOG_OUT_OF_RANGE = new DialogId("ExportTargets.OutOfRange", "Exporting to file. Coordinates out of range");
    private static DialogId DIALOG_INVALID_COORDS = new DialogId("ExportTargets.InvalidCoords", "Exporting to file. Invalid coordinates");
    private static DialogId DIALOG_FILE_IO_ERROR = new DialogId("ExportTargets.WriteFileProblem", "Exporting to file. Problem while writing file");
    private boolean offsetPointingPattern = false;
    private PointingPatternTableModel ppTableModel = new PointingPatternTableModel(this);
    private double DEFAULTCOORD = 0.0;

    public PointingPatternModel(Object object) {
        super(object);
    }

    public PointingPatternTableModel getPointingPatternTableModel() {
        return this.ppTableModel;
    }

    public PointingPatternI getPointingPattern() {
        return (PointingPatternI)this.document;
    }

    public void originCoordinatesSystemUpdated() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            return;
        }
        pointingPatternI.originCoordinatesSystemUpdated();
        this.resetSexagesimal();
        this.getPointingPatternTableModel().fireTableStructureChanged();
        this.publish(PointingPatternEditor.POINTING_PATTERN_TABLE_FID, this.getPointingPattern());
    }

    @Override
    public void publish() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI != null) {
            this.getPointingPatternTableModel().fireTableStructureChanged();
            this.publish(PointingPatternEditor.POINTING_PATTERN_TABLE_FID, pointingPatternI);
            this.publish(PointingPatternEditor.OFFSET_COORD_TYPE_SELECTOR, pointingPatternI.isOffsetPointingPattern());
            this.publish(PointingPatternEditor.OFFSET_UNIT_COMBO_FID, pointingPatternI.getOffsetAngleUnit());
            this.publish(PointingPatternEditor.CUSTOM_MOSAIC_CHECKBOX_FID, pointingPatternI.isMosaic());
            this.updateNpointingsFeedback();
        }
    }

    private void updateNpointingsFeedback() {
        this.publish(PointingPatternEditor.NPOINTINGS_FID, this.getPointingCount());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        boolean bl;
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (fieldID.equals(PointingPatternEditor.CUSTOM_MOSAIC_CHECKBOX_FID)) {
            bl = (Boolean)object;
            this.setIsMosaic(bl);
        }
        if (fieldID.equals(PointingPatternEditor.OFFSET_COORD_TYPE_SELECTOR)) {
            bl = object instanceof String ? Boolean.valueOf((String)object).booleanValue() : Boolean.valueOf((Boolean)object).booleanValue();
            if (pointingPatternI != null) {
                pointingPatternI.setOffsetPointingPattern(bl);
            }
            this.resetPointingPatternTable();
        } else if (fieldID.equals(PointingPatternEditor.OFFSET_UNIT_COMBO_FID)) {
            if (pointingPatternI != null) {
                pointingPatternI.setOffsetAngleUnit((String)object);
            }
            this.setOffsetUnit((String)object);
            this.getPointingPatternTableModel().fireTableStructureChanged();
        }
        return object;
    }

    public void performCoordinateResetOfAllPointings() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        boolean bl = pointingPatternI.isOffsetPointingPattern();
        SkyCoordinates skyCoordinates = pointingPatternI.getSourceCoordinates();
        int n = pointingPatternI.getPhaseCenterCoordinates().length;
        int n2 = 1;
        for (SkyCoordinates skyCoordinates2 : pointingPatternI.getPhaseCenterCoordinates()) {
            if (n2 == n) break;
            pointingPatternI.removePhaseCenterCoordinates(skyCoordinates2);
            ++n2;
        }
        for (SkyCoordinates skyCoordinates2 : pointingPatternI.getPhaseCenterCoordinates()) {
            if (bl) {
                skyCoordinates2.getLatitude().setContentInDeg(0.0);
                skyCoordinates2.getLongitude().setContentInDeg(0.0);
                continue;
            }
            skyCoordinates2.getLatitude().setContentInDeg(skyCoordinates.getLatitude().getContentInDeg());
            skyCoordinates2.getLongitude().setContentInDeg(skyCoordinates.getLongitude().getContentInDeg());
        }
        this.getPointingPatternTableModel().fireTableStructureChanged();
    }

    public void setOffsetUnit(String string) {
        if (this.document != null) {
            PointingPatternI pointingPatternI = this.getPointingPattern();
            for (SkyCoordinates skyCoordinates : pointingPatternI.getPhaseCenterCoordinates()) {
                if (!skyCoordinates.isOffsetCoordinates()) continue;
                double d = skyCoordinates.getLatitude().getContentInUnits(string);
                skyCoordinates.getLatitude().setContent(d);
                skyCoordinates.getLatitude().setUnit(string);
                d = skyCoordinates.getLongitude().getContentInUnits(string);
                skyCoordinates.getLongitude().setContent(d);
                skyCoordinates.getLongitude().setUnit(string);
            }
        }
    }

    public String getDisplayedOffsetUnit() {
        String string = PointingPatternI.DEFAULT_OFFSETANGLE_UNIT;
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI != null) {
            string = pointingPatternI.getOffsetAngleUnit();
        }
        return string;
    }

    public void resetPointingPatternTable() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        boolean bl = pointingPatternI.isOffsetPointingPattern();
        PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter();
        pointingCoordsConverter.setOrigin(pointingPatternI.getSourceCoordinates());
        for (SkyCoordinates skyCoordinates : pointingPatternI.getPhaseCenterCoordinates()) {
            pointingCoordsConverter.convert(skyCoordinates, bl);
        }
        this.resetSexagesimal();
        this.getPointingPatternTableModel().fireTableStructureChanged();
    }

    public void resetSexagesimal() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        boolean bl = !pointingPatternI.isOffsetPointingPattern() && SkyCoordinates.isEquatorial(pointingPatternI.getSourceCoordinates().getSystem());
        this.getPointingPatternTableModel().setSexagesimal(bl);
    }

    public SkyCoordinates addPointing(int n, boolean bl) {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null || !pointingPatternI.isPointingPattern()) {
            return null;
        }
        SkyCoordinates skyCoordinates = SkyCoordinates.createAbsoluteCoordinates();
        skyCoordinates.getLatitude().setContent(this.DEFAULTCOORD);
        skyCoordinates.getLongitude().setContent(this.DEFAULTCOORD);
        if (bl) {
            skyCoordinates.setType(SkyCoordinates.TYPE_RELATIVE);
            skyCoordinates.getLatitude().setUnit(this.getDisplayedOffsetUnit());
            skyCoordinates.getLongitude().setUnit(this.getDisplayedOffsetUnit());
        }
        if (n == -1) {
            n = this.getPointingCount();
        }
        this.getPointingPattern().addPhaseCenterCoordinates(n, skyCoordinates);
        this.getPointingPatternTableModel().fireTableRowsInserted(n, n);
        this.updateNpointingsFeedback();
        return skyCoordinates;
    }

    public void deletePointing(int n) {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null || !pointingPatternI.isPointingPattern()) {
            return;
        }
        if (n != -1) {
            SkyCoordinates skyCoordinates = pointingPatternI.getPhaseCenterCoordinates(n);
            this.getPointingPatternTableModel().fireTableRowsDeleted(n, n);
            pointingPatternI.removePhaseCenterCoordinates(skyCoordinates);
            this.updateNpointingsFeedback();
        }
    }

    public void deleteAllPointings() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null || !pointingPatternI.isPointingPattern()) {
            return;
        }
        int n = this.getPointingCount();
        for (int i = 0; i < n; ++i) {
            pointingPatternI.removePhaseCenterCoordinates(pointingPatternI.getPhaseCenterCoordinates(0));
        }
        this.updateNpointingsFeedback();
    }

    public SkyCoordinates getPointing(int n) {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null || !pointingPatternI.isPointingPattern()) {
            return null;
        }
        try {
            return pointingPatternI.getPhaseCenterCoordinates(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public SkyCoordinates[] getPointings() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null || !pointingPatternI.isPointingPattern()) {
            return new SkyCoordinates[0];
        }
        return pointingPatternI.getPhaseCenterCoordinates();
    }

    public int getPointingCount() {
        PointingPatternTableModel pointingPatternTableModel = this.getPointingPatternTableModel();
        return pointingPatternTableModel == null ? 0 : pointingPatternTableModel.getRowCount();
    }

    @Override
    public void setonlyDocument(Object object) {
        if (object == null) {
            this.document = null;
            return;
        }
        if (object instanceof PointingPatternI) {
            this.document = object;
        } else if (object instanceof TargetParameters) {
            TargetParameters targetParameters = (TargetParameters)object;
            this.document = targetParameters.getPointingPattern();
        }
        this.refreshSexagesimal();
        this.ppTableModel.fireTableStructureChanged();
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
    }

    public void refreshSexagesimal() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            return;
        }
        String string = pointingPatternI.getSourceCoordinates().getSystem();
        this.refreshSexagesimal(string);
    }

    public void refreshSexagesimal(String string) {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            return;
        }
        boolean bl = pointingPatternI.isOffsetPointingPattern();
        this.ppTableModel.setSexagesimal(!bl && SkyCoordinates.isEquatorial(string));
    }

    public boolean isMosaic() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            return true;
        }
        return pointingPatternI.isMosaic();
    }

    public void setIsMosaic(boolean bl) {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI != null) {
            pointingPatternI.setIsMosaic(bl);
        }
    }

    public void exportAbsoluteCoordsToFile(File file, PointingPatternEditor.AbsoluteCoordsFormat absoluteCoordsFormat) {
        if (file == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: outputFile");
        }
        if (absoluteCoordsFormat == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: absCoordsType");
        }
        if (!EnumSet.of(PointingPatternEditor.AbsoluteCoordsFormat.DEGREES, PointingPatternEditor.AbsoluteCoordsFormat.RADIANS, PointingPatternEditor.AbsoluteCoordsFormat.SEXAGESIMAL).contains((Object)absoluteCoordsFormat)) {
            throw new IllegalArgumentException("Unknown absCoordsType has been specified : " + (Object)((Object)absoluteCoordsFormat));
        }
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            throw new NullPointerException("No pointing pattern found when one is expected");
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            assert (fileWriter != null);
            this.writeHeader(fileWriter);
            if (pointingPatternI.isAbsolutePointingPattern()) {
                for (SkyCoordinates skyCoordinates : this.getPointings()) {
                    String string;
                    String string2 = new String();
                    try {
                        switch (absoluteCoordsFormat) {
                            case DEGREES: {
                                string2 = string2 + Double.toString(skyCoordinates.getLongitude().getContentInDeg()) + ",";
                                string2 = string2 + Double.toString(skyCoordinates.getLatitude().getContentInDeg()) + ",";
                                break;
                            }
                            case RADIANS: {
                                string2 = string2 + Double.toString(skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_RAD)) + ",";
                                string2 = string2 + Double.toString(skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_RAD)) + ",";
                                break;
                            }
                            case SEXAGESIMAL: {
                                string2 = string2 + skyCoordinates.getLongitude().toHHMMSS() + ",";
                                string2 = string2 + skyCoordinates.getLatitude().toDDMMSS() + ",";
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown absCoordsType type specified: " + (Object)((Object)absoluteCoordsFormat));
                            }
                        }
                    }
                    catch (OutOfRangeException outOfRangeException) {
                        string = "Pointing coordinates out of range for " + skyCoordinates.toString() + ".\nPlease check your system coordinates.";
                        GUIUtilities.error(DIALOG_OUT_OF_RANGE, string);
                    }
                    catch (InvalidCoordException invalidCoordException) {
                        string = "Invalid pointing coordinates for " + skyCoordinates.toString() + ".\nPlease check your system coordinates.";
                        GUIUtilities.error(DIALOG_INVALID_COORDS, string);
                    }
                    fileWriter.write(string2);
                    fileWriter.write(PointingPatternEditor.PointingStorageFormat.ABSOLUTECOORDS.getLabel() + "," + (Object)((Object)absoluteCoordsFormat) + "\n");
                }
            } else {
                SkyCoordinates skyCoordinates = pointingPatternI.getSourceCoordinates();
                assert (skyCoordinates != null);
                for (SkyCoordinates skyCoordinates2 : this.getPointings()) {
                    String string;
                    String string3 = new String();
                    try {
                        switch (absoluteCoordsFormat) {
                            case DEGREES: {
                                string3 = string3 + Double.toString(skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLongitude().getContentInDeg()) + ",";
                                string3 = string3 + Double.toString(skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLatitude().getContentInDeg()) + ",";
                                break;
                            }
                            case RADIANS: {
                                string3 = string3 + Double.toString(skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLongitude().getContentInUnits(Longitude.UNIT_RAD)) + ",";
                                string3 = string3 + Double.toString(skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLatitude().getContentInUnits(Latitude.UNIT_RAD)) + ",";
                                break;
                            }
                            case SEXAGESIMAL: {
                                string3 = string3 + skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLongitude().toHHMMSS() + ",";
                                string3 = string3 + skyCoordinates2.getAbsoluteCoordinates(skyCoordinates).getLatitude().toDDMMSS() + ",";
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown absCoordsType type specified: " + (Object)((Object)absoluteCoordsFormat));
                            }
                        }
                    }
                    catch (OutOfRangeException outOfRangeException) {
                        string = "Pointing coordinates out of range for " + skyCoordinates2.toString() + ".\nPlease check your system coordinates.";
                        GUIUtilities.error(DIALOG_OUT_OF_RANGE, string);
                    }
                    catch (InvalidCoordException invalidCoordException) {
                        string = "Invalid pointing coordinates for " + skyCoordinates2.toString() + ".\nPlease check your system coordinates.";
                        GUIUtilities.error(DIALOG_INVALID_COORDS, string);
                    }
                    fileWriter.write(string3);
                    fileWriter.write(PointingPatternEditor.PointingStorageFormat.ABSOLUTECOORDS.getLabel() + "," + (Object)((Object)absoluteCoordsFormat) + "\n");
                }
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            String string = "";
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            String string4 = "Problem occurred while writing pointing\ncoordinates to " + string;
            GUIUtilities.error(DIALOG_FILE_IO_ERROR, string4);
        }
    }

    public void exportOffsetCoordsToFile(File file, PointingPatternEditor.OffsetCoordsFormat offsetCoordsFormat) {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: pointingPattern");
        }
        if (file == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: outputFile");
        }
        if (offsetCoordsFormat == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: offsetCoordsType");
        }
        if (!EnumSet.of(PointingPatternEditor.OffsetCoordsFormat.DEGREES, PointingPatternEditor.OffsetCoordsFormat.ARCMINS, PointingPatternEditor.OffsetCoordsFormat.ARCSECS).contains((Object)offsetCoordsFormat)) {
            throw new IllegalArgumentException("Unknown absCoordsType has been specified: " + (Object)((Object)offsetCoordsFormat));
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            this.writeHeader(fileWriter);
            assert (fileWriter != null);
            if (pointingPatternI.isAbsolutePointingPattern()) {
                SkyCoordinates skyCoordinates = pointingPatternI.getSourceCoordinates();
                assert (skyCoordinates != null);
                for (SkyCoordinates skyCoordinates2 : this.getPointings()) {
                    String string = new String();
                    switch (offsetCoordsFormat) {
                        case DEGREES: {
                            string = string + Double.toString(skyCoordinates2.getOffsetCoordinates(skyCoordinates).getLongitude().getContentInDeg()) + ",";
                            string = string + Double.toString(skyCoordinates2.getOffsetCoordinates(skyCoordinates).getLatitude().getContentInDeg()) + ",";
                            break;
                        }
                        case ARCMINS: {
                            string = string + Double.toString(skyCoordinates2.getOffsetCoordinates(skyCoordinates).getLongitude().getContentInUnits(Longitude.UNIT_ARCMIN)) + ",";
                            string = string + Double.toString(skyCoordinates2.getOffsetCoordinates(skyCoordinates).getLatitude().getContentInUnits(Latitude.UNIT_ARCMIN)) + ",";
                            break;
                        }
                        case ARCSECS: {
                            string = string + Double.toString(skyCoordinates2.getOffsetCoordinates(skyCoordinates).getLongitude().getContentInUnits(Longitude.UNIT_ARCSEC)) + ",";
                            string = string + Double.toString(skyCoordinates2.getOffsetCoordinates(skyCoordinates).getLatitude().getContentInUnits(Latitude.UNIT_ARCSEC)) + ",";
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown offsetCoordsType type specified: " + (Object)((Object)offsetCoordsFormat));
                        }
                    }
                    fileWriter.write(string);
                    fileWriter.write(PointingPatternEditor.PointingStorageFormat.OFFSETCOORDS.getLabel() + "," + (Object)((Object)offsetCoordsFormat) + "\n");
                }
                fileWriter.close();
            } else {
                for (SkyCoordinates skyCoordinates : this.getPointings()) {
                    String string = new String();
                    switch (offsetCoordsFormat) {
                        case DEGREES: {
                            string = string + Double.toString(skyCoordinates.getLongitude().getContentInDeg()) + ",";
                            string = string + Double.toString(skyCoordinates.getLatitude().getContentInDeg()) + ",";
                            break;
                        }
                        case ARCMINS: {
                            string = string + Double.toString(skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_ARCMIN)) + ",";
                            string = string + Double.toString(skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_ARCMIN)) + ",";
                            break;
                        }
                        case ARCSECS: {
                            string = string + Double.toString(skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_ARCSEC)) + ",";
                            string = string + Double.toString(skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_ARCSEC)) + ",";
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown offsetCoordsType type specified: " + (Object)((Object)offsetCoordsFormat));
                        }
                    }
                    fileWriter.write(string);
                    fileWriter.write(PointingPatternEditor.PointingStorageFormat.OFFSETCOORDS.getLabel() + "," + (Object)((Object)offsetCoordsFormat) + "\n");
                }
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            String string = "";
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            String string2 = "Problem occurred while writing pointing\ncoordinates to " + string;
            GUIUtilities.error(DIALOG_FILE_IO_ERROR, string2);
        }
    }

    private void writeHeader(FileWriter fileWriter) throws IOException {
        fileWriter.write("RA , Dec, Coordinate Type, Coordinate Units\n");
        fileWriter.write("--   This signals end of the header\n");
    }

    public void importPointingsFromFile(File file, boolean bl) {
        Boolean bl2;
        if (file == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: file");
        }
        IndividualPointingsTableLoader individualPointingsTableLoader = new IndividualPointingsTableLoader();
        if (individualPointingsTableLoader == null) {
            return;
        }
        try {
            bl2 = individualPointingsTableLoader.loadList(file, ",");
        }
        catch (IOException iOException) {
            return;
        }
        if (!bl2.booleanValue()) {
            return;
        }
        if (!bl) {
            this.deleteAllPointings();
        }
        if (!individualPointingsTableLoader.getList().isEmpty()) {
            this.addToParent(individualPointingsTableLoader.getList());
        }
    }

    private void addToParent(List list) {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (list == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: list");
        }
        if (pointingPatternI == null || !pointingPatternI.isPointingPattern()) {
            return;
        }
        String string = pointingPatternI.getSourceCoordinates().getSystem();
        Iterator iterator = list.iterator();
        Boolean bl = null;
        while (iterator.hasNext()) {
            try {
                SkyCoordinates skyCoordinates = (SkyCoordinates)iterator.next();
                skyCoordinates.setSystem(string);
                bl = skyCoordinates.isOffsetCoordinates();
                pointingPatternI.addPhaseCenterCoordinates(skyCoordinates);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("The list should contain only type SkyCoordinates");
            }
        }
        this.getPointingPatternTableModel().fireTableRowsInserted(0, list.size() - 1);
        this.updateNpointingsFeedback();
        if (bl != null) {
            pointingPatternI.setOffsetPointingPattern(bl);
        }
        this.publish();
    }
}

