/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.schedblock.PointingPatternEditor;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.util.Convert;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class PointingPatternTableModel
extends AbstractTableModel {
    private boolean sexagesimal = false;
    private PointingPatternModel pointingPatternModel = null;

    public PointingPatternTableModel(PointingPatternModel pointingPatternModel) {
        this.pointingPatternModel = pointingPatternModel;
    }

    private PointingPatternI getPointingPattern() {
        return this.pointingPatternModel.getPointingPattern();
    }

    private String getOffsetUnit() {
        return this.pointingPatternModel.getDisplayedOffsetUnit();
    }

    private boolean isOffsetPointingPattern() {
        boolean bl = true;
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI != null) {
            bl = pointingPatternI.isOffsetPointingPattern();
        }
        return bl;
    }

    public void setSexagesimal(boolean bl) {
        if (this.sexagesimal != bl) {
            this.sexagesimal = bl;
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getRowCount() {
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            return 0;
        }
        return pointingPatternI.getPhaseCenterCoordinatesCount();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        String string;
        String string2;
        PointingPatternI pointingPatternI = this.getPointingPattern();
        if (pointingPatternI == null) {
            return "";
        }
        if (pointingPatternI.getSourceCoordinates() == null) {
            Log.logger((Object)this).warning("source coordinates should not be null");
            return "";
        }
        boolean bl = pointingPatternI.getSourceCoordinates().isGalactic();
        if (bl) {
            string2 = "Lon";
            string = "Lat";
        } else {
            string2 = "RA";
            string = "Dec";
        }
        String string3 = pointingPatternI.isOffsetPointingPattern() ? " [" + this.getOffsetUnit() + "]" : (bl ? " [deg]" : " ");
        switch (n) {
            case 0: {
                return string2 + string3;
            }
            case 1: {
                return string + string3;
            }
        }
        return "unknown";
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SkyCoordinates skyCoordinates = this.getPointingPattern().getPhaseCenterCoordinates(n);
        Longitude longitude = skyCoordinates.getLongitude();
        Latitude latitude = skyCoordinates.getLatitude();
        double d = 0.0;
        switch (n2) {
            case 0: {
                String string;
                try {
                    if (this.isOffsetPointingPattern()) {
                        d = longitude.getContentInUnits(this.getOffsetUnit());
                        string = TextUtils.format(d, 0, 5);
                    } else {
                        d = longitude.getContentInUnits(Angle.UNIT_DEG);
                        string = this.sexagesimal ? Convert.degToHHMMSS(d) : TextUtils.format(d, 0, 5);
                    }
                }
                catch (OutOfRangeException outOfRangeException) {
                    string = outOfRangeException.getLocalizedMessage();
                }
                catch (InvalidCoordException invalidCoordException) {
                    string = invalidCoordException.getLocalizedMessage();
                }
                return string;
            }
            case 1: {
                String string;
                try {
                    if (this.isOffsetPointingPattern()) {
                        d = latitude.getContentInUnits(this.getOffsetUnit());
                        string = TextUtils.format(d, 0, 5);
                    } else {
                        d = latitude.getContentInUnits(Angle.UNIT_DEG);
                        string = this.sexagesimal ? Convert.degToDDMMSS(d) : TextUtils.format(d, 0, 5);
                    }
                }
                catch (OutOfRangeException outOfRangeException) {
                    string = outOfRangeException.getLocalizedMessage();
                }
                catch (InvalidCoordException invalidCoordException) {
                    string = invalidCoordException.getLocalizedMessage();
                }
                return string;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        SkyCoordinates skyCoordinates = this.getPointingPattern().getPhaseCenterCoordinates(n);
        Longitude longitude = skyCoordinates.getLongitude();
        Latitude latitude = skyCoordinates.getLatitude();
        int n3 = n + 1;
        skyCoordinates.setFieldName("Field-" + n3);
        String string = (String)object;
        switch (n2) {
            case 0: {
                try {
                    if (this.isOffsetPointingPattern()) {
                        longitude.setContent(Double.parseDouble(string));
                        longitude.setUnit(this.getOffsetUnit());
                        break;
                    }
                    if (this.sexagesimal) {
                        longitude.setContent(Convert.HHMMSSToDeg(string));
                    } else {
                        longitude.setContent(Double.parseDouble(string));
                    }
                    longitude.setUnit(Angle.UNIT_DEG);
                }
                catch (InvalidCoordException invalidCoordException) {
                    Log.logger((Object)this).warning("Invalid coordinate " + string + " - " + invalidCoordException.getLocalizedMessage());
                }
                catch (NumberFormatException numberFormatException) {
                    Log.logger((Object)this).warning("Invalid format " + string + " - " + numberFormatException.getLocalizedMessage());
                }
                break;
            }
            case 1: {
                try {
                    if (this.isOffsetPointingPattern()) {
                        latitude.setContent(Double.parseDouble(string));
                        latitude.setUnit(this.getOffsetUnit());
                        break;
                    }
                    if (this.sexagesimal) {
                        latitude.setContent(Convert.DDMMSSToDeg(string));
                    } else {
                        latitude.setContent(Double.parseDouble(string));
                    }
                    latitude.setUnit(Angle.UNIT_DEG);
                    break;
                }
                catch (InvalidCoordException invalidCoordException) {
                    Log.logger((Object)this).warning("Invalid coordinate " + string + " - " + invalidCoordException.getLocalizedMessage());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    Log.logger((Object)this).warning("Invalid format " + string + " - " + numberFormatException.getLocalizedMessage());
                }
            }
        }
        if (this.pointingPatternModel != null) {
            this.pointingPatternModel.publish(PointingPatternEditor.POINTING_PATTERN_TABLE_FID, this.getPointingPattern());
        }
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.add(TableModelListener.class, tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.remove(TableModelListener.class, tableModelListener);
    }

    @Override
    public TableModelListener[] getTableModelListeners() {
        return (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
    }

    @Override
    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    @Override
    public void fireTableRowsInserted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 1));
    }

    @Override
    public void fireTableRowsUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 0));
    }

    @Override
    public void fireTableRowsDeleted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, -1));
    }

    @Override
    public void fireTableCellUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n, n2));
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableModelListener.class) continue;
            ((TableModelListener)objectArray[i + 1]).tableChanged(tableModelEvent);
        }
    }
}

