/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.ReferencePointEditor;
import alma.obsprep.ot.models.valuetypes.CoordsModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.valuetypes.Time;

public class ReferencePointModel
extends Model {
    private CoordsModel referenceCoordinatesModel = new CoordsModel(null);
    private ValueUnitPairModel integrationTimeModel = new ValueUnitPairModel();
    private ValueUnitPairModel cycleTimeModel = new ValueUnitPairModel();
    private ValueUnitPairModel subScanDurationModel = new ValueUnitPairModel();

    public ReferencePointModel(Object object) {
        super(object);
        this.registerSubModel(this.referenceCoordinatesModel);
        this.registerSubModel(this.integrationTimeModel);
        this.registerSubModel(this.cycleTimeModel);
        this.registerSubModel(this.subScanDurationModel);
        this.setDocument(object);
    }

    protected Reference getReference() {
        return (Reference)this.getDocument();
    }

    public ValueUnitPairModel getCycleTimeModel() {
        return this.cycleTimeModel;
    }

    public ValueUnitPairModel getIntegrationTimeModel() {
        return this.integrationTimeModel;
    }

    public CoordsModel getReferenceCoordinatesModel() {
        return this.referenceCoordinatesModel;
    }

    public ValueUnitPairModel getSubScanDurationModel() {
        return this.subScanDurationModel;
    }

    @Override
    public void publish() {
        if (this.referenceCoordinatesModel != null) {
            this.referenceCoordinatesModel.publish();
        }
        if (this.integrationTimeModel != null) {
            this.integrationTimeModel.publish();
        }
        if (this.cycleTimeModel != null) {
            this.cycleTimeModel.publish();
        }
        if (this.subScanDurationModel != null) {
            this.subScanDurationModel.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        FieldSource fieldSource;
        Target[] targetArray;
        String string = object.toString();
        if (fieldID.equals(ReferencePointEditor.FID_REFADJUST_BUTTON) && (targetArray = (fieldSource = (FieldSource)this.getReference().getParent()).getTargetList()).length > 0 && targetArray[0].getAbstractInstrumentSpec() != null && !(targetArray[0].getAbstractInstrumentSpec() instanceof OpticalCameraSpec)) {
            SpectralSpec spectralSpec = (SpectralSpec)((Object)targetArray[0].getAbstractInstrumentSpec());
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
            if (abstractCorrelatorConfiguration == null) {
                return object;
            }
            CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
            double d = this.getReference().getSubScanDuration().getContentInUnits(Time.UNIT_S);
            double d2 = abstractCorrelatorConfiguration.getIntegrationDuration().getContentInUnits(Time.UNIT_S);
            double d3 = correlatorExpert.calcSubscanDuration(d, d2, 1);
            this.getReference().getSubScanDuration().setContentAndUnit((ValueUnitPair)Time.createTimeSec(d3));
            this.getSubScanDurationModel().publish();
        }
        return string;
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        Reference reference = this.getReference();
        if (reference != null) {
            this.getReferenceCoordinatesModel().setDocument(reference);
            Time time = reference.getIntegrationTime();
            this.getIntegrationTimeModel().setDocument(time);
            time = reference.getCycleTime();
            this.getCycleTimeModel().setDocument(time);
            time = reference.getSubScanDuration();
            this.getSubScanDurationModel().setDocument(time);
        }
    }
}

