/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.SchedBlock;
import javax.swing.table.AbstractTableModel;

public class SchedBlockObservingGroupTableModel
extends AbstractTableModel {
    public static final int COLUMN_INDEX = 0;
    public static final int COLUMN_GROUP_NAME = 1;
    public static final int LAST_COLUMN = 1;
    private SchedBlock m_schedBlock;

    public SchedBlockObservingGroupTableModel(SchedBlock schedBlock) {
        this.m_schedBlock = schedBlock;
    }

    public void setSchedBlock(SchedBlock schedBlock) {
        this.m_schedBlock = schedBlock;
    }

    public SchedBlock getSchedBlock() {
        return this.m_schedBlock;
    }

    private int getObservingGroupCount() {
        return this.getSchedBlock() == null ? 0 : this.getSchedBlock().getObservingGroupCount();
    }

    private ObservingGroup[] getObservingGroups() {
        return this.getSchedBlock() == null ? null : this.getSchedBlock().getObservingGroup();
    }

    private ObservingGroup getObservingGroupAtRow(int n) {
        return this.getSchedBlock() == null ? null : this.getSchedBlock().getObservingGroup(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.getSchedBlock() == null) {
            return false;
        }
        switch (n2) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
        }
        throw new RuntimeException("Invalid number of columns");
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "<html><div align=center>Index</div></html>";
            }
            case 1: {
                return "<html><div align=center>Group Name</div></html>";
            }
        }
        return "<html><div align=center><font color=red>**ERROR**</font></div></html>";
    }

    @Override
    public int getRowCount() {
        return this.getObservingGroupCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ObservingGroup observingGroup = this.getObservingGroupAtRow(n);
        try {
            switch (n2) {
                case 0: {
                    return observingGroup.getIndex();
                }
                case 1: {
                    return observingGroup.getName();
                }
            }
            return "<html><font color=\"red\">Error!</font></html>";
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ObservingGroup observingGroup = this.getObservingGroupAtRow(n);
        switch (n2) {
            case 1: {
                observingGroup.setName((String)object);
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    public Object[] getLongValues() {
        return new Object[]{"123", "Observing Group Name"};
    }
}

