/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.TemporalConstraints;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.SchedBlockTemporalTabbedEditor;
import alma.obsprep.ot.models.schedblock.SchedBlockTemporalModel;

public class SchedBlockTemporalTabbedModel
extends Model {
    private SchedBlockTemporalModel tempModel = new SchedBlockTemporalModel(null);

    public SchedBlockTemporalTabbedModel(SchedBlock schedBlock) {
        super(schedBlock);
        this.registerSubModel(this.tempModel);
        this.publish();
    }

    private SchedBlock getSchedBlock() {
        return (SchedBlock)this.getDocument();
    }

    public SchedBlockTemporalModel getSchedBlockTemporalModel() {
        return this.tempModel;
    }

    public TemporalConstraints[] getTemporalConstraints() {
        return this.getSchedBlock().getTemporalConstraints();
    }

    public TemporalConstraints getTemporalConstraints(int n) {
        return this.getSchedBlock().getTemporalConstraints(n);
    }

    public int getTemporalConstraintsCount() {
        return this.getSchedBlock().getTemporalConstraintsCount();
    }

    public void setSelectedTemporalConstraintsIndex(int n) {
        TemporalConstraints temporalConstraints = this.tempModel.getTemporalConstraints();
        TemporalConstraints temporalConstraints2 = this.getTemporalConstraints(n);
        if (temporalConstraints2 != temporalConstraints) {
            this.tempModel.setDocument((Object)temporalConstraints2);
        }
    }

    @Override
    public void setDocument(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof SchedBlock) {
            this.document = object;
            SchedBlock schedBlock = (SchedBlock)object;
            if (schedBlock.getTemporalConstraintsCount() > 0) {
                this.tempModel.setDocument((Object)schedBlock.getTemporalConstraints(0));
            }
        } else {
            throw new RuntimeException("Unexpected type of document");
        }
        this.publish();
        this.publish();
    }

    @Override
    public void publish() {
        if (this.getSchedBlock() == null) {
            return;
        }
        this.publish(SchedBlockTemporalTabbedEditor.FID_TABBEDPANE, this.getSchedBlock());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID == SchedBlockTemporalTabbedEditor.FID_ADD_BUTTON) {
            this.getSchedBlock().createTemporalConstraints();
            this.publish();
        } else if (fieldID == SchedBlockTemporalTabbedEditor.FID_DELETE_BUTTON) {
            TemporalConstraints temporalConstraints = this.tempModel.getTemporalConstraints();
            this.getSchedBlock().removeTemporalConstraints(temporalConstraints);
            this.publish();
        } else if (fieldID == SchedBlockTemporalTabbedEditor.FID_DELETE_ALL_BUTTON) {
            this.getSchedBlock().clearTemporalConstraints();
            this.tempModel.setDocument(null);
            this.publish();
        }
        return object;
    }
}

